package com.ejie.y41b.adapter.services;

import java.io.InputStream;
import java.util.List;

import org.w3c.dom.Document;

import com.ejie.y31.vo.Y31AttachmentBean;

public interface Y41bPifService {

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param file
	 *            Stream de datos para acceder al contenido a copiar en el
	 *            repositorio
	 * @param pathTo
	 *            Ruta lógica donde alojar el fichero. Incluirá como carpeta
	 *            principal la aplicación destino
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de dígitos que lo hace único en el repositorio
	 * @param Ttl
	 *            Número de segundos que se desea mantener el fichero en el
	 *            repositorio. Como máximo se podrá fijar el número de segundos
	 *            de 15 días naturales
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws Exception
	 *             excepcion en el PIF
	 */
	Y31AttachmentBean putFile(Document sSessionToken, InputStream file,
			String pathTo, boolean preserveName, Long Ttl) throws Exception;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param pathFrom
	 *            Ruta lógica de donde se va a descargar el fichero. Incluirá
	 *            como carpeta principal la aplicación destino
	 * @return InputStream
	 * @throws Exception
	 */
	InputStream getFile(Document sSessionToken, String pathFrom)
			throws Exception;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @param pathTo
	 *            Ruta lógica donde se va a mover el fichero. Incluirá como
	 *            carpeta principal la aplicación destino
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de dígitos que lo hace único en el repositorio
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws Exception
	 */
	Y31AttachmentBean moveFile(Document sSessionToken, String pathFrom,
			String pathTo, boolean preserveName) throws Exception;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @param pathTo
	 *            Ruta lógica donde se va a mover el fichero. Incluirá como
	 *            carpeta principal la aplicación destino
	 * @param boolena
	 *            preserveName preserveName
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws Exception
	 */
	Y31AttachmentBean copyFile(Document sSessionToken, String pathFrom,
			String pathTo, boolean preserveName) throws Exception;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @return List<Y31AttachmentBean>
	 * @throws Exception
	 */
	List<Y31AttachmentBean> listFile(Document sSessionToken, String pathFrom)
			throws Exception;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @throws Exception
	 */
	void deleteFile(Document sSessionToken, String pathFrom) throws Exception;

}
