package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.ws.cliente.eika.cp.crearO.DTCREAROREQUEST;
import com.ejie.y41b.ws.cliente.eika.cp.crearO.DTCREARORESPONSE;
import com.ejie.y41b.ws.cliente.eika.cp.crearO.SICP004CrearOOS;
import com.ejie.y41b.ws.cliente.eika.cp.crearO.SICP004CrearOOSService;

/**
 * Y41bEikaCrearObligacionesServiceImpl
 * 
 *  
 *
 */
@Service(value = "Y41bEikaCrearObligacionesServiceImpl")
public class Y41bEikaCrearObligacionesServiceImpl {
	private static final Logger logger = LoggerFactory.getLogger(NSHFServiceImpl.class);

	private SICP004CrearOOSService service;

	/**
	 * consultaTerceros
	 * 
	 * @param integrationToken
	 * @param mtCONSULTATERCEROSREQUEST
	 * @return DTCREARORESPONSE
	 * @throws Exception_Exception
	 */
	public DTCREARORESPONSE crearObligaciones(String integrationToken, DTCREAROREQUEST mtCREAROSREQUEST)
			throws Exception {
		return this.getEikaServicePort().siCP004CrearOOS(mtCREAROSREQUEST);
	}

	/**
	 * iniciarEikaService
	 */
	public void iniciarEikaService() {
		this.getEikaServicePort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName QNAME = new QName("http://iecisa.com/po/cp", "SI_CP_004_CrearO_OSService");

	private SICP004CrearOOS getEikaServicePort() {
		return this.getEikaServicePort(true);
	}

	private SICP004CrearOOS getEikaServicePort(boolean getPort) {
		try {
			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE EIKA >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new SICP004CrearOOSService(new URL(prop.getProperty("URL_EIKA_CREAR_OBLIGACIONES")), QNAME);
				// service = new SICP004CrearOOSService();

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections.singletonList(new Y41bEikaCrearObligacionesServiceHandler());
					}
				});
				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE EIKA >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT EIKA inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				SICP004CrearOOS proxy = this.service.getHTTPSPort();

				Map<String, Object> ctxt = ((BindingProvider) proxy).getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, prop.getProperty("URL_EIKA_CREAR_OBLIGACIONES"));

				return proxy;
			}
		} catch (Exception e) {
			this.service = null;
		}
		return null;
	}
}