package com.ejie.y41b.adapter.services;

import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;

/**
 * Y41bEikaCrearObligacionesServiceHandler
 *
 *
 *
 */
public class Y41bEikaCrearObligacionesServiceHandler implements SOAPHandler<SOAPMessageContext> {

	private static final Logger logger = LoggerFactory.getLogger(Y41bEikaCrearObligacionesServiceHandler.class);

	/**
	 * Constructor por defecto.
	 *
	 */
	public Y41bEikaCrearObligacionesServiceHandler() {
	}

	@Override
	public Set<QName> getHeaders() {
		return new HashSet<QName>();
	}

	@Override
	public void close(MessageContext context) {

	}

	/**
	 * @see javax.xml.ws.handler.Handler#handleFault(javax.xml.ws.handler.MessageContext)
	 */
	@Override
	public boolean handleFault(SOAPMessageContext context) {
		logger.error("Error cliente ws EIKA Crear obligaciones" + logging(context));
		return true;
	}

	/**
	 * @see javax.xml.ws.handler.Handler#handleMessage(javax.xml.ws.handler.MessageContext)
	 */
	@Override
	public boolean handleMessage(SOAPMessageContext context) {

		boolean valid = true;

		Boolean outbound = (Boolean) context.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

		// solo para los mensajes SALIENTES
		if (outbound != null && outbound.booleanValue()) {
			valid = false;
			try {
				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

				SOAPEnvelope envelope = context.getMessage().getSOAPPart().getEnvelope();
				SOAPHeader soapHeader = envelope.getHeader();
				if (soapHeader == null) {
					soapHeader = envelope.addHeader();
				}

				SOAPElement security = soapHeader.addChildElement("Security", "wsse",
						"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");

				SOAPElement usernameToken = security.addChildElement("UsernameToken", "XXXX");
				usernameToken.addAttribute(new QName("xmlns:wsu"),
						"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");

				SOAPElement username = usernameToken.addChildElement("Username", "XXXX");
				username.addTextNode(prop.getProperty("EIKA_CREAR_OBLIGACIONES_USUARIO"));

				SOAPElement password = usernameToken.addChildElement("Password", "XXXX");
				password.setAttribute("Type",
						"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
				password.addTextNode(prop.getProperty("EIKA_CREAR_OBLIGACIONES_PASSWD"));

				// Se puede continuar el procesamiento
				valid = true;

				System.out.println(
						"Y41bWSServiceHandler (handleMessage). Cliente WS Y41bWSServiceHandler outbound: Token inyectado al header");

				context.put("timeini", new Long(System.currentTimeMillis()));

			} catch (Exception e) {
				System.out.println("Y41bWSServiceHandler (handleMessage). Exception: " + e);
				e.printStackTrace();
			}
		} else {
			long timeini = (Long) (context.get("timeini"));
			long timefin = System.currentTimeMillis();
			BigDecimal result = ((new BigDecimal(timefin).subtract(new BigDecimal(timeini)))
					.divide(new BigDecimal(1000), 5, BigDecimal.ROUND_FLOOR));
			logger.info("cliente ws tiempo transcurrido de respuesta: " + result + " sg ");
		}
		return valid;

	}

	private String logging(SOAPMessageContext context) {
		try {
			ByteArrayOutputStream out = new ByteArrayOutputStream();
			context.getMessage().writeTo(out);
			return new String(out.toByteArray());
		} catch (Exception e) {
			logger.error("Error", e);
		}
		return "NO SACAMOS MENSAJE SOAP";
	}
}
