package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.sir.Exception_Exception;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.ws.cliente.eika.tesoreria.consultaTerceros.DTCONSULTATERCEROSREQUEST;
import com.ejie.y41b.ws.cliente.eika.tesoreria.consultaTerceros.DTCONSULTATERCEROSRESPONSE;
import com.ejie.y41b.ws.cliente.eika.tesoreria.consultaTerceros.SITR001ConsulTercerosOS;
import com.ejie.y41b.ws.cliente.eika.tesoreria.consultaTerceros.SITR001ConsulTercerosOSService;

/**
 * Y41bEikaServiceImpl
 * 
 *  
 *
 */
@Service(value = "Y41bEikaConsultaTercerosServiceImpl")
public class Y41bEikaConsultaTercerosServiceImpl {
	private static final Logger logger = LoggerFactory.getLogger(NSHFServiceImpl.class);

	private SITR001ConsulTercerosOSService service;

	/**
	 * consultaTerceros
	 * 
	 * @param integrationToken
	 * @param mtCONSULTATERCEROSREQUEST
	 * @return
	 * @throws Exception_Exception
	 */
	public DTCONSULTATERCEROSRESPONSE consultaTerceros(String integrationToken,
			DTCONSULTATERCEROSREQUEST mtCONSULTATERCEROSREQUEST) throws Exception_Exception {
		return this.getEikaServicePort().siTR001ConsulTercerosOS(mtCONSULTATERCEROSREQUEST);
	}

	/**
	 * iniciarEikaService
	 */
	public void iniciarEikaService() {
		this.getEikaServicePort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName QNAME = new QName("http://iecisa.com/po/tesoreria",
			"SI_TR_001_ConsulTerceros_OSService");

	private SITR001ConsulTercerosOS getEikaServicePort() {
		return this.getEikaServicePort(true);
	}

	private SITR001ConsulTercerosOS getEikaServicePort(boolean getPort) {
		try {
			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE EIKA >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new SITR001ConsulTercerosOSService(new URL(prop.getProperty("URL_EIKA_CONSULTA_TERCEROS")),
						QNAME);

				// service = new SITR001ConsulTercerosOSService();

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections.singletonList(new Y41bEikaConsultaTercerosServiceHandler());
					}
				});
				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE EIKA >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT EIKA inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				SITR001ConsulTercerosOS proxy = this.service.getHTTPSPort();

				Map<String, Object> ctxt = ((BindingProvider) proxy).getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, prop.getProperty("URL_EIKA_CONSULTA_TERCEROS"));

				return proxy;
			}
		} catch (Exception e) {
			this.service = null;
		}
		return null;
	}
}