package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.sir.Exception_Exception;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.ws.cliente.eika.cp.consultaResultadoPagos.DTCONSULTARESULTADOPAGOSREQUEST;
import com.ejie.y41b.ws.cliente.eika.cp.consultaResultadoPagos.DTCONSULTARESULTADOPAGOSRESPONSE;
import com.ejie.y41b.ws.cliente.eika.cp.consultaResultadoPagos.SICP034ConsultaResultadoPagosOS;
import com.ejie.y41b.ws.cliente.eika.cp.consultaResultadoPagos.SICP034ConsultaResultadoPagosOSService;

/**
 * Y41bEikaConsultaResultadoPagosServiceImpl
 * 
 *  
 *
 */
@Service(value = "Y41bEikaConsultaResultadoPagosServiceImpl")
public class Y41bEikaConsultaResultadoPagosServiceImpl {
	private static final Logger logger = LoggerFactory.getLogger(NSHFServiceImpl.class);

	private SICP034ConsultaResultadoPagosOSService service;

	/**
	 * consultaResultadoPagos
	 * 
	 * @param integrationToken
	 * @param mtCONSULTAEXPEREQUEST
	 * @return
	 * @throws Exception_Exception
	 */
	public DTCONSULTARESULTADOPAGOSRESPONSE consultaResultadoPagos(String integrationToken,
			DTCONSULTARESULTADOPAGOSREQUEST mtCONSULTARESULTADOPAGOSREQUEST) throws Exception_Exception {
		return this.getEikaServicePort().siCP034ConsultaResultadoPagosOS(mtCONSULTARESULTADOPAGOSREQUEST);
	}

	/**
	 * iniciarEikaService
	 */
	public void iniciarEikaService() {
		this.getEikaServicePort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName QNAME = new QName("http://iecisa.com/po/cp",
			"SI_CP_034_ConsultaResultadoPagos_OSService");

	private SICP034ConsultaResultadoPagosOS getEikaServicePort() {
		return this.getEikaServicePort(true);
	}

	private SICP034ConsultaResultadoPagosOS getEikaServicePort(boolean getPort) {
		try {
			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE EIKA >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new SICP034ConsultaResultadoPagosOSService(
						new URL(prop.getProperty("URL_EIKA_CONSULTA_RESULTADO_PAGOS")), QNAME);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections.singletonList(new Y41bEikaConsultaResultadoPagosServiceHandler());
					}
				});
				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE EIKA >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT EIKA inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				SICP034ConsultaResultadoPagosOS proxy = this.service.getHTTPSPort();

				Map<String, Object> ctxt = ((BindingProvider) proxy).getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						prop.getProperty("URL_EIKA_CONSULTA_RESULTADO_PAGOS"));

				return proxy;
			}
		} catch (Exception e) {
			this.service = null;
		}
		return null;
	}
}