package com.ejie.y41b.adapter.services;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.ejie.y41b.constantes.Y41bConstantes;

/**
 * <p>
 * Titulo: Y41bDokusiServiceImpl
 * </p>
 * <p>
 * Descipcion: Realiza invocaciones a los webServices de Dokusi
 * </p>
 * <p>
 * Copyright: Copyright (c) 2013
 * </p>
 * <p>
 * Empresa: Bilbomatica
 * </p>
 * 
 *  
 * @version 1.0
 */
@Service(value = "y41bDokusiServiceImpl")
public class Y41bDokusiServiceImpl implements Y41bDokusiService {

	/**
	 * Final static logger.
	 */
	private static final Logger logger = LoggerFactory.getLogger(Y41bDokusiServiceImpl.class);

	/**
	 * Clase que hara de facade para invocar los servicios de Dokusi
	 */
	private Y41bDokusiServiceImpl() {
		super();
	}

	/**
	 * Metodo que obtiene los ids de documentos obtenidos filtrando por una
	 * lista de metadatos
	 * 
	 * @param tokenSesion
	 *            token de sesion
	 * @param auditUser
	 *            usuario
	 * @param documentalType
	 *            String Identificador del Tipo
	 * @param returnedAttributeKeysList
	 *            String Lista de Metadatos a devolver
	 * @param searchConditionsList
	 *            String Lista de Metadatos para filtrar
	 * @param boolAllVersions
	 *            boolean Indica si se recuperan todas las versiones de los
	 *            documentos
	 * @param intMaxRows
	 *            int Numero maximo de resultados a recuperar
	 * @return String: OID del documento. null si falla
	 * @throws Exception
	 *             ex
	 */
	public String buscarDocumentosDokusi(String tokenSesion, String auditUser, String documentalType,
			String returnedAttributeKeysList, String searchConditionsList, boolean boolAllVersions, int intMaxRows)
			throws Exception {
		logger.info("Y41bDokusiServiceImpl.buscarDocumentosMetadatosDokusi - Inicio");
		try {
			String respuesta;

			T65BFSDWSClasePortQSServiceWSServiceImpl t65BFSDWSClasePortQSServiceWSServiceImpl = new T65BFSDWSClasePortQSServiceWSServiceImpl();
			respuesta = t65BFSDWSClasePortQSServiceWSServiceImpl.buscarDocumentosDokusi(tokenSesion, auditUser,
					documentalType, returnedAttributeKeysList, searchConditionsList, boolAllVersions, intMaxRows);

			logger.debug("Y41bDokusiServiceImpl.buscarDocumentosMetadatosDokusi - Return: " + respuesta);
			return respuesta;
		} catch (Exception e_buscarDocumentosDokusi) {
			logger.error("Y41bDokusiServiceImpl.buscarDocumentosMetadatosDokusi", e_buscarDocumentosDokusi);
			throw e_buscarDocumentosDokusi;
		} finally {
			logger.info("Y41bDokusiServiceImpl.buscarDocumentosMetadatosDokusi - Final");
		}
	}

	private String tratarTipoDocumental(String tipoDocumental) {
		String resultado = tipoDocumental;
		// 86178: [SOLICITUDES] - Nuevos tramites - Solicitud de...
		if (Y41bConstantes.TIPO_DOC_RESP_SOL_COLABORACION.equals(tipoDocumental)) {
			resultado = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
		} else if (Y41bConstantes.TIPO_DOC_SOL_ARBITRAJE.equals(tipoDocumental)) {
			resultado = Y41bConstantes.TIPO_DOC_SOLICITUD;
		} else if (Y41bConstantes.TIPO_DOC_INS_INFORME_INSPECCION.equals(tipoDocumental)) {
			resultado = Y41bConstantes.TIPO_DOC_INFORME;
		} else if (Y41bConstantes.TIPO_DOC_RESPUESTA_MEDIACION.equals(tipoDocumental)) {
			resultado = Y41bConstantes.TIPO_DOC_ALEGACION;
		} else if (Y41bConstantes.TIPO_DOC_PROTOCOLO.equals(tipoDocumental)) {
			resultado = Y41bConstantes.TIPO_DOC_INFORME;

		} else {
			if (tipoDocumental != null && tipoDocumental.indexOf(".") != -1) {
				resultado = tipoDocumental.substring(0, tipoDocumental.indexOf("."));
			}
		}
		return resultado;
	}

	/**
	 * Método que almacena un documento en DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de sesion
	 * @param auditUser
	 *            usuario
	 * @param content
	 *            contenido del documento
	 * @param documentalType
	 *            tipo documental
	 * @param attributeList
	 *            lista de metadatos
	 * @return String: OID del documento. null si falla
	 * @throws Exception
	 *             ex
	 */
	public String registrarDocumentoDokusi(String tokenSesion, String auditUser, String content, String documentalType,
			String attributeList) throws Exception {
		logger.info("Y41bDokusiServiceImpl.registrarDocumentoDokusi - Inicio");
		try {
			documentalType = this.tratarTipoDocumental(documentalType);

			String respuesta;

			T65BFSDWSClasePortQSServiceWSServiceImpl t65BFSDWSClasePortQSServiceWSServiceImpl = new T65BFSDWSClasePortQSServiceWSServiceImpl();
			respuesta = t65BFSDWSClasePortQSServiceWSServiceImpl.registrarDocumentoDokusi(tokenSesion, auditUser,
					content, documentalType, attributeList);

			logger.debug("Y41bDokusiServiceImpl.registrarDocumentoDokusi - Return: " + respuesta);
			return respuesta;
		} catch (Exception e_registrarDocumentoDokusi) {
			logger.error("Y41bDokusiServiceImpl.registrarDocumentoDokusi", e_registrarDocumentoDokusi);
			throw e_registrarDocumentoDokusi;
		} finally {
			logger.info("Y41bDokusiServiceImpl.registrarDocumentoDokusi - Final");
		}
	}

	/**
	 * Método que retramita un documento en DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de sesion
	 * @param auditUser
	 *            usuario
	 * @param documentId
	 *            id del documento
	 * @param documentalType
	 *            tipo documental
	 * @param attributeList
	 *            lista de metadatos
	 * @return String
	 * @throws Exception
	 *             ex
	 */
	public String retramitarDocumentoDokusi(String tokenSesion, String auditUser, String documentId,
			String documentalType, String attributeList) throws Exception {
		logger.info("Y41bDokusiServiceImpl.retramitarDocumentoDokusi - Inicio");
		try {
			documentalType = this.tratarTipoDocumental(documentalType);

			boolean bolRespuesta;

			T65BFSDWSClasePortQSServiceWSServiceImpl t65BFSDWSClasePortQSServiceWSServiceImpl = new T65BFSDWSClasePortQSServiceWSServiceImpl();
			bolRespuesta = t65BFSDWSClasePortQSServiceWSServiceImpl.retramitarDocumentoDokusi(tokenSesion, auditUser,
					documentId, documentalType, attributeList);

			logger.debug("Y41bDokusiServiceImpl.retramitarDocumentoDokusi - Return: " + String.valueOf(bolRespuesta));
			return String.valueOf(bolRespuesta);
		} catch (Exception e_retramitarDocumentoDokusi) {
			logger.error("Y41bDokusiServiceImpl.retramitarDocumentoDokusi", e_retramitarDocumentoDokusi);
			throw e_retramitarDocumentoDokusi;
		} finally {
			logger.info("Y41bDokusiServiceImpl.retramitarDocumentoDokusi - Final");
		}
	}

	/**
	 * Método que permitirá cambiar un documento de contexto de Registro a
	 * contexto de Tramitación y modifica el acl o la serie documental de un
	 * documento de DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de seguridad
	 * @param auditUser
	 *            datos del usuario
	 * @param documentID
	 *            identificador del documento
	 * @param tipoDocumental
	 *            tipo documental del documento
	 * @param attributeList
	 *            lista de atributos
	 * 
	 * @return boolean: Resultado de la operacion
	 * @throws Exception
	 *             ex
	 */
	public boolean tramitarDocumentoDokusi(String tokenSesion, String auditUser, String documentID,
			String tipoDocumental, String attributeList) throws Exception {
		logger.info("Y41bDokusiServiceImpl.tramitarDocumentoDokusi - Inicio");
		try {

			tipoDocumental = this.tratarTipoDocumental(tipoDocumental);

			boolean bolRespuesta;

			T65BFSDWSClasePortQSServiceWSServiceImpl t65BFSDWSClasePortQSServiceWSServiceImpl = new T65BFSDWSClasePortQSServiceWSServiceImpl();
			bolRespuesta = t65BFSDWSClasePortQSServiceWSServiceImpl.tramitarDocumentoDokusi(tokenSesion, auditUser,
					documentID, tipoDocumental, attributeList);

			logger.debug("Y41bDokusiServiceImpl.tramitarDocumentoDokusi - Return: " + bolRespuesta);
			return bolRespuesta;
		} catch (Exception e_descargarDocumentoDokusi) {
			throw e_descargarDocumentoDokusi;
		} finally {
			logger.info("Y41bDokusiServiceImpl.tramitarDocumentoDokusi - Final");
		}
	}

	/**
	 * Método que modifica el contenido de un documento en DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de sesion
	 * @param auditUser
	 *            usuario
	 * @param documentId
	 *            id del documento
	 * @param saveAsVersion
	 *            String
	 * @param boolSetCurrent
	 *            boolean
	 * @param content
	 *            String
	 * @return String: OID del documento. null si falla
	 * @throws Exception
	 *             ex
	 */
	public String modificarDocumentoDokusiContent(String tokenSesion, String auditUser, String documentId,
			String saveAsVersion, boolean boolSetCurrent, String content) throws Exception {
		logger.info("Y41bDokusiServiceImpl.modificarDocumentoDokusiContent - Inicio");
		try {
			String respuesta;

			T65BFSDWSClasePortQSServiceWSServiceImpl t65BFSDWSClasePortQSServiceWSServiceImpl = new T65BFSDWSClasePortQSServiceWSServiceImpl();
			respuesta = t65BFSDWSClasePortQSServiceWSServiceImpl.modificarDocumentoDokusiContent(tokenSesion, auditUser,
					documentId, saveAsVersion, boolSetCurrent, content);

			logger.debug("Y41bDokusiServiceImpl.modificarDocumentoDokusiContent - Return: " + respuesta);
			return respuesta;
		} catch (Exception e_modificarDocumentoDokusiContent) {
			logger.error("Y41bDokusiServiceImpl.modificarDocumentoDokusiContent", e_modificarDocumentoDokusiContent);
			throw e_modificarDocumentoDokusiContent;
		} finally {
			logger.info("Y41bDokusiServiceImpl.modificarDocumentoDokusiContent - Final");
		}
	}

	/**
	 * Método que modifica los atributos de un documento en DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de sesion
	 * @param auditUser
	 *            usuario
	 * @param documentId
	 *            id del documento
	 * @param saveAsVersion
	 *            String
	 * @param boolSetCurrent
	 *            boolean
	 * @param attributeList
	 *            String
	 * @return String: OID del documento. null si falla
	 * @throws Exception
	 *             ex
	 */
	public String modificarDocumentoDokusiAtrib(String tokenSesion, String auditUser, String documentId,
			String saveAsVersion, boolean boolSetCurrent, String attributeList) throws Exception {
		logger.info("Y41bDokusiServiceImpl.modificarDocumentoDokusiAtrib - Inicio");
		try {
			String respuesta;

			T65BFSDWSClasePortQSServiceWSServiceImpl t65BFSDWSClasePortQSServiceWSServiceImpl = new T65BFSDWSClasePortQSServiceWSServiceImpl();
			respuesta = t65BFSDWSClasePortQSServiceWSServiceImpl.modificarDocumentoDokusiAtrib(tokenSesion, auditUser,
					documentId, saveAsVersion, boolSetCurrent, attributeList);

			logger.debug("Y41bDokusiServiceImpl.modificarDocumentoDokusiAtrib - Return: " + respuesta);
			return respuesta;
		} catch (Exception e_modificarDocumentoDokusiAtrib) {
			logger.error("Y41bDokusiServiceImpl.modificarDocumentoDokusiAtrib", e_modificarDocumentoDokusiAtrib);
			throw e_modificarDocumentoDokusiAtrib;
		} finally {
			logger.info("Y41bDokusiServiceImpl.modificarDocumentoDokusiAtrib - Final");
		}
	}

	/**
	 * Método que modifica el contenido o atributos o ambas cosas de un
	 * documento en DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de sesion
	 * @param auditUser
	 *            usuario
	 * @param documentId
	 *            id del documento
	 * @param saveAsVersion
	 *            String
	 * @param boolSetCurrent
	 *            boolean
	 * @param attributeList
	 *            String
	 * @param content
	 *            String
	 * @return String: OID del documento. null si falla
	 * @throws Exception
	 *             ex
	 */
	public String modificarDocumentoDokusi(String tokenSesion, String auditUser, String documentId,
			String saveAsVersion, boolean boolSetCurrent, String attributeList, String content) throws Exception {
		logger.info("Y41bDokusiServiceImpl.modificarDocumentoDokusi - Inicio");
		try {
			String respuesta;

			T65BFSDWSClasePortQSServiceWSServiceImpl t65BFSDWSClasePortQSServiceWSServiceImpl = new T65BFSDWSClasePortQSServiceWSServiceImpl();
			respuesta = t65BFSDWSClasePortQSServiceWSServiceImpl.modificarDocumentoDokusi(tokenSesion, auditUser,
					documentId, saveAsVersion, boolSetCurrent, attributeList, content);

			logger.debug("Y41bDokusiServiceImpl.modificarDocumentoDokusi - Return: " + respuesta);
			return respuesta;
		} catch (Exception e_modificarDocumentoDokusi) {
			logger.error("Y41bDokusiServiceImpl.modificarDocumentoDokusi", e_modificarDocumentoDokusi);
			throw e_modificarDocumentoDokusi;
		} finally {
			logger.info("Y41bDokusiServiceImpl.modificarDocumentoDokusi - Final");
		}
	}

	/**
	 * Método que descarga un documento en DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de sesion
	 * @param auditUser
	 *            usuario
	 * @param documentID
	 *            id del documento
	 * @param keysList
	 *            lista de metadatos a devolver
	 * @param content
	 *            bean con la extension del documento a recuperar
	 * @return String: OID del documento. null si casca
	 * @throws Exception
	 *             ex
	 */
	public String descargarDocumentoDokusi(String tokenSesion, String auditUser, String documentID, String keysList,
			String content) throws Exception {
		logger.info("Y41bDokusiServiceImpl.descargarDocumentoDokusi - Inicio");
		try {
			String respuesta;

			T65BFSDWSClasePortQSServiceWSServiceImpl t65BFSDWSClasePortQSServiceWSServiceImpl = new T65BFSDWSClasePortQSServiceWSServiceImpl();
			respuesta = t65BFSDWSClasePortQSServiceWSServiceImpl.descargarDocumentoDokusi(tokenSesion, auditUser,
					documentID, keysList, content);

			return respuesta;
		} catch (Exception e_descargarDocumentoDokusi) {
			logger.error("Y41bDokusiServiceImpl.descargarDocumentoDokusi", e_descargarDocumentoDokusi);
			throw e_descargarDocumentoDokusi;
		} finally {
			logger.info("Y41bDokusiServiceImpl.descargarDocumentoDokusi - Final");
		}
	}

	/**
	 * Método que elimina un documento de DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de seguridad
	 * @param auditUser
	 *            datos del usuario
	 * @param documentID
	 *            identificador del documento
	 * @param boolAllVersions
	 *            indica el borrado de todas las versiones del documento
	 * 
	 * @return String: OID del documento. null si casca
	 * @throws Exception
	 *             ex
	 */
	public String eliminarDocumentoDokusi(String tokenSesion, String auditUser, String documentID,
			boolean boolAllVersions) throws Exception {
		logger.info("Y41bDokusiServiceImpl.eliminarDocumentoDokusi - Inicio");
		try {
			String respuesta;

			T65BFSDWSClasePortQSServiceWSServiceImpl t65BFSDWSClasePortQSServiceWSServiceImpl = new T65BFSDWSClasePortQSServiceWSServiceImpl();
			respuesta = t65BFSDWSClasePortQSServiceWSServiceImpl.eliminarDocumentoDokusi(tokenSesion, auditUser,
					documentID, boolAllVersions);

			logger.debug("Y41bDokusiServiceImpl.eliminarDocumentoDokusi - Return: " + respuesta);
			return respuesta;
		} catch (Exception e_descargarDocumentoDokusi) {
			logger.error("Y41bDokusiServiceImpl.eliminarDocumentoDokusi", e_descargarDocumentoDokusi);
			throw e_descargarDocumentoDokusi;
		} finally {
			logger.info("Y41bDokusiServiceImpl.eliminarDocumentoDokusi - Final");
		}
	}

	/**
	 * Método que permite recuperar las firmas de documento almacenado en el
	 * repositorio
	 * 
	 * @param tokenSesion
	 *            token xlnets
	 * @param auditUser
	 *            usuario
	 * @param documentID
	 *            identificador del documento
	 * @param format
	 *            formato del documento
	 * @return String: OID del documento. null si casca
	 * @throws Exception
	 *             ex
	 */
	public String recuperarFirmarDocumentosDokusi(String tokenSesion, String auditUser, String documentID,
			String format) throws Exception {
		logger.info("Y41bDokusiServiceImpl.recuperarFirmarDocumentosDokusi - Inicio");
		try {
			String respuesta;

			T65BFSDWSClasePortQSServiceWSServiceImpl t65BFSDWSClasePortQSServiceWSServiceImpl = new T65BFSDWSClasePortQSServiceWSServiceImpl();
			respuesta = t65BFSDWSClasePortQSServiceWSServiceImpl.recuperarFirmarDocumentosDokusi(tokenSesion, auditUser,
					documentID, format);

			logger.debug("Y41bDokusiServiceImpl.recuperarFirmarDocumentosDokusi - Return: " + respuesta);
			return respuesta;
		} catch (Exception e_recuperarFirmarDocumentosDokusi) {
			logger.error("Y41bDokusiServiceImpl.recuperarFirmarDocumentosDokusi", e_recuperarFirmarDocumentosDokusi);
			throw e_recuperarFirmarDocumentosDokusi;
		} finally {
			logger.info("Y41bDokusiServiceImpl.recuperarFirmarDocumentosDokusi - Final");
		}
	}

	/**
	 * Método que permite añadir firmas a un documento almacenado en el
	 * repositorio
	 * 
	 * @param tokenSesion
	 *            token xlnets
	 * @param auditUser
	 *            usuario
	 * @param documentID
	 *            identificador del documento
	 * @param signatures
	 *            lista de firmas
	 * @return String: OID del documento. null si casca
	 * @throws Exception
	 *             ex
	 */
	public String firmarDocumentosDokusi(String tokenSesion, String auditUser, String documentID, String signatures)
			throws Exception {

		logger.info("Y41bDokusiServiceImpl.firmarDocumentosDokusi - Inicio");
		try {
			String respuesta;

			T65BFSDWSClasePortQSServiceWSServiceImpl t65BFSDWSClasePortQSServiceWSServiceImpl = new T65BFSDWSClasePortQSServiceWSServiceImpl();
			respuesta = String.valueOf(t65BFSDWSClasePortQSServiceWSServiceImpl.firmarDocumentosDokusi(tokenSesion,
					auditUser, documentID, signatures));

			logger.debug("Y41bDokusiServiceImpl.firmarDocumentosDokusi - Return: " + respuesta);
			return respuesta;
		} catch (Exception e_firmarDocumentosDokusi) {
			logger.error("Y41bDokusiServiceImpl.firmarDocumentosDokusi", e_firmarDocumentosDokusi);
			throw e_firmarDocumentosDokusi;
		} finally {
			logger.info("Y41bDokusiServiceImpl.firmarDocumentosDokusi - Final");
		}
	}

	/**
	 * Método que permite añadir un localizador a un documento almacenado en
	 * el repositorio
	 * 
	 * @param tokenSesion
	 *            String
	 * @param auditUser
	 *            String
	 * @param documentID
	 *            String
	 * @param boolVersion
	 *            boolean
	 * @param boolReducir
	 *            String
	 * @param sede
	 *            String
	 * 
	 * @return String: OID del documento. null si casca
	 * @throws Exception
	 *             ex
	 */
	public String incorporarLocalizadorDocumentoDokusi(String tokenSesion, String auditUser, String documentID,
			boolean boolVersion, String boolReducir, String sede) throws Exception {

		logger.info("Y41bDokusiServiceImpl.incorporarLocalizadorDocumentoDokusi - Inicio");
		try {
			String respuesta;
			logger.info("A61tDokusiServiceImpl.incorporarLocalizadorDocumentoDokusi - MANDO A LOCALIZAR DOCUMENTO****"
					+ documentID + ".");

			T65BFSDWSClasePortQSServiceWSServiceImpl t65BFSDWSClasePortQSServiceWSServiceImpl = new T65BFSDWSClasePortQSServiceWSServiceImpl();
			respuesta = t65BFSDWSClasePortQSServiceWSServiceImpl.incorporarLocalizadorDocumentoDokusi(tokenSesion,
					auditUser, documentID, boolVersion, boolReducir, sede);

			logger.debug("Y41bDokusiServiceImpl.incorporarLocalizadorDocumentoDokusi - Return: " + respuesta);
			return respuesta;
		} catch (Exception e_incorporarLocalizadorDocumentoDokusi) {
			logger.error("Y41bDokusiServiceImpl.incorporarLocalizadorDocumentoDokusi",
					e_incorporarLocalizadorDocumentoDokusi);
			throw e_incorporarLocalizadorDocumentoDokusi;
		} finally {
			logger.info("Y41bDokusiServiceImpl.incorporarLocalizadorDocumentoDokusi - Final");
		}
	}

	/**
	 * Método que recupera los formatos de un documento de DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de seguridad
	 * @param auditUser
	 *            datos del usuario
	 * @param documentID
	 *            identificador del documento
	 * 
	 * @return String: Formatos del documento
	 * @throws Exception
	 *             ex
	 */
	public String recuperarFormatosDocumentosDokusi(String tokenSesion, String auditUser, String documentID)
			throws Exception {
		logger.info("Y41bDokusiServiceImpl.recuperarFormatosDocumentosDokusi - Inicio");
		try {
			String respuesta;

			T65BFSDWSClasePortQSServiceWSServiceImpl t65BFSDWSClasePortQSServiceWSServiceImpl = new T65BFSDWSClasePortQSServiceWSServiceImpl();
			respuesta = t65BFSDWSClasePortQSServiceWSServiceImpl.recuperarFormatosDocumentosDokusi(tokenSesion,
					auditUser, documentID);

			logger.debug("Y41bDokusiServiceImpl.recuperarFormatosDocumentosDokusi - Return: " + respuesta);
			return respuesta;
		} catch (Exception e_descargarDocumentoDokusi) {
			logger.error("Y41bDokusiServiceImpl.recuperarFormatosDocumentosDokusi", e_descargarDocumentoDokusi);
			throw e_descargarDocumentoDokusi;
		} finally {
			logger.info("Y41bDokusiServiceImpl.recuperarFormatosDocumentosDokusi - Final");
		}
	}

	/**
	 * Metodo que transforma un documento almacenado en el repositorio
	 * 
	 * @param tokenSesion
	 *            String
	 * @param auditUser
	 *            String
	 * @param documentID
	 *            String
	 * @param format
	 *            String
	 * 
	 * @return String: OID del documento. null si casca
	 * @throws Exception
	 *             ex
	 */
	public String transformarDocumentoDokusi(String tokenSesion, String auditUser, String documentID, String format)
			throws Exception {

		logger.info("Y41bDokusiServiceImpl.transformarDocumentoDokusi - Inicio");
		try {

			boolean bolRespuesta;

			T65BFSDWSClasePortQSServiceWSServiceImpl t65BFSDWSClasePortQSServiceWSServiceImpl = new T65BFSDWSClasePortQSServiceWSServiceImpl();
			bolRespuesta = t65BFSDWSClasePortQSServiceWSServiceImpl.transformarDocumentoDokusi(tokenSesion, auditUser,
					documentID, format);

			logger.debug("Y41bDokusiServiceImpl.transformarDocumentoDokusi - Return: " + String.valueOf(bolRespuesta));
			return String.valueOf(bolRespuesta);
		} catch (Exception e_transformarDocumentoDokusi) {
			logger.error("Y41bDokusiServiceImpl.transformarDocumentoDokusi", e_transformarDocumentoDokusi);
			throw e_transformarDocumentoDokusi;
		} finally {
			logger.info("Y41bDokusiServiceImpl.transformarDocumentoDokusi - Final");
		}
	}

	/**
	 * Metodo que genera un nuevo documento copia que comparte el contenido del
	 * original.
	 * 
	 * @param tokenSesion
	 *            token de sesion
	 * @param auditUser
	 *            usuario
	 * @param documentID
	 *            String
	 * @param attributeList
	 *            lista de metadatos
	 * @return String: OID del documento. null si falla
	 * @throws Exception
	 *             ex
	 */
	public String shareDocumentContents(String tokenSesion, String auditUser, String documentID, String attributeList)
			throws Exception {
		logger.info("Y41bDokusiServiceImpl.e_shareDocumentContents - Inicio");
		try {
			String respuesta;

			T65BFSDWSClasePortQSServiceWSServiceImpl t65BFSDWSClasePortQSServiceWSServiceImpl = new T65BFSDWSClasePortQSServiceWSServiceImpl();
			respuesta = t65BFSDWSClasePortQSServiceWSServiceImpl.shareDocumentContents(tokenSesion, auditUser,
					documentID, attributeList);

			logger.debug("Y41bDokusiServiceImpl.shareDocumentContents - Return: " + respuesta);
			return respuesta;
		} catch (Exception e_shareDocumentContents) {
			logger.error("Y41bDokusiServiceImpl.shareDocumentContents", e_shareDocumentContents);
			throw e_shareDocumentContents;
		} finally {
			logger.info("Y41bDokusiServiceImpl.shareDocumentContents - Final");
		}
	}

}