package com.ejie.y41b.adapter.services;

/**
 * Y41bDokusiService.
 * 
 *  
 */

public interface Y41bDokusiService {

	/**
	 * Metodo que obtiene los ids de documentos obtenidos filtrando por una
	 * lista de metadatos
	 * 
	 * @param tokenSesion
	 *            token de sesion
	 * @param auditUser
	 *            usuario
	 * @param documentalType
	 *            String Identificador del Tipo
	 * @param returnedAttributeKeysList
	 *            String Lista de Metadatos a devolver
	 * @param searchConditionsList
	 *            String Lista de Metadatos para filtrar
	 * @param boolAllVersions
	 *            boolean Indica si se recuperan todas las versiones de los
	 *            documentos
	 * @param intMaxRows
	 *            int Numero maximo de resultados a recuperar
	 * @return String: OID del documento. null si falla
	 * @throws Exception
	 *             ex
	 */
	public String buscarDocumentosDokusi(String tokenSesion, String auditUser, String documentalType,
			String returnedAttributeKeysList, String searchConditionsList, boolean boolAllVersions, int intMaxRows)
			throws Exception;

	/**
	 * Método que almacena un documento en DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de sesion
	 * @param auditUser
	 *            usuario
	 * @param content
	 *            contenido del documento
	 * @param documentalType
	 *            tipo documental
	 * @param attributeList
	 *            lista de metadatos
	 * @return String: OID del documento. null si falla
	 * @throws Exception
	 *             ex
	 */
	public String registrarDocumentoDokusi(String tokenSesion, String auditUser, String content, String documentalType,
			String attributeList) throws Exception;

	/**
	 * Método que retramita un documento en DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de sesion
	 * @param auditUser
	 *            usuario
	 * @param documentId
	 *            id del documento
	 * @param documentalType
	 *            tipo documental
	 * @param attributeList
	 *            lista de metadatos
	 * @return String
	 * @throws Exception
	 *             ex
	 */
	public String retramitarDocumentoDokusi(String tokenSesion, String auditUser, String documentId,
			String documentalType, String attributeList) throws Exception;

	/**
	 * Método que modifica el contenido de un documento en DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de sesion
	 * @param auditUser
	 *            usuario
	 * @param documentId
	 *            id del documento
	 * @param saveAsVersion
	 *            String
	 * @param boolSetCurrent
	 *            boolean
	 * @param content
	 *            String
	 * @return String: OID del documento. null si falla
	 * @throws Exception
	 *             ex
	 */
	public String modificarDocumentoDokusiContent(String tokenSesion, String auditUser, String documentId,
			String saveAsVersion, boolean boolSetCurrent, String content) throws Exception;

	/**
	 * Método que modifica los atributos de un documento en DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de sesion
	 * @param auditUser
	 *            usuario
	 * @param documentId
	 *            id del documento
	 * @param saveAsVersion
	 *            String
	 * @param boolSetCurrent
	 *            boolean
	 * @param attributeList
	 *            String
	 * @return String: OID del documento. null si falla
	 * @throws Exception
	 *             ex
	 */
	public String modificarDocumentoDokusiAtrib(String tokenSesion, String auditUser, String documentId,
			String saveAsVersion, boolean boolSetCurrent, String attributeList) throws Exception;

	/**
	 * Método que modifica el contenido o atributos o ambas cosas de un
	 * documento en DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de sesion
	 * @param auditUser
	 *            usuario
	 * @param documentId
	 *            id del documento
	 * @param saveAsVersion
	 *            String
	 * @param boolSetCurrent
	 *            boolean
	 * @param attributeList
	 *            String
	 * @param content
	 *            String
	 * @return String: OID del documento. null si falla
	 * @throws Exception
	 *             ex
	 */
	public String modificarDocumentoDokusi(String tokenSesion, String auditUser, String documentId,
			String saveAsVersion, boolean boolSetCurrent, String attributeList, String content) throws Exception;

	/**
	 * Método que descarga un documento en DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de sesion
	 * @param auditUser
	 *            usuario
	 * @param documentID
	 *            id del documento
	 * @param keysList
	 *            lista de metadatos a devolver
	 * @param content
	 *            bean con la extension del documento a recuperar
	 * @return String: OID del documento. null si casca
	 * @throws Exception
	 *             ex
	 */
	public String descargarDocumentoDokusi(String tokenSesion, String auditUser, String documentID, String keysList,
			String content) throws Exception;

	/**
	 * Método que elimina un documento de DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de seguridad
	 * @param auditUser
	 *            datos del usuario
	 * @param documentID
	 *            identificador del documento
	 * @param boolAllVersions
	 *            indica el borrado de todas las versiones del documento
	 * 
	 * @return String: OID del documento. null si casca
	 * @throws Exception
	 *             ex
	 */
	public String eliminarDocumentoDokusi(String tokenSesion, String auditUser, String documentID,
			boolean boolAllVersions) throws Exception;

	/**
	 * Método que permite recuperar las firmas de documento almacenado en el
	 * repositorio
	 * 
	 * @param tokenSesion
	 *            token xlnets
	 * @param auditUser
	 *            usuario
	 * @param documentID
	 *            identificador del documento
	 * @param format
	 *            formato del documento
	 * @return String: OID del documento. null si casca
	 * @throws Exception
	 *             ex
	 */
	public String recuperarFirmarDocumentosDokusi(String tokenSesion, String auditUser, String documentID,
			String format) throws Exception;

	/**
	 * Método que permite añadir firmas a un documento almacenado en el
	 * repositorio
	 * 
	 * @param tokenSesion
	 *            token xlnets
	 * @param auditUser
	 *            usuario
	 * @param documentID
	 *            identificador del documento
	 * @param signatures
	 *            lista de firmas
	 * @return String: OID del documento. null si casca
	 * @throws Exception
	 *             ex
	 */
	public String firmarDocumentosDokusi(String tokenSesion, String auditUser, String documentID, String signatures)
			throws Exception;

	/**
	 * Método que permite añadir un localizador a un documento almacenado en
	 * el repositorio
	 * 
	 * @param tokenSesion
	 *            String
	 * @param auditUser
	 *            String
	 * @param documentID
	 *            String
	 * @param boolVersion
	 *            boolean
	 * @param boolReducir
	 *            String
	 * @param sede
	 *            String
	 * 
	 * @return String: OID del documento. null si casca
	 * @throws Exception
	 *             ex
	 */
	public String incorporarLocalizadorDocumentoDokusi(String tokenSesion, String auditUser, String documentID,
			boolean boolVersion, String boolReducir, String sede) throws Exception;

	/**
	 * Metodo que transforma un documento almacenado en el repositorio
	 * 
	 * @param tokenSesion
	 *            String
	 * @param auditUser
	 *            String
	 * @param documentID
	 *            String
	 * @param format
	 *            String
	 * 
	 * @return String: OID del documento. null si casca
	 * @throws Exception
	 *             ex
	 */
	public String transformarDocumentoDokusi(String tokenSesion, String auditUser, String documentID, String format)
			throws Exception;

	/**
	 * Método que recupera los formatos de un documento de DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de seguridad
	 * @param auditUser
	 *            datos del usuario
	 * @param documentID
	 *            identificador del documento
	 * 
	 * @return String: Formatos del documento
	 * @throws Exception
	 *             ex
	 */
	public String recuperarFormatosDocumentosDokusi(String tokenSesion, String auditUser, String documentID)
			throws Exception;

	/**
	 * Metodo que genera un nuevo documento copia que comparte el contenido del
	 * original.
	 * 
	 * @param tokenSesion
	 *            token de sesion
	 * @param auditUser
	 *            usuario
	 * @param documentID
	 *            String
	 * @param attributeList
	 *            lista de metadatos
	 * @return String: OID del documento. null si falla
	 * @throws Exception
	 *             ex
	 */
	public String shareDocumentContents(String tokenSesion, String auditUser, String documentID, String attributeList)
			throws Exception;

	/**
	 * Método que permitirá cambiar un documento de contexto de Registro a
	 * contexto de Tramitación y modifica el acl o la serie documental de un
	 * documento de DOKUSI
	 * 
	 * @param tokenSesion
	 *            token de seguridad
	 * @param auditUser
	 *            datos del usuario
	 * @param documentID
	 *            identificador del documento
	 * @param tipoDocumental
	 *            tipo documental del documento
	 * @param attributeList
	 *            lista de atributos
	 * 
	 * @return boolean: Resultado de la operacion
	 * @throws Exception
	 *             ex
	 */
	public boolean tramitarDocumentoDokusi(String tokenSesion, String auditUser, String documentID,
			String tipoDocumental, String attributeList) throws Exception;
}
