package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.ejie.x43s.v2.mgs.ws.X43MGS;
import com.ejie.x43s.v2.mgs.ws.X43MGSPortType;
import com.ejie.x43s.v2.mgs.xml.TProceedingList;
import com.ejie.x43s.v2.ttn.xml.AExtensionPoint;
import com.ejie.x43s.v2.ttn.xml.TBoolean;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;

/**
 * <p>
 * Titulo: X43sServiceImpl
 * </p>
 * <p>
 * Descipcion: Realiza invocaciones al webServices de X43MisGestiones
 * </p>
 * <p>
 * Copyright: Copyright (c) 2018
 * </p>
 * <p>
 * Empresa: Bilbomatica
 * </p>
 * 
 *  
 * @version 1.0
 */
@Service(value = "X43sServiceImpl")
public class X43sServiceImpl {
	private static final Logger logger = LoggerFactory
			.getLogger(X43sServiceImpl.class);

	private X43MGS service;

	/**
	 * Method 'reportProceedingsUpdate'. Metodo encargado de escribir en mis
	 * gestiones
	 * 
	 * @param folderNumber
	 *            String
	 * @param year
	 *            String
	 * @param procedureID
	 *            String
	 * @param updateDate
	 *            String
	 * @param proceedingList
	 *            TProceedingList
	 * @param ep
	 *            AExtensionPoint
	 * 
	 * @return TBoolean
	 * @throws Throwable
	 *             Throwable
	 */
	public TBoolean reportProceedingsUpdate(String folderNumber, String year,
			String procedureID, String updateDate,
			TProceedingList proceedingList, AExtensionPoint ep)
			throws Throwable {
		return this.getX43MGSServicePort()
				.reportProceedingsUpdate(folderNumber, year, procedureID,
						updateDate, proceedingList, ep);
	}

	/**
	 * Method 'reportProceedingsDelete'. Metodo encargado de borrar en mis
	 * gestiones
	 * 
	 * @param folderNumber
	 *            String
	 * @param year
	 *            String
	 * @param procedureID
	 *            String
	 * @param proceedingID
	 *            String
	 * @param participantID
	 *            String
	 * @param ep
	 *            AExtensionPoint
	 * 
	 * @return TBoolean
	 * @throws Throwable
	 *             Throwable
	 */
	public TBoolean reportProceedingsDelete(String folderNumber, String year,
			String procedureID, String proceedingID, String participantID,
			AExtensionPoint ep) throws Throwable {
		return this.getX43MGSServicePort().reportProceedingsDelete(
				folderNumber, year, procedureID, proceedingID, participantID,
				ep);
	}

	/**
	 * Method 'iniciarX43MGSService'. Metodo que inicia el servicio
	 * 
	 * @throws Throwable
	 *             Throwable
	 * 
	 */
	public void iniciarX43MGSService() throws Throwable {
		this.getX43MGSServicePort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName qname = new QName("com/ejie/x43s/v2/mgs/ws",
			"X43MGS");

	/**
	 * Method 'getX43MGSServicePort'. Metodo encargado de obtener el port del WS
	 * 
	 * @return X43MGSPortType
	 * @throws Throwable
	 *             Throwable
	 */
	private X43MGSPortType getX43MGSServicePort() throws Throwable {
		return this.getX43MGSServicePort(true);
	}

	/**
	 * Method 'getX43MGSServicePort'. Metodo encargado de obtener el port del WS
	 * 
	 * @param getPort
	 *            boolean
	 * @return X43MGSPortType
	 * @throws Throwable
	 *             Throwable
	 */
	private X43MGSPortType getX43MGSServicePort(boolean getPort)
			throws Throwable {
		try {
			Properties prop = Y41bConfig
					.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE X43MGS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new X43MGS(new URL(prop.getProperty("URL_X43MGS")),
						qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections
								.singletonList(new X43sServiceHandler());
					}
				});
				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE X43MGS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT X43MGS inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				X43MGSPortType proxy = this.service.getX43MGSPort();

				Map<String, Object> ctxt = ((BindingProvider) proxy)
						.getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						prop.getProperty("URL_X43MGS"));

				return proxy;
			}
		} catch (Throwable e) {
			logger.error(
					"Error al intentar obtener el servidor en el mtodo getAA66ServicePort ",
					e);
			this.service = null;
		}
		return null;
	}
}