package com.ejie.y41b.adapter.services;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.xlnets.Y41bUtils;

public class X43sServiceHandler implements SOAPHandler<SOAPMessageContext> {

	private static final Logger logger = LoggerFactory
			.getLogger(X43sServiceHandler.class);

	private TransformerFactory transformerFactory;

	/**
	 * Constructor por defecto.
	 * 
	 */
	public X43sServiceHandler() {
		this.transformerFactory = TransformerFactory.newInstance();
	}

	@Override
	public Set<QName> getHeaders() {
		return new HashSet<QName>();
	}

	@Override
	public void close(MessageContext context) {

	}

	/**
	 * @see javax.xml.ws.handler.Handler#handleFault(javax.xml.ws.handler.MessageContext)
	 */
	@Override
	public boolean handleFault(SOAPMessageContext context) {
		logger.error("Error cliente ws X43S " + logging(context));
		return true;
	}

	/**
	 * @see javax.xml.ws.handler.Handler#handleMessage(javax.xml.ws.handler.MessageContext)
	 */
	@Override
	public boolean handleMessage(SOAPMessageContext context) {

		boolean valid = true;

		Boolean outbound = (Boolean) context
				.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

		// logger.info("cliente ws NSHF outbound: " + String.valueOf(outbound)
		// + " " + logging(context));

		// solo para los mensajes SALIENTES
		if (outbound != null && outbound.booleanValue()) {
			valid = false;
			try {
				DocumentBuilderFactory factory = DocumentBuilderFactory
						.newInstance();
				DocumentBuilder builder = factory.newDocumentBuilder();
				Properties prop = Y41bConfig
						.loadProperties(Y41bConstantes.CONFIG_PATH);

				org.w3c.dom.Document token = builder
						.parse(new InputSource(
								new StringReader(
										Y41bUtils
												.getInstance()
												.getTokenAplicacion(
														Boolean.parseBoolean(prop
																.getProperty("xlnets.loginApp.isSimulated"))))));

				// recuperar cabecera SOAP
				SOAPHeader soapHeader = context.getMessage().getSOAPHeader();

				// incluir token en la cabecera creada
				Source source = new DOMSource(token);
				Result result = new DOMResult(soapHeader);
				this.transformerFactory.newTransformer().transform(source,
						result);

				// se puede continuar el procesamiento
				valid = true;

				logger.info("cliente ws X43S outbound: Token inyectado al header");

				context.put("timeini", new Long(System.currentTimeMillis()));

			} catch (Exception e) {
				e.printStackTrace();
			} catch (Throwable e) {
				e.printStackTrace();
			}

		} else {

			long timeini = (Long) (context.get("timeini"));
			long timefin = System.currentTimeMillis();

			BigDecimal result = ((new BigDecimal(timefin)
					.subtract(new BigDecimal(timeini))).divide(new BigDecimal(
					1000), 5, BigDecimal.ROUND_FLOOR));

			logger.info("cliente ws X43S tiempo transcurrido de respuesta: "
					+ result + " sg ");
		}
		return valid;

	}

	private String logging(SOAPMessageContext context) {
		try {
			ByteArrayOutputStream out = new ByteArrayOutputStream();
			context.getMessage().writeTo(out);
			return new String(out.toByteArray());
		} catch (Exception e) {
			logger.error("Error", e);
		}
		return "NO SACAMOS MENSAJE SOAP";
	}
}
