package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.ws.cliente.x43k.X43KWebService;
import com.ejie.y41b.ws.cliente.x43k.X43KWebService_Service;

/**
 * <p>
 * Titulo: X43kServiceImpl
 * </p>
 * <p>
 * Descipcion: Realiza invocaciones al webServices de X43MisGestiones
 * </p>
 * <p>
 * Copyright: Copyright (c) 2018
 * </p>
 * <p>
 * Empresa: Bilbomatica
 * </p>
 * 
 *  
 * @version 1.0
 */
@Service(value = "X43kServiceImpl")
public class X43kServiceImpl {
	private static final Logger logger = LoggerFactory
			.getLogger(X43kServiceImpl.class);

	private X43KWebService_Service service;

	/**
	 * Method 'getRequestInformation'. Metodo encargado de recuperar el
	 * EJGVDocument
	 * 
	 * @param idSolicitud
	 *            String
	 * @param folderId
	 *            String
	 * 
	 * @return String
	 * @throws Throwable
	 *             Throwable
	 */
	public String getRequestInformation(String idSolicitud, String folderId)
			throws Throwable {
		return this.getX43KWebServicePort().getRequestInformation(idSolicitud,
				folderId);
	}

	/**
	 * Method 'iniciarX43KWebService'. Metodo que inicia el servicio
	 * 
	 * @throws Throwable
	 *             Throwable
	 * 
	 */
	public void iniciarX43KWebService() throws Throwable {
		this.getX43KWebServicePort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName qname = new QName("com/ejie/toolkit/xml",
			"x43kWebService");

	/**
	 * Method 'getX43KWebServicePort'. Metodo encargado de obtener el port del
	 * WS
	 * 
	 * @return X43KWebService
	 * @throws Throwable
	 *             Throwable
	 */
	private X43KWebService getX43KWebServicePort() throws Throwable {
		return this.getX43KWebServicePort(true);
	}

	/**
	 * Method 'getX43KWebServicePort'. Metodo encargado de obtener el port del
	 * WS
	 * 
	 * @param getPort
	 *            boolean
	 * @return X43KWebService
	 * @throws Throwable
	 *             Throwable
	 */
	private X43KWebService getX43KWebServicePort(boolean getPort)
			throws Throwable {
		try {
			Properties prop = Y41bConfig
					.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE X43K >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new X43KWebService_Service(new URL(
						prop.getProperty("URL_X43K")), qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections
								.singletonList(new X43kServiceHandler());
					}
				});
				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE X43K >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT X43K inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				X43KWebService proxy = this.service.getX43KWebServicePort();

				Map<String, Object> ctxt = ((BindingProvider) proxy)
						.getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						prop.getProperty("URL_X43K"));

				return proxy;
			}
		} catch (Throwable e) {
			logger.error(
					"Error al intentar obtener el servidor en el mtodo getAA66ServicePort ",
					e);
			this.service = null;
		}
		return null;
	}
}