package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.ws.cliente.x43notificaciones.AExtensionPoint;
import com.ejie.y41b.ws.cliente.x43notificaciones.TDocumentFilter;
import com.ejie.y41b.ws.cliente.x43notificaciones.TDocumentList;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNotificationCreateNew;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNotificationFilter;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNotificationList;
import com.ejie.y41b.ws.cliente.x43notificaciones.X43NOT;
import com.ejie.y41b.ws.cliente.x43notificaciones.X43NOTPortType;

/**
 * <p>
 * Titulo: X43NotificacionesServiceImpl
 * </p>
 * <p>
 * Descipcion: Realiza invocaciones al webServices de X43Notificaciones
 * </p>
 * <p>
 * Copyright: Copyright (c) 2018
 * </p>
 * <p>
 * Empresa: Bilbomatica
 * </p>
 * 
 *  
 * @version 1.0
 */
@Service(value = "X43NotificacionesServiceImpl")
public class X43NotificacionesServiceImpl {
	private static final Logger logger = LoggerFactory
			.getLogger(X43NotificacionesServiceImpl.class);

	private X43NOT service;

	/**
	 * Method 'searchDocument'. Metodo que devuelve la lista de todas las
	 * notificaciones existentes segn los parmetros de entrada. Al menos tiene
	 * que tener un parmetro de filtro.
	 * 
	 * @param filter
	 *            TDocumentFilter
	 * @param ep
	 *            AExtensionPoint
	 * 
	 * @return TDocumentList
	 * @throws Throwable
	 *             Throwable
	 */
	public TDocumentList searchDocument(TDocumentFilter filter,
			AExtensionPoint ep) throws Throwable {
		return this.getX43NotificacionesWebServicePort().searchDocument(filter,
				ep);
	}

	/**
	 * Method 'searchNotification'. Metodo que devuelve la lista de todas las
	 * notificaciones existentes segn los parmetros de entrada. Al menos tiene
	 * que tener un parmetro de filtro.
	 * 
	 * @param filter
	 *            TNotificationFilter
	 * @param ep
	 *            AExtensionPoint
	 * 
	 * @return TNotificationList
	 * @throws Throwable
	 *             Throwable
	 */
	public TNotificationList searchNotification(TNotificationFilter filter,
			AExtensionPoint ep) throws Throwable {
		return this.getX43NotificacionesWebServicePort().searchNotification(
				filter, ep);
	}

	/**
	 * Method 'searchNotification'. Metodo que envia una notificacin
	 * telematica.
	 * 
	 * @param notification
	 *            TNotificationCreateNew
	 * @param ep
	 *            AExtensionPoint
	 * 
	 * @return String
	 * @throws Throwable
	 *             Throwable
	 */
	public String notificationPublish(TNotificationCreateNew notification,
			AExtensionPoint ep) throws Throwable {
		return this.getX43NotificacionesWebServicePort().notificationPublish(
				notification, ep);
	}

	/**
	 * Method 'iniciarX43NotificacionesWebService'. Metodo que inicia el
	 * servicio
	 * 
	 * @throws Throwable
	 *             Throwable
	 * 
	 */
	public void iniciarX43NotificacionesWebService() throws Throwable {
		this.getX43NotificacionesWebServicePort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName qname = new QName("com/ejie/x43s/v2/not/ws",
			"X43NOT");

	/**
	 * Method 'getX43KWebServicePort'. Metodo encargado de obtener el port del
	 * WS
	 * 
	 * @return X43NOTPortType
	 * @throws Throwable
	 *             Throwable
	 */
	private X43NOTPortType getX43NotificacionesWebServicePort()
			throws Throwable {
		return this.getX43NotificacionesWebServicePort(true);
	}

	/**
	 * Method 'getX43NotificacionesWebServicePort'. Metodo encargado de obtener
	 * el port del WS
	 * 
	 * @param getPort
	 *            boolean
	 * @return X43NOTPortType
	 * @throws Throwable
	 *             Throwable
	 */
	private X43NOTPortType getX43NotificacionesWebServicePort(boolean getPort)
			throws Throwable {
		try {
			Properties prop = Y41bConfig
					.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE X43NOTIFICACIONES >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new X43NOT(new URL(
						prop.getProperty("URL_X43NOTIFICACIONES")), qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections
								.singletonList(new X43NotificacionesServiceHandler());
					}
				});
				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE X43NOTIFICACIONES >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT X43NOTIFICACIONES inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				X43NOTPortType proxy = this.service.getX43NOTPort();

				Map<String, Object> ctxt = ((BindingProvider) proxy)
						.getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						prop.getProperty("URL_X43NOTIFICACIONES"));

				return proxy;
			}
		} catch (Throwable e) {
			logger.error(
					"Error al intentar obtener el servidor en el mtodo getX43NotificacionesWebServicePort ",
					e);
			this.service = null;
		}
		return null;
	}
}