package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.ws.cliente.x43CuentasInteresados.TInteresado;
import com.ejie.y41b.ws.cliente.x43CuentasInteresados.TInterestedSearch;
import com.ejie.y41b.ws.cliente.x43CuentasInteresados.X43AWsRriPublicService;
import com.ejie.y41b.ws.cliente.x43CuentasInteresados.X43AWsRriPublicService_Service;

/**
 * <p>
 * Titulo: X43CuentasInteresadosServiceImpl
 * </p>
 * <p>
 * Descipcion: Realiza invocaciones al webServices de X43CuentasInteresados
 * </p>
 * <p>
 * Copyright: Copyright (c) 2018
 * </p>
 * <p>
 * Empresa: Bilbomatica
 * </p>
 * 
 *  
 * @version 1.0
 */
@Service(value = "X43CuentasInteresadosServiceImpl")
public class X43CuentasInteresadosServiceImpl {
	private static final Logger logger = LoggerFactory
			.getLogger(X43CuentasInteresadosServiceImpl.class);

	private X43AWsRriPublicService_Service service;

	/**
	 * Method 'getPersonsConsent'. Metodo que devuelve la informacin de los
	 * interesados por los que se pregunta.
	 * 
	 * @param interestedSearch
	 *            TInterestedSearch
	 * 
	 * @return List<TInteresado>
	 * @throws Throwable
	 *             Throwable
	 */
	public List<TInteresado> getPersonsConsent(
			TInterestedSearch interestedSearch) throws Throwable {
		return this.getX43CuentasInteresadosWebServicePort().getPersonsConsent(
				interestedSearch);
	}

	/**
	 * Method 'iniciarX43CuentasInteresadosWebService'. Metodo que inicia el
	 * servicio
	 * 
	 * @throws Throwable
	 *             Throwable
	 * 
	 */
	public void iniciarX43CuentasInteresadosWebService() throws Throwable {
		this.getX43CuentasInteresadosWebServicePort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName qname = new QName("com/ejie/x43a/rri/ws",
			"X43aWsRriPublicService");

	/**
	 * Method 'getX43CuentasInteresadosWebServicePort'. Metodo encargado de
	 * obtener el port del WS
	 * 
	 * @return X43AWsRriPublicService
	 * @throws Throwable
	 *             Throwable
	 */
	private X43AWsRriPublicService getX43CuentasInteresadosWebServicePort()
			throws Throwable {
		return this.getX43CuentasInteresadosWebServicePort(true);
	}

	/**
	 * Method 'getX43CuentasInteresadosWebServicePort'. Metodo encargado de
	 * obtener el port del WS
	 * 
	 * @param getPort
	 *            boolean
	 * @return X43AWsRriPublicService
	 * @throws Throwable
	 *             Throwable
	 */
	private X43AWsRriPublicService getX43CuentasInteresadosWebServicePort(
			boolean getPort) throws Throwable {
		try {
			Properties prop = Y41bConfig
					.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE X43CUENTASINTERESADOS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new X43AWsRriPublicService_Service(new URL(
						prop.getProperty("URL_X43CUENTASINTERESADOS")), qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections
								.singletonList(new X43CuentasInteresadosServiceHandler());
					}
				});
				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE X43CUENTASINTERESADOS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT X43CUENTASINTERESADOS inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				X43AWsRriPublicService proxy = this.service
						.getX43AWsRriPublicServicePort();

				Map<String, Object> ctxt = ((BindingProvider) proxy)
						.getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						prop.getProperty("URL_X43CUENTASINTERESADOS"));

				return proxy;
			}
		} catch (Throwable e) {
			logger.error(
					"Error al intentar obtener el servidor en el mtodo getX43CuentasInteresadosWebServicePort ",
					e);
			this.service = null;
		}
		return null;
	}
}