package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.ws.cliente.t65bfsd.T65BFSDWSClasePort;
import com.ejie.y41b.ws.cliente.t65bfsd.T65BFSDWSClasePortQSService;

public class T65BFSDWSClasePortQSServiceWSServiceImpl {
	private static final Logger logger = LoggerFactory
			.getLogger(T65BFSDWSClasePortQSServiceWSServiceImpl.class);

	private T65BFSDWSClasePortQSService service;

	public String buscarDocumentosDokusi(String integrationToken,
			String auditUser, String documentalType,
			String returnedAttributeKeysList, String searchConditionsList,
			boolean boolAllVersions, int intMaxRows) {
		return this.getT65BFSDWSClasePort().searchDocumentsEx(integrationToken,
				auditUser, documentalType, returnedAttributeKeysList,
				searchConditionsList, boolAllVersions, intMaxRows);
	}

	public String registrarDocumentoDokusi(String integrationToken,
			String auditUser, String content, String documentalType,
			String attributeList) {
		return this.getT65BFSDWSClasePort().storeDocument(integrationToken,
				auditUser, content, documentalType, attributeList);
	}

	public String shareDocumentContents(String integrationToken,
			String auditUser, String documentID, String attributeList) {
		return this.getT65BFSDWSClasePort().shareDocumentContents(
				integrationToken, auditUser, documentID, attributeList);
	}

	public String modificarDocumentoDokusiContent(String integrationToken,
			String auditUser, String documentID, String saveAsVersion,
			boolean boolSetCurrent, String content) {
		return this.getT65BFSDWSClasePort().modifyDocument(integrationToken,
				auditUser, documentID, saveAsVersion, boolSetCurrent, null,
				content);
	}

	public String modificarDocumentoDokusiAtrib(String integrationToken,
			String auditUser, String documentID, String saveAsVersion,
			boolean boolSetCurrent, String attributeList) {
		return this.getT65BFSDWSClasePort().modifyDocument(integrationToken,
				auditUser, documentID, saveAsVersion, boolSetCurrent,
				attributeList, "");
	}

	public String modificarDocumentoDokusi(String integrationToken,
			String auditUser, String documentID, String saveAsVersion,
			boolean boolSetCurrent, String attributeList, String content) {
		return this.getT65BFSDWSClasePort().modifyDocument(integrationToken,
				auditUser, documentID, saveAsVersion, boolSetCurrent,
				attributeList, content);
	}

	public String descargarDocumentoDokusi(String integrationToken,
			String auditUser, String documentID, String keysList, String content) {
		return this.getT65BFSDWSClasePort().retrieveDocument(integrationToken,
				auditUser, documentID, keysList, content);
	}

	public String eliminarDocumentoDokusi(String integrationToken,
			String auditUser, String documentID, boolean boolAllVersions) {
		return this.getT65BFSDWSClasePort().deleteDocument(integrationToken,
				auditUser, documentID, boolAllVersions);
	}

	public String recuperarFirmarDocumentosDokusi(String integrationToken,
			String auditUser, String documentID, String format) {
		return this.getT65BFSDWSClasePort().retrieveSignatures(
				integrationToken, auditUser, documentID, format);
	}

	public boolean firmarDocumentosDokusi(String integrationToken,
			String auditUser, String documentID, String signatures) {
		return this.getT65BFSDWSClasePort().addSignaturesToDocument(
				integrationToken, auditUser, documentID, signatures);
	}

	public String incorporarLocalizadorDocumentoDokusi(String integrationToken,
			String auditUser, String documentID, boolean boolVersion,
			String boolReducir, String sede) {
		return this.getT65BFSDWSClasePort().addLocatorToDocumentQR(
				integrationToken, auditUser, documentID, boolVersion,
				boolReducir, sede);
	}

	public boolean transformarDocumentoDokusi(String integrationToken,
			String auditUser, String documentID, String format) {
		return this.getT65BFSDWSClasePort().createTransformation(
				integrationToken, auditUser, documentID, format);
	}

	public boolean eliminarLocalizadorDocumentoDokusi(String integrationToken,
			String auditUser, String documentIDs) {
		return this.getT65BFSDWSClasePort().removeLocatorVerification(
				integrationToken, auditUser, documentIDs);
	}

	public boolean reincorporarLocalizadorDocumentoDokusi(
			String integrationToken, String auditUser, String documentIDs) {
		return this.getT65BFSDWSClasePort().restoreLocatorVerification(
				integrationToken, auditUser, documentIDs);
	}

	public String recuperarFormatosDocumentosDokusi(String integrationToken,
			String auditUser, String documentID) {
		return this.getT65BFSDWSClasePort().retrieveDocumentFormats(
				integrationToken, auditUser, documentID);
	}

	public boolean retramitarDocumentoDokusi(String integrationToken,
			String auditUser, String documentID, String newDocumentalType,
			String attributeList) {
		return this.getT65BFSDWSClasePort().retramitateDocument(
				integrationToken, auditUser, documentID, newDocumentalType,
				attributeList);
	}

	public boolean tramitarDocumentoDokusi(String integrationToken,
			String auditUser, String documentID, String newDocumentalType,
			String attributeList) {
		return this.getT65BFSDWSClasePort().tramitateDocument(integrationToken,
				auditUser, documentID, newDocumentalType, attributeList);
	}

	public void iniciarT65BFSDWSClasePortQSService() {
		this.getT65BFSDWSClasePort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName qname = new QName(
			"http://www.ejie.es/webServiceClase/t65bFSDWar",
			"t65bFSDWSClasePortQSService");

	private T65BFSDWSClasePort getT65BFSDWSClasePort() {
		return this.getT65BFSDWSClasePort(true);
	}

	private T65BFSDWSClasePort getT65BFSDWSClasePort(boolean getPort) {
		try {
			Properties prop = Y41bConfig
					.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE T65BFSDWSClasePortQSService >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new T65BFSDWSClasePortQSService(new URL(
						prop.getProperty("URL_DOKUSI")), qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections
								.singletonList(new Y41bDefaultServiceHandler());
					}
				});

				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE T65BFSDWSClasePortQSService >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT T65BFSDWSClasePortQSService inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				T65BFSDWSClasePort proxy = this.service
						.getT65BFSDWSClasePortQSPort();

				Map<String, Object> ctxt = ((BindingProvider) proxy)
						.getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						prop.getProperty("URL_DOKUSI"));

				return proxy;
			}
		} catch (Exception e) {
			this.service = null;
		}
		return null;
	}
}