package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.sir.Exception_Exception;
import com.ejie.y41b.sir.X97DistributionWebServiceImpl;
import com.ejie.y41b.sir.X97DistributionWebServicePortBindingQSService;
import com.ejie.y41b.utils.config.Y41bConfig;

public class SirServiceImpl {
	private static final Logger logger = LoggerFactory.getLogger(SirServiceImpl.class);

	private X97DistributionWebServicePortBindingQSService service;

	public String verifyProcedure(String integrationToken, String procedure) throws Exception_Exception {
		return this.getX97DistributionWebServiceSoapPort().verifyProcedure(integrationToken, procedure);
	}

	public String retrieveRegistryDocuments(String integrationToken, String auditUser, String documentIDArray,
			String keysListArray, String contentArray) throws Exception_Exception {
		return this.getX97DistributionWebServiceSoapPort().retrieveRegistryDocuments(integrationToken, auditUser,
				documentIDArray, keysListArray, contentArray);
	}

	public String acceptDistribution(String integrationToken, String distributionInfo) throws Exception_Exception {
		return this.getX97DistributionWebServiceSoapPort().acceptDistribution(integrationToken, distributionInfo);
	}

	public String rejectDistribution(String integrationToken, String distributionInfo) throws Exception_Exception {
		return this.getX97DistributionWebServiceSoapPort().rejectDistribution(integrationToken, distributionInfo);
	}

	public void iniciarNSHFService() {
		this.getX97DistributionWebServiceSoapPort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName qname = new QName("http://com.ejie.x97",
			"X97DistributionWebServicePortBindingQSService");

	private X97DistributionWebServiceImpl getX97DistributionWebServiceSoapPort() {
		return this.getX97DistributionWebServiceSoapPort(true);
	}

	private X97DistributionWebServiceImpl getX97DistributionWebServiceSoapPort(boolean getPort) {
		try {
			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			// String url = "";
			// if (prop.getProperty("entorno_ejecucion").equals("produccion")) {
			// url = prop.getProperty("URL_CDAR");
			// } else {
			// url = prop.getProperty("URL_DAR");
			// }

			// Para todos CDAR - tras hablar con Mikel 07/05
			String url = prop.getProperty("URL_CDAR");

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE SIR >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new X97DistributionWebServicePortBindingQSService(new URL(url), qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections.singletonList(new N61ServiceHandler());
					}
				});
				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE SIR >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT SIR inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				X97DistributionWebServiceImpl proxy = this.service.getX97DistributionWebServicePortBindingQSPort();

				Map<String, Object> ctxt = ((BindingProvider) proxy).getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, url);

				return proxy;
			}
		} catch (Exception e) {
			this.service = null;
			logger.error("Error en el metodo getX97DistributionWebServiceSoapPort de la clase SirServiceImpl: ", e);
		}
		return null;
	}
}