package com.ejie.y41b.adapter.services;

import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SirServiceHandler implements SOAPHandler<SOAPMessageContext> {

	private static final Logger logger = LoggerFactory.getLogger(SirServiceHandler.class);

	private TransformerFactory transformerFactory;

	/**
	 * Constructor por defecto.
	 * 
	 */
	public SirServiceHandler() {
		this.transformerFactory = TransformerFactory.newInstance();
	}

	@Override
	public Set<QName> getHeaders() {
		return new HashSet<QName>();
	}

	@Override
	public void close(MessageContext context) {

	}

	/**
	 * @see javax.xml.ws.handler.Handler#handleFault(javax.xml.ws.handler.MessageContext)
	 */
	@Override
	public boolean handleFault(SOAPMessageContext context) {
		logger.error("Error cliente ws NSHF " + logging(context));
		return true;
	}

	/**
	 * @see javax.xml.ws.handler.Handler#handleMessage(javax.xml.ws.handler.MessageContext)
	 */
	@Override
	public boolean handleMessage(SOAPMessageContext context) {

		boolean valid = true;

		Boolean outbound = (Boolean) context.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

		// solo para los mensajes SALIENTES
		if (outbound != null && outbound.booleanValue()) {
			try {
				logger.info("cliente ws outbound: Token inyectado al header");
				context.put("timeini", new Long(System.currentTimeMillis()));
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			long timeini = (Long) (context.get("timeini"));
			long timefin = System.currentTimeMillis();
			BigDecimal result = ((new BigDecimal(timefin).subtract(new BigDecimal(timeini)))
					.divide(new BigDecimal(1000), 5, BigDecimal.ROUND_FLOOR));
			logger.info("cliente ws tiempo transcurrido de respuesta: " + result + " sg ");
		}
		return valid;

	}

	private String logging(SOAPMessageContext context) {
		try {
			ByteArrayOutputStream out = new ByteArrayOutputStream();
			context.getMessage().writeTo(out);
			return new String(out.toByteArray());
		} catch (Exception e) {
			logger.error("Error", e);
		}
		return "NO SACAMOS MENSAJE SOAP";
	}
}
