package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.ws.cliente.r02vdcaincrono.Q99USendMessageSCPFacadeWS;
import com.ejie.y41b.ws.cliente.r02vdcaincrono.Q99USendMessageSCPFacadeWSSoap;

public class Q99USendMessageSCPFacadeWSServiceImpl {
	private static final Logger logger = LoggerFactory
			.getLogger(Q99USendMessageSCPFacadeWSServiceImpl.class);

	private Q99USendMessageSCPFacadeWS service;

	public void actualizarMisGestiones(String sSessionToken,
			String sXMLExpedient) {
		this.getQ99USendMessageSCPFacadeWSSoapPort().sendMessageSC(
				sSessionToken, sXMLExpedient, "saveOrUpdateProceedingsNT");
	}

	public void eliminarMisGestiones(String sSessionToken, String sXMLExpedient) {
		this.getQ99USendMessageSCPFacadeWSSoapPort().sendMessageSC(
				sSessionToken, sXMLExpedient, "deleteProceedingsNT");
	}

	public void actualizarExpediente(String sSessionToken, String sXMLExpedient) {
		this.getQ99USendMessageSCPFacadeWSSoapPort().sendMessageSC(
				sSessionToken, sXMLExpedient, "saveOrUpdateExpedientNT");
	}

	public void crearMatarEspera(String sSessionToken, String sXMLExpedient,
			String sServiceType) {
		this.getQ99USendMessageSCPFacadeWSSoapPort().sendMessageSC(
				sSessionToken, sXMLExpedient, sServiceType);
	}

	public void registrarHistorico(String sSessionToken, String xmlHistorico,
			String tipoHistorico) {
		this.getQ99USendMessageSCPFacadeWSSoapPort().sendMessageSC(
				sSessionToken, xmlHistorico, tipoHistorico);
	}

	public void eliminarHistorico(String sSessionToken, String xmlHistorico,
			String tipoHistorico) {
		this.getQ99USendMessageSCPFacadeWSSoapPort().sendMessageSC(
				sSessionToken, xmlHistorico, tipoHistorico);
	}

	public void abrirExpediente(String sSessionToken, String sXMLExpedient) {
		this.getQ99USendMessageSCPFacadeWSSoapPort().sendMessageSC(
				sSessionToken, sXMLExpedient, "initExpedientNT");
	}

	public void cerrarExpediente(String sSessionToken, String xmlCierre) {
		this.getQ99USendMessageSCPFacadeWSSoapPort().sendMessageSC(
				sSessionToken, xmlCierre, "closeExpedientNT");
	}

	public void actualizarParticipacion(String sSessionToken,
			String xmlParticipacion) {
		this.getQ99USendMessageSCPFacadeWSSoapPort().sendMessageSC(
				sSessionToken, xmlParticipacion, "saveOrUpdateParticipantNT");
	}

	public void iniciarQ99USendMessageSCPFacadeWSService() {
		this.getQ99USendMessageSCPFacadeWSSoapPort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName qname = new QName("http://www.openuri.org/",
			"Q99uSendMessageSCPFacadeWS");

	private Q99USendMessageSCPFacadeWSSoap getQ99USendMessageSCPFacadeWSSoapPort() {
		return this.getQ99USendMessageSCPFacadeWSSoapPort(true);
	}

	private Q99USendMessageSCPFacadeWSSoap getQ99USendMessageSCPFacadeWSSoapPort(
			boolean getPort) {
		try {
			Properties prop = Y41bConfig
					.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE Q99USendMessageSCPFacadeWS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new Q99USendMessageSCPFacadeWS(new URL(
						prop.getProperty("URL_NOTIF")), qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections
								.singletonList(new Y41bDefaultServiceHandler());
					}
				});

				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE Q99USendMessageSCPFacadeWS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT Q99USendMessageSCPFacadeWS inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				Q99USendMessageSCPFacadeWSSoap proxy = this.service
						.getQ99USendMessageSCPFacadeWSSoap();

				Map<String, Object> ctxt = ((BindingProvider) proxy)
						.getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						prop.getProperty("URL_SC"));

				return proxy;
			}
		} catch (Exception e) {
			this.service = null;
		}
		return null;
	}
}