package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.ws.cliente.r02tramitacionidsnotificaciones.Q99SSHNFacadeWS;
import com.ejie.y41b.ws.cliente.r02tramitacionidsnotificaciones.Q99SSHNFacadeWSSoap;

public class Q99SSHNFacadeWSServiceImpl {
	private static final Logger logger = LoggerFactory
			.getLogger(Q99SSHNFacadeWSServiceImpl.class);

	private Q99SSHNFacadeWS service;

	public String getNotificacionPubReceiptById(String sSessionToken,
			String sNotifID) {
		return this.getQ99SSHNFacadeWSSoapPort().getNotificationPubReceipt(
				sSessionToken, sNotifID);
	}

	public String getNotificacionReceiptById(String sSessionToken,
			String sNotifID) {
		return this.getQ99SSHNFacadeWSSoapPort().getNotificationReceipt(
				sSessionToken, sNotifID);
	}

	public void iniciarQ99SSHNFacadeWSService() {
		this.getQ99SSHNFacadeWSSoapPort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName qname = new QName("http://www.openuri.org/",
			"Q99sSHNFacadeWS");

	private Q99SSHNFacadeWSSoap getQ99SSHNFacadeWSSoapPort() {
		return this.getQ99SSHNFacadeWSSoapPort(true);
	}

	private Q99SSHNFacadeWSSoap getQ99SSHNFacadeWSSoapPort(boolean getPort) {
		try {
			Properties prop = Y41bConfig
					.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE Q99SSHNFacadeWS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new Q99SSHNFacadeWS(new URL(
						prop.getProperty("URL_SHN")), qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections
								.singletonList(new Y41bDefaultServiceHandler());
					}
				});

				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE Q99SSHNFacadeWS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT Q99SSHNFacadeWS inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				Q99SSHNFacadeWSSoap proxy = this.service
						.getQ99SSHNFacadeWSSoap();

				Map<String, Object> ctxt = ((BindingProvider) proxy)
						.getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						prop.getProperty("URL_SHN"));

				return proxy;
			}
		} catch (Exception e) {
			this.service = null;
		}
		return null;
	}
}