package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.ws.cliente.r02fdcdp.Q99RCPFacadeWS;
import com.ejie.y41b.ws.cliente.r02fdcdp.Q99RCPFacadeWSSoap;

public class Q99RCPFacadeWSServiceImpl {
	private static final Logger logger = LoggerFactory
			.getLogger(Q99RCPFacadeWSServiceImpl.class);

	private Q99RCPFacadeWS service;

	public String obtenerDatosCatalogoProcedimientos(String sSessionToken,
			String sProcedureId) {
		return this.getQ99RCPFacadeWSSoapPort().getProcedureFac(sSessionToken,
				sProcedureId);
	}

	public void iniciarQ99RCPFacadeWSService() {
		this.getQ99RCPFacadeWSSoapPort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName qname = new QName("http://www.openuri.org/",
			"Q99rCPFacadeWS");

	private Q99RCPFacadeWSSoap getQ99RCPFacadeWSSoapPort() {
		return this.getQ99RCPFacadeWSSoapPort(true);
	}

	private Q99RCPFacadeWSSoap getQ99RCPFacadeWSSoapPort(boolean getPort) {
		try {
			Properties prop = Y41bConfig
					.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE Q99RCPFacadeWS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new Q99RCPFacadeWS(
						new URL(prop.getProperty("URL_CP")), qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections
								.singletonList(new Y41bDefaultServiceHandler());
					}
				});

				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE Q99RCPFacadeWS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT Q99RCPFacadeWS inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				Q99RCPFacadeWSSoap proxy = this.service.getQ99RCPFacadeWSSoap();

				Map<String, Object> ctxt = ((BindingProvider) proxy)
						.getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						prop.getProperty("URL_CP"));

				return proxy;
			}
		} catch (Exception e) {
			this.service = null;
		}
		return null;
	}
}