package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.ws.cliente.r02cdtesc.Q99OTransactionClientFacadeWS;
import com.ejie.y41b.ws.cliente.r02cdtesc.Q99OTransactionClientFacadeWSSoap;

public class Q99OFacadeWSServiceImpl {
	private static final Logger logger = LoggerFactory
			.getLogger(Q99OFacadeWSServiceImpl.class);

	private Q99OTransactionClientFacadeWS service;

	public String abrirExpedienteOficio(String sSessionToken,
			String sAdminInitiationXML) {
		return this.getQ99OTransactionClientFacadeWSSoapPort()
				.addAdminInitiationRequest(sSessionToken, sAdminInitiationXML);
	}

	public void iniciarQ99OTransactionClientFacadeWSService() {
		this.getQ99OTransactionClientFacadeWSSoapPort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName qname = new QName("http://www.openuri.org/",
			"Q99oTransactionClientFacadeWS");

	private Q99OTransactionClientFacadeWSSoap getQ99OTransactionClientFacadeWSSoapPort() {
		return this.getQ99OTransactionClientFacadeWSSoapPort(true);
	}

	private Q99OTransactionClientFacadeWSSoap getQ99OTransactionClientFacadeWSSoapPort(
			boolean getPort) {
		try {
			Properties prop = Y41bConfig
					.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE Q99OTransactionClientFacadeWS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new Q99OTransactionClientFacadeWS(new URL(
						prop.getProperty("URL_OFICIO")), qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections
								.singletonList(new Y41bDefaultServiceHandler());
					}
				});

				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE Q99OTransactionClientFacadeWS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT Q99OTransactionClientFacadeWS inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				Q99OTransactionClientFacadeWSSoap proxy = this.service
						.getQ99OTransactionClientFacadeWSSoap();

				Map<String, Object> ctxt = ((BindingProvider) proxy)
						.getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						prop.getProperty("URL_OFICIO"));

				return proxy;
			}
		} catch (Exception e) {
			this.service = null;
		}
		return null;
	}
}