package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.ws.cliente.r02tramitacionids.Q99MServiceIfzFacadeWS;
import com.ejie.y41b.ws.cliente.r02tramitacionids.Q99MServiceIfzFacadeWSSoap;

public class Q99MServiceIfzFacadeWSServiceImpl {
	private static final Logger logger = LoggerFactory
			.getLogger(Q99MServiceIfzFacadeWSServiceImpl.class);

	Q99MServiceIfzFacadeWS service;

	public String crearEJGVDocumentNotificacion(String sessionToken,
			String tareaNotificar) {
		return this.getQ99MServiceIfzFacadeWSSoapPort()
				.createNotificationRequest(sessionToken, tareaNotificar);
	}

	public String envioNotificaciones(String sSessionToken,
			String sUnsignedNotification, String bytesNotification) {
		return this.getQ99MServiceIfzFacadeWSSoapPort().publishNotification(
				sSessionToken, sUnsignedNotification, bytesNotification);
	}

	public void iniciarQ99MServiceIfzFacadeWSService() {
		this.getQ99MServiceIfzFacadeWSSoapPort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName qname = new QName("http://www.openuri.org/",
			"Q99mServiceIfzFacadeWS");

	private Q99MServiceIfzFacadeWSSoap getQ99MServiceIfzFacadeWSSoapPort() {
		return this.getQ99MServiceIfzFacadeWSSoapPort(true);
	}

	private Q99MServiceIfzFacadeWSSoap getQ99MServiceIfzFacadeWSSoapPort(
			boolean getPort) {
		try {
			Properties prop = Y41bConfig
					.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE Q99MServiceIfzFacadeWS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new Q99MServiceIfzFacadeWS(new URL(
						prop.getProperty("URL_NOTIFICACIONES")), qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections
								.singletonList(new Y41bDefaultServiceHandler());
					}
				});

				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE Q99MServiceIfzFacadeWS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT Q99MServiceIfzFacadeWS inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				Q99MServiceIfzFacadeWSSoap proxy = this.service
						.getQ99MServiceIfzFacadeWSSoap();

				Map<String, Object> ctxt = ((BindingProvider) proxy)
						.getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						prop.getProperty("URL_NOTIFICACIONES"));

				return proxy;
			}
		} catch (Exception e) {
			this.service = null;
		}
		return null;
	}
}