package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.ws.cliente.r02solicitudesaportaciones.Q99MPPSFacadeWS;
import com.ejie.y41b.ws.cliente.r02solicitudesaportaciones.Q99MPPSFacadeWSSoap;

public class Q99MPPSFacadeWSServiceImpl {
	private static final Logger logger = LoggerFactory
			.getLogger(Q99MPPSFacadeWSServiceImpl.class);

	private Q99MPPSFacadeWS service;

	public String crearSolicitudPresencial(String sessionToken,
			String contextSubmission) {
		return this.getQ99MPPSFacadeWSSoapPort().sendEjgvDocumentPresencial(
				sessionToken, contextSubmission);
	}

	public String crearEJGVDocumentSolicitud(String sessionToken,
			String xmlDocument, String xslDocument, String textoPlano) {
		return this.getQ99MPPSFacadeWSSoapPort().createEjgvDocument(
				sessionToken, xmlDocument, xslDocument, textoPlano);
	}

	public String envioSolicitudes(String sSessionToken,
			String sContextSubmission, byte[] baEjgvDocument) {
		return this.getQ99MPPSFacadeWSSoapPort().sendEjgvDocumentST(
				sSessionToken, sContextSubmission, baEjgvDocument);
	}

	public void iniciarQ99MPPSFacadeWSService() {
		this.getQ99MPPSFacadeWSSoapPort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName qname = new QName("http://www.openuri.org/",
			"Q99mPPSFacadeWS");

	private Q99MPPSFacadeWSSoap getQ99MPPSFacadeWSSoapPort() {
		return this.getQ99MPPSFacadeWSSoapPort(true);
	}

	private Q99MPPSFacadeWSSoap getQ99MPPSFacadeWSSoapPort(boolean getPort) {
		try {
			Properties prop = Y41bConfig
					.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE Q99MPPSFacadeWS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new Q99MPPSFacadeWS(new URL(
						prop.getProperty("URL_PFS")), qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections
								.singletonList(new Y41bDefaultServiceHandler());
					}
				});

				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE Q99MPPSFacadeWS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT Q99MPPSFacadeWS inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				Q99MPPSFacadeWSSoap proxy = this.service
						.getQ99MPPSFacadeWSSoap();

				Map<String, Object> ctxt = ((BindingProvider) proxy)
						.getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						prop.getProperty("URL_PFS"));

				return proxy;
			}
		} catch (Exception e) {
			this.service = null;
		}
		return null;
	}
}