package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.ws.cliente.r02registroesc.Q99DSRTFacadeWS;
import com.ejie.y41b.ws.cliente.r02registroesc.Q99DSRTFacadeWSSoap;

public class Q99DSRTFacadeWSServiceImpl {
	private static final Logger logger = LoggerFactory
			.getLogger(Q99DSRTFacadeWSServiceImpl.class);

	private Q99DSRTFacadeWS service;

	public String obtenerRegistroEntrada(String sSessionToken,
			String sXmlContextRegistry) {
		return this.getQ99DSRTFacadeWSSoapPort().createEntryRegistry(
				sSessionToken, sXmlContextRegistry);
	}

	public String obtenerRegistroSalida(String sSessionToken,
			String sXmlExitRegistryCreationInfo) {
		return this.getQ99DSRTFacadeWSSoapPort().createExitRegistry(
				sSessionToken, sXmlExitRegistryCreationInfo);
	}

	public void iniciarQ99MPPSFacadeWSService() {
		this.getQ99DSRTFacadeWSSoapPort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName qname = new QName("http://www.openuri.org/",
			"Q99dSRTFacadeWS");

	private Q99DSRTFacadeWSSoap getQ99DSRTFacadeWSSoapPort() {
		return this.getQ99DSRTFacadeWSSoapPort(true);
	}

	private Q99DSRTFacadeWSSoap getQ99DSRTFacadeWSSoapPort(boolean getPort) {
		try {
			Properties prop = Y41bConfig
					.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE Q99dSRTFacadeWS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new Q99DSRTFacadeWS(new URL(
						prop.getProperty("URL_REGISTRO")), qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections
								.singletonList(new Y41bDefaultServiceHandler());
					}
				});

				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE Q99dSRTFacadeWS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT Q99dSRTFacadeWS inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				Q99DSRTFacadeWSSoap proxy = this.service
						.getQ99DSRTFacadeWSSoap();

				Map<String, Object> ctxt = ((BindingProvider) proxy)
						.getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						prop.getProperty("URL_REGISTRO"));

				return proxy;
			}
		} catch (Exception e) {
			this.service = null;
		}
		return null;
	}
}