package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.outputsir.SistemaRegistroPresencialWS;
import com.ejie.y41b.outputsir.SistemaRegistroPresencialWSSoap;
import com.ejie.y41b.outputsir.WSOutputRegister;
import com.ejie.y41b.outputsir.WSParamSIROutputRegister;
import com.ejie.y41b.utils.config.Y41bConfig;

public class OutputSirServiceImpl {
	private static final Logger logger = LoggerFactory.getLogger(OutputSirServiceImpl.class);

	private SistemaRegistroPresencialWS service;

	public WSOutputRegister wsNewSIROutputRegister(WSParamSIROutputRegister datas) {
		return this.getSistemaRegistroPresencialWSSoapPort().wsNewSIROutputRegister(datas);
	}

	public void iniciarSistemaRegistroPresencialWS() {
		this.getSistemaRegistroPresencialWSSoapPort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName qname = new QName("http://tempuri.org/", "SistemaRegistroPresencialWS");

	private SistemaRegistroPresencialWSSoap getSistemaRegistroPresencialWSSoapPort() {
		return this.getSistemaRegistroPresencialWSSoapPort(true);
	}

	private SistemaRegistroPresencialWSSoap getSistemaRegistroPresencialWSSoapPort(boolean getPort) {
		try {
			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			String url = prop.getProperty("URL_OUTPUTSIR");

			if (this.service == null) {
				logger.info(
						"<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE SistemaRegistroPresencialWS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new SistemaRegistroPresencialWS(new URL(url), qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections.singletonList(new OutputSirServiceHandler());
					}
				});
				logger.info(
						"<<<<<<<<<<<<<<<<<<< INICIADO SERVICE SistemaRegistroPresencialWS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info(
						"<<<<<<<<<<<<<<<<<<< get SERVICE PORT SIR inicia llamada SistemaRegistroPresencialWS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				SistemaRegistroPresencialWSSoap proxy = this.service.getSistemaRegistroPresencialWSSoap();

				Map<String, Object> ctxt = ((BindingProvider) proxy).getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, url);

				return proxy;
			}
		} catch (Exception e) {
			this.service = null;
			logger.error("Error en el metodo getX97DistributionWebServiceSoapPort de la clase SirServiceImpl: ", e);
		}
		return null;
	}
}