package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.nshf.VerificationResultType;
import com.ejie.y41b.nshf.X43FNSHF;
import com.ejie.y41b.nshf.X43FNSHF_Service;
import com.ejie.y41b.utils.config.Y41bConfig;

public class NSHFServiceImpl {
	private static final Logger logger = LoggerFactory
			.getLogger(NSHFServiceImpl.class);

	private X43FNSHF_Service service;

	public VerificationResultType verifyCertificateLocation(
			String certificateLocation) {

		return this.getNSHFServicePort().verifyCertificateLocation(
				certificateLocation);
	}

	public String createHashLocation(String documentLocation) {

		return this.getNSHFServicePort().createHashLocation(documentLocation);
	}

	public VerificationResultType verifySignatureLocation(
			String signatureLocation, String documentLocation) {

		return this.getNSHFServicePort().verifySignatureLocation(
				signatureLocation, documentLocation);
	}

	public String updateSignatureLocation(String signatureLocation,
			String documentLocation, String appDest) {

		return this.getNSHFServicePort().updateSignatureLocation(
				signatureLocation, documentLocation, appDest);
	}

	public void iniciarNSHFService() {
		this.getNSHFServicePort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName qname = new QName(
			"http://com.ejie.x43f/X43FNSHF/", "X43FNSHF");

	private X43FNSHF getNSHFServicePort() {
		return this.getNSHFServicePort(true);
	}

	private X43FNSHF getNSHFServicePort(boolean getPort) {
		try {
			Properties prop = Y41bConfig
					.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE NSHF >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new X43FNSHF_Service(new URL(
						prop.getProperty("URL_NSHF")), qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections
								.singletonList(new NSHFServiceHandler());
					}
				});
				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE NSHF >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT NSHF inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				X43FNSHF proxy = this.service.getX43FNSHFSOAP();

				Map<String, Object> ctxt = ((BindingProvider) proxy)
						.getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						prop.getProperty("URL_NSHF"));

				return proxy;
			}
		} catch (Exception e) {
			this.service = null;
		}
		return null;
	}
}