package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.n61.SistemaRegistroPresencialWS;
import com.ejie.y41b.n61.SistemaRegistroPresencialWSSoap;
import com.ejie.y41b.n61.WSInputRegister;
import com.ejie.y41b.n61.WSOutputRegister;
import com.ejie.y41b.n61.WSParamInputRegisterEx;
import com.ejie.y41b.n61.WSParamOutputRegisterEx;
import com.ejie.y41b.utils.config.Y41bConfig;

public class N61ServiceImpl {
	private static final Logger logger = LoggerFactory
			.getLogger(N61ServiceImpl.class);

	private SistemaRegistroPresencialWS service;

	public WSInputRegister wsNewInputRegister(WSParamInputRegisterEx datas) {
		if (datas != null
				&& datas.getPersons() != null
				&& datas.getPersons().getWSParamPerson() != null
				&& datas.getPersons().getWSParamPerson().get(0) != null
				&& datas.getPersons().getWSParamPerson().get(0).getPersonName() != null) {
			if (datas.getPersons().getWSParamPerson().get(0).getPersonName()
					.length() > Y41bConstantes.NUM_80) {
				datas.getPersons()
						.getWSParamPerson()
						.get(0)
						.setPersonName(
								datas.getPersons().getWSParamPerson().get(0)
										.getPersonName()
										.substring(0, Y41bConstantes.NUM_80));
			}
		}

		return this.getSistemaRegistroPresencialWSSoapPort()
				.wsNewInputRegister(datas);
	}

	public WSOutputRegister wsNewOutputRegister(WSParamOutputRegisterEx datas) {

		if (datas != null
				&& datas.getPersons() != null
				&& datas.getPersons().getWSParamPerson() != null
				&& datas.getPersons().getWSParamPerson().get(0) != null
				&& datas.getPersons().getWSParamPerson().get(0).getPersonName() != null) {
			if (datas.getPersons().getWSParamPerson().get(0).getPersonName()
					.length() > Y41bConstantes.NUM_80) {
				datas.getPersons()
						.getWSParamPerson()
						.get(0)
						.setPersonName(
								datas.getPersons().getWSParamPerson().get(0)
										.getPersonName()
										.substring(0, Y41bConstantes.NUM_80));
			}
		}
		return this.getSistemaRegistroPresencialWSSoapPort()
				.wsNewOutputRegister(datas);
	}

	public void iniciarNSHFService() {
		this.getSistemaRegistroPresencialWSSoapPort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName qname = new QName("http://tempuri.org/",
			"SistemaRegistroPresencialWS");

	private SistemaRegistroPresencialWSSoap getSistemaRegistroPresencialWSSoapPort() {
		return this.getSistemaRegistroPresencialWSSoapPort(true);
	}

	private SistemaRegistroPresencialWSSoap getSistemaRegistroPresencialWSSoapPort(
			boolean getPort) {
		try {
			Properties prop = Y41bConfig
					.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE N61 >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new SistemaRegistroPresencialWS(new URL(
						prop.getProperty("URL_REGISTROPRESENCIAL")), qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections
								.singletonList(new N61ServiceHandler());
					}
				});
				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE N61 >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT N61 inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				SistemaRegistroPresencialWSSoap proxy = this.service
						.getSistemaRegistroPresencialWSSoap();

				Map<String, Object> ctxt = ((BindingProvider) proxy)
						.getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						prop.getProperty("URL_REGISTROPRESENCIAL"));

				return proxy;
			}
		} catch (Exception e) {
			this.service = null;
			logger.error(
					"Error en el metodo getSistemaRegistroPresencialWSSoapPort de la clase N61ServiceImpl: ",
					e);
		}
		return null;
	}
}