package com.ejie.y41b.adapter.services;

import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y41b.aa66.AA66Notificaciones;
import com.ejie.y41b.aa66.CargaRemesaBuzonWs;
import com.ejie.y41b.aa66.DestinatarioWs;
import com.ejie.y41b.aa66.EliminarOutWs;
import com.ejie.y41b.aa66.EnvioOutWs;
import com.ejie.y41b.aa66.EnvioWs;
import com.ejie.y41b.aa66.ErrorWs;
import com.ejie.y41b.aa66.IdentTramitadorAplicacionWs;
import com.ejie.y41b.aa66.IdentTramitadorCondicionalAplicacionWs;
import com.ejie.y41b.aa66.IdentTramitadorCondicionalWs;
import com.ejie.y41b.aa66.IdentTramitadorWs;
import com.ejie.y41b.aa66.MotivoObsWs;
import com.ejie.y41b.aa66.NotificacionesWebServiceImplService;
import com.ejie.y41b.aa66.PrepararOutWs;
import com.ejie.y41b.aa66.RemesaOutWs;
import com.ejie.y41b.aa66.SituacionEntregaRemesaWs;
import com.ejie.y41b.aa66.SituacionEntregaWs;
import com.ejie.y41b.aa66.ZipEnvioWs;
import com.ejie.y41b.aa66.ZipRemesaWs;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.exception.Y41bAA66Exception;

/**
 * <p>
 * Titulo: AA66ServiceImpl
 * </p>
 * <p>
 * Descipcion: Realiza invocaciones al webServices de Notificacion de correos
 * (AA66)
 * </p>
 * <p>
 * Copyright: Copyright (c) 2016
 * </p>
 * <p>
 * Empresa: Bilbomatica
 * </p>
 * 
 *  
 * @version 1.0
 */
public class AA66ServiceImpl {
	private static final Logger logger = LoggerFactory.getLogger(AA66ServiceImpl.class);

	private NotificacionesWebServiceImplService service;

	// TODO CARGARLOS DEL FICHERO DE IDIOMAS
	private static final String ERROR_INCONTROLADO_WS_CAS = "Error grave incontrolado en la llamada al WS ";
	private static final String ERROR_INCONTROLADO_WS_EUS = "Errore larri inkontrolatua WSrako deian";
	private static final String ERROR_INCONTROLADO_CAS = "Error incontrolado ";
	private static final String ERROR_INCONTROLADO_EUS = "Errore inkontrolatua";
	private static final String ERROR_OBTENCION_SERVIDOR_CAS = "Error al intentar obtener el servidor ";
	private static final String ERROR_OBTENCION_SERVIDOR_EUS = "Errorea zerbitzaria lortzen saiatzean";

	/**
	 * Method 'cargaMasiva'. Metodo encargado de recibir una remesa de entrada
	 * con varios envios y devolver una remesa de salida, una coleccion por
	 * carga y datos del envio
	 * 
	 * @param cargaRemesaBuzonWs
	 *            CargaRemesaBuzonWs
	 * @return RemesaOutWs
	 */
	public RemesaOutWs cargaRemesaBuzon(CargaRemesaBuzonWs cargaRemesaBuzonWs) throws Y41bAA66Exception {

		RemesaOutWs remesaOutWs = new RemesaOutWs();

		try {
			// Lo primero es 'recortar' los strings a la longitud demandada por
			// el WS
			cargaRemesaBuzonWs.setDescripcionRemesa(getStringMaximo(cargaRemesaBuzonWs.getDescripcionRemesa(), 30));

			MotivoObsWs motivoAux = cargaRemesaBuzonWs.getMotivo();
			motivoAux.setDescripcionMotivo(getStringMaximo(motivoAux.getDescripcionMotivo(), 40));

			List<EnvioWs> listaEnvios = cargaRemesaBuzonWs.getListaEnvios();
			if (listaEnvios != null) {
				Iterator<EnvioWs> it = listaEnvios.iterator();
				while (it.hasNext()) {
					EnvioWs envioAux = it.next();
					envioAux.setExpediente(getStringMaximo(envioAux.getExpediente(), 40));

					DestinatarioWs destinatarioAux = envioAux.getDestinatario();
					destinatarioAux.setDireccion(getStringMaximo(destinatarioAux.getDireccion(), 250));
					destinatarioAux.setInstitucion(getStringMaximo(destinatarioAux.getInstitucion(), 50));
					destinatarioAux.setLocalidad(getStringMaximo(destinatarioAux.getLocalidad(), 80));
					destinatarioAux.setMunicipio(getStringMaximo(destinatarioAux.getMunicipio(), 50));
					destinatarioAux.setNombreApellidos(getStringMaximo(destinatarioAux.getNombreApellidos(), 50));
					destinatarioAux.setProvincia(getStringMaximo(destinatarioAux.getProvincia(), 40));

				}
			}

			toStringCargaRemesaBuzonWs(cargaRemesaBuzonWs);
			remesaOutWs = this.getAA66ServicePort().cargaRemesaBuzon(cargaRemesaBuzonWs);
			toStringRemesaOutWs(remesaOutWs);

			if (remesaOutWs != null) {
				if (remesaOutWs.getCodigoRemesa() == null && remesaOutWs.getErrores().isEmpty()) {

					// Se trata de un error incontrolado del WS. P.ej: El token
					// de sesion no tiene el perfil de acceso al WS
					throw new Y41bAA66Exception(null, ERROR_INCONTROLADO_WS_CAS + "(cargaMasiva) ",
							ERROR_INCONTROLADO_WS_EUS + "(cargaMasiva) ", null, "3");
				} else if (remesaOutWs.getErrores() != null && !remesaOutWs.getErrores().isEmpty()) {

					for (ErrorWs errorWs : remesaOutWs.getErrores()) {
						// Se trata de un error controlado del WS

						// Aunque devuelve una lista, en principio SOLO devuelve
						// un error.
						// ... En caso contrario, hubiera que realizar una
						// implementacin nueva sin probar (con
						// listY41bAA66Exception)
						throw new Y41bAA66Exception(errorWs.getCodigoError(), errorWs.getDescripcionCastellano(),
								errorWs.getDescripcionEuskera(), errorWs.getIdErroneo(), "1");
					}
				}

			}
		} catch (Y41bAA66Exception e) {
			// Se trata de un de validacion del WS. P.ej: Los datos de entrada
			// no cumplen el xsd del WS
			throw e;
		} catch (Throwable e) {
			// Se trata de un de validacion del WS. P.ej: Los datos de entrada
			// no cumplen el xsd del WS
			String error = e.getMessage().trim();
			throw new Y41bAA66Exception(null, ERROR_INCONTROLADO_CAS + "(cargaMasiva): " + error,
					ERROR_INCONTROLADO_EUS + "(cargaMasiva): " + error, null, "2");
		}

		return remesaOutWs;
	}

	/**
	 * Method 'eliminarEnvio'. Metodo encargado de recibir la peticion de
	 * eliminar envio de carga masiva, cuya remesa este sin pasar a estado
	 * Preparada. Devuelve un 1 cuando es Ok y -1 cuando No OK y la descripcion
	 * del error.
	 * 
	 * @param envioAEliminar
	 *            IdentTramitadorWs
	 * @return EliminarOutWs
	 */
	public EliminarOutWs eliminarEnvio(IdentTramitadorWs envioAEliminar) throws Y41bAA66Exception {

		EliminarOutWs eliminarOutWs = new EliminarOutWs();

		try {
			eliminarOutWs = this.getAA66ServicePort().eliminarEnvio(envioAEliminar);

			if (eliminarOutWs != null) {
				if (eliminarOutWs.getResultadoEliminar() == 0 && eliminarOutWs.getError() == null) {

					// Se trata de un error incontrolado del WS. P.ej: El token
					// de sesion no tiene el perfil de acceso al WS
					throw new Y41bAA66Exception(null, ERROR_INCONTROLADO_WS_CAS + "(eliminarEnvio) ",
							ERROR_INCONTROLADO_WS_EUS + "(eliminarEnvio) ", null, "3");
				} else if (eliminarOutWs.getError() != null) {
					// Se trata de un error controlado del WS
					throw new Y41bAA66Exception(eliminarOutWs.getError().getCodigoError(),
							eliminarOutWs.getError().getDescripcionCastellano(),
							eliminarOutWs.getError().getDescripcionEuskera(), eliminarOutWs.getError().getIdErroneo(),
							"1");
				}
			}
		} catch (Y41bAA66Exception e) {
			// Se trata de un de validacion del WS. P.ej: Los datos de entrada
			// no cumplen el xsd del WS
			throw e;
		} catch (Throwable e) {
			// Se trata de un de validacion del WS. P.ej: Los datos de entrada
			// no cumplen el xsd del WS
			String error = e.getMessage().trim();
			throw new Y41bAA66Exception(null, ERROR_INCONTROLADO_CAS + "(eliminarEnvio): " + error,
					ERROR_INCONTROLADO_EUS + "(eliminarEnvio): " + error, null, "2");
		}

		return eliminarOutWs;
	}

	/**
	 * Method 'prepararColeccion'. Metodo encargado de recibir la peticion de
	 * coleccion con el cambio de estado a Preparada, para enviar a Correos las
	 * cartas por medio del Servicio de Correspondencia. Devuelve un 1 cuando es
	 * Ok y -1 cuando No OK y la descripcion del error
	 * 
	 * @param coleccionPreparar
	 *            IdentTramitadorWs
	 * @return PrepararOutWs
	 */
	public PrepararOutWs prepararColeccion(IdentTramitadorWs coleccionPreparar) throws Y41bAA66Exception {

		PrepararOutWs prepararOutWs = new PrepararOutWs();

		try {
			prepararOutWs = this.getAA66ServicePort().prepararColeccion(coleccionPreparar);

			if (prepararOutWs != null) {
				if (prepararOutWs.getResultadoPreparacion() == 0 && prepararOutWs.getError() == null) {

					throw new Y41bAA66Exception(null, ERROR_INCONTROLADO_WS_CAS + "(prepararColeccion) ",
							ERROR_INCONTROLADO_WS_EUS + "(prepararColeccion) ", null, "3");
				} else if (prepararOutWs.getError() != null) {
					// Se trata de un error controlado del WS

					throw new Y41bAA66Exception(prepararOutWs.getError().getCodigoError(),
							prepararOutWs.getError().getDescripcionCastellano(),
							prepararOutWs.getError().getDescripcionEuskera(), prepararOutWs.getError().getIdErroneo(),
							"1");
				}
			}
		} catch (Y41bAA66Exception e) {
			// Se trata de un de validacion del WS. P.ej: Los datos de entrada
			// no cumplen el xsd del WS
			throw e;
		} catch (Throwable e) {
			// Se trata de un de validacion del WS. P.ej: Los datos de entrada
			// no cumplen el xsd del WS
			String error = e.getMessage().trim();
			throw new Y41bAA66Exception(null, ERROR_INCONTROLADO_CAS + "(prepararColeccion): " + error,
					ERROR_INCONTROLADO_EUS + "(prepararColeccion): " + error, null, "2");
		}

		return prepararOutWs;
	}

	/**
	 * Method 'situacionEntregaEnvio'. Metodo encargado de recibir la peticion
	 * de un envio y devuelve la situacion de entrega en Correos, del envio de
	 * entrada
	 * 
	 * @param envioSituacion
	 *            IdentTramitadorCondicionalWs
	 * @return SituacionEntregaWs
	 * @throws Throwable
	 */
	public SituacionEntregaWs situacionEntregaEnvio(IdentTramitadorCondicionalWs envioSituacion) throws Throwable {
		SituacionEntregaWs situacionEntregaWs = new SituacionEntregaWs();

		try {
			situacionEntregaWs = this.getAA66ServicePort().situacionEntregaEnvio(envioSituacion);

			if (situacionEntregaWs != null) {
				if (situacionEntregaWs.getIdEnvio() == 0 && situacionEntregaWs.getError() == null) {

					throw new Y41bAA66Exception(null, ERROR_INCONTROLADO_WS_CAS + "(situacionEntregaEnvio) ",
							ERROR_INCONTROLADO_WS_EUS + "(situacionEntregaEnvio) ", null, "3");
				} else if (situacionEntregaWs.getError() != null) {
					// Se trata de un error controlado del WS

					throw new Y41bAA66Exception(situacionEntregaWs.getError().getCodigoError(),
							situacionEntregaWs.getError().getDescripcionCastellano(),
							situacionEntregaWs.getError().getDescripcionEuskera(),
							situacionEntregaWs.getError().getIdErroneo(), "1");
				}
			}
		} catch (Y41bAA66Exception e) {
			// Se trata de un de validacion del WS. P.ej: Los datos de entrada
			// no cumplen el xsd del WS
			throw e;
		} catch (Throwable e) {
			// Se trata de un de validacion del WS. P.ej: Los datos de entrada
			// no cumplen el xsd del WS
			throw new Y41bAA66Exception(null, ERROR_INCONTROLADO_CAS + "(situacionEntregaEnvio) " + e.getMessage(),
					ERROR_INCONTROLADO_EUS + "(situacionEntregaEnvio) " + e.getMessage(), null, "2");
		}
		return situacionEntregaWs;
	}

	/**
	 * Method 'situacionEntregaRemesa'. Metodo encargado de recibir la peticion
	 * de remesa y devuelve las situaciones de entrega en Correos, de todos los
	 * envios de la remesa de entrada
	 * 
	 * @param remesaSituaciones
	 *            IdentTramitadorCondicionalAplicacionWs
	 * @return SituacionEntregaRemesaWs
	 * @throws Throwable
	 */
	public SituacionEntregaRemesaWs situacionEntregaRemesa(IdentTramitadorCondicionalAplicacionWs remesaSituaciones)
			throws Throwable {

		// Metodo no probado, ni implementado totalmente ya que no se usa
		// en la aplicacin (si en el futuro se necesitase, entonces hubiera que
		// implementarlo).
		return this.getAA66ServicePort().situacionEntregaRemesa(remesaSituaciones);
	}

	/**
	 * Method 'pruebaEntregaEnvio'. Metodo encargado de recibir la peticion de
	 * un envio y devuelve la PEE  prueba de entrega electronica de fichero PDF
	 * en formato .zip
	 * 
	 * @param pruebaEntregaE
	 *            IdentTramitadorWs
	 * @return ZipEnvioWs
	 * @throws Throwable
	 */
	public ZipEnvioWs pruebaEntregaEnvio(IdentTramitadorWs pruebaEntregaE) throws Throwable {
		ZipEnvioWs zipEnvioWs = new ZipEnvioWs();

		try {
			zipEnvioWs = this.getAA66ServicePort().pruebaEntregaEnvio(pruebaEntregaE);

			if (zipEnvioWs != null) {
				if (zipEnvioWs.getIdEnvio() == 0 && zipEnvioWs.getError() == null) {

					throw new Y41bAA66Exception(null, ERROR_INCONTROLADO_WS_CAS + "(pruebaEntregaEnvio) ",
							ERROR_INCONTROLADO_WS_EUS + "(pruebaEntregaEnvio) ", null, "3");
				} else if (zipEnvioWs.getError() != null) {
					// Se trata de un error controlado del WS

					throw new Y41bAA66Exception(zipEnvioWs.getError().getCodigoError(),
							zipEnvioWs.getError().getDescripcionCastellano(),
							zipEnvioWs.getError().getDescripcionEuskera(), zipEnvioWs.getError().getIdErroneo(), "1");
				}
			}
		} catch (Y41bAA66Exception e) {
			// Se trata de un de validacion del WS. P.ej: Los datos de entrada
			// no cumplen el xsd del WS
			throw e;
		} catch (Throwable e) {
			// Se trata de un de validacion del WS. P.ej: Los datos de entrada
			// no cumplen el xsd del WS
			throw new Y41bAA66Exception(null, ERROR_INCONTROLADO_CAS + e.getMessage(),
					ERROR_INCONTROLADO_EUS + e.getMessage(), null, "2");
		}
		return zipEnvioWs;
	}

	/**
	 * Method 'pruebasEntregaRemesa'. Metodo encargado de recibir la peticion de
	 * remesa y devuelve los ficheros pdf, de cada envio de la remesa de entrada
	 * en formato .zip
	 * 
	 * @param pruebasEntregaR
	 *            IdentTramitadorAplicacionWs
	 * @return ZipRemesaWs
	 * @throws Throwable
	 */
	public ZipRemesaWs pruebasEntregaRemesa(IdentTramitadorAplicacionWs pruebasEntregaR) throws Throwable {

		// Metodo no probado, ni implementado totalmente ya que no se usa
		// en la aplicacin (si en el futuro se necesitase, entonces hubiera que
		// implementarlo).
		return this.getAA66ServicePort().pruebasEntregaRemesa(pruebasEntregaR);
	}

	/**
	 * Method 'iniciarAA66Service'. Metodo que inicia el servicio
	 * 
	 * @throws Throwable
	 * 
	 */
	public void iniciarAA66Service() throws Throwable {
		this.getAA66ServicePort(false);
	}

	// INICAMOS PORT SERVICE
	private static final QName qname = new QName("http://com.ejie.aa66", "NotificacionesWebServiceImplService");

	/**
	 * Method 'getAA66ServicePort'. Metodo encargado de obtener el port del WS
	 * 
	 * @return AA66Notificaciones
	 * @throws Throwable
	 */
	private AA66Notificaciones getAA66ServicePort() throws Throwable {
		return this.getAA66ServicePort(true);
	}

	/**
	 * Method 'getAA66ServicePort'. Metodo encargado de obtener el port del WS
	 * 
	 * @param getPort
	 *            boolean
	 * @return AA66Notificaciones
	 * @throws Throwable
	 */
	private AA66Notificaciones getAA66ServicePort(boolean getPort) throws Throwable {
		try {
			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			if (this.service == null) {
				logger.info("<<<<<<<<<<<<<<<<<<< INICIANDO SERVICE AA66 >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				// Creamos el servicio

				service = new NotificacionesWebServiceImplService(new URL(prop.getProperty("URL_AA66")), qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					public List getHandlerChain(PortInfo portInfo) {
						return Collections.singletonList(new AA66ServiceHandler());
					}
				});
				logger.info("<<<<<<<<<<<<<<<<<<< INICIADO SERVICE AA66 >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
			}
			if (getPort) {
				logger.info("<<<<<<<<<<<<<<<<<<< get SERVICE PORT AA66 inicia llamada WS >>>>>>>>>>>>>>>>>>>>>>>>>>>>");
				AA66Notificaciones proxy = this.service.getAA66NotificacionesPort();

				Map<String, Object> ctxt = ((BindingProvider) proxy).getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, prop.getProperty("URL_AA66"));

				return proxy;
			}
		} catch (Throwable e) {
			logger.error("Error al intentar obtener el servidor en el mtodo getAA66ServicePort ", e);
			this.service = null;
			throw new Y41bAA66Exception(null, ERROR_OBTENCION_SERVIDOR_CAS + e.getMessage(),
					ERROR_OBTENCION_SERVIDOR_EUS + e.getMessage(), null, "2");
		}
		return null;
	}

	private String getStringMaximo(String descripcion, int longitud) {
		return descripcion == null ? null
				: descripcion.length() <= longitud ? descripcion : descripcion.substring(0, longitud - 1);
	}

	private void toStringCargaRemesaBuzonWs(CargaRemesaBuzonWs cargaRemesaBuzonWs) {
		logger.debug("AA66ServiceImpl.toStringCargaRemesaBuzonWs:" + cargaRemesaBuzonWs);
		logger.debug("AA66ServiceImpl.toStringCargaRemesaBuzonWs.getUidPuestoTramitador():"
				+ cargaRemesaBuzonWs.getUidPuestoTramitador());

		List<EnvioWs> listaEnvios = cargaRemesaBuzonWs.getListaEnvios();
		if (listaEnvios != null) {
			Iterator<EnvioWs> it = listaEnvios.iterator();
			while (it.hasNext()) {
				EnvioWs envioAux = it.next();

				logger.debug("AA66ServiceImpl.toStringRemesaWs.getListaEnvios.getIdInterno();getExpediente():"
						+ envioAux.getIdInterno() + ";" + envioAux.getExpediente());

				DestinatarioWs destinatarioAux = envioAux.getDestinatario();
				logger.debug(
						"AA66ServiceImpl.toStringRemesaWs.getListaEnvios.getDestinatario.getNombreApellidos();getInstitucion():"
								+ destinatarioAux.getNombreApellidos() + ";" + destinatarioAux.getInstitucion());
				logger.debug(
						"AA66ServiceImpl.toStringRemesaWs.getListaEnvios.getDestinatario.getCodigoPostal();getDireccion():"
								+ destinatarioAux.getCodigoPostal() + ";" + destinatarioAux.getDireccion());
			}
		}
	}

	private void toStringRemesaOutWs(RemesaOutWs remesaOutWs) {
		logger.debug("AA66ServiceImpl.toStringRemesaOutWs:" + remesaOutWs);
		logger.debug("AA66ServiceImpl.toStringRemesaOutWs.getCodigoRemesa();getIdremesa():"
				+ remesaOutWs.getCodigoRemesa() + ";" + remesaOutWs.getIdremesa());
		logger.debug("AA66ServiceImpl.toStringRemesaOutWs.getCodigoColeccion();getIdColeccion():"
				+ remesaOutWs.getCodigoColeccion() + ";" + remesaOutWs.getIdColeccion());

		List<EnvioOutWs> listaEnvios = remesaOutWs.getEnvios();
		if (listaEnvios != null) {
			Iterator<EnvioOutWs> it = listaEnvios.iterator();
			while (it.hasNext()) {
				EnvioOutWs envioAux = it.next();

				logger.debug("AA66ServiceImpl.toStringRemesaWs.getEnvios.getIdInterno();getIdEnvio();getCodEnvio():"
						+ envioAux.getIdInterno() + ";" + envioAux.getIdEnvio() + ";" + envioAux.getCodEnvio());
				logger.debug(
						"AA66ServiceImpl.toStringRemesaWs.getEnvios.getCodigoBarras():" + envioAux.getCodigoBarras());
			}
		}
	}

}