package com.ejie.y41b.adapter.services;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.xlnets.Y41bUtils;

public class AA66ServiceHandler implements SOAPHandler<SOAPMessageContext> {

	private static final Logger logger = LoggerFactory
			.getLogger(AA66ServiceHandler.class);

	private TransformerFactory transformerFactory;

	/**
	 * Constructor por defecto.
	 * 
	 */
	public AA66ServiceHandler() {
		this.transformerFactory = TransformerFactory.newInstance();
	}

	@Override
	public Set<QName> getHeaders() {
		return new HashSet<QName>();
	}

	@Override
	public void close(MessageContext context) {

	}

	/**
	 * @see javax.xml.ws.handler.Handler#handleFault(javax.xml.ws.handler.MessageContext)
	 */
	@Override
	public boolean handleFault(SOAPMessageContext context) {
		logger.error("Error cliente ws AA66 " + logging(context));
		return true;
	}

	/**
	 * @see javax.xml.ws.handler.Handler#handleMessage(javax.xml.ws.handler.MessageContext)
	 */
	@Override
	public boolean handleMessage(SOAPMessageContext context) {

		boolean valid = true;

		Boolean outbound = (Boolean) context
				.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

		// logger.info("cliente ws NSHF outbound: " + String.valueOf(outbound)
		// + " " + logging(context));

		// solo para los mensajes SALIENTES
		if (outbound != null && outbound.booleanValue()) {
			valid = false;
			try {
				DocumentBuilderFactory factory = DocumentBuilderFactory
						.newInstance();
				DocumentBuilder builder = factory.newDocumentBuilder();
				Properties prop = Y41bConfig
						.loadProperties(Y41bConstantes.CONFIG_PATH);

				org.w3c.dom.Document token = builder
						.parse(new InputSource(
								new StringReader(
										Y41bUtils
												.getInstance()
												.getTokenAplicacion(
														Boolean.parseBoolean(prop
																.getProperty("xlnets.loginApp.isSimulated"))))));

				// PRUEBAS CON TOKEN APLICACION W16B
				// String strXlNetsW16b =
				// "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><n38><elementos tipo=\"n38APISesionCrearToken\"><elemento subtipo=\"N38Sesion\"><parametro id=\"n38fhum\"><valor>1459333043641</valor></parametro><parametro id=\"n38listamsservidores\"><valor>hola Aitzi</valor></parametro><parametro id=\"n38dominioscookies\"><valor>.jakina.ejgvdns</valor></parametro><parametro id=\"n38rangoip\"><valor>10.200.56.11</valor><valor>10.170.9.109</valor><valor>10.170.8.4</valor><valor>10.170.8.5</valor><valor>10.170.9.4</valor><valor>10.170.9.5</valor><valor>10.170.9.137</valor><valor>10.170.9.79</valor><valor>10.200.56.57</valor><valor>10.170.17.114</valor><valor>10.200.8.216</valor><valor>10.200.8.217</valor><valor>10.200.8.218</valor><valor>10.190.8.14</valor><valor>10.170.17.105</valor><valor>192.168.56.231</valor><valor>192.168.56.233</valor><valor>192.168.56.242</valor><valor>192.168.56.241</valor><valor>10.190.20.25</valor><valor>10.190.24.15</valor><valor>192.168.56.234</valor><valor>10.190.8.101</valor><valor>10.190.20.20</valor><valor>192.168.56.21</valor><valor>192.168.56.13</valor><valor>192.168.56.17</valor><valor>192.168.56.11</valor><valor>192.168.56.228</valor><valor>10.170.8.216</valor><valor>192.168.56.58</valor><valor>10.190.20.14</valor><valor>10.170.17.201</valor><valor>555.</valor><valor>10.190.20.43</valor><valor>10.190.20.47</valor><valor>10.190.20.32</valor><valor>10.190.20.40</valor><valor>10.190.20.11</valor><valor>10.190.20.56</valor><valor>10.190.20.38</valor><valor>10.190.8.69</valor><valor>10.190.8.70</valor><valor>10.170.17.200</valor><valor>10.190.20.50</valor><valor>10.190.40.15</valor><valor>10.190.40.16</valor><valor>10.190.40.18</valor><valor>10.190.40.19</valor><valor>10.190.20.69</valor><valor>10.190.20.70</valor><valor>10.170.9.21</valor><valor>10.190.20.67</valor><valor>10.170.16.172</valor><valor>10.190.20.100</valor><valor>10.190.20.102</valor><valor>10.190.20.63</valor><valor>10.190.20.64</valor><valor>10.170.17.203</valor><valor>10.170.17.207</valor><valor>10.190.20.101</valor><valor>10.190.28.18</valor><valor>10.190.20.71</valor><valor>10.190.20.138</valor><valor>10.190.20.139</valor><valor>10.190.20.86</valor><valor>10.170.18.235</valor><valor>10.190.16.12</valor><valor>10.170.18.230</valor></parametro><parametro id=\"n38listags\"><valor>x_ssdes01:47770:1000</valor><valor>x_ssdes02:47770:1000</valor></parametro><parametro id=\"n38urlsredireccion\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38nWar/N38NodoEstrellaServlet</valor></parametro><parametro id=\"n38listacede\"><valor>x_cddes01:48880:1000</valor><valor>x_cddes02:48880:1000</valor></parametro><parametro id=\"n38idcontexto\"><valor>intranet</valor><valor>internet</valor></parametro><parametro id=\"n38perfiles\"><valor>Publico</valor><valor>X43F-PF-0033</valor><valor>R02F-PF-0033</valor><valor>W16B-PF-0004</valor><valor>W16B-PF-0001</valor><valor>R02K-PF-0001</valor><valor>AA66-PF-0007</valor></parametro><parametro id=\"n38cadenaconfianza\"><valor>desarrollo-produccion</valor></parametro><parametro id=\"n38politicauid\"><valor>P2</valor></parametro><parametro id=\"n38direccionproxy\"><valor>http://www.servicios.comunes.ejiedes.net/proxy</valor></parametro><parametro id=\"n38direcciongrc\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38rWar/N38rFachadaGRCServlet</valor></parametro><parametro id=\"n38sistemaxlnetsuid\"><valor>desarrollo-produccion</valor></parametro><parametro id=\"n38dominiocomuncookie\"><valor>.jakina.ejgvdns</valor></parametro><parametro id=\"n38urlsgsd\"><valor>https://xlnets.servicios.jakina.ejiedes.net/n38nCDominioWar/N38GestorCDominioServlet</valor></parametro><parametro id=\"n38urldispatcher\"><valor>http://xlnets.servicios.jakina.ejiedes.net/n38nWar/N38DispatcherEstrellaServlet</valor></parametro><parametro id=\"n38urlfinal\"><valor>http://jakina</valor></parametro><parametro id=\"n38orgunituid\"><valor>10500</valor></parametro><parametro id=\"n38grupoorganicouid\"><valor>400</valor></parametro><parametro id=\"n38urlportal\"><valor>https://xlnets.servicios.jakina.ejiedes.net/n38a/N38servletPortal</valor></parametro><parametro id=\"n38crearsesionapp\"><valor>true</valor></parametro><parametro id=\"n38eudescripciondominio\"><valor>rak Interneta</valor></parametro><parametro id=\"n38cadescripciondominio\"><valor>ras internete</valor></parametro><parametro id=\"n38oleserver\"><valor>false</valor></parametro><parametro id=\"n38servidoraudit\"><valor>x_auddes01:4560</valor></parametro><parametro id=\"n38certificadopoliticas\"><valor>NO</valor></parametro><parametro id=\"n38subjectcert\"><valor>NO</valor></parametro><parametro id=\"n38idioma\"><valor>3</valor></parametro><parametro id=\"n38personauid\"><valor>W16B</valor></parametro><parametro id=\"n38puestouid\"><valor>W16B</valor></parametro><parametro id=\"n38dominiouid\"><valor>D0_Servidores11</valor></parametro><parametro id=\"n38exclusivo\"><valor>False</valor></parametro><parametro id=\"n38comportamientofirma\"><valor>False</valor></parametro><parametro id=\"n38loginasociado\"><valor>https://xlnets.servicios.jakina.ejiedes.net:443/n38a/N38LoginInicioServlet</valor></parametro><parametro id=\"n38comportamientoip\"><valor>ipv</valor></parametro><parametro id=\"n38sexpiracion\"><valor>988999999999</valor></parametro><parametro id=\"n38fechainicio\"><valor>1341486509650</valor></parametro><parametro id=\"iphostnumber\"><valor>10.190.8.101</valor></parametro><parametro id=\"n38organizacion\"><valor>400</valor></parametro><parametro id=\"n38login\"><valor>W16B</valor></parametro><parametro id=\"dni\"><valor>W16B</valor></parametro><parametro id=\"n38fechalogoff\"><valor>1339412469270</valor></parametro><parametro id=\"cn\"><valor>W16B1291895451195</valor></parametro><parametro id=\"n38uidsesion\"><valor>1291919925475</valor></parametro><parametro id=\"n38reintentossesion\"><valor>1</valor></parametro><parametro id=\"n38tiposesion\"><valor>C/S</valor></parametro><parametro id=\"n38fechacreacion\"><valor>1291895451195</valor></parametro><parametro id=\"n38valorhash\"><valor>BFeJH/HExTcZWpzY+ufTmkCbq3U=</valor></parametro><parametro id=\"n38uidsesionglobal\"><valor>desarrollo-produccion-1291919925475</valor></parametro></elemento></elementos></n38>";
				// String strXlNetsW16b = "";
				// org.w3c.dom.Document token = builder.parse(new InputSource(
				// new StringReader(strXlNetsW16b)));
				// FIN PRUEBAS CON TOKEN APLICACION W16B

				// recuperar cabecera SOAP
				SOAPHeader soapHeader = context.getMessage().getSOAPHeader();

				// incluir token en la cabecera creada
				Source source = new DOMSource(token);
				Result result = new DOMResult(soapHeader);
				this.transformerFactory.newTransformer().transform(source,
						result);

				// se puede continuar el procesamiento
				valid = true;

				logger.info("cliente ws AA66 outbound: Token inyectado al header");

				context.put("timeini", new Long(System.currentTimeMillis()));

			} catch (Exception e) {
				e.printStackTrace();
			} catch (Throwable e) {
				e.printStackTrace();
			}

		} else {

			long timeini = (Long) (context.get("timeini"));
			long timefin = System.currentTimeMillis();

			BigDecimal result = ((new BigDecimal(timefin)
					.subtract(new BigDecimal(timeini))).divide(new BigDecimal(
					1000), 5, BigDecimal.ROUND_FLOOR));

			logger.info("cliente ws AA66 tiempo transcurrido de respuesta: "
					+ result + " sg ");
		}
		return valid;

	}

	private String logging(SOAPMessageContext context) {
		try {
			ByteArrayOutputStream out = new ByteArrayOutputStream();
			context.getMessage().writeTo(out);
			return new String(out.toByteArray());
		} catch (Exception e) {
			logger.error("Error", e);
		}
		return "NO SACAMOS MENSAJE SOAP";
	}
}
