// CHECKSTYLE:OFF
package com.ejie.y41b.adapter.helper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.taskdefs.Sleep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.bea.xml.XmlObject;
import com.ejie.ainit.xml.AdminInitiation;
import com.ejie.ainit.xml.AdminInitiation.Applicants;
import com.ejie.ainit.xml.AdminInitiationDocument;
import com.ejie.ainit.xml.GeneralData;
import com.ejie.ainit.xml.Participation;
import com.ejie.ainit.xml.PostalAddressDocument;
import com.ejie.ainit.xml.PostalAddressDocument.PostalAddress;
import com.ejie.cp.xml.ProcedureDocument.Procedure;
import com.ejie.ctfm.xml.AddresseeDocument.Addressee;
import com.ejie.ctfm.xml.ApplicantInfoDocument.ApplicantInfo;
import com.ejie.ctfm.xml.ChannelDocument.Channel;
import com.ejie.ctfm.xml.ContextSubmissionDocument;
import com.ejie.ctfm.xml.ContextSubmissionDocument.ContextSubmission;
import com.ejie.ctfm.xml.ContextSubmissionDocument.ContextSubmission.DataControl;
import com.ejie.ctfm.xml.DocumentDocument.Document;
import com.ejie.ctfm.xml.DocumentsDocument.Documents;
import com.ejie.ctfm.xml.NotificationDocument.Notification;
import com.ejie.ctfm.xml.PersonDocument.Person;
import com.ejie.ctfm.xml.PersonsDocument.Persons;
import com.ejie.ctfm.xml.SignatureDocument.Signature;
import com.ejie.ctfm.xml.SignaturesDocument.Signatures;
import com.ejie.folderManagement.xml.ContextRegistryDocument;
import com.ejie.folderManagement.xml.ContextRegistryDocument.ContextRegistry;
import com.ejie.horizontalSystemOfNotification.xml.ExitRegistryCreationInfoDocument;
import com.ejie.horizontalSystemOfNotification.xml.ExitRegistryCreationInfoDocument.ExitRegistryCreationInfo;
import com.ejie.r02K.xml.AddresseeDocument;
import com.ejie.r02K.xml.ApplicantInfoDocument;
import com.ejie.r02K.xml.AttachmentDocument.Attachment;
import com.ejie.r02K.xml.AttachmentsDocument.Attachments;
import com.ejie.r02K.xml.BasicInfoDocument.BasicInfo;
import com.ejie.r02K.xml.BodyDocument.Body;
import com.ejie.r02K.xml.ChannelDocument;
import com.ejie.r02K.xml.ChannelInfoDocument;
import com.ejie.r02K.xml.ChannelInfoDocument.ChannelInfo;
import com.ejie.r02K.xml.ChannelTypeDocument;
import com.ejie.r02K.xml.ContactDocument.Contact;
import com.ejie.r02K.xml.ContactsDocument.Contacts;
import com.ejie.r02K.xml.DepartmentNameDocument.DepartmentName;
import com.ejie.r02K.xml.DescriptionDocument.Description;
import com.ejie.r02K.xml.EjgvDocumentDocument1.EjgvDocument;
import com.ejie.r02K.xml.EntityNameDocument.EntityName;
import com.ejie.r02K.xml.HeaderDocument.Header;
import com.ejie.r02K.xml.LanguageDocument;
import com.ejie.r02K.xml.LanguageDocument.Language.Locale;
import com.ejie.r02K.xml.ManagingUnitNameDocument.ManagingUnitName;
import com.ejie.r02K.xml.NoticeDocument.Notice;
import com.ejie.r02K.xml.NoticesDocument.Notices;
import com.ejie.r02K.xml.NotificationDocument;
import com.ejie.r02K.xml.PersonDocument;
import com.ejie.r02K.xml.PersonsDocument;
import com.ejie.r02K.xml.ProcedureNameDocument.ProcedureName;
import com.ejie.r02K.xml.ProvinciaDocument.Provincia;
import com.ejie.r02K.xml.TypeDocument;
import com.ejie.r02K.xml.ValueDocument.Value;
import com.ejie.r02R.xml.AdminInitiationType;
import com.ejie.r02R.xml.AttachmentType;
import com.ejie.r02R.xml.CancelcloseExpedientNTDocument;
import com.ejie.r02R.xml.CancelcloseExpedientNTType;
import com.ejie.r02R.xml.CloseExpedientNTDocument;
import com.ejie.r02R.xml.CloseExpedientNTType;
import com.ejie.r02R.xml.CompleteFolderNumberNTType;
import com.ejie.r02R.xml.DecisionType;
import com.ejie.r02R.xml.DeleteProceedingsNTDocument;
import com.ejie.r02R.xml.DeleteProceedingsNTType;
import com.ejie.r02R.xml.DescriptionType;
import com.ejie.r02R.xml.DescriptionType.Language;
import com.ejie.r02R.xml.DocumentType;
import com.ejie.r02R.xml.DocumentType.Electronic;
import com.ejie.r02R.xml.DocumentType.Paper;
import com.ejie.r02R.xml.DocumentsType;
import com.ejie.r02R.xml.ExpedientNTDocument;
import com.ejie.r02R.xml.ExpedientNTType;
import com.ejie.r02R.xml.InitExpedientNTDocument;
import com.ejie.r02R.xml.InitExpedientNTType;
import com.ejie.r02R.xml.NoticeChanelType;
import com.ejie.r02R.xml.NotificationChanelType;
import com.ejie.r02R.xml.NotificationChanelType.Postal;
import com.ejie.r02R.xml.NotificationProceedingsType;
import com.ejie.r02R.xml.NotificationType;
import com.ejie.r02R.xml.ParticipantType;
import com.ejie.r02R.xml.ParticipantsType;
import com.ejie.r02R.xml.PersonType;
import com.ejie.r02R.xml.ProceedingsDetailType;
import com.ejie.r02R.xml.ProceedingsType;
import com.ejie.r02R.xml.SaveOrUpdateParticipantNTDocument;
import com.ejie.r02R.xml.SaveOrUpdateParticipantNTType;
import com.ejie.r02R.xml.SaveorupdateProceedingsNTDocument;
import com.ejie.r02R.xml.SaveorupdateProceedingsNTType;
import com.ejie.r02R.xml.WaitingType;
import com.ejie.servicesIfz.xml.q99MTareaNotificarSchema.AttachmentsListDocument;
import com.ejie.servicesIfz.xml.q99MTareaNotificarSchema.AttachmentsListDocument.AttachmentsList;
import com.ejie.servicesIfz.xml.q99MTareaNotificarSchema.NotificationCreateTaskDocument;
import com.ejie.servicesIfz.xml.q99MTareaNotificarSchema.NotificationCreateTaskDocument.NotificationCreateTask;
import com.ejie.x43s.v2.mgs.xml.TAttachment;
import com.ejie.x43s.v2.mgs.xml.TDocOriginType;
import com.ejie.x43s.v2.mgs.xml.TDocument;
import com.ejie.x43s.v2.mgs.xml.TDocumentList;
import com.ejie.x43s.v2.mgs.xml.TElectronic;
import com.ejie.x43s.v2.mgs.xml.TPaper;
import com.ejie.x43s.v2.mgs.xml.TProceeding;
import com.ejie.x43s.v2.mgs.xml.TProceedingList;
import com.ejie.x43s.v2.ttn.xml.TAttachmentType;
import com.ejie.x43s.v2.ttn.xml.TLanguage;
import com.ejie.x43s.v2.ttn.xml.TPersonIDName;
import com.ejie.x43s.v2.ttn.xml.TStringI18N;
import com.ejie.x43s.v2.ttn.xml.TTextI18N;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.platea.ActualizarExpediente;
import com.ejie.y41b.model.platea.ActualizarMisGestiones;
import com.ejie.y41b.model.platea.CierreExpediente;
import com.ejie.y41b.model.platea.CrearEJGV;
import com.ejie.y41b.model.platea.CrearNotifEJGV;
import com.ejie.y41b.model.platea.DatosCertificado;
import com.ejie.y41b.model.platea.DatosPersona;
import com.ejie.y41b.model.platea.EnvioEJGV;
import com.ejie.y41b.model.platea.Espera;
import com.ejie.y41b.model.platea.ExpedienteOficio;
import com.ejie.y41b.model.platea.Historico;
import com.ejie.y41b.model.platea.NotificacionPostal;
import com.ejie.y41b.model.platea.Proceedings;
import com.ejie.y41b.model.platea.RegistroEntrada;
import com.ejie.y41b.model.platea.RegistroSalida;
import com.ejie.y41b.model.platea.SolicitudOficio;
import com.ejie.y41b.model.platea.SolicitudPresencial;
import com.ejie.y41b.model.platea.SolicitudTelematica;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;
import com.ejie.y41b.utils.xml.Y41bXMLUtils;
import com.ejie.y41b.ws.cliente.x43notificaciones.TAttachmentList;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNoticeAddressee;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNoticeAddresseeList;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNoticeChannel;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNoticeMessage;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNoticeType;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNotificationCreateNew;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNotificationType;

/**
 * <p>
 * Titulo: Y41bPlateaHelper
 * </p>
 * <p>
 * Descripcion: Contiene metodos para crear los parametros de envio en las
 * llamadas a los WebServices de Platea
 * </p>
 * <p>
 * 
 * 
 * Copyright: Copyright (c) 2013
 * </p>
 * <p>
 * Empresa: Bilbomatica
 * 
 * </p>
 * 
 *  
 * @version 1.0
 */
public final class Y41bPlateaHelper {

	private static final Logger logger = LoggerFactory.getLogger(Y41bPlateaHelper.class);

	/**
	 * Constructor
	 */
	private Y41bPlateaHelper() {
		super();
	}

	/**
	 * Método que construye el contentSubmision de una solicitud presencial
	 * 
	 * @param solicitudPresencial
	 *            objeto con los datos de la solicitud presencial
	 *            ProcedureDocument procedureDocument
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLContentSubmisionEnvioPresencial(SolicitudPresencial solicitudPresencial,
			Procedure procedureCatalog) throws Exception {

		ContextSubmissionDocument contextSubmissionDocument = ContextSubmissionDocument.Factory.newInstance();
		ContextSubmission contextSubmission = contextSubmissionDocument.addNewContextSubmission();

		contextSubmission.setProcedureID(solicitudPresencial.getProcedure().getIdProcedimiento());

		contextSubmission.setProcedureName(procedureCatalog.getProcedureName());

		contextSubmission.setDepartmentID(procedureCatalog.getDepartmentId());
		contextSubmission.setManagingUnitID(procedureCatalog.getManagingUnitId());
		contextSubmission.setSenderID(solicitudPresencial.getSolicitante().getDni());
		contextSubmission.setSenderName(solicitudPresencial.getSolicitante().getNombre());
		contextSubmission.setSubmissionType(Y41bConstantes.SUBMISSIONTYPE_SOLICITUD_PRESENCIAL);

		DescriptionType description = DescriptionType.Factory.newInstance();
		Language cas = description.addNewLanguage();
		cas.setLocale(Locale.ES.toString());
		cas.setStringValue(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_PRESENCIAL_ES);
		Language eus = description.addNewLanguage();
		eus.setLocale(Y41bConstantes.EUSKERA);
		eus.setStringValue(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_PRESENCIAL_EU);
		contextSubmission.setSubmissionTypeName(description);

		contextSubmission.setFolderNumber(solicitudPresencial.getNumeroExpediente());

		contextSubmission.setMustRegistry(Y41bConstantes.SI);
		contextSubmission.setRegistrySenderID(solicitudPresencial.getSolicitante().getDni());
		contextSubmission.setRegistrySenderName(solicitudPresencial.getSolicitante().getNombre());
		contextSubmission.setFamilyID(procedureCatalog.getFamilyId());
		contextSubmission.setEntityID(procedureCatalog.getEntityCode());
		contextSubmission.setEntityName(procedureCatalog.getEntityName());

		contextSubmission.setDepartmentName(procedureCatalog.getDepartmentName());
		contextSubmission.setManagingUnitName(procedureCatalog.getManagingUnitName());

		DataControl dataControlMessage = contextSubmission.addNewDataControl();
		dataControlMessage.setType(Y41bConstantes.MESSAGECONTROL);
		dataControlMessage.setValue(Y41bConstantes.SI);

		DataControl dataControlCertified = contextSubmission.addNewDataControl();
		dataControlCertified.setType(Y41bConstantes.CERTIFIEDVALIDATIONMODE);
		dataControlCertified.setValue(Y41bConstantes.ASYNC);

		contextSubmission.setMailbox(procedureCatalog.getProcedureInboxId());
		contextSubmission.setProcedureInboxID(procedureCatalog.getProcedureInboxId());
		contextSubmission.setProcedureInboxName(procedureCatalog.getProcedureInboxName());
		ApplicantInfo applicantInfo = contextSubmission.addNewApplicantInfo();
		// IMPORTANTE sin language da error
		applicantInfo.setLanguage(Y41bConstantes.CASTELLANO);
		Persons persons = applicantInfo.addNewPersons();
		Person solicitante = persons.addNewPerson();
		solicitante.setId(solicitudPresencial.getSolicitante().getDni().trim());
		solicitante.setName(solicitudPresencial.getSolicitante().getNombre());
		solicitante.setHolderShip(Y41bConstantes.TITULAR);
		solicitante.setPersonType(Y41bConstantes.FISICA);

		if (solicitudPresencial.getRepresentante() != null) {
			Person representante = persons.addNewPerson();
			representante.setId(solicitudPresencial.getRepresentante().getDni().trim());
			representante.setName(solicitudPresencial.getRepresentante().getNombre());
			representante.setHolderShip(Y41bConstantes.REPRESENTANTE);
			representante.setPersonType(Y41bConstantes.FISICA);
		}

		Notification notification = applicantInfo.addNewNotification();
		Addressee direccion = notification.addNewAddressee();
		direccion.setAddresseeID(solicitudPresencial.getSolicitante().getDni());
		direccion.setAddresseeName(solicitudPresencial.getSolicitante().getNombre());

		Channel canal = notification.addNewChannel();
		canal.setChannelType(solicitudPresencial.getTipoNotificacion());

		if (null != solicitudPresencial.getNotificacionPostal()
				&& Y41bConstantes.POSTAL.equals(solicitudPresencial.getNotificacionPostal())) {

			NotificacionPostal notificacionPostal = solicitudPresencial.getNotificacionPostal();

			PostalAddressDocument channelInfo = PostalAddressDocument.Factory.newInstance();
			PostalAddress postal = channelInfo.addNewPostalAddress();
			postal.setPais(notificacionPostal.getPais());
			postal.setDireccion(notificacionPostal.getCalle());
			postal.setLocalidad(notificacionPostal.getLocalidad());
			String provincia = Y41bXMLUtils.createLanguageEstructura("provincia", notificacionPostal.getProvincia());
			postal.setProvincia(XmlObject.Factory.parse(provincia));
			postal.setPortal(notificacionPostal.getPortal());
			postal.setCp(notificacionPostal.getCodigoPostal());

			canal.setChannelInfo(channelInfo);
		}

		Documents documents = contextSubmission.addNewDocuments();
		if (null != solicitudPresencial.getDocumentosAdjuntos()
				&& solicitudPresencial.getDocumentosAdjuntos().size() > 0) {
			for (Documento documentoAux : solicitudPresencial.getDocumentosAdjuntos()) {
				Document document = documents.addNewDocument();
				document.setOid(documentoAux.getOidDokusi());
			}
		}

		return Y41bXMLUtils.quitarNameSpacesString(contextSubmissionDocument);
	}

	/**
	 * Crear xml para la apertura de un expediente telemático
	 * 
	 * @param solicitudPresencial
	 *            objeto con los datos de la solicitud presencial
	 *            ProcedureDocument procedureDocument
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLInicioExpedientePresencial(SolicitudPresencial solicitudPresencial,
			Procedure procedureCatalog) throws Exception {

		InitExpedientNTDocument initExpedientNTDocument = InitExpedientNTDocument.Factory.newInstance();
		InitExpedientNTType initExpedientNTType = initExpedientNTDocument.addNewInitExpedientNT();

		initExpedientNTType.setFamily(procedureCatalog.getFamilyId());

		initExpedientNTType.setProcedureId(solicitudPresencial.getProcedure().getIdProcedimiento());

		String ejercicio = getEjercicio(solicitudPresencial.getNumeroExpediente());

		initExpedientNTType.setExercise(ejercicio);

		initExpedientNTType.setFolderNumber(solicitudPresencial.getNumeroExpediente());

		DescriptionType description = initExpedientNTType.addNewDescription();
		description.set(procedureCatalog.getProcedureName());

		initExpedientNTType.setEntity(procedureCatalog.getEntityCode());
		initExpedientNTType.setManagingUnitId(procedureCatalog.getManagingUnitId());

		DescriptionType descriptionType = initExpedientNTType.addNewManagingUnitName();

		descriptionType.set(procedureCatalog.getManagingUnitName());

		initExpedientNTType.setDeliveryKey(procedureCatalog.getManagingUnitInboxId());
		initExpedientNTType.setProcessingRoleId(procedureCatalog.getManagingUnitInboxId());
		initExpedientNTType.setProcessingRoleName(procedureCatalog.getManagingUnitInboxName());
		initExpedientNTType.setStatus(BigInteger.ONE);
		initExpedientNTType.setOpeningTimestamp(Calendar.getInstance());
		initExpedientNTType.setStartTimestamp(Calendar.getInstance());
		initExpedientNTType.setUpdateTimestamp(Calendar.getInstance());

		ParticipantType participant = initExpedientNTType.addNewParticipant();

		if (Y41bUtils.isFilled(solicitudPresencial.getIdParticipacion())) {
			participant.setParticipantId(solicitudPresencial.getIdParticipacion().trim());
		} else {
			participant.setParticipantId(solicitudPresencial.getSolicitante().getDni().trim());
		}

		participant
				.setRole(com.ejie.r02R.xml.ParticipantNoProceedingsType.Role.Enum.forString(Y41bConstantes.APPLICANT));

		if (StringUtils.isEmpty(solicitudPresencial.getSolicitante().getIdioma())) {
			participant.setLanguage(
					com.ejie.r02R.xml.ParticipantNoProceedingsType.Language.Enum.forString(Y41bConstantes.CASTELLANO));
		} else {
			participant.setLanguage(com.ejie.r02R.xml.ParticipantNoProceedingsType.Language.Enum
					.forString(solicitudPresencial.getSolicitante().getIdioma().toLowerCase()));
		}

		participant = Y41bPlateaHelper.addNoticeChannelAperturaExpediente(participant,
				solicitudPresencial.getSolicitante());
		participant = Y41bPlateaHelper.addNotificationChannelAperturaExpediente(participant, solicitudPresencial);

		ParticipantsType participantsType = participant.addNewParticipants();

		PersonType holder = participantsType.addNewHolder();
		holder.setType(BigInteger.ONE);
		holder.setId(solicitudPresencial.getSolicitante().getDni().trim());
		holder.setNombre(StringEscapeUtils.escapeHtml(solicitudPresencial.getSolicitante().getNombre()));

		if (Y41bUtils.isFilled(solicitudPresencial.getSolicitante().getApellido1())) {
			holder.setApellido1(StringEscapeUtils.escapeHtml(solicitudPresencial.getSolicitante().getApellido1()));
		} else {
			holder.setApellido1(".");
		}

		if (solicitudPresencial.getRepresentante() != null
				&& StringUtils.isNotBlank(solicitudPresencial.getRepresentante().getDni())) {
			PersonType representante = participantsType.addNewRepresentative();
			representante.setId(solicitudPresencial.getRepresentante().getDni().trim());
			representante.setNombre(StringEscapeUtils.escapeHtml(solicitudPresencial.getRepresentante().getNombre()));

			if (Y41bUtils.isFilled(solicitudPresencial.getRepresentante().getApellido1())) {
				representante.setApellido1(
						StringEscapeUtils.escapeHtml(solicitudPresencial.getRepresentante().getApellido1()));
			} else {
				representante.setApellido1(".");
			}
			representante.setType(BigInteger.ONE);
		}

		ProceedingsType proceedingsType;
		proceedingsType = participant.addNewProceedings();

		// ProceedingsType proceedingsType = initExpedientNTType
		// .addNewProceedings();
		proceedingsType.setProceedingsId(Y41bConstantes.LITERAL_PROCEEDINGSID_PRESENCIAL);
		proceedingsType.setTimestamp(Calendar.getInstance());
		DescriptionType proccedingsDesc = proceedingsType.addNewDescription();
		Language procedingLanguage = proccedingsDesc.addNewLanguage();
		procedingLanguage.setLocale(Y41bConstantes.CASTELLANO);
		procedingLanguage.setStringValue(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_PRESENCIAL_ES);
		procedingLanguage = proccedingsDesc.addNewLanguage();
		procedingLanguage.setLocale(Y41bConstantes.EUSKERA);
		procedingLanguage.setStringValue(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_PRESENCIAL_EU);
		proceedingsType.setManagingUnitId(procedureCatalog.getManagingUnitId());
		DescriptionType descManaging = proceedingsType.addNewManagingUnitName();
		descManaging.set(procedureCatalog.getManagingUnitName());

		proceedingsType = Y41bPlateaHelper.addFromCitizenAperturaExpedientePresencial(proceedingsType,
				solicitudPresencial);

		AttachmentType attachmentType;
		attachmentType = initExpedientNTType.getParticipantArray(0).getProceedingsArray(0).addNewAttachment();

		attachmentType.setTypeattchment(BigInteger.ONE);
		attachmentType.setSenderId(solicitudPresencial.getSolicitante().getDni());
		if (solicitudPresencial.getProcedure().getIdProcedimiento().equals(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE)) {
			Calendar cal = Calendar.getInstance();
			cal.setTime(Y41bUtils.formatearStringToDateFormato(
					solicitudPresencial.getDatosRegistro().getRegistryTimestamp(),
					Y41bConstantes.FORMATO_FECHAHORALARGA_ES));
			attachmentType.setInputTimestamp(cal);
		} else {
			attachmentType.setInputTimestamp(Calendar.getInstance());
		}

		Sleep w = new Sleep();
		w.doSleep(Y41bConstantes.NUM_1000);

		ProceedingsType proceedingsType2;
		if (solicitudPresencial.getInteresado() == null) {
			proceedingsType2 = initExpedientNTType.addNewProceedings();
		} else {
			proceedingsType2 = participant.addNewProceedings();
		}

		proceedingsType2.setProceedingsId(Y41bConstantes.LITERAL_PROCEEDINGSID_APERTURA);
		proceedingsType2.setTimestamp(Calendar.getInstance());
		DescriptionType proccedingsDesc2 = proceedingsType2.addNewDescription();
		Language procedingLanguage2 = proccedingsDesc2.addNewLanguage();
		procedingLanguage2.setLocale(Y41bConstantes.CASTELLANO);
		procedingLanguage2.setStringValue(Y41bConstantes.LITERAL_APERTURA_PRESENCIAL_ES);
		procedingLanguage2 = proccedingsDesc2.addNewLanguage();
		procedingLanguage2.setLocale(Y41bConstantes.EUSKERA);
		procedingLanguage2.setStringValue(Y41bConstantes.LITERAL_APERTURA_PRESENCIAL_EU);
		proceedingsType2.setManagingUnitId(procedureCatalog.getManagingUnitId());

		DescriptionType descManagingProceeding2 = proceedingsType2.addNewManagingUnitName();
		descManagingProceeding2.set(procedureCatalog.getManagingUnitName());

		// aadimos la segunda participacin
		// solicitudPresencial.setInteresado(null);
		if (solicitudPresencial.getInteresado() != null) {

			ParticipantType participantInteresado = initExpedientNTType.addNewParticipant();
			participantInteresado.setParticipantId(solicitudPresencial.getInteresado().getDni().trim());

			participantInteresado.setRole(
					com.ejie.r02R.xml.ParticipantNoProceedingsType.Role.Enum.forString(Y41bConstantes.AFECTED));

			if (StringUtils.isEmpty(solicitudPresencial.getInteresado().getIdioma())) {
				participantInteresado.setLanguage(com.ejie.r02R.xml.ParticipantNoProceedingsType.Language.Enum
						.forString(Y41bConstantes.CASTELLANO));
			} else {
				participantInteresado.setLanguage(com.ejie.r02R.xml.ParticipantNoProceedingsType.Language.Enum
						.forString(solicitudPresencial.getInteresado().getIdioma().toLowerCase()));
			}
			participantInteresado = Y41bPlateaHelper.addNoticeChannelAperturaExpediente(participantInteresado,
					solicitudPresencial.getInteresado());
			participantInteresado = Y41bPlateaHelper.addNotificationChannelAperturaExpediente(participantInteresado,
					solicitudPresencial);

			ParticipantsType participantInteresadosType = participantInteresado.addNewParticipants();

			PersonType holderInteresado = participantInteresadosType.addNewHolder();
			holderInteresado.setType(BigInteger.valueOf(2));
			holderInteresado.setId(solicitudPresencial.getInteresado().getDni().trim());
			holderInteresado.setNombre(solicitudPresencial.getInteresado().getNombre());

			if (Y41bUtils.isFilled(solicitudPresencial.getInteresado().getApellido1())) {
				holderInteresado.setApellido1(solicitudPresencial.getInteresado().getApellido1());
			} else {
				holderInteresado.setApellido1(".");
			}
			// if (solicitudPresencial.getRepresentante() != null
			// && StringUtils.isNotBlank(solicitudPresencial
			// .getRepresentante().getDni())) {
			// PersonType representante =
			// participantInteresadosType.addNewRepresentative();
			// representante.setId(solicitudPresencial.getRepresentante().getDni()
			// .trim());
			// representante.setNombre(solicitudPresencial.getRepresentante()
			// .getNombre());
			//
			// if (Y41bUtils.isFilled(solicitudPresencial.getRepresentante()
			// .getApellido1())) {
			// representante.setApellido1(solicitudPresencial
			// .getRepresentante().getApellido1());
			// } else {
			// representante.setApellido1(".");
			// }
			// representante.setType(BigInteger.ONE);
			// }

			// aadimos un procedimiento al interesado de apertura
			ProceedingsType proceedingsTypeInteresado;
			proceedingsTypeInteresado = participantInteresado.addNewProceedings();
			proceedingsTypeInteresado.setProceedingsId(Y41bConstantes.LITERAL_PROCEEDINGSID_APERTURA_RECLAMADO);
			proceedingsTypeInteresado.setTimestamp(Calendar.getInstance());
			DescriptionType proccedingsDescInteresado = proceedingsTypeInteresado.addNewDescription();
			Language procedingLanguageInteresado = proccedingsDescInteresado.addNewLanguage();
			procedingLanguageInteresado.setLocale(Y41bConstantes.CASTELLANO);
			procedingLanguageInteresado.setStringValue(Y41bConstantes.LITERAL_APERTURA_PRESENCIAL_ES);
			procedingLanguageInteresado = proccedingsDescInteresado.addNewLanguage();
			procedingLanguageInteresado.setLocale(Y41bConstantes.EUSKERA);
			procedingLanguageInteresado.setStringValue(Y41bConstantes.LITERAL_APERTURA_PRESENCIAL_EU);
			proceedingsTypeInteresado.setManagingUnitId(procedureCatalog.getManagingUnitId());

			DescriptionType descManagingProceedingInteresado = proceedingsTypeInteresado.addNewManagingUnitName();
			descManagingProceedingInteresado.set(procedureCatalog.getManagingUnitName());
		}

		return Y41bXMLUtils.quitarNameSpacesString(initExpedientNTDocument);
	}

	/**
	 * Crear xml para la apertura de un expediente de oficio
	 * 
	 * @param solicitudOficio
	 *            objeto con los datos de la solicitud de oficio
	 *            ProcedureDocument procedureDocument
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLInicioExpedienteOficio(SolicitudOficio solicitudOficio, Procedure procedureCatalog)
			throws Exception {

		InitExpedientNTDocument initExpedientNTDocument = InitExpedientNTDocument.Factory.newInstance();
		InitExpedientNTType initExpedientNTType = initExpedientNTDocument.addNewInitExpedientNT();

		initExpedientNTType.setFamily(procedureCatalog.getFamilyId());

		initExpedientNTType.setProcedureId(solicitudOficio.getProcedure().getIdProcedimiento());

		String ejercicio = getEjercicio(solicitudOficio.getNumeroExpediente());

		initExpedientNTType.setExercise(ejercicio);

		initExpedientNTType.setFolderNumber(solicitudOficio.getNumeroExpediente());

		DescriptionType description = initExpedientNTType.addNewDescription();
		description.set(procedureCatalog.getProcedureName());

		initExpedientNTType.setEntity(procedureCatalog.getEntityCode());
		initExpedientNTType.setManagingUnitId(procedureCatalog.getManagingUnitId());

		DescriptionType descriptionType = initExpedientNTType.addNewManagingUnitName();

		descriptionType.set(procedureCatalog.getManagingUnitName());

		initExpedientNTType.setDeliveryKey(procedureCatalog.getManagingUnitInboxId());
		initExpedientNTType.setProcessingRoleId(procedureCatalog.getManagingUnitInboxId());
		initExpedientNTType.setProcessingRoleName(procedureCatalog.getManagingUnitInboxName());
		initExpedientNTType.setStatus(BigInteger.ONE);

		if (solicitudOficio.getAperturaTimestamp() != null) {
			initExpedientNTType.setOpeningTimestamp(solicitudOficio.getAperturaTimestamp());
			initExpedientNTType.setStartTimestamp(solicitudOficio.getAperturaTimestamp());
			initExpedientNTType.setUpdateTimestamp(solicitudOficio.getAperturaTimestamp());
		} else {
			initExpedientNTType.setOpeningTimestamp(Calendar.getInstance());
			initExpedientNTType.setStartTimestamp(Calendar.getInstance());
			initExpedientNTType.setUpdateTimestamp(Calendar.getInstance());
		}

		if (solicitudOficio.getSancionado() != null) {
			ParticipantType participant = initExpedientNTType.addNewParticipant();

			if (Y41bUtils.isFilled(solicitudOficio.getIdParticipacion())) {
				participant.setParticipantId(solicitudOficio.getIdParticipacion().trim());
			} else {
				participant.setParticipantId(solicitudOficio.getSancionado().getDni().trim());
			}
			participant.setRole(
					com.ejie.r02R.xml.ParticipantNoProceedingsType.Role.Enum.forString(Y41bConstantes.APPLICANT));

			if (StringUtils.isEmpty(solicitudOficio.getIdiomaNotificacion())) {
				participant.setLanguage(com.ejie.r02R.xml.ParticipantNoProceedingsType.Language.Enum
						.forString(Y41bConstantes.CASTELLANO));
			} else {
				participant.setLanguage(com.ejie.r02R.xml.ParticipantNoProceedingsType.Language.Enum
						.forString(solicitudOficio.getIdiomaNotificacion().toLowerCase()));
			}
			participant = Y41bPlateaHelper.addNoticeChannelAperturaExpediente(participant, solicitudOficio);
			participant = Y41bPlateaHelper.addNotificationChannelAperturaExpediente(participant, solicitudOficio);

			ParticipantsType participantsType = participant.addNewParticipants();
			PersonType holder = participantsType.addNewHolder();

			holder.setType(BigInteger.ONE);
			holder.setId(solicitudOficio.getSancionado().getDni().trim());
			holder.setNombre(StringEscapeUtils.escapeHtml(solicitudOficio.getSancionado().getNombre()));
			holder.setApellido1(".");

			if (solicitudOficio.getRepresentante() != null
					&& StringUtils.isNotBlank(solicitudOficio.getRepresentante().getDni())) {
				PersonType representante = participantsType.addNewRepresentative();
				representante.setId(solicitudOficio.getRepresentante().getDni().trim());
				representante.setNombre(StringEscapeUtils.escapeHtml(solicitudOficio.getRepresentante().getNombre()));
				representante.setApellido1(".");
				representante.setType(BigInteger.ONE);
			}

			ProceedingsType proceedingsType2 = initExpedientNTType.getParticipantArray(0).addNewProceedings();
			proceedingsType2.setProceedingsId(Y41bConstantes.LITERAL_PROCEEDINGSID_APERTURA);

			if (solicitudOficio.getAperturaTimestamp() != null) {
				proceedingsType2.setTimestamp(solicitudOficio.getAperturaTimestamp());
			} else {
				proceedingsType2.setTimestamp(Calendar.getInstance());
			}
			DescriptionType proccedingsDesc2 = proceedingsType2.addNewDescription();
			Language procedingLanguage2 = proccedingsDesc2.addNewLanguage();
			procedingLanguage2.setLocale(Y41bConstantes.CASTELLANO);
			procedingLanguage2.setStringValue(Y41bConstantes.LITERAL_APERTURA_OFICIO_ES);
			procedingLanguage2 = proccedingsDesc2.addNewLanguage();
			procedingLanguage2.setLocale(Y41bConstantes.EUSKERA);
			procedingLanguage2.setStringValue(Y41bConstantes.LITERAL_APERTURA_OFICIO_EU);
			proceedingsType2.setManagingUnitId(procedureCatalog.getManagingUnitId());

			DescriptionType descManagingProceeding2 = proceedingsType2.addNewManagingUnitName();
			descManagingProceeding2.set(procedureCatalog.getManagingUnitName());
		}

		return Y41bXMLUtils.quitarNameSpacesString(initExpedientNTDocument);
	}

	/**
	 * Crear xml para la apertura de un expediente de oficio
	 * 
	 * @param expedienteOficio
	 *            objeto con los datos del expediente de oficio
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLInicioExpedienteOficio(ExpedienteOficio expedienteOficio, Procedure procedureCatalog)
			throws Exception {
		AdminInitiationDocument initiationDocument = AdminInitiationDocument.Factory.newInstance();
		AdminInitiation initiation = initiationDocument.addNewAdminInitiation();

		GeneralData generalData = initiation.addNewGeneralData();
		generalData.setProcedureId(expedienteOficio.getProcedure().getIdProcedimiento());
		generalData.setProcedureName(procedureCatalog.getProcedureName());
		generalData.setManagingUnitId(procedureCatalog.getManagingUnitId());
		generalData.setManagingUnitName(procedureCatalog.getManagingUnitName());
		generalData.setProceedingFamily(procedureCatalog.getFamilyId());
		generalData.setEntity(procedureCatalog.getEntityCode());

		String fecha = Y41bUtils.fncParsearFechaLargaAlternativa(
				new Timestamp(Long.parseLong(expedienteOficio.getAperturaTimeStamp())));
		generalData.setStartDateAI(fecha);
		generalData.setMAILBOX(expedienteOficio.getBuzonId());
		generalData.setSenderId(expedienteOficio.getBuzonId());
		generalData.setSenderName(expedienteOficio.getBuzonName());
		generalData.setDaDocumentalSeries(procedureCatalog.getDaDocumentalSeries().getID());
		generalData.setResolutionCalendarType(procedureCatalog.getResolutionCalendarTypeID());
		generalData.setManagerCalendarType(procedureCatalog.getManagerCalendarTypeID());

		generalData.setDepartmentId(procedureCatalog.getDepartmentId());
		generalData.setProcedureInboxId(procedureCatalog.getProcedureInboxId());
		generalData.setProcedureInboxName(procedureCatalog.getProcedureInboxName());

		generalData.setInitiationType(Y41bConstantes.NUM_3 + "");
		generalData.setInitiateById("");
		generalData.setInitiateByDesc(XmlObject.Factory.newInstance());

		Applicants applicants = initiation.addNewApplicants();
		Participation applicant = applicants.addNewApplicant();
		applicant.setLanguage(Y41bConstantes.CASTELLANO);
		applicant.setRole(Y41bConstantes.AFFECTED);
		com.ejie.ainit.xml.Participation.Persons persons = applicant.addNewPersons();
		com.ejie.ainit.xml.Person solicitante = persons.addNewPerson();
		solicitante.setID(expedienteOficio.getSolicitante().getDni().trim());
		solicitante.setName(expedienteOficio.getSolicitante().getNombre());
		solicitante.setHoldership(Y41bConstantes.TITULAR);
		solicitante.setPersonType(Y41bConstantes.FISICA);

		if (expedienteOficio.getRepresentante() != null
				&& Y41bUtils.isFilled(expedienteOficio.getRepresentante().getDni())) {
			com.ejie.ainit.xml.Person representante = persons.addNewPerson();
			representante.setID(expedienteOficio.getRepresentante().getDni().trim());
			representante.setName(expedienteOficio.getRepresentante().getNombre());
			representante.setHoldership(Y41bConstantes.REPRESENTANTE);
			representante.setPersonType(Y41bConstantes.FISICA);
		}

		com.ejie.ainit.xml.NotificationDocument.Notification notification = applicant.addNewNotification();
		com.ejie.ainit.xml.AddresseeDocument.Addressee direccion = notification.addNewAddressee();
		direccion.setAddresseeID(expedienteOficio.getSolicitante().getDni());
		direccion.setAddresseename(expedienteOficio.getSolicitante().getNombre());

		com.ejie.ainit.xml.ChannelDocument.Channel canal = notification.addNewChannel();
		canal.setChannelType(Y41bConstantes.POSTAL);

		if (null != expedienteOficio.getNotificacionPostal()) {
			ChannelInfoDocument.ChannelInfo channelInfo = ChannelInfoDocument.ChannelInfo.Factory.newInstance();
			com.ejie.r02K.xml.PostalAddressDocument.PostalAddress postal = channelInfo.addNewPostalAddress();
			postal.setPais(expedienteOficio.getNotificacionPostal().getPais());
			postal.setDireccion(expedienteOficio.getNotificacionPostal().getCalle());
			postal.setMunicipio(expedienteOficio.getNotificacionPostal().getMunicipio());
			postal.setLocalidad(expedienteOficio.getNotificacionPostal().getLocalidad());

			Provincia provincia = postal.addNewProvincia();
			LanguageDocument.Language cas = provincia.addNewLanguage();
			cas.setLocale(Locale.ES);
			cas.setStringValue(expedienteOficio.getNotificacionPostal().getProvincia());
			LanguageDocument.Language eus = provincia.addNewLanguage();
			eus.setLocale(Locale.EU);
			eus.setStringValue(expedienteOficio.getNotificacionPostal().getProvincia());
			postal.setProvincia(provincia);

			postal.setPortal(expedienteOficio.getNotificacionPostal().getPortal());
			postal.setCp(expedienteOficio.getNotificacionPostal().getCodigoPostal());

			canal.setChannelInfo(channelInfo);
		}
		return Y41bXMLUtils.quitarNameSpacesString(initiationDocument);
	}

	/**
	 * Crear xml para la apertura de un expediente telemático
	 * 
	 * @param solicitudTelematica
	 *            objeto con los datos de la solicitud telemático
	 *            ProcedureDocument procedureDocument
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLInicioExpedienteTelematico(SolicitudTelematica solicitudTelematica,
			Procedure procedureCatalog) throws Exception {

		InitExpedientNTDocument initExpedientNTDocument = InitExpedientNTDocument.Factory.newInstance();
		InitExpedientNTType initExpedientNTType = initExpedientNTDocument.addNewInitExpedientNT();

		initExpedientNTType.setFamily(procedureCatalog.getFamilyId());

		initExpedientNTType.setProcedureId(solicitudTelematica.getProcedure().getIdProcedimiento());

		String ejercicio = getEjercicio(solicitudTelematica.getNumeroExpediente());

		initExpedientNTType.setExercise(ejercicio);

		initExpedientNTType.setFolderNumber(solicitudTelematica.getNumeroExpediente());

		DescriptionType description = initExpedientNTType.addNewDescription();
		description.set(procedureCatalog.getProcedureName());

		initExpedientNTType.setEntity(procedureCatalog.getEntityCode());
		initExpedientNTType.setManagingUnitId(procedureCatalog.getManagingUnitId());

		DescriptionType descriptionType = initExpedientNTType.addNewManagingUnitName();

		descriptionType.set(procedureCatalog.getManagingUnitName());

		initExpedientNTType.setDeliveryKey(procedureCatalog.getManagingUnitInboxId());
		initExpedientNTType.setProcessingRoleId(procedureCatalog.getManagingUnitInboxId());
		initExpedientNTType.setProcessingRoleName(procedureCatalog.getManagingUnitInboxName());
		initExpedientNTType.setStatus(BigInteger.ONE);
		initExpedientNTType.setOpeningTimestamp(Calendar.getInstance());
		initExpedientNTType.setStartTimestamp(Calendar.getInstance());
		initExpedientNTType.setUpdateTimestamp(Calendar.getInstance());

		ParticipantType participant = initExpedientNTType.addNewParticipant();
		participant.setParticipantId(solicitudTelematica.getSolicitante().getDni().trim());

		participant
				.setRole(com.ejie.r02R.xml.ParticipantNoProceedingsType.Role.Enum.forString(Y41bConstantes.APPLICANT));

		// la etiqueta es obligatoria

		if (solicitudTelematica.getProcedure().getIdProcedimiento().equals(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE)) {

			if (StringUtils.isEmpty(solicitudTelematica.getSolicitante().getIdioma())) {

				// if (!solicitudTelematica.getProcedure().getIdProcedimiento()
				// .equals(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE)) {
				participant.setLanguage(com.ejie.r02R.xml.ParticipantNoProceedingsType.Language.Enum
						.forString(Y41bConstantes.CASTELLANO));
				// }
			} else {

				participant.setLanguage(com.ejie.r02R.xml.ParticipantNoProceedingsType.Language.Enum
						.forString(solicitudTelematica.getSolicitante().getIdioma().toLowerCase()));
			}

		} else {
			if (StringUtils.isEmpty(solicitudTelematica.getIdiomaNotificacion())) {

				// if (!solicitudTelematica.getProcedure().getIdProcedimiento()
				// .equals(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE)) {
				participant.setLanguage(com.ejie.r02R.xml.ParticipantNoProceedingsType.Language.Enum
						.forString(Y41bConstantes.CASTELLANO));
				// }
			} else {

				participant.setLanguage(com.ejie.r02R.xml.ParticipantNoProceedingsType.Language.Enum
						.forString(solicitudTelematica.getIdiomaNotificacion().toLowerCase()));
			}
		}

		participant = Y41bPlateaHelper.addNoticeChannelAperturaExpedienteTelematica(participant, solicitudTelematica,
				solicitudTelematica.getSolicitante());
		participant = Y41bPlateaHelper.addNotificationChannelAperturaExpedienteTelematica(participant,
				solicitudTelematica);

		ParticipantsType participantsType = participant.addNewParticipants();

		PersonType holder = participantsType.addNewHolder();
		holder.setType(BigInteger.ONE);
		holder.setId(solicitudTelematica.getSolicitante().getDni().trim());
		holder.setNombre(StringEscapeUtils.escapeHtml(solicitudTelematica.getSolicitante().getNombre()));

		if (Y41bUtils.isFilled(solicitudTelematica.getSolicitante().getApellido1())) {
			holder.setApellido1(StringEscapeUtils.escapeHtml(solicitudTelematica.getSolicitante().getApellido1()));
		} else {
			holder.setApellido1(".");
		}

		/*
		 * if (solicitudTelematica.getRepresentante() != null &&
		 * StringUtils.isNotBlank(solicitudTelematica
		 * .getRepresentante().getDni())) { PersonType representante =
		 * participantsType.addNewRepresentative();
		 * representante.setId(solicitudTelematica.getRepresentante().getDni()
		 * .trim());
		 * representante.setNombre(solicitudTelematica.getRepresentante()
		 * .getNombre()); representante.setApellido1(".");
		 * representante.setType(BigInteger.ONE); }
		 */

		// si tenemos interesado y estamos en arbitraje
		// los tramites van dentro de la participacin y los documentos tambin

		ProceedingsType proceedingsType;
		proceedingsType = participant.addNewProceedings();

		proceedingsType.setProceedingsId(Y41bConstantes.LITERAL_PROCEEDINGSID_TELEMATICO);
		proceedingsType.setTimestamp(Calendar.getInstance());
		DescriptionType proccedingsDesc = proceedingsType.addNewDescription();
		Language procedingLanguage = proccedingsDesc.addNewLanguage();
		procedingLanguage.setLocale(Y41bConstantes.CASTELLANO);
		procedingLanguage.setStringValue(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_TELEMATICO_ES);
		procedingLanguage = proccedingsDesc.addNewLanguage();
		procedingLanguage.setLocale(Y41bConstantes.EUSKERA);
		procedingLanguage.setStringValue(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_TELEMATICO_EU);
		proceedingsType.setManagingUnitId(procedureCatalog.getManagingUnitId());
		DescriptionType descManaging = proceedingsType.addNewManagingUnitName();
		descManaging.set(procedureCatalog.getManagingUnitName());

		proceedingsType = Y41bPlateaHelper.addFromCitizenAperturaExpedienteTelematica(proceedingsType,
				solicitudTelematica);
		AttachmentType attachmentType;
		attachmentType = initExpedientNTType.getParticipantArray(0).getProceedingsArray(0).addNewAttachment();

		attachmentType.setTypeattchment(BigInteger.ONE);
		attachmentType.setSenderId(solicitudTelematica.getSolicitante().getDni());
		if (solicitudTelematica.getProcedure().getIdProcedimiento().equals(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE)) {
			Calendar cal = Calendar.getInstance();
			cal.setTime(Y41bUtils.formatearStringToDateFormato(
					solicitudTelematica.getDatosRegistro().getRegistryTimestamp(),
					Y41bConstantes.FORMATO_FECHAHORALARGA_ES));
			attachmentType.setInputTimestamp(cal);
		} else {
			attachmentType.setInputTimestamp(Calendar.getInstance());
		}

		Sleep w = new Sleep();
		w.doSleep(Y41bConstantes.NUM_1000);

		ProceedingsType proceedingsType2;
		if (solicitudTelematica.getInteresado() != null && solicitudTelematica.getProcedure().getIdProcedimiento()
				.equals(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE)) {
			proceedingsType2 = participant.addNewProceedings();
		} else {
			proceedingsType2 = initExpedientNTType.addNewProceedings();
		}
		proceedingsType2.setProceedingsId(Y41bConstantes.LITERAL_PROCEEDINGSID_APERTURA);
		proceedingsType2.setTimestamp(Calendar.getInstance());
		DescriptionType proccedingsDesc2 = proceedingsType2.addNewDescription();
		Language procedingLanguage2 = proccedingsDesc2.addNewLanguage();
		procedingLanguage2.setLocale(Y41bConstantes.CASTELLANO);
		procedingLanguage2.setStringValue(Y41bConstantes.LITERAL_APERTURA_TELEMATICO_ES);
		procedingLanguage2 = proccedingsDesc2.addNewLanguage();
		procedingLanguage2.setLocale(Y41bConstantes.EUSKERA);
		procedingLanguage2.setStringValue(Y41bConstantes.LITERAL_APERTURA_TELEMATICO_EU);
		proceedingsType2.setManagingUnitId(procedureCatalog.getManagingUnitId());

		DescriptionType descManagingProceeding2 = proceedingsType2.addNewManagingUnitName();
		descManagingProceeding2.set(procedureCatalog.getManagingUnitName());

		// si tenemos interesado y estamos en arbitraje aadimos la nueva
		// participacin y sus trmites

		if (solicitudTelematica.getInteresado() != null && solicitudTelematica.getProcedure().getIdProcedimiento()
				.equals(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE)) {

			ParticipantType participantInteresado = initExpedientNTType.addNewParticipant();
			participantInteresado.setParticipantId(solicitudTelematica.getInteresado().getDni().trim());

			participantInteresado.setRole(
					com.ejie.r02R.xml.ParticipantNoProceedingsType.Role.Enum.forString(Y41bConstantes.AFECTED));

			if (StringUtils.isEmpty(solicitudTelematica.getInteresado().getIdioma())) {
				participantInteresado.setLanguage(com.ejie.r02R.xml.ParticipantNoProceedingsType.Language.Enum
						.forString(Y41bConstantes.CASTELLANO));
			} else {
				participantInteresado.setLanguage(com.ejie.r02R.xml.ParticipantNoProceedingsType.Language.Enum
						.forString(solicitudTelematica.getInteresado().getIdioma().toLowerCase()));
			}
			participantInteresado = Y41bPlateaHelper.addNoticeChannelAperturaExpedienteTelematica(participantInteresado,
					solicitudTelematica, solicitudTelematica.getInteresado());
			participantInteresado = Y41bPlateaHelper
					.addNotificationChannelAperturaExpedienteTelematica(participantInteresado, solicitudTelematica);

			ParticipantsType participantsTypeInteresado = participantInteresado.addNewParticipants();

			PersonType holderInteresado = participantsTypeInteresado.addNewHolder();
			holderInteresado.setType(BigInteger.valueOf(2));
			holderInteresado.setId(solicitudTelematica.getInteresado().getDni().trim());
			holderInteresado.setNombre(solicitudTelematica.getInteresado().getNombre());
			holderInteresado.setApellido1(".");

			/*
			 * if (solicitudTelematica.getRepresentante() != null &&
			 * StringUtils.isNotBlank(solicitudTelematica
			 * .getRepresentante().getDni())) { PersonType representante =
			 * participantsTypeInteresado.addNewRepresentative();
			 * representante.setId
			 * (solicitudTelematica.getRepresentante().getDni() .trim());
			 * representante.setNombre(solicitudTelematica.getRepresentante()
			 * .getNombre()); representante.setApellido1(".");
			 * representante.setType(BigInteger.ONE); }
			 */

			ProceedingsType proceedingsTypeInteresado;
			proceedingsTypeInteresado = participantInteresado.addNewProceedings();

			proceedingsTypeInteresado.setProceedingsId(Y41bConstantes.LITERAL_PROCEEDINGSID_APERTURA);
			proceedingsTypeInteresado.setTimestamp(Calendar.getInstance());
			DescriptionType proccedingsDescInteresado = proceedingsTypeInteresado.addNewDescription();
			Language procedingLanguageInteresado = proccedingsDescInteresado.addNewLanguage();
			procedingLanguageInteresado.setLocale(Y41bConstantes.CASTELLANO);
			procedingLanguageInteresado.setStringValue(Y41bConstantes.LITERAL_APERTURA_TELEMATICO_ES);
			procedingLanguageInteresado = proccedingsDescInteresado.addNewLanguage();
			procedingLanguageInteresado.setLocale(Y41bConstantes.EUSKERA);
			procedingLanguageInteresado.setStringValue(Y41bConstantes.LITERAL_APERTURA_TELEMATICO_EU);
			proceedingsTypeInteresado.setManagingUnitId(procedureCatalog.getManagingUnitId());

			DescriptionType descManagingProceedingInteresado = proceedingsTypeInteresado.addNewManagingUnitName();
			descManagingProceedingInteresado.set(procedureCatalog.getManagingUnitName());

		}

		return Y41bXMLUtils.quitarNameSpacesString(initExpedientNTDocument);
	}

	/**
	 * Metodo que recupera el ejericio a partir del numExpediente
	 * 
	 * @param numExpediente
	 *            String
	 * @return String
	 */
	public static String getEjercicio(String numExpediente) {
		String ejercicio = "";
		try {
			if (Y41bUtils.isFilled(numExpediente)) {
				StringTokenizer tokenizer = new StringTokenizer(numExpediente, "-");
				if (tokenizer.hasMoreTokens()) {
					// Procedimiento
					tokenizer.nextToken();
					if (tokenizer.hasMoreTokens()) {
						// Organismo
						tokenizer.nextToken();
						if (tokenizer.hasMoreTokens()) {
							// Numero
							tokenizer.nextToken();
							if (tokenizer.hasMoreTokens()) {
								// Ejercicio
								ejercicio = tokenizer.nextToken();
							}
						}
					}
				}
			}
		} catch (Exception e) {
			ejercicio = null;
		}
		return ejercicio;
	}

	/**
	 * Crear xml para la apertura de un expediente telemático
	 * 
	 * @param actualizarMisGestiones
	 *            ActualizarMisGestiones
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLActualizacionMisGestiones(ActualizarMisGestiones actualizarMisGestiones,
			Procedure procedureCatalog) throws Exception {

		SaveorupdateProceedingsNTDocument saveorupdateProceedingsNTDocument = SaveorupdateProceedingsNTDocument.Factory
				.newInstance();
		SaveorupdateProceedingsNTType saveorupdateProceedingsNTType = saveorupdateProceedingsNTDocument
				.addNewSaveorupdateProceedingsNT();

		CompleteFolderNumberNTType completeFolderNumberNTType = saveorupdateProceedingsNTType
				.addNewCompleteFolderNumber();
		completeFolderNumberNTType.setProcedureId(actualizarMisGestiones.getProcedure().getIdProcedimiento());

		completeFolderNumberNTType.setExercise(actualizarMisGestiones.getEjercicio());
		completeFolderNumberNTType.setFolderNumber(actualizarMisGestiones.getNumeroExpediente());

		saveorupdateProceedingsNTType.setUpdateTimestamp(Calendar.getInstance());

		if (Y41bUtils.isFilled(actualizarMisGestiones.getIdParticipacion())) {
			saveorupdateProceedingsNTType.setParticipantId(actualizarMisGestiones.getIdParticipacion().trim());
		} else {
			saveorupdateProceedingsNTType.setParticipantId(actualizarMisGestiones.getSolicitante().getDni().trim());
		}

		ProceedingsType proceedingsType = saveorupdateProceedingsNTType.addNewProceedings();

		proceedingsType.setProceedingsId(actualizarMisGestiones.getProceedingsID());

		if (actualizarMisGestiones.getAportacionTimestamp() != null) {
			proceedingsType.setTimestamp(actualizarMisGestiones.getAportacionTimestamp());
		} else {
			proceedingsType.setTimestamp(Calendar.getInstance());
		}

		DescriptionType descriptionTypeSaveOrUp = proceedingsType.addNewDescription();
		Language desLanguage = descriptionTypeSaveOrUp.addNewLanguage();
		desLanguage.setLocale(Y41bConstantes.CASTELLANO);
		desLanguage.setStringValue(actualizarMisGestiones.getDescripcionTramiteCas());
		Language desLanguageEu = descriptionTypeSaveOrUp.addNewLanguage();
		desLanguageEu.setLocale(Y41bConstantes.EUSKERA);
		desLanguageEu.setStringValue(actualizarMisGestiones.getDescripcionTramiteEus());
		proceedingsType.setDescription(descriptionTypeSaveOrUp);

		proceedingsType.setManagingUnitId(procedureCatalog.getManagingUnitId());
		DescriptionType descManaging = proceedingsType.addNewManagingUnitName();
		descManaging.set(procedureCatalog.getManagingUnitName());

		/*
		 * NotificationProceedingsType actNotification = proceedingsType
		 * .addNewNotificationProceedings();
		 * 
		 * NotificationType descNotificedAct = actNotification
		 * .addNewNotification();
		 * 
		 * DescriptionType descNotificedAct2 = descNotificedAct
		 * .addNewNotifiedAct();
		 * 
		 * Language languageNotif = descNotificedAct2.addNewLanguage();
		 * 
		 * languageNotif.setLocale(Y41bConstantes.CASTELLANO);
		 * 
		 * languageNotif
		 * .setStringValue(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
		 * 
		 * Language languageNotifEu = descNotificedAct2.addNewLanguage();
		 * languageNotifEu.setLocale(Y41bConstantes.EUSKERA);
		 * 
		 * languageNotifEu
		 * .setStringValue(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);
		 * 
		 * descNotificedAct.setNotifiedAct(descNotificedAct2);
		 * descNotificedAct.setNotifiedActId(Y41bUtilsWS.crearProceedingsID());
		 */
		proceedingsType = Y41bPlateaHelper.addFromCitizenMisGestiones(proceedingsType, actualizarMisGestiones);

		return Y41bXMLUtils.quitarNameSpacesString(saveorupdateProceedingsNTDocument);
	}

	/**
	 * Crear xml para la apertura de un expediente telemático
	 * 
	 * @param actualizarMisGestiones
	 *            ActualizarMisGestiones
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLActualizacionMisGestionesActa(ActualizarMisGestiones actualizarMisGestiones,
			Procedure procedureCatalog) throws Exception {

		SaveorupdateProceedingsNTDocument saveorupdateProceedingsNTDocument = SaveorupdateProceedingsNTDocument.Factory
				.newInstance();
		SaveorupdateProceedingsNTType saveorupdateProceedingsNTType = saveorupdateProceedingsNTDocument
				.addNewSaveorupdateProceedingsNT();

		CompleteFolderNumberNTType completeFolderNumberNTType = saveorupdateProceedingsNTType
				.addNewCompleteFolderNumber();
		completeFolderNumberNTType.setProcedureId(actualizarMisGestiones.getProcedure().getIdProcedimiento());

		completeFolderNumberNTType.setExercise(actualizarMisGestiones.getEjercicio());
		completeFolderNumberNTType.setFolderNumber(actualizarMisGestiones.getNumeroExpediente());

		saveorupdateProceedingsNTType.setUpdateTimestamp(Calendar.getInstance());

		if (Y41bUtils.isFilled(actualizarMisGestiones.getIdParticipacion())) {
			saveorupdateProceedingsNTType.setParticipantId(actualizarMisGestiones.getIdParticipacion().trim());
		} else {
			saveorupdateProceedingsNTType.setParticipantId(actualizarMisGestiones.getSolicitante().getDni().trim());
		}

		ProceedingsType proceedingsType = saveorupdateProceedingsNTType.addNewProceedings();

		proceedingsType.setProceedingsId(actualizarMisGestiones.getProceedingsID());

		if (actualizarMisGestiones.getAportacionTimestamp() != null) {
			proceedingsType.setTimestamp(actualizarMisGestiones.getAportacionTimestamp());
		} else {
			proceedingsType.setTimestamp(Calendar.getInstance());
		}

		DescriptionType descriptionTypeSaveOrUp = proceedingsType.addNewDescription();
		Language desLanguage = descriptionTypeSaveOrUp.addNewLanguage();
		desLanguage.setLocale(Y41bConstantes.CASTELLANO);
		desLanguage.setStringValue(actualizarMisGestiones.getDescripcionTramiteCas());
		Language desLanguageEu = descriptionTypeSaveOrUp.addNewLanguage();
		desLanguageEu.setLocale(Y41bConstantes.EUSKERA);
		desLanguageEu.setStringValue(actualizarMisGestiones.getDescripcionTramiteEus());
		proceedingsType.setDescription(descriptionTypeSaveOrUp);

		proceedingsType.setManagingUnitId(procedureCatalog.getManagingUnitId());
		DescriptionType descManaging = proceedingsType.addNewManagingUnitName();
		descManaging.set(procedureCatalog.getManagingUnitName());

		proceedingsType = Y41bPlateaHelper.addFromAdministrationActualizarExpediente(proceedingsType,
				actualizarMisGestiones.getDocumentos());

		return Y41bXMLUtils.quitarNameSpacesString(saveorupdateProceedingsNTDocument);
	}

	/**
	 * Crear el objeto para informar a mis gestiones con X43
	 * 
	 * @param actualizarMisGestiones
	 *            ActualizarMisGestiones
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return TProceedingList
	 */
	public static TProceedingList crearXMLActualizacionMisGestionesX43(ActualizarMisGestiones actualizarMisGestiones,
			Procedure procedureCatalog) throws Exception {
		TProceedingList tProceedingList = new TProceedingList();
		List<TProceeding> listTProceeding = tProceedingList.getProceeding();

		TProceeding tProceeding = new TProceeding();

		tProceeding.setProceedingID(actualizarMisGestiones.getProceedingsID());

		if (actualizarMisGestiones.getAportacionTimestamp() != null) {
			tProceeding.setCreationDate(com.ejie.y41b.utils.Y41bUtils.formatearDateToString(
					actualizarMisGestiones.getAportacionTimestamp().getTime(),
					Y41bConstantes.FORMATO_FECHAHORA_TOOLKIT));
		} else {
			tProceeding.setCreationDate(com.ejie.y41b.utils.Y41bUtils.fncFechaActualLargaAlternativa());
		}

		TTextI18N value = new TTextI18N();
		List<TStringI18N> listTStringI18N = value.getText();
		TStringI18N tStringI18N = new TStringI18N();
		tStringI18N.setLocale(TLanguage.ES);
		tStringI18N.setValue(actualizarMisGestiones.getDescripcionTramiteCas());
		listTStringI18N.add(tStringI18N);

		tStringI18N = new TStringI18N();
		tStringI18N.setLocale(TLanguage.EU);
		tStringI18N.setValue(actualizarMisGestiones.getDescripcionTramiteEus());
		listTStringI18N.add(tStringI18N);

		tProceeding.setDescription(value);

		listTProceeding.add(tProceeding);

		tProceeding.setManagingUnitID(procedureCatalog.getManagingUnitId());

		com.ejie.r02K.xml.DescriptionDocument descriptionDocument = com.ejie.r02K.xml.DescriptionDocument.Factory.parse(
				procedureCatalog.getManagingUnitName().xmlText().replaceAll("com/ejie/cp/xml", "com/ejie/r02k/xml"));

		value = new TTextI18N();
		listTStringI18N = value.getText();
		tStringI18N = new TStringI18N();
		tStringI18N.setLocale(TLanguage.ES);
		tStringI18N.setValue(descriptionDocument.getDescription().getLanguageArray(1).getStringValue().toString());
		listTStringI18N.add(tStringI18N);

		tStringI18N = new TStringI18N();
		tStringI18N.setLocale(TLanguage.EU);
		tStringI18N.setValue(descriptionDocument.getDescription().getLanguageArray(0).getStringValue().toString());
		listTStringI18N.add(tStringI18N);
		tProceeding.setManagingUnitName(value);

		tProceeding.setParticipantID(actualizarMisGestiones.getSolicitante().getDni().trim());

		TDocument tDocument = null;
		if (null != actualizarMisGestiones.getDocumentos() && actualizarMisGestiones.getDocumentos().size() > 0) {
			TAttachment tAttachment = new TAttachment();

			tAttachment.setAttachmentType(TAttachmentType.APORTACION);
			// tAttachment.setSubmissionType();

			TPersonIDName tPersonIDName = new TPersonIDName();
			tPersonIDName.setID(actualizarMisGestiones.getSolicitante().getDni().trim());
			tPersonIDName.setName(actualizarMisGestiones.getSolicitante().getNombre());
			// tPersonIDName.setFirstLastName();
			// tPersonIDName.setSecondLastName();

			tAttachment.setSenderID(tPersonIDName);

			tAttachment.setInputDate(com.ejie.y41b.utils.Y41bUtils.formatearDateToString(
					actualizarMisGestiones.getAportacionTimestamp().getTime(),
					Y41bConstantes.FORMATO_FECHAHORA_TOOLKIT));

			TDocumentList tDocumentList = new TDocumentList();
			List<TDocument> listTDocument = tDocumentList.getDocument();

			for (Documento documento : actualizarMisGestiones.getDocumentos()) {

				tDocument = new TDocument();

				tDocument.setOriginType(TDocOriginType.DE_CIUDADANO);

				value = new TTextI18N();
				listTStringI18N = value.getText();
				tStringI18N = new TStringI18N();
				tStringI18N.setLocale(TLanguage.ES);

				if (Y41bUtils.isFilled(documento.getDescripcion())) {
					tStringI18N.setValue(documento.getDescripcion());// DESCRIPCION
				} else {
					tStringI18N.setValue(documento.getNombre());// DESCRIPCION
				}
				listTStringI18N.add(tStringI18N);

				tStringI18N = new TStringI18N();
				tStringI18N.setLocale(TLanguage.EU);
				if (Y41bUtils.isFilled(documento.getDescripcion())) {
					tStringI18N.setValue(documento.getDescripcion());// DESCRIPCION
				} else {
					tStringI18N.setValue(documento.getNombre());// DESCRIPCION
				}
				listTStringI18N.add(tStringI18N);

				tDocument.setDocumentRoleName(value);

				if (StringUtils.isNotBlank(documento.getOidDokusi())) {
					TElectronic tElectronic = new TElectronic();
					tElectronic.setName(Y41bUtils
							.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(documento.getNombre())));// NOMBRE
					tElectronic.setDokusiID(documento.getOidDokusi());
					tDocument.setElectronic(tElectronic);
				} else {
					TPaper tPaper = new TPaper();
					tPaper.setName(Y41bUtils
							.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(documento.getNombre())));// NOMBRE
					tDocument.setPaper(tPaper);
				}

				listTDocument.add(tDocument);
			}

			tAttachment.setDocumentList(tDocumentList);

			tProceeding.setAttachment(tAttachment);
		}

		return tProceedingList;
	}

	/**
	 * Crear xml para la apertura de un expediente telemático
	 * 
	 * @param actualizarMisGestiones
	 *            ActualizarMisGestiones
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLActualizacionMisGestionesComunicacion(ActualizarMisGestiones actualizarMisGestiones,
			Procedure procedureCatalog) throws Exception {

		SaveorupdateProceedingsNTDocument saveorupdateProceedingsNTDocument = SaveorupdateProceedingsNTDocument.Factory
				.newInstance();
		SaveorupdateProceedingsNTType saveorupdateProceedingsNTType = saveorupdateProceedingsNTDocument
				.addNewSaveorupdateProceedingsNT();

		CompleteFolderNumberNTType completeFolderNumberNTType = saveorupdateProceedingsNTType
				.addNewCompleteFolderNumber();
		completeFolderNumberNTType.setProcedureId(actualizarMisGestiones.getProcedure().getIdProcedimiento());

		completeFolderNumberNTType.setExercise(actualizarMisGestiones.getEjercicio());
		completeFolderNumberNTType.setFolderNumber(actualizarMisGestiones.getNumeroExpediente());

		saveorupdateProceedingsNTType.setUpdateTimestamp(Calendar.getInstance());

		if (Y41bUtils.isFilled(actualizarMisGestiones.getIdParticipacion())) {
			saveorupdateProceedingsNTType.setParticipantId(actualizarMisGestiones.getIdParticipacion().trim());
		} else {
			saveorupdateProceedingsNTType.setParticipantId(actualizarMisGestiones.getSolicitante().getDni().trim());
		}

		ProceedingsType proceedingsType = saveorupdateProceedingsNTType.addNewProceedings();

		proceedingsType.setProceedingsId(actualizarMisGestiones.getProceedingsID());

		proceedingsType.setTimestamp(Calendar.getInstance());
		DescriptionType descriptionTypeSaveOrUp = proceedingsType.addNewDescription();
		Language desLanguage = descriptionTypeSaveOrUp.addNewLanguage();
		desLanguage.setLocale(Y41bConstantes.CASTELLANO);
		desLanguage.setStringValue(Y41bConstantes.LITERAL_COMUNICACION_ES);
		Language desLanguageEu = descriptionTypeSaveOrUp.addNewLanguage();
		desLanguageEu.setLocale(Y41bConstantes.EUSKERA);
		desLanguageEu.setStringValue(Y41bConstantes.LITERAL_COMUNICACION_EU);
		proceedingsType.setDescription(descriptionTypeSaveOrUp);

		proceedingsType.setManagingUnitId(procedureCatalog.getManagingUnitId());
		DescriptionType descManaging = proceedingsType.addNewManagingUnitName();
		descManaging.set(procedureCatalog.getManagingUnitName());

		NotificationProceedingsType notificationProceedingsType = proceedingsType.addNewNotificationProceedings();
		NotificationType notificationType = notificationProceedingsType.addNewNotification();
		notificationType.setNotifiedActId(Y41bConstantes.NOTIFICACION_COMUNICACION);
		DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();

		Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
		desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
		desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_COMUNICACION_ES);
		Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
		desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
		desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_COMUNICACION_EU);

		if (actualizarMisGestiones.getTipoNotificacion() != null
				&& actualizarMisGestiones.getTipoNotificacion().equals(Y41bConstantes.ELECTRONICO)) {
			NotificationType.Electronic electronic = notificationType.addNewElectronic();
			electronic.setPublicationTimestamp(Calendar.getInstance());
			electronic.setOidnotification(actualizarMisGestiones.getIdnotificacionplatea());
		} else {
			NotificationType.Postal postal = notificationType.addNewPostal();
			postal.setPublicationTimestamp(Calendar.getInstance());
		}

		proceedingsType = Y41bPlateaHelper.addNewFromAdministration(proceedingsType, actualizarMisGestiones);

		return Y41bXMLUtils.quitarNameSpacesString(saveorupdateProceedingsNTDocument);
	}

	/**
	 * Crear xml para la apertura de un expediente telemático
	 * 
	 * @param actualizarMisGestiones
	 *            ActualizarMisGestiones
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLActualizacionMisGestionesNotificacion(ActualizarMisGestiones actualizarMisGestiones,
			Procedure procedureCatalog) throws Exception {

		SaveorupdateProceedingsNTDocument saveorupdateProceedingsNTDocument = SaveorupdateProceedingsNTDocument.Factory
				.newInstance();
		SaveorupdateProceedingsNTType saveorupdateProceedingsNTType = saveorupdateProceedingsNTDocument
				.addNewSaveorupdateProceedingsNT();

		CompleteFolderNumberNTType completeFolderNumberNTType = saveorupdateProceedingsNTType
				.addNewCompleteFolderNumber();
		completeFolderNumberNTType.setProcedureId(actualizarMisGestiones.getProcedure().getIdProcedimiento());

		completeFolderNumberNTType.setExercise(actualizarMisGestiones.getEjercicio());
		completeFolderNumberNTType.setFolderNumber(actualizarMisGestiones.getNumeroExpediente());

		saveorupdateProceedingsNTType.setUpdateTimestamp(Calendar.getInstance());

		if (Y41bUtils.isFilled(actualizarMisGestiones.getIdParticipacion())) {
			saveorupdateProceedingsNTType.setParticipantId(actualizarMisGestiones.getIdParticipacion().trim());
		} else {
			saveorupdateProceedingsNTType.setParticipantId(actualizarMisGestiones.getSolicitante().getDni().trim());
		}

		ProceedingsType proceedingsType = saveorupdateProceedingsNTType.addNewProceedings();

		proceedingsType.setProceedingsId(actualizarMisGestiones.getProceedingsID());

		proceedingsType.setTimestamp(Calendar.getInstance());
		DescriptionType descriptionTypeSaveOrUp = proceedingsType.addNewDescription();
		Language desLanguage = descriptionTypeSaveOrUp.addNewLanguage();
		desLanguage.setLocale(Y41bConstantes.CASTELLANO);
		desLanguage.setStringValue(Y41bConstantes.LITERAL_NOTIFICACION_ES);
		Language desLanguageEu = descriptionTypeSaveOrUp.addNewLanguage();
		desLanguageEu.setLocale(Y41bConstantes.EUSKERA);
		desLanguageEu.setStringValue(Y41bConstantes.LITERAL_NOTIFICACION_EU);
		proceedingsType.setDescription(descriptionTypeSaveOrUp);

		proceedingsType.setManagingUnitId(procedureCatalog.getManagingUnitId());
		DescriptionType descManaging = proceedingsType.addNewManagingUnitName();
		descManaging.set(procedureCatalog.getManagingUnitName());

		Proceedings proceedings = new Proceedings();
		proceedings.setNotifiedActId(actualizarMisGestiones.getIdTiponotificacionplatea());
		proceedings.setNotifiedResult(actualizarMisGestiones.getSituacionNotificacionAcuseRecibo());
		proceedings.setTipoNotificacion(actualizarMisGestiones.getTipoNotificacion());
		proceedings.setNotifiedPublicationtimestamp(actualizarMisGestiones.getNotificacionPublicationTimestamp());

		if (actualizarMisGestiones.getProcedure().getIdProcedimiento() != null && actualizarMisGestiones.getProcedure()
				.getIdProcedimiento().equals(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES)) {
			if (proceedings.getNotifiedResult() != null
					&& !proceedings.getNotifiedResult().equals(Y41bConstantes.SITUACION_ACUSERECIBO_NOENTREGADO)) {
				proceedings.setNotifiedDeliverytimestamp(actualizarMisGestiones.getNotificacionDeliveryTimestamp());
			}
		} else {
			if (proceedings.getNotifiedResult() != null && (proceedings.getNotifiedResult()
					.equals(Y41bConstantes.SITUACION_ACUSERECIBO_ACEPTADO)
					|| proceedings.getNotifiedResult().equals(Y41bConstantes.SITUACION_ACUSERECIBO_RECHAZADO))) {
				proceedings.setNotifiedDeliverytimestamp(actualizarMisGestiones.getNotificacionDeliveryTimestamp());
			}
		}

		proceedings.setOidnotification(actualizarMisGestiones.getIdnotificacionplatea());

		proceedingsType = Y41bPlateaHelper.generarProceedingsNotificacion(proceedingsType, proceedings,
				actualizarMisGestiones.getProcedure().getIdProcedimiento());

		proceedingsType = Y41bPlateaHelper.addNewFromAdministration(proceedingsType, actualizarMisGestiones);

		return Y41bXMLUtils.quitarNameSpacesString(saveorupdateProceedingsNTDocument);
	}

	/**
	 * Crear xml para la apertura de un expediente telemático
	 * 
	 * @param actualizarMisGestiones
	 *            ActualizarMisGestiones
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLActualizacionMisGestionesDecision(ActualizarMisGestiones actualizarMisGestiones,
			Procedure procedureCatalog) throws Exception {

		SaveorupdateProceedingsNTDocument saveorupdateProceedingsNTDocument = SaveorupdateProceedingsNTDocument.Factory
				.newInstance();
		SaveorupdateProceedingsNTType saveorupdateProceedingsNTType = saveorupdateProceedingsNTDocument
				.addNewSaveorupdateProceedingsNT();

		CompleteFolderNumberNTType completeFolderNumberNTType = saveorupdateProceedingsNTType
				.addNewCompleteFolderNumber();
		completeFolderNumberNTType.setProcedureId(actualizarMisGestiones.getProcedure().getIdProcedimiento());

		completeFolderNumberNTType.setExercise(actualizarMisGestiones.getEjercicio());
		completeFolderNumberNTType.setFolderNumber(actualizarMisGestiones.getNumeroExpediente());

		saveorupdateProceedingsNTType.setUpdateTimestamp(Calendar.getInstance());

		if (Y41bUtils.isFilled(actualizarMisGestiones.getIdParticipacion())) {
			saveorupdateProceedingsNTType.setParticipantId(actualizarMisGestiones.getIdParticipacion().trim());
		} else {
			saveorupdateProceedingsNTType.setParticipantId(actualizarMisGestiones.getSolicitante().getDni().trim());
		}

		ProceedingsType proceedingsType = saveorupdateProceedingsNTType.addNewProceedings();

		proceedingsType.setProceedingsId(actualizarMisGestiones.getProceedingsID());

		proceedingsType.setTimestamp(Calendar.getInstance());
		DescriptionType descriptionTypeSaveOrUp = proceedingsType.addNewDescription();
		Language desLanguage = descriptionTypeSaveOrUp.addNewLanguage();
		desLanguage.setLocale(Y41bConstantes.CASTELLANO);
		desLanguage.setStringValue(actualizarMisGestiones.getDescripcionTramiteCas());
		Language desLanguageEu = descriptionTypeSaveOrUp.addNewLanguage();
		desLanguageEu.setLocale(Y41bConstantes.EUSKERA);
		desLanguageEu.setStringValue(actualizarMisGestiones.getDescripcionTramiteEus());
		proceedingsType.setDescription(descriptionTypeSaveOrUp);

		proceedingsType.setManagingUnitId(procedureCatalog.getManagingUnitId());
		DescriptionType descManaging = proceedingsType.addNewManagingUnitName();
		descManaging.set(procedureCatalog.getManagingUnitName());

		DecisionType decisionType = proceedingsType.addNewDecision();
		decisionType.setDecisionTimestamp(actualizarMisGestiones.getDecisionTimestamp());
		DescriptionType descriptionTypeOrganDecisionDescription = decisionType.addNewOrganDecisionDescription();
		Language desLanguageOrganDecision = descriptionTypeOrganDecisionDescription.addNewLanguage();
		desLanguageOrganDecision.setLocale(Y41bConstantes.CASTELLANO);
		desLanguageOrganDecision.setStringValue(Y41bConstantes.LITERAL_KONTSUMOBIDE_ES);
		Language desLanguageOrganDecisionEu = descriptionTypeOrganDecisionDescription.addNewLanguage();
		desLanguageOrganDecisionEu.setLocale(Y41bConstantes.EUSKERA);
		desLanguageOrganDecisionEu.setStringValue(Y41bConstantes.LITERAL_KONTSUMOBIDE_EU);

		DescriptionType descriptionTypeDecisionObject = decisionType.addNewDecisionObject();
		Language desLanguageDecision = descriptionTypeDecisionObject.addNewLanguage();
		desLanguageDecision.setLocale(Y41bConstantes.CASTELLANO);
		desLanguageDecision.setStringValue(actualizarMisGestiones.getDescripcionTramiteCas());
		Language desLanguageDecisionEu = descriptionTypeDecisionObject.addNewLanguage();
		desLanguageDecisionEu.setLocale(Y41bConstantes.EUSKERA);
		desLanguageDecisionEu.setStringValue(actualizarMisGestiones.getDescripcionTramiteEus());

		DescriptionType descriptionTypeResult = decisionType.addNewResult();
		Language desLanguageResult = descriptionTypeResult.addNewLanguage();
		desLanguageResult.setLocale(Y41bConstantes.CASTELLANO);
		desLanguageResult.setStringValue(actualizarMisGestiones.getDecisionCas());
		Language desLanguageResultEu = descriptionTypeDecisionObject.addNewLanguage();
		desLanguageResultEu.setLocale(Y41bConstantes.EUSKERA);
		desLanguageResultEu.setStringValue(actualizarMisGestiones.getDecisionEus());

		return Y41bXMLUtils.quitarNameSpacesString(saveorupdateProceedingsNTDocument);
	}

	/**
	 * Crear xml para la eliminacion de mis gestiones
	 * 
	 * @param actualizarMisGestiones
	 *            ActualizarMisGestiones
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLEliminarMisGestiones(ActualizarMisGestiones actualizarMisGestiones,
			Procedure procedureCatalog) throws Exception {

		DeleteProceedingsNTDocument deleteProceedingsNTDocument = DeleteProceedingsNTDocument.Factory.newInstance();
		DeleteProceedingsNTType deleteProceedingsNTType = deleteProceedingsNTDocument.addNewDeleteProceedingsNT();

		CompleteFolderNumberNTType completeFolderNumberNTType = deleteProceedingsNTType.addNewCompleteFolderNumber();
		completeFolderNumberNTType.setProcedureId(actualizarMisGestiones.getProcedure().getIdProcedimiento());

		completeFolderNumberNTType.setExercise(actualizarMisGestiones.getEjercicio());
		completeFolderNumberNTType.setFolderNumber(actualizarMisGestiones.getNumeroExpediente());

		if (Y41bUtils.isFilled(actualizarMisGestiones.getIdParticipacion())) {
			deleteProceedingsNTType.setParticipantId(actualizarMisGestiones.getIdParticipacion().trim());
		} else {
			deleteProceedingsNTType.setParticipantId(actualizarMisGestiones.getSolicitante().getDni().trim());
		}

		deleteProceedingsNTType.setProceedingsId(actualizarMisGestiones.getProceedingsID());

		return Y41bXMLUtils.quitarNameSpacesString(deleteProceedingsNTDocument);
	}

	/**
	 * Crear xml para la apertura de un expediente telemático
	 * 
	 * @param actualizarExpediente
	 *            ActualizarExpediente
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLActualizacionExpediente(ActualizarExpediente actualizarExpediente,
			Procedure procedureCatalog) throws Exception {

		ExpedientNTDocument expedientNTDocument = ExpedientNTDocument.Factory.newInstance();
		ExpedientNTType expedientNTType = expedientNTDocument.addNewExpedientNT();
		expedientNTType.setFamily(procedureCatalog.getFamilyId());
		expedientNTType.setProcedureId(actualizarExpediente.getProcedure().getIdProcedimiento());
		expedientNTType.setExercise(actualizarExpediente.getEjercicio());
		expedientNTType.setFolderNumber(actualizarExpediente.getNumeroExpediente());
		DescriptionType description = expedientNTType.addNewDescription();
		description.set(procedureCatalog.getProcedureName());

		expedientNTType.setEntity(procedureCatalog.getEntityCode());
		expedientNTType.setManagingUnitId(procedureCatalog.getManagingUnitId());
		DescriptionType descManaging = expedientNTType.addNewManagingUnitName();
		descManaging.set(procedureCatalog.getManagingUnitName());
		expedientNTType.setDeliveryKey(procedureCatalog.getManagingUnitInboxId());
		expedientNTType.setProcessingRoleId(procedureCatalog.getManagingUnitInboxId());
		expedientNTType.setProcessingRoleName(procedureCatalog.getManagingUnitInboxName());
		expedientNTType.setStatus(BigInteger.ONE);

		expedientNTType.setOpeningTimestamp(actualizarExpediente.getStartTimestamp());
		expedientNTType.setStartTimestamp(actualizarExpediente.getStartTimestamp());
		expedientNTType.setUpdateTimestamp(Calendar.getInstance());

		ParticipantType participant = expedientNTType.addNewParticipant();

		if (Y41bUtils.isFilled(actualizarExpediente.getIdParticipacion())) {
			participant.setParticipantId(actualizarExpediente.getIdParticipacion().trim());
		} else {
			participant.setParticipantId(actualizarExpediente.getSolicitante().getDni().trim());
		}

		participant
				.setRole(com.ejie.r02R.xml.ParticipantNoProceedingsType.Role.Enum.forString(Y41bConstantes.APPLICANT));

		if (StringUtils.isEmpty(actualizarExpediente.getIdiomaNotificacion())) {
			participant.setLanguage(
					com.ejie.r02R.xml.ParticipantNoProceedingsType.Language.Enum.forString(Y41bConstantes.CASTELLANO));
		} else {
			participant.setLanguage(com.ejie.r02R.xml.ParticipantNoProceedingsType.Language.Enum
					.forString(actualizarExpediente.getIdiomaNotificacion().toLowerCase()));
		}

		NoticeChanelType noticeChanelType = participant.addNewNoticeChanel();
		if (actualizarExpediente.getSolicitante().getTelefono() != null) {
			// noticeChanelType.addPhone(actualizarExpediente.getSolicitante().getTelefono());
			noticeChanelType.addSms(actualizarExpediente.getSolicitante().getTelefono());
		}
		if (actualizarExpediente.getSolicitante().getMail() != null) {
			noticeChanelType.addEmail(actualizarExpediente.getSolicitante().getMail());
		}

		NotificationChanelType notificationChanelType = participant.addNewNotificationChanel();
		if (StringUtils.isBlank(actualizarExpediente.getTipoNotificacion())
				|| actualizarExpediente.getTipoNotificacion().equals(Y41bConstantes.ELECTRONICO)) {
			notificationChanelType.setElectronic("");
		} else {
			Postal postal = notificationChanelType.addNewPostal();
			postal.setStreet(actualizarExpediente.getNotificacionPostal().getCalle());
			DescriptionType descriptionProvincia = postal.addNewProvince();
			Language languageProv = descriptionProvincia.addNewLanguage();
			languageProv.setLocale(Y41bConstantes.EUSKERA);
			languageProv.setStringValue(actualizarExpediente.getNotificacionPostal().getProvincia());
			languageProv = descriptionProvincia.addNewLanguage();
			languageProv.setLocale(Y41bConstantes.CASTELLANO);
			languageProv.setStringValue(actualizarExpediente.getNotificacionPostal().getProvincia());

			DescriptionType descriptionTown = postal.addNewTown();
			Language languageTown = descriptionTown.addNewLanguage();
			languageTown.setLocale(Y41bConstantes.EUSKERA);
			languageTown.setStringValue(actualizarExpediente.getNotificacionPostal().getMunicipio());
			languageTown = descriptionTown.addNewLanguage();
			languageTown.setLocale(Y41bConstantes.CASTELLANO);
			languageTown.setStringValue(actualizarExpediente.getNotificacionPostal().getMunicipio());

			postal.setZipcode(actualizarExpediente.getNotificacionPostal().getCodigoPostal());
		}

		ParticipantsType participantsType = participant.addNewParticipants();

		PersonType holder = participantsType.addNewHolder();
		holder.setType(BigInteger.ONE);
		holder.setId(actualizarExpediente.getSolicitante().getDni().trim());
		holder.setNombre(StringEscapeUtils.escapeHtml(actualizarExpediente.getSolicitante().getNombre()));

		if (Y41bUtils.isFilled(actualizarExpediente.getSolicitante().getApellido1())) {
			holder.setApellido1(StringEscapeUtils.escapeHtml(actualizarExpediente.getSolicitante().getApellido1()));
		} else {
			holder.setApellido1(".");
		}

		if (actualizarExpediente.getRepresentante() != null
				&& StringUtils.isNotBlank(actualizarExpediente.getRepresentante().getDni())) {
			PersonType representante = participantsType.addNewRepresentative();
			representante.setId(actualizarExpediente.getRepresentante().getDni().trim());
			representante.setNombre(StringEscapeUtils.escapeHtml(actualizarExpediente.getRepresentante().getNombre()));

			if (Y41bUtils.isFilled(actualizarExpediente.getRepresentante().getApellido1())) {
				representante.setApellido1(
						StringEscapeUtils.escapeHtml(actualizarExpediente.getRepresentante().getApellido1()));
			} else {
				representante.setApellido1(".");
			}
			representante.setType(BigInteger.ONE);
		}

		// tramites del solicitante
		if (null != actualizarExpediente.getProceedings() && actualizarExpediente.getProceedings().size() > 0) {

			for (Proceedings proceedings : actualizarExpediente.getProceedings()) {

				ProceedingsType proceedingsType;
				proceedingsType = participant.addNewProceedings();

				proceedingsType.setProceedingsId(proceedings.getProceedingsID());
				proceedingsType.setTimestamp(proceedings.getTimestamp());
				DescriptionType proccedingsDesc2 = proceedingsType.addNewDescription();
				Language procedingLanguage2 = proccedingsDesc2.addNewLanguage();
				procedingLanguage2.setLocale(Y41bConstantes.CASTELLANO);
				procedingLanguage2.setStringValue(proceedings.getProceedingsDescriptionCast());
				procedingLanguage2 = proccedingsDesc2.addNewLanguage();
				procedingLanguage2.setLocale(Y41bConstantes.EUSKERA);
				procedingLanguage2.setStringValue(proceedings.getProceedingsDescriptionEus());
				proceedingsType.setManagingUnitId(procedureCatalog.getManagingUnitId());

				DescriptionType descManagingProceeding2 = proceedingsType.addNewManagingUnitName();
				descManagingProceeding2.set(procedureCatalog.getManagingUnitName());

				// Decision
				if (proceedings.getDecisiontimestamp() != null) {
					proceedingsType = Y41bPlateaHelper.generarProceedingsDecision(proceedingsType, proceedings);
				}

				// Comunicacin
				if (null != proceedings.getNotifiedActId()
						&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_COMUNICACION)) {
					proceedingsType = Y41bPlateaHelper.generarProceedingsComunicacion(proceedingsType, proceedings);
					// Notificacion
				} else if (null != proceedings.getNotifiedActId()) {
					proceedingsType = Y41bPlateaHelper.generarProceedingsNotificacion(proceedingsType, proceedings,
							actualizarExpediente.getProcedure().getIdProcedimiento());
				}

				if (null != proceedings.getDocumentos() && proceedings.getDocumentos().size() > 0) {
					proceedingsType = Y41bPlateaHelper.addFromCitizenActualizarExpediente(proceedingsType,
							proceedings.getDocumentos());
				}
				if (null != proceedings.getDocumentosNotificacionComunicacion()
						&& proceedings.getDocumentosNotificacionComunicacion().size() > 0) {
					proceedingsType = Y41bPlateaHelper.addFromAdministrationActualizarExpediente(proceedingsType,
							proceedings.getDocumentosNotificacionComunicacion());
				}
				if (Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES
						.equals(actualizarExpediente.getProcedure().getIdProcedimiento())) {

					AdminInitiationType adminInitiationType = expedientNTType.getParticipantArray(0)
							.getProceedingsArray(0).addNewAdminInitiationProceedings();
					adminInitiationType.setInitiationTypeId(
							BigInteger.valueOf(Y41bConstantes.INITIATIONTYPE_OFICIO_INICIATIVA_PROPIA));
				}
				// Esto solo para arbitraje
				if (Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE
						.equals(actualizarExpediente.getProcedure().getIdProcedimiento())) {
					AttachmentType attachmentType = expedientNTType.getParticipantArray(0).getProceedingsArray(0)
							.addNewAttachment();
					attachmentType.setTypeattchment(BigInteger.ONE);
					attachmentType.setSenderId(actualizarExpediente.getSolicitante().getDni());
					attachmentType.setInputTimestamp(proceedings.getTimestamp());
					attachmentType.setSenderName(actualizarExpediente.getSender().getNombre());
				}
				Sleep w = new Sleep();
				w.doSleep(Y41bConstantes.NUM_1000);
			}
		}

		// ahora hay que aadir la participacin del reclamado en caso de
		// existir.

		if (actualizarExpediente.getInteresado() != null) {

			ParticipantType participantInteresado = expedientNTType.addNewParticipant();

			if (Y41bUtils.isFilled(actualizarExpediente.getIdParticipacionInteresado())) {
				participantInteresado.setParticipantId(actualizarExpediente.getIdParticipacionInteresado().trim());
			} else {
				participantInteresado.setParticipantId(actualizarExpediente.getInteresado().getDni().trim());
			}

			participantInteresado.setRole(
					com.ejie.r02R.xml.ParticipantNoProceedingsType.Role.Enum.forString(Y41bConstantes.AFECTED));

			if (StringUtils.isEmpty(actualizarExpediente.getIdiomaNotificacionInteresado())) {
				participantInteresado.setLanguage(com.ejie.r02R.xml.ParticipantNoProceedingsType.Language.Enum
						.forString(Y41bConstantes.CASTELLANO));
			} else {
				participantInteresado.setLanguage(com.ejie.r02R.xml.ParticipantNoProceedingsType.Language.Enum
						.forString(actualizarExpediente.getIdiomaNotificacionInteresado().toLowerCase()));
			}

			noticeChanelType = participantInteresado.addNewNoticeChanel();
			if (actualizarExpediente.getInteresado().getTelefono() != null) {
				// noticeChanelType.addPhone(actualizarExpediente.getInteresado().getTelefono());
				noticeChanelType.addSms(actualizarExpediente.getInteresado().getTelefono());
			}
			if (actualizarExpediente.getInteresado().getMail() != null) {
				noticeChanelType.addEmail(actualizarExpediente.getInteresado().getMail());
			}

			notificationChanelType = participantInteresado.addNewNotificationChanel();
			if (StringUtils.isBlank(actualizarExpediente.getTipoNotificacion())
					|| actualizarExpediente.getTipoNotificacion().equals(Y41bConstantes.ELECTRONICO)) {
				notificationChanelType.setElectronic("");
			} else {
				Postal postal = notificationChanelType.addNewPostal();
				postal.setStreet(actualizarExpediente.getNotificacionPostal().getCalle());
				DescriptionType descriptionProvincia = postal.addNewProvince();
				Language languageProv = descriptionProvincia.addNewLanguage();
				languageProv.setLocale(Y41bConstantes.EUSKERA);
				languageProv.setStringValue(actualizarExpediente.getNotificacionPostal().getProvincia());
				languageProv = descriptionProvincia.addNewLanguage();
				languageProv.setLocale(Y41bConstantes.CASTELLANO);
				languageProv.setStringValue(actualizarExpediente.getNotificacionPostal().getProvincia());

				DescriptionType descriptionTown = postal.addNewTown();
				Language languageTown = descriptionTown.addNewLanguage();
				languageTown.setLocale(Y41bConstantes.EUSKERA);
				languageTown.setStringValue(actualizarExpediente.getNotificacionPostal().getMunicipio());
				languageTown = descriptionTown.addNewLanguage();
				languageTown.setLocale(Y41bConstantes.CASTELLANO);
				languageTown.setStringValue(actualizarExpediente.getNotificacionPostal().getMunicipio());

				postal.setZipcode(actualizarExpediente.getNotificacionPostal().getCodigoPostal());
			}

			participantsType = participantInteresado.addNewParticipants();

			holder = participantsType.addNewHolder();
			holder.setType(BigInteger.ONE);
			holder.setId(actualizarExpediente.getInteresado().getDni().trim());
			holder.setNombre(StringEscapeUtils.escapeHtml(actualizarExpediente.getInteresado().getNombre()));

			if (Y41bUtils.isFilled(actualizarExpediente.getInteresado().getApellido1())) {
				holder.setApellido1(StringEscapeUtils.escapeHtml(actualizarExpediente.getInteresado().getApellido1()));
			} else {
				holder.setApellido1(".");
			}

			if (actualizarExpediente.getRepresentanteInteresado() != null
					&& StringUtils.isNotBlank(actualizarExpediente.getRepresentanteInteresado().getDni())) {
				PersonType representante = participantsType.addNewRepresentative();
				representante.setId(actualizarExpediente.getRepresentanteInteresado().getDni().trim());
				representante.setNombre(
						StringEscapeUtils.escapeHtml(actualizarExpediente.getRepresentanteInteresado().getNombre()));

				if (Y41bUtils.isFilled(actualizarExpediente.getRepresentanteInteresado().getApellido1())) {
					representante.setApellido1(StringEscapeUtils
							.escapeHtml(actualizarExpediente.getRepresentanteInteresado().getApellido1()));
				} else {
					representante.setApellido1(".");
				}
				representante.setType(BigInteger.ONE);
			}

			// aadimos los trmites del interesado
			if (null != actualizarExpediente.getProceedingsInteresado()
					&& actualizarExpediente.getProceedingsInteresado().size() > 0) {

				for (Proceedings proceedings : actualizarExpediente.getProceedingsInteresado()) {

					ProceedingsType proceedingsType;
					proceedingsType = participantInteresado.addNewProceedings();
					proceedingsType.setProceedingsId(proceedings.getProceedingsID());
					proceedingsType.setTimestamp(proceedings.getTimestamp());
					DescriptionType proccedingsDesc2 = proceedingsType.addNewDescription();
					Language procedingLanguage2 = proccedingsDesc2.addNewLanguage();
					procedingLanguage2.setLocale(Y41bConstantes.CASTELLANO);
					procedingLanguage2.setStringValue(proceedings.getProceedingsDescriptionCast());
					procedingLanguage2 = proccedingsDesc2.addNewLanguage();
					procedingLanguage2.setLocale(Y41bConstantes.EUSKERA);
					procedingLanguage2.setStringValue(proceedings.getProceedingsDescriptionEus());
					proceedingsType.setManagingUnitId(procedureCatalog.getManagingUnitId());

					DescriptionType descManagingProceeding2 = proceedingsType.addNewManagingUnitName();
					descManagingProceeding2.set(procedureCatalog.getManagingUnitName());

					// Decision
					if (proceedings.getDecisiontimestamp() != null) {
						proceedingsType = Y41bPlateaHelper.generarProceedingsDecision(proceedingsType, proceedings);
					}

					// Comunicacin
					if (null != proceedings.getNotifiedActId()
							&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_COMUNICACION)) {
						proceedingsType = Y41bPlateaHelper.generarProceedingsComunicacion(proceedingsType, proceedings);
						// Notificacion
					} else if (null != proceedings.getNotifiedActId()) {
						proceedingsType = Y41bPlateaHelper.generarProceedingsNotificacion(proceedingsType, proceedings,
								actualizarExpediente.getProcedure().getIdProcedimiento());
					}

					if (null != proceedings.getDocumentos() && proceedings.getDocumentos().size() > 0) {
						proceedingsType = Y41bPlateaHelper.addFromCitizenActualizarExpediente(proceedingsType,
								proceedings.getDocumentos());
					}
					if (null != proceedings.getDocumentosNotificacionComunicacion()
							&& proceedings.getDocumentosNotificacionComunicacion().size() > 0) {
						proceedingsType = Y41bPlateaHelper.addFromAdministrationActualizarExpediente(proceedingsType,
								proceedings.getDocumentosNotificacionComunicacion());
					}
					if (Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES
							.equals(actualizarExpediente.getProcedure().getIdProcedimiento())) {
						AdminInitiationType adminInitiationType = expedientNTType.getParticipantArray(0)
								.getProceedingsArray(0).addNewAdminInitiationProceedings();
						adminInitiationType.setInitiationTypeId(
								BigInteger.valueOf(Y41bConstantes.INITIATIONTYPE_OFICIO_INICIATIVA_PROPIA));

						// AttachmentType attachmentType = expedientNTType
						// .getParticipantArray(0).getProceedingsArray(0)
						// .addNewAttachment();
						// attachmentType.setTypeattchment(BigInteger.ONE);
						// attachmentType.setSenderId(actualizarExpediente
						// .getSender().getDni());
						// attachmentType.setSenderName(actualizarExpediente
						// .getSender().getNombre());
						// attachmentType.setInputTimestamp(proceedings
						// .getTimestamp());
					} else {

						/*
						 * AttachmentType attachmentType; // aqu quitamos el if
						 * de arbitraje e interesado xq ya // lo tenemos fuera
						 * // attachmentType = //
						 * expedientNTType.getParticipantArray(1) //
						 * .getProceedingsArray(0).addNewAttachment();
						 * 
						 * attachmentType = proceedingsType.addNewAttachment();
						 * 
						 * attachmentType.setTypeattchment(BigInteger.ONE);
						 * attachmentType.setSenderId(actualizarExpediente
						 * .getSolicitante().getDni());
						 * attachmentType.setInputTimestamp(proceedings
						 * .getTimestamp());
						 */
					}
					Sleep w = new Sleep();
					w.doSleep(Y41bConstantes.NUM_1000);
				}
			}
		}

		return Y41bXMLUtils.quitarNameSpacesString(expedientNTDocument);
	}

	/**
	 * Genera el proceedings de una decision
	 * 
	 * @param proceedingsType
	 *            ProceedingsType
	 * @param proceedings
	 *            Proceedings
	 * @return ProceedingsType
	 */
	private static ProceedingsType generarProceedingsDecision(ProceedingsType proceedingsType,
			Proceedings proceedings) {
		DecisionType decisionType = proceedingsType.addNewDecision();
		decisionType.setDecisionTimestamp(proceedings.getDecisiontimestamp());
		DescriptionType descriptionTypeOrganDecisionDescription = decisionType.addNewOrganDecisionDescription();
		Language desLanguageOrganDecision = descriptionTypeOrganDecisionDescription.addNewLanguage();
		desLanguageOrganDecision.setLocale(Y41bConstantes.CASTELLANO);
		desLanguageOrganDecision.setStringValue(Y41bConstantes.LITERAL_KONTSUMOBIDE_ES);
		Language desLanguageOrganDecisionEu = descriptionTypeOrganDecisionDescription.addNewLanguage();
		desLanguageOrganDecisionEu.setLocale(Y41bConstantes.EUSKERA);
		desLanguageOrganDecisionEu.setStringValue(Y41bConstantes.LITERAL_KONTSUMOBIDE_EU);

		DescriptionType descriptionTypeDecisionObject = decisionType.addNewDecisionObject();
		Language desLanguageDecision = descriptionTypeDecisionObject.addNewLanguage();
		desLanguageDecision.setLocale(Y41bConstantes.CASTELLANO);
		desLanguageDecision.setStringValue(Y41bConstantes.LITERAL_DECISION_ES);
		Language desLanguageDecisionEu = descriptionTypeDecisionObject.addNewLanguage();
		desLanguageDecisionEu.setLocale(Y41bConstantes.EUSKERA);
		desLanguageDecisionEu.setStringValue(Y41bConstantes.LITERAL_DECISION_EU);

		DescriptionType descriptionTypeResult = decisionType.addNewResult();
		Language desLanguageResult = descriptionTypeResult.addNewLanguage();
		desLanguageResult.setLocale(Y41bConstantes.CASTELLANO);
		desLanguageResult.setStringValue(proceedings.getDecisionCast());
		Language desLanguageResultEu = descriptionTypeDecisionObject.addNewLanguage();
		desLanguageResultEu.setLocale(Y41bConstantes.EUSKERA);
		desLanguageResultEu.setStringValue(proceedings.getDecisionEus());

		return proceedingsType;
	}

	/**
	 * Genera el proceedings de una notificacion
	 * 
	 * @param proceedingsType
	 *            ProceedingsType
	 * @param proceedings
	 *            Proceedings
	 * @param idProcedimiento
	 *            String
	 * @return ProceedingsType
	 */
	private static ProceedingsType generarProceedingsNotificacion(ProceedingsType proceedingsType,
			Proceedings proceedings, String idProcedimiento) {
		NotificationProceedingsType notificationProceedingsType = proceedingsType.addNewNotificationProceedings();
		NotificationType notificationType = notificationProceedingsType.addNewNotification();
		notificationType.setNotifiedActId(proceedings.getNotifiedActId());

		if (idProcedimiento.equals(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES)) {
			if (proceedings.getNotifiedActId() != null
					&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_ALEGACION)) {
				DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();
				Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_ALEGACION_ES);
				Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_ALEGACION_EU);

			} else if (proceedings.getNotifiedActId() != null
					&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_RESOLUCION)) {
				DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();
				Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RESOLUCION_ES);
				Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RESOLUCION_EU);

			} else if (proceedings.getNotifiedActId() != null
					&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_RECURSO)) {
				DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();
				Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RECURSO_ES);
				Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RECURSO_EU);

			} else if (proceedings.getNotifiedActId() != null
					&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_REQUERIMIENTO)) {
				DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();
				Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_REQUERIMIENTO_ES);
				Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_REQUERIMIENTO_EU);

			} else if (proceedings.getNotifiedActId() != null
					&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_SUBSANACION)) {
				DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();
				Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_SUBSANACION_ES);
				Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_SUBSANACION_EU);

			} else if (proceedings.getNotifiedActId() != null
					&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_RESOLUCION_RECURSO)) {
				DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();
				Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RESOLUCIONRECURSOALZADA_ES);
				Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RESOLUCIONRECURSOALZADA_EU);

			} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
					.equals(Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_AMPLIACIONPLAZOALEGACIONES)) {
				DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();
				Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_ACUERDOAMPLIACIONPLAZOALEG_ES);
				Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_ACUERDOAMPLIACIONPLAZOALEG_EU);
			}
		} else if (idProcedimiento.equals(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES)) {

			DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();
			Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
			desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
			Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
			desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);

			if (proceedings.getNotifiedActId() != null
					&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_RESOLUCION)) {
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RESOLUCION_ES);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RESOLUCION_EU);

			} else if (proceedings.getNotifiedActId() != null
					&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_PROPUESTA_RESOLUCION)) {
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_PROPUESTARESOLUCION_ES);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_PROPUESTARESOLUCION_EU);

			} else if (proceedings.getNotifiedActId() != null
					&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_RESOLUCIONRECURSOACEPTDEN)) {
				desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RESOLUCIONRECURSOACEPTDEN_ES);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RESOLUCIONRECURSOACEPTDEN_EU);

			} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
					.equals(Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_RESOLUCION_SOLICITUD_PRUEBA)) {
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RESOLUCIONSOLICITUD_ES);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RESOLUCIONSOLICITUD_EU);

			} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
					.equals(Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_INCOACCION)) {
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_INCOACION_ES);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_INCOACION_EU);

			} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
					.equals(Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_RESOLUCIONCOMPLEMENTARIA)) {
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RESOLUCIONCOMPLEMENTARIA_ES);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RESOLUCIONCOMPLEMENTARIA_EU);

			} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
					.equals(Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_AMPLIACIONPLAZOALEGACIONES)) {
				desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_ACUERDOAMPLIACIONPLAZOALEG_ES);
				desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_ACUERDOAMPLIACIONPLAZOALEG_EU);

			} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
					.equals(Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_REQUERIMIENTO)) {
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_REQUERIMIENTOACREDREPR_ES);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_REQUERIMIENTOACREDREPR_EU);

			} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
					.equals(Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_RESOLUCIONFRACCIONAMIENTO)) {
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RESOLUCIONFRACCIONAMIENTO_ES);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RESOLUCIONFRACCIONAMIENTO_EU);

			} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
					.equals(Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_RESOLUCIONACEPTACIONPRUEBA)) {
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RESOLUCIONRECURSOALZADA_ES);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RESOLUCIONRECURSOALZADA_EU);

			} else if (proceedings.getNotifiedActId() != null
					&& proceedings.getNotifiedActId().equals(Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_OTROS)) {
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_LIQUIDACIONPAGOVOLUNTARIO_ES);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_LIQUIDACIONPAGOVOLUNTARIO_EU);

			}
		} else if (idProcedimiento.equals(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE)) {
			DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();
			obtenerDescripcionActoANotificarARB(proceedings, descriptionTypeNotifiedAct);
		} else if (idProcedimiento.equals(Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA)
				|| idProcedimiento.equals(Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA)
				|| idProcedimiento.equals(Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF)) {
			DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();
			Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
			desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
			Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
			desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
			if (proceedings.getNotifiedActId() != null
					&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_RESOLUCION)) {
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RESOLUCION_ES);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RESOLUCION_EU);

			}
		} else if (idProcedimiento.equals(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES)) {
			if (proceedings.getNotifiedActId() != null
					&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_ALEGACION)) {
				DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();
				Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_ALEGACION_ES);
				Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_ALEGACION_EU);

			} else if (proceedings.getNotifiedActId() != null
					&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_RESOLUCION)) {
				DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();
				Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RESOLUCION_ES);
				Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RESOLUCION_EU);

			} else if (proceedings.getNotifiedActId() != null
					&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_RECURSO)) {
				DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();
				Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RECURSO_ES);
				Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RECURSO_EU);

			} else if (proceedings.getNotifiedActId() != null
					&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_REQUERIMIENTO)) {
				DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();
				Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_REQUERIMIENTO_ES);
				Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_REQUERIMIENTO_EU);

			} else if (proceedings.getNotifiedActId() != null
					&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_SUBSANACION)) {
				DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();
				Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_SUBSANACION_ES);
				Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_SUBSANACION_EU);

			} else if (proceedings.getNotifiedActId() != null
					&& proceedings.getNotifiedActId().equals(Y41bConstantes.NOTIFICACION_RESOLUCION_RECURSO)) {
				DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();
				Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
				desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RESOLUCIONRECURSOALZADA_ES);
				Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
				desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
				desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RESOLUCIONRECURSOALZADA_EU);

			}
		}

		String resultadoAcuseEs = "";
		String resultadoAcuseEu = "";

		if (proceedings.getNotifiedResult() != null
				&& proceedings.getNotifiedResult().equals(Y41bConstantes.SITUACION_ACUSERECIBO_ACEPTADO)) {
			resultadoAcuseEs = Y41bConstantes.LITERAL_SITUACION_ACUSERECIBO_ACEPTADO_ES;
			resultadoAcuseEu = Y41bConstantes.LITERAL_SITUACION_ACUSERECIBO_ACEPTADO_EU;
		} else if (proceedings.getNotifiedResult() != null
				&& proceedings.getNotifiedResult().equals(Y41bConstantes.SITUACION_ACUSERECIBO_RECHAZADO)) {
			resultadoAcuseEs = Y41bConstantes.LITERAL_SITUACION_ACUSERECIBO_RECHAZADO_ES;
			resultadoAcuseEu = Y41bConstantes.LITERAL_SITUACION_ACUSERECIBO_RECHAZADO_EU;
		} else if (proceedings.getNotifiedResult() != null
				&& proceedings.getNotifiedResult().equals(Y41bConstantes.SITUACION_ACUSERECIBO_NOENTREGADO)) {
			resultadoAcuseEs = Y41bConstantes.LITERAL_SITUACION_ACUSERECIBO_NOENTREGADO_ES;
			resultadoAcuseEu = Y41bConstantes.LITERAL_SITUACION_ACUSERECIBO_NOENTREGADO_EU;
		} else {
			if (idProcedimiento.equals(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES)
					|| idProcedimiento.equals(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE)) {
				String fecha = proceedings.getNotifiedResult();
				String fechaES = fecha.split("@")[0];
				String fechaEU = fecha.split("@")[1];
				resultadoAcuseEs = Y41bConstantes.LITERAL_ACUSENOENTREGADOBOE_ES.concat(" (").concat(fechaES)
						.concat(")");
				resultadoAcuseEu = Y41bConstantes.LITERAL_ACUSENOENTREGADOBOE_EU.concat(" (").concat(fechaEU)
						.concat(")");

			}
		}

		if (proceedings.getTipoNotificacion() != null
				&& proceedings.getTipoNotificacion().equals(Y41bConstantes.ELECTRONICO)) {
			NotificationType.Electronic electronic = notificationType.addNewElectronic();
			electronic.setPublicationTimestamp(proceedings.getNotifiedPublicationtimestamp());
			electronic.setDeliveryTimestamp(proceedings.getNotifiedDeliverytimestamp());
			electronic.setOidnotification(proceedings.getOidnotification());
			DescriptionType descriptionTypeResult = electronic.addNewResult();
			Language desLanguageResult = descriptionTypeResult.addNewLanguage();
			desLanguageResult.setLocale(Y41bConstantes.CASTELLANO);
			desLanguageResult.setStringValue(resultadoAcuseEs);
			Language desLanguageResultEu = descriptionTypeResult.addNewLanguage();
			desLanguageResultEu.setLocale(Y41bConstantes.EUSKERA);
			desLanguageResultEu.setStringValue(resultadoAcuseEu);

		} else {
			NotificationType.Postal postal = notificationType.addNewPostal();
			postal.setPublicationTimestamp(proceedings.getNotifiedPublicationtimestamp());
			postal.setDeliveryTimestamp(proceedings.getNotifiedDeliverytimestamp());
			DescriptionType descriptionTypeResult = postal.addNewResult();
			Language desLanguageResult = descriptionTypeResult.addNewLanguage();
			desLanguageResult.setLocale(Y41bConstantes.CASTELLANO);
			desLanguageResult.setStringValue(resultadoAcuseEs);
			Language desLanguageResultEu = descriptionTypeResult.addNewLanguage();
			desLanguageResultEu.setLocale(Y41bConstantes.EUSKERA);
			desLanguageResultEu.setStringValue(resultadoAcuseEu);
		}

		return proceedingsType;
	}

	private static void obtenerDescripcionActoANotificarARB(Proceedings proceedings,
			DescriptionType descriptionTypeNotifiedAct) {
		Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
		desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
		Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
		desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
		if (proceedings.getNotifiedActId() != null
				&& proceedings.getNotifiedActId().equals(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_SUBSANACION)) {
			desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_SUBSANACION_ES);
			desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_SUBSANACION_EU);

		} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
				.equals(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_RECEPCION_ALEGACIONES)) {
			desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RECEPCION_ALEGACIONES_ES);
			desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RECEPCION_ALEGACIONES_EU);

		} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
				.equals(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_RESULTADO_ANALISIS)) {
			desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RESULTADO_ANALISIS_ES);
			desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RESULTADO_ANALISIS_EU);

		} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
				.equals(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_CONVENIO_ARBITRAL)) {
			desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_CONVENIO_ARBITRAL_ES);
			desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_CONVENIO_ARBITRAL_EU);

		} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
				.equals(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_CITACION_AUDIENCIA)) {
			desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_CITACION_AUDIENCIA_ES);
			desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_CITACION_AUDIENCIA_EU);

		} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
				.equals(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_CITACION_A_PRUEBA)) {
			desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_CITACION_A_PRUEBA_ES);
			desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_CITACION_A_PRUEBA_EU);

		} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
				.equals(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_CITACION_2AUDIENCIA)) {
			desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_CITACION_2AUDIENCIA_ES);
			desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_CITACION_2AUDIENCIA_EU);

		} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
				.equals(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_SUSPENSION_AUDIENCIA)) {
			desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_SUSPENSION_AUDIENCIA_ES);
			desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_SUSPENSION_AUDIENCIA_EU);

		} else if (proceedings.getNotifiedActId() != null
				&& proceedings.getNotifiedActId().equals(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_RESOLUCION)) {
			desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RESOLUCION_ES);
			desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RESOLUCION_EU);

		} else if (proceedings.getNotifiedActId() != null
				&& proceedings.getNotifiedActId().equals(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_LAUDO)) {
			desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_LAUDO_ES);
			desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_LAUDO_EU);

		} else if (proceedings.getNotifiedActId() != null
				&& proceedings.getNotifiedActId().equals(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_PAGO_PERICIAL)) {
			desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_PAGO_PERICIAL_ES);
			desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_PAGO_PERICIAL_EU);

		} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
				.equals(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_RECEPCION_INFORME_PERICIAL)) {
			desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RECEPCION_INFORME_PERICIAL_ES);
			desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RECEPCION_INFORME_PERICIAL_EU);

		} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
				.equals(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION)) {
			desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_RECEPCION_SOLICITUD_ACLARACION_ES);
			desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_RECEPCION_SOLICITUD_ACLARACION_EU);

		} else if (proceedings.getNotifiedActId() != null
				&& proceedings.getNotifiedActId().equals(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_ACLARACION)) {
			desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_ACLARACION_ES);
			desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_ACLARACION_EU);

		} else if (proceedings.getNotifiedActId() != null && proceedings.getNotifiedActId()
				.equals(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_REQUERIMIENTO_ACREDITACION)) {
			desLanguageNotifiedAct.setStringValue(Y41bConstantes.LITERAL_REQUERIMIENTOACREDREPR_ES);
			desLanguageNotifiedActEu.setStringValue(Y41bConstantes.LITERAL_REQUERIMIENTOACREDREPR_EU);
			proceedings.setNotifiedActId(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_REQUERIMIENTO);
		}
	}

	/**
	 * Genera el proceedings de una comunicacion
	 * 
	 * @param proceedingsType
	 *            ProceedingsType
	 * @param proceedings
	 *            Proceedings
	 * @return ProceedingsType
	 */
	private static ProceedingsType generarProceedingsComunicacion(ProceedingsType proceedingsType,
			Proceedings proceedings) {
		NotificationProceedingsType notificationProceedingsType = proceedingsType.addNewNotificationProceedings();
		NotificationType notificationType = notificationProceedingsType.addNewNotification();
		notificationType.setNotifiedActId(proceedings.getNotifiedActId());
		DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();

		Language desLanguageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
		desLanguageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
		desLanguageNotifiedAct.setStringValue(proceedings.getDesnotifiedActCast());
		Language desLanguageNotifiedActEu = descriptionTypeNotifiedAct.addNewLanguage();
		desLanguageNotifiedActEu.setLocale(Y41bConstantes.EUSKERA);
		desLanguageNotifiedActEu.setStringValue(proceedings.getDesnotifiedActEus());

		if (proceedings.getTipoNotificacion() != null
				&& proceedings.getTipoNotificacion().equals(Y41bConstantes.ELECTRONICO)) {
			NotificationType.Electronic electronic = notificationType.addNewElectronic();
			electronic.setPublicationTimestamp(proceedings.getNotifiedPublicationtimestamp());
			electronic.setOidnotification(proceedings.getOidnotification());
		} else {
			NotificationType.Postal postal = notificationType.addNewPostal();
			postal.setPublicationTimestamp(proceedings.getNotifiedPublicationtimestamp());
		}

		return proceedingsType;
	}

	/**
	 * Crear xml para el cierre de un expediente telemático
	 * 
	 * @param cierreExpediente
	 *            CierreExpediente
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLCerrarExpediente(CierreExpediente cierreExpediente, Procedure procedureCatalog)
			throws Exception {

		CloseExpedientNTDocument closeExpedientNTDocument = CloseExpedientNTDocument.Factory.newInstance();
		CloseExpedientNTType closeExpedientNTType = closeExpedientNTDocument.addNewCloseExpedientNT();

		CompleteFolderNumberNTType completeFolderNumberNTType = closeExpedientNTType.addNewCompleteFolderNumber();

		completeFolderNumberNTType.setProcedureId(cierreExpediente.getProcedure().getIdProcedimiento());
		completeFolderNumberNTType.setExercise(cierreExpediente.getEjercicio());
		completeFolderNumberNTType.setFolderNumber(cierreExpediente.getNumeroExpediente());

		closeExpedientNTType.setClosingTimestamp(Calendar.getInstance());
		closeExpedientNTType.setUpdateTimestamp(Calendar.getInstance());

		DescriptionType descriptionType = closeExpedientNTType.addNewObservations();
		Language descriptionLanguage = descriptionType.addNewLanguage();
		descriptionLanguage.setLocale(Y41bConstantes.CASTELLANO);
		descriptionLanguage.setStringValue(Y41bConstantes.LITERAL_CIERRE_ES);
		descriptionLanguage = descriptionType.addNewLanguage();
		descriptionLanguage.setLocale(Y41bConstantes.EUSKERA);
		descriptionLanguage.setStringValue(Y41bConstantes.LITERAL_CIERRE_EU);

		ProceedingsDetailType proceedingsDetailType = closeExpedientNTType.addNewProceedings();
		proceedingsDetailType.setProceedingsId(Y41bConstantes.LITERAL_PROCEEDINGSID_CIERRE);
		proceedingsDetailType.setTimestamp(Calendar.getInstance());

		DescriptionType proccedingsDesc = proceedingsDetailType.addNewDescription();
		Language procedingLanguage = proccedingsDesc.addNewLanguage();
		procedingLanguage.setLocale(Y41bConstantes.CASTELLANO);
		procedingLanguage.setStringValue(Y41bConstantes.LITERAL_CIERREARCHIVO_ES);
		procedingLanguage = proccedingsDesc.addNewLanguage();
		procedingLanguage.setLocale(Y41bConstantes.EUSKERA);
		procedingLanguage.setStringValue(Y41bConstantes.LITERAL_CIERREARCHIVO_EU);

		proceedingsDetailType.setManagingUnitId(procedureCatalog.getManagingUnitId());
		DescriptionType descManaging = proceedingsDetailType.addNewManagingUnitName();
		descManaging.set(procedureCatalog.getManagingUnitName());

		return Y41bXMLUtils.quitarNameSpacesString(closeExpedientNTDocument);
	}

	/**
	 * Añade notice_chanel al xml de init_expedientNT
	 * 
	 * @param participant
	 *            ParticipantType
	 * @return notice_chanel
	 */
	private static ParticipantType addNoticeChannelAperturaExpediente(ParticipantType participant,
			DatosPersona persona) {
		NoticeChanelType noticeChanelType = participant.addNewNoticeChanel();
		if (persona.getTelefono() != null) {
			// noticeChanelType.addPhone(persona.getTelefono());
			noticeChanelType.addSms(persona.getTelefono());
		}
		if (persona.getMail() != null) {
			noticeChanelType.addEmail(persona.getMail());
		}
		return participant;
	}

	/**
	 * Añade notice_chanel al xml de init_expedientNT
	 * 
	 * @param participant
	 *            ParticipantType
	 * @param solicitudOficio
	 *            SolicitudPresencial
	 * @return notice_chanel
	 */
	private static ParticipantType addNoticeChannelAperturaExpediente(ParticipantType participant,
			SolicitudOficio solicitudOficio) {
		NoticeChanelType noticeChanelType = participant.addNewNoticeChanel();
		if (solicitudOficio.getSancionado().getTelefono() != null) {
			// noticeChanelType.addPhone(solicitudOficio.getSancionado().getTelefono());
			noticeChanelType.addSms(solicitudOficio.getSancionado().getTelefono());
		}
		if (solicitudOficio.getSancionado().getMail() != null) {
			noticeChanelType.addEmail(solicitudOficio.getSancionado().getMail());
		}
		return participant;
	}

	/**
	 * Añade notice_chanel al xml de init_expedientNT
	 * 
	 * @param participant
	 *            ParticipantType
	 * @param solicitudTelematica
	 *            SolicitudTelematica
	 * @param persona
	 *            DatosPersona
	 * @return notice_chanel
	 */
	private static ParticipantType addNoticeChannelAperturaExpedienteTelematica(ParticipantType participant,
			SolicitudTelematica solicitudTelematica, DatosPersona persona) {
		NoticeChanelType noticeChanelType = participant.addNewNoticeChanel();
		if (persona.getTelefono() != null) {
			// noticeChanelType.addPhone(persona.getTelefono());
			noticeChanelType.addSms(persona.getTelefono());
		}
		if (persona.getMail() != null) {
			noticeChanelType.addEmail(persona.getMail());
		}
		return participant;
	}

	/**
	 * Añade notification_chanel al xml de init_expedientNT
	 * 
	 * @param participantType
	 *            ParticipantType
	 * @param solicitudPresencial
	 *            SolicitudPresencial
	 * @return notification_chanel
	 */
	private static ParticipantType addNotificationChannelAperturaExpediente(ParticipantType participantType,
			SolicitudPresencial solicitudPresencial) {

		NotificationChanelType notificationChanelType = participantType.addNewNotificationChanel();
		if (StringUtils.isBlank(solicitudPresencial.getTipoNotificacion())
				|| solicitudPresencial.getTipoNotificacion().equals(Y41bConstantes.ELECTRONICO)) {
			notificationChanelType.setElectronic("");
		} else {
			// creo que no est preparado porque siempre se est poniendo
			// electroico
			Postal postal = notificationChanelType.addNewPostal();
			postal.setStreet(solicitudPresencial.getNotificacionPostal().getCalle());
			DescriptionType descriptionProvincia = postal.addNewProvince();
			Language languageProv = descriptionProvincia.addNewLanguage();
			languageProv.setLocale(Y41bConstantes.EUSKERA);
			languageProv.setStringValue(solicitudPresencial.getNotificacionPostal().getProvincia());
			languageProv = descriptionProvincia.addNewLanguage();
			languageProv.setLocale(Y41bConstantes.CASTELLANO);
			languageProv.setStringValue(solicitudPresencial.getNotificacionPostal().getProvincia());

			DescriptionType descriptionTown = postal.addNewTown();
			Language languageTown = descriptionTown.addNewLanguage();
			languageTown.setLocale(Y41bConstantes.EUSKERA);
			languageTown.setStringValue(solicitudPresencial.getNotificacionPostal().getMunicipio());
			languageTown = descriptionTown.addNewLanguage();
			languageTown.setLocale(Y41bConstantes.CASTELLANO);
			languageTown.setStringValue(solicitudPresencial.getNotificacionPostal().getMunicipio());

			postal.setZipcode(solicitudPresencial.getNotificacionPostal().getCodigoPostal().trim());
		}
		return participantType;
	}

	/**
	 * Añade notification_chanel al xml de init_expedientNT
	 * 
	 * @param participantType
	 *            ParticipantType
	 * @param solicitudOficio
	 *            SolicitudPresencial
	 * @return notification_chanel
	 */
	private static ParticipantType addNotificationChannelAperturaExpediente(ParticipantType participantType,
			SolicitudOficio solicitudOficio) {

		NotificationChanelType notificationChanelType = participantType.addNewNotificationChanel();
		if (StringUtils.isBlank(solicitudOficio.getTipoNotificacion())
				|| solicitudOficio.getTipoNotificacion().equals(Y41bConstantes.ELECTRONICO)) {
			notificationChanelType.setElectronic("");
		} else {
			Postal postal = notificationChanelType.addNewPostal();
			postal.setStreet(solicitudOficio.getNotificacionPostal().getCalle());
			DescriptionType descriptionProvincia = postal.addNewProvince();
			Language languageProv = descriptionProvincia.addNewLanguage();
			languageProv.setLocale(Y41bConstantes.EUSKERA);
			languageProv.setStringValue(solicitudOficio.getNotificacionPostal().getProvincia());
			languageProv = descriptionProvincia.addNewLanguage();
			languageProv.setLocale(Y41bConstantes.CASTELLANO);
			languageProv.setStringValue(solicitudOficio.getNotificacionPostal().getProvincia());

			DescriptionType descriptionTown = postal.addNewTown();
			Language languageTown = descriptionTown.addNewLanguage();
			languageTown.setLocale(Y41bConstantes.EUSKERA);
			languageTown.setStringValue(solicitudOficio.getNotificacionPostal().getMunicipio());
			languageTown = descriptionTown.addNewLanguage();
			languageTown.setLocale(Y41bConstantes.CASTELLANO);
			languageTown.setStringValue(solicitudOficio.getNotificacionPostal().getMunicipio());

			postal.setZipcode(solicitudOficio.getNotificacionPostal().getCodigoPostal());
		}
		return participantType;
	}

	/**
	 * Añade notification_chanel al xml de init_expedientNT
	 * 
	 * @param participantType
	 *            ParticipantType
	 * @param solicitudTelematica
	 *            SolicitudTelematica
	 * @return notification_chanel
	 */
	private static ParticipantType addNotificationChannelAperturaExpedienteTelematica(ParticipantType participantType,
			SolicitudTelematica solicitudTelematica) {

		NotificationChanelType notificationChanelType = participantType.addNewNotificationChanel();
		if (StringUtils.isBlank(solicitudTelematica.getTipoNotificacion())
				|| solicitudTelematica.getTipoNotificacion().equals(Y41bConstantes.ELECTRONICO)) {
			notificationChanelType.setElectronic("");
		} else {
			Postal postal = notificationChanelType.addNewPostal();
			postal.setStreet(solicitudTelematica.getNotificacionPostal().getCalle());
			DescriptionType descriptionProvincia = postal.addNewProvince();
			Language languageProv = descriptionProvincia.addNewLanguage();
			languageProv.setLocale(Y41bConstantes.EUSKERA);
			languageProv.setStringValue(solicitudTelematica.getNotificacionPostal().getProvincia());
			languageProv = descriptionProvincia.addNewLanguage();
			languageProv.setLocale(Y41bConstantes.CASTELLANO);
			languageProv.setStringValue(solicitudTelematica.getNotificacionPostal().getProvincia());

			DescriptionType descriptionTown = postal.addNewTown();
			Language languageTown = descriptionTown.addNewLanguage();
			languageTown.setLocale(Y41bConstantes.EUSKERA);
			languageTown.setStringValue(solicitudTelematica.getNotificacionPostal().getMunicipio());
			languageTown = descriptionTown.addNewLanguage();
			languageTown.setLocale(Y41bConstantes.CASTELLANO);
			languageTown.setStringValue(solicitudTelematica.getNotificacionPostal().getMunicipio());

			postal.setZipcode(solicitudTelematica.getNotificacionPostal().getCodigoPostal().trim());

		}
		return participantType;
	}

	/**
	 * Añade la parte de from_citicen al xml de saveOrUpdateExpedientNT
	 * 
	 * @param proceedingsType
	 *            ProceedingsType
	 * @param listDocumento
	 *            List<Documento>
	 * @return String from_citicen
	 */
	private static ProceedingsType addFromCitizenActualizarExpediente(ProceedingsType proceedingsType,
			List<Documento> listDocumento) {
		DocumentsType documentsType = proceedingsType.addNewFromCiticen();

		if (null != listDocumento && listDocumento.size() > 0) {
			for (Documento documento : listDocumento) {

				DocumentType documentoType = documentsType.addNewDocument();
				DescriptionType descriptionType = documentoType.addNewRolName();
				Language language = descriptionType.addNewLanguage();
				language.setLocale(Y41bConstantes.CASTELLANO);

				if (Y41bUtils.isFilled(documento.getDescripcion())) {
					language.setStringValue(documento.getDescripcion());// DESCRIPCION
				} else {
					language.setStringValue(documento.getNombre());// DESCRIPCION
				}

				language = descriptionType.addNewLanguage();
				language.setLocale(Y41bConstantes.EUSKERA);

				if (Y41bUtils.isFilled(documento.getDescripcion())) {
					language.setStringValue(documento.getDescripcion());// DESCRIPCION
				} else {
					language.setStringValue(documento.getNombre());// DESCRIPCION
				}

				if (StringUtils.isNotBlank(documento.getOidDokusi())) {
					Electronic electronic = documentoType.addNewElectronic();
					electronic.setRdeId(documento.getOidDokusi());
					electronic.setOriginSystem(com.ejie.r02R.xml.DocumentType.Electronic.OriginSystem.Enum
							.forString(Y41bConstantes.ORIGIN_RDE));
					electronic.setName(Y41bUtils
							.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(documento.getNombre())));// NOMBRE
				} else {
					Paper paper = documentoType.addNewPaper();
					paper.setName(Y41bUtils
							.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(documento.getNombre())));// NOMBRE
				}
			}
		}

		return proceedingsType;
	}

	/**
	 * Añade la parte de from_administration al xml de saveOrUpdateExpedientNT
	 * 
	 * @param proceedingsType
	 *            ProceedingsType
	 * @param listDocumento
	 *            List<Documento>
	 * @return String from_administration
	 */
	private static ProceedingsType addFromAdministrationActualizarExpediente(ProceedingsType proceedingsType,
			List<Documento> listDocumento) {
		DocumentsType documentsType = proceedingsType.addNewFromAdministration();

		if (null != listDocumento && listDocumento.size() > 0) {
			for (Documento documento : listDocumento) {

				DocumentType documentoType = documentsType.addNewDocument();
				DescriptionType descriptionType = documentoType.addNewRolName();
				Language language = descriptionType.addNewLanguage();
				language.setLocale(Y41bConstantes.CASTELLANO);

				if (Y41bUtils.isFilled(documento.getDescripcion())) {
					language.setStringValue(documento.getDescripcion());// DESCRIPCION
				} else {
					language.setStringValue(documento.getNombre());// DESCRIPCION
				}

				language = descriptionType.addNewLanguage();
				language.setLocale(Y41bConstantes.EUSKERA);

				if (Y41bUtils.isFilled(documento.getDescripcion())) {
					language.setStringValue(documento.getDescripcion());// DESCRIPCION
				} else {
					language.setStringValue(documento.getNombre());// DESCRIPCION
				}

				if (StringUtils.isNotBlank(documento.getOidDokusi())) {
					Electronic electronic = documentoType.addNewElectronic();
					electronic.setRdeId(documento.getOidDokusi());
					electronic.setOriginSystem(com.ejie.r02R.xml.DocumentType.Electronic.OriginSystem.Enum
							.forString(Y41bConstantes.ORIGIN_RDE));
					electronic.setName(Y41bUtils
							.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(documento.getNombre())));// NOMBRE
				} else {
					Paper paper = documentoType.addNewPaper();
					paper.setName(Y41bUtils
							.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(documento.getNombre())));// NOMBRE
				}
			}
		}

		return proceedingsType;
	}

	/**
	 * Añade la parte de from_citicen al xml de init_expedientNT
	 * 
	 * @param proceedingsType
	 *            ProceedingsType
	 * @param solicitudPresencial
	 *            SolicitudPresencial
	 * @return String from_citicen
	 */
	private static ProceedingsType addFromCitizenAperturaExpedientePresencial(ProceedingsType proceedingsType,
			SolicitudPresencial solicitudPresencial) {
		DocumentsType documentsType = proceedingsType.addNewFromCiticen();

		if (null != solicitudPresencial.getDocumentosAdjuntos()
				&& solicitudPresencial.getDocumentosAdjuntos().size() > 0) {
			for (Documento documento : solicitudPresencial.getDocumentosAdjuntos()) {

				DocumentType documentoType = documentsType.addNewDocument();
				DescriptionType descriptionType = documentoType.addNewRolName();
				Language language = descriptionType.addNewLanguage();
				language.setLocale(Y41bConstantes.CASTELLANO);

				if (Y41bUtils.isFilled(documento.getDescripcion())) {
					language.setStringValue(documento.getDescripcion());// DESCRIPCION
				} else {
					language.setStringValue(documento.getNombre());// DESCRIPCION
				}

				language = descriptionType.addNewLanguage();
				language.setLocale(Y41bConstantes.EUSKERA);
				if (Y41bUtils.isFilled(documento.getDescripcion())) {
					language.setStringValue(documento.getDescripcion());// DESCRIPCION
				} else {
					language.setStringValue(documento.getNombre());// DESCRIPCION
				}

				if (StringUtils.isNotBlank(documento.getOidDokusi())) {
					Electronic electronic = documentoType.addNewElectronic();
					electronic.setRdeId(documento.getOidDokusi());
					electronic.setOriginSystem(com.ejie.r02R.xml.DocumentType.Electronic.OriginSystem.Enum
							.forString(Y41bConstantes.ORIGIN_RDE));
					electronic.setName(Y41bUtils
							.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(documento.getNombre())));// NOMBRE
				} else {
					Paper paper = documentoType.addNewPaper();
					paper.setName(Y41bUtils
							.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(documento.getNombre())));// NOMBRE
				}
			}
		}

		return proceedingsType;
	}

	/**
	 * Añade la parte de from_citicen al xml de expedientNT
	 * 
	 * @param proceedingsType
	 *            ProceedingsType
	 * @param actualizarMisGestiones
	 *            ActualizarMisGestiones
	 * @return String from_citicen
	 */
	private static ProceedingsType addFromCitizenMisGestiones(ProceedingsType proceedingsType,
			ActualizarMisGestiones actualizarMisGestiones) {
		DocumentsType documentsType = proceedingsType.addNewFromCiticen();

		if (null != actualizarMisGestiones.getDocumentos() && actualizarMisGestiones.getDocumentos().size() > 0) {
			for (Documento documento : actualizarMisGestiones.getDocumentos()) {

				DocumentType documentoType = documentsType.addNewDocument();
				DescriptionType descriptionType = documentoType.addNewRolName();
				Language language = descriptionType.addNewLanguage();
				language.setLocale(Y41bConstantes.CASTELLANO);

				if (Y41bUtils.isFilled(documento.getDescripcion())) {
					language.setStringValue(documento.getDescripcion());// DESCRIPCION
				} else {
					language.setStringValue(documento.getNombre());// DESCRIPCION
				}

				language = descriptionType.addNewLanguage();
				language.setLocale(Y41bConstantes.EUSKERA);

				if (Y41bUtils.isFilled(documento.getDescripcion())) {
					language.setStringValue(documento.getDescripcion());// DESCRIPCION
				} else {
					language.setStringValue(documento.getNombre());// DESCRIPCION
				}

				if (StringUtils.isNotBlank(documento.getOidDokusi())) {
					Electronic electronic = documentoType.addNewElectronic();
					electronic.setRdeId(documento.getOidDokusi());
					electronic.setOriginSystem(com.ejie.r02R.xml.DocumentType.Electronic.OriginSystem.Enum
							.forString(Y41bConstantes.ORIGIN_RDE));
					electronic.setName(Y41bUtils
							.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(documento.getNombre())));// NOMBRE
				} else {
					Paper paper = documentoType.addNewPaper();
					paper.setName(Y41bUtils
							.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(documento.getNombre())));// NOMBRE
				}
			}
		}

		return proceedingsType;
	}

	/**
	 * Añade la parte de from_administration al xml de expedientNT
	 * 
	 * @param proceedingsType
	 *            ProceedingsType
	 * @param actualizarMisGestiones
	 *            ActualizarMisGestiones
	 * @return String from_administration
	 */
	private static ProceedingsType addNewFromAdministration(ProceedingsType proceedingsType,
			ActualizarMisGestiones actualizarMisGestiones) {
		DocumentsType documentsType = proceedingsType.addNewFromAdministration();

		if (null != actualizarMisGestiones.getDocumentos() && actualizarMisGestiones.getDocumentos().size() > 0) {
			for (Documento documento : actualizarMisGestiones.getDocumentos()) {

				DocumentType documentoType = documentsType.addNewDocument();
				DescriptionType descriptionType = documentoType.addNewRolName();
				Language language = descriptionType.addNewLanguage();
				language.setLocale(Y41bConstantes.CASTELLANO);

				if (Y41bUtils.isFilled(documento.getDescripcion())) {
					language.setStringValue(documento.getDescripcion());// DESCRIPCION
				} else {
					language.setStringValue(documento.getNombre());// DESCRIPCION
				}

				language = descriptionType.addNewLanguage();
				language.setLocale(Y41bConstantes.EUSKERA);

				if (Y41bUtils.isFilled(documento.getDescripcion())) {
					language.setStringValue(documento.getDescripcion());// DESCRIPCION
				} else {
					language.setStringValue(documento.getNombre());// DESCRIPCION
				}

				if (StringUtils.isNotBlank(documento.getOidDokusi())) {
					Electronic electronic = documentoType.addNewElectronic();
					electronic.setRdeId(documento.getOidDokusi());
					electronic.setOriginSystem(com.ejie.r02R.xml.DocumentType.Electronic.OriginSystem.Enum
							.forString(Y41bConstantes.ORIGIN_RDE));
					electronic.setName(Y41bUtils
							.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(documento.getNombre())));// NOMBRE
				} else {
					Paper paper = documentoType.addNewPaper();
					paper.setName(Y41bUtils
							.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(documento.getNombre())));// NOMBRE
				}
			}
		}

		return proceedingsType;
	}

	/**
	 * Añade la parte de from_citicen al xml de init_expedientNT
	 * 
	 * @param proceedingsType
	 *            ProceedingsType
	 * @param solicitudOficio
	 *            SolicitudPresencial
	 * @return String from_citicen
	 */
	private static ProceedingsType addFromCitizenAperturaExpedientePresencial(ProceedingsType proceedingsType,
			SolicitudOficio solicitudOficio) {
		DocumentsType documentsType = proceedingsType.addNewFromCiticen();

		if (null != solicitudOficio.getDocumentosAdjuntos() && solicitudOficio.getDocumentosAdjuntos().size() > 0) {
			for (Documento documento : solicitudOficio.getDocumentosAdjuntos()) {

				DocumentType documentoType = documentsType.addNewDocument();
				DescriptionType descriptionType = documentoType.addNewRolName();
				Language language = descriptionType.addNewLanguage();
				language.setLocale(Y41bConstantes.CASTELLANO);
				language.setStringValue(documento.getNombre());// DESCRIPCION
				language = descriptionType.addNewLanguage();
				language.setLocale(Y41bConstantes.EUSKERA);
				language.setStringValue(documento.getNombre());// DESCRIPCION

				if (StringUtils.isNotBlank(documento.getOidDokusi())) {
					Electronic electronic = documentoType.addNewElectronic();
					electronic.setRdeId(documento.getOidDokusi());
					electronic.setOriginSystem(com.ejie.r02R.xml.DocumentType.Electronic.OriginSystem.Enum
							.forString(Y41bConstantes.ORIGIN_RDE));
					electronic.setName(documento.getNombre());// NOMBRE
				} else {
					Paper paper = documentoType.addNewPaper();
					paper.setName(documento.getNombre());// NOMBRE
				}
			}
		}

		return proceedingsType;
	}

	/**
	 * Añade la parte de from_citicen al xml de init_expedientNT
	 * 
	 * @param proceedingsType
	 *            ProceedingsType
	 * @param solicitudTelematica
	 *            SolicitudTelematica
	 * @return String from_citicen
	 */
	private static ProceedingsType addFromCitizenAperturaExpedienteTelematica(ProceedingsType proceedingsType,
			SolicitudTelematica solicitudTelematica) {
		DocumentsType documentsType = proceedingsType.addNewFromCiticen();

		if (null != solicitudTelematica.getDocumentosAdjuntos()
				&& solicitudTelematica.getDocumentosAdjuntos().size() > 0) {
			for (Documento documento : solicitudTelematica.getDocumentosAdjuntos()) {

				logger.info("Documento: " + documento.getNombre());
				DocumentType documentoType = documentsType.addNewDocument();
				DescriptionType descriptionType = documentoType.addNewRolName();
				Language language = descriptionType.addNewLanguage();
				language.setLocale(Y41bConstantes.CASTELLANO);

				if (Y41bUtils.isFilled(documento.getDescripcion())) {
					language.setStringValue(documento.getDescripcion());// DESCRIPCION
				} else {
					language.setStringValue(documento.getNombre());// DESCRIPCION
				}

				language = descriptionType.addNewLanguage();
				language.setLocale(Y41bConstantes.EUSKERA);
				if (Y41bUtils.isFilled(documento.getDescripcion())) {
					language.setStringValue(documento.getDescripcion());// DESCRIPCION
				} else {
					language.setStringValue(documento.getNombre());// DESCRIPCION
				}

				logger.info(
						"El OID de dokusi del documento " + documento.getNombre() + " es " + documento.getOidDokusi());
				if (StringUtils.isNotBlank(documento.getOidDokusi())) {
					logger.info("Documento " + documento.getNombre() + " es de tipo electronico");
					Electronic electronic = documentoType.addNewElectronic();
					electronic.setRdeId(documento.getOidDokusi());
					electronic.setOriginSystem(com.ejie.r02R.xml.DocumentType.Electronic.OriginSystem.Enum
							.forString(Y41bConstantes.ORIGIN_RDE));
					electronic.setName(documento.getNombre());// NOMBRE
				} else {
					logger.info("Documento " + documento.getNombre() + " es de tipo papel");
					Paper paper = documentoType.addNewPaper();
					paper.setName(documento.getNombre());// NOMBRE
				}
			}
		}

		return proceedingsType;
	}

	/**
	 * Crear xml para crear el registro de entrada
	 * 
	 * @param registroEntrada
	 *            RegistroEntrada
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLContextRegistry(RegistroEntrada registroEntrada, Procedure procedureCatalog)
			throws Exception {

		ContextRegistryDocument contextRegistryDocument = ContextRegistryDocument.Factory.newInstance();
		ContextRegistry contextRegistry = contextRegistryDocument.addNewContextRegistry();

		contextRegistry.setProcedureID(registroEntrada.getProcedure().getIdProcedimiento());

		contextRegistry.setProcedureName(procedureCatalog.getProcedureName());

		contextRegistry.setManagingUnitID(procedureCatalog.getManagingUnitId());

		contextRegistry.setManagingUnitName(procedureCatalog.getManagingUnitName());

		contextRegistry.setDepartmentName(procedureCatalog.getDepartmentName());

		DescriptionType description = DescriptionType.Factory.newInstance();
		Language cas = description.addNewLanguage();
		cas.setLocale(Locale.ES.toString());
		cas.setStringValue(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
		Language eus = description.addNewLanguage();
		eus.setLocale(Y41bConstantes.EUSKERA);
		eus.setStringValue(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);
		contextRegistry.setSubmissionTypeName(description);

		contextRegistry.setRegistryTopicCode(registroEntrada.getProcedure().getIdProcedimiento());

		if (registroEntrada.getSolicitante() == null || StringUtils.isBlank(registroEntrada.getSolicitante().getDni())
				|| StringUtils.isBlank(registroEntrada.getSolicitante().getNombre())) {
			throw new Y41bUDAException("error.platea.origen.datosminimos", true, null);
		}

		contextRegistry.setRegistrySenderId(registroEntrada.getSolicitante().getDni());
		contextRegistry.setRegistrySenderName(registroEntrada.getSolicitante().getNombre());

		contextRegistry.setRegistryAddresseeCode(procedureCatalog.getManagingUnitId());
		contextRegistry.setRegistryAddresseeName(procedureCatalog.getManagingUnitName());

		contextRegistry.setLanguage(registroEntrada.getIdioma());

		if (registroEntrada.getDocumentosAdjuntos() != null && registroEntrada.getDocumentosAdjuntos().size() > 0) {
			com.ejie.folderManagement.xml.DocumentsDocument.Documents documents = contextRegistry.addNewDocuments();

			for (Documento documento : registroEntrada.getDocumentosAdjuntos()) {
				com.ejie.folderManagement.xml.DocumentDocument.Document document = documents.addNewDocument();
				document.setOid(documento.getOidDokusi());
				document.setRoleId(documento.getTipoDocumental());
				document.setSourceName(documento.getNombre());
				document.setFormat(documento.getExtension());
			}
		}

		return Y41bXMLUtils.quitarNameSpacesString(contextRegistryDocument);
	}

	/**
	 * Crear xml para crear el registro de salida
	 * 
	 * @param registroSalida
	 *            RegistroSalida
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLExitRegistryCreationInfo(RegistroSalida registroSalida, Procedure procedureCatalog)
			throws Exception {

		ExitRegistryCreationInfoDocument exitRegistryCreationInfoDocument = ExitRegistryCreationInfoDocument.Factory
				.newInstance();
		ExitRegistryCreationInfo exitRegistryCreationInfo = exitRegistryCreationInfoDocument
				.addNewExitRegistryCreationInfo();

		exitRegistryCreationInfo.setProcedureID(registroSalida.getProcedure().getIdProcedimiento());

		exitRegistryCreationInfo.setManagingUnitID(procedureCatalog.getManagingUnitId());

		if (registroSalida.getSolicitante() == null || StringUtils.isBlank(registroSalida.getSolicitante().getDni())
				|| StringUtils.isBlank(registroSalida.getSolicitante().getNombre())) {
			throw new Y41bUDAException("error.platea.destinatario.datosminimos", true, null);
		}

		exitRegistryCreationInfo.setRegistryAddreseeOrganID(registroSalida.getSolicitante().getDni());

		DescriptionType description = DescriptionType.Factory.newInstance();
		Language cas = description.addNewLanguage();
		cas.setLocale(Locale.ES.toString());
		cas.setStringValue(registroSalida.getSolicitante().getNombre());
		Language eus = description.addNewLanguage();
		eus.setLocale(Y41bConstantes.EUSKERA);
		eus.setStringValue(registroSalida.getSolicitante().getNombre());
		exitRegistryCreationInfo.setRegistryAddreseeOrganName(description);

		exitRegistryCreationInfo.setRegistrySenderCode(procedureCatalog.getManagingUnitId());
		exitRegistryCreationInfo.setRegistryTopicCode(registroSalida.getProcedure().getIdProcedimiento());
		description = DescriptionType.Factory.newInstance();
		cas = description.addNewLanguage();
		cas.setLocale(Locale.ES.toString());
		cas.setStringValue(Y41bConstantes.LITERAL_NOTIFICACION_ES);
		eus = description.addNewLanguage();
		eus.setLocale(Y41bConstantes.EUSKERA);
		eus.setStringValue(Y41bConstantes.LITERAL_NOTIFICACION_EU);
		exitRegistryCreationInfo.setSubmissionTypeName(description);

		if (registroSalida.getDocumentosAdjuntos() != null && registroSalida.getDocumentosAdjuntos().size() > 0) {
			com.ejie.horizontalSystemOfNotification.xml.DocumentsDocument.Documents documents = exitRegistryCreationInfo
					.addNewDocuments();

			for (Documento documento : registroSalida.getDocumentosAdjuntos()) {
				com.ejie.horizontalSystemOfNotification.xml.DocumentDocument.Document document = documents
						.addNewDocument();
				document.setOid(documento.getOidDokusi());
				document.setRoleId(documento.getTipoDocumental());
				// document.setRoleName();
				document.setSourceName(documento.getNombre());
				document.setFormat(documento.getExtension());
			}
		}
		return Y41bXMLUtils.quitarNameSpacesString(exitRegistryCreationInfoDocument);
	}

	/**
	 * Crear el xml para realizar el envío de una solicitud telemática
	 * 
	 * @param crearEJGV
	 *            CrearEJGV
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLSolicitud(CrearEJGV crearEJGV, Procedure procedureCatalog) throws Exception {
		StringBuffer sbXml = new StringBuffer(Y41bConstantes.NUM_100);
		sbXml.append(Y41bConstantes.CABECERA_XML_ISO);
		sbXml.append(Y41bConstantes.CABECERA_XSL_SOLICITUD);

		EjgvDocument ejgvDocument = EjgvDocument.Factory.newInstance();
		Header header = ejgvDocument.addNewHeader();
		header.setType(TypeDocument.Type.Enum.forString(Y41bConstantes.APPLICATION));
		header.setVersion(new BigDecimal(1.0));
		header.setFlags(Y41bConstantes.CERO);

		Body body = ejgvDocument.addNewBody();

		BasicInfo basicInfo = body.addNewBasicInfo();
		basicInfo.setProcedureID(crearEJGV.getProcedure().getIdProcedimiento());

		ProcedureName procedureName = basicInfo.addNewProcedureName();
		procedureName.set(procedureCatalog.getProcedureName());

		basicInfo.setDepartmentID(procedureCatalog.getDepartmentId());
		basicInfo.setManagingUnitID(procedureCatalog.getManagingUnitId());

		basicInfo.setEntityID(procedureCatalog.getEntityCode());
		DepartmentName departmentName = basicInfo.addNewDepartmentName();
		departmentName.set(procedureCatalog.getDepartmentName());

		ManagingUnitName managingUnitName = basicInfo.addNewManagingUnitName();
		managingUnitName.set(procedureCatalog.getManagingUnitName());

		EntityName entityName = basicInfo.addNewEntityName();
		Description description = entityName.addNewDescription();
		LanguageDocument.Language cas = description.addNewLanguage();
		cas.setLocale(Locale.ES);
		cas.setStringValue(Y41bConstantes.LITERAL_GOBIERNO_VASCO_ES);
		LanguageDocument.Language eus = description.addNewLanguage();
		eus.setLocale(Locale.EU);
		eus.setStringValue(Y41bConstantes.LITERAL_GOBIERNO_VASCO_EU);
		entityName.setDescription(description);

		ApplicantInfoDocument.ApplicantInfo applicantInfo = body.addNewApplicantInfo();

		PersonsDocument.Persons persons = applicantInfo.addNewPersons();
		PersonDocument.Person person = persons.addNewPerson();
		person.setId(crearEJGV.getSolicitante().getDni().trim());
		person.setName(crearEJGV.getSolicitante().getNombre());
		person.setPersonType(Y41bConstantes.PERSONTYPE);
		person.setHolderShip(Y41bConstantes.HOLDERSHIP_TITULAR);
		Contacts contacts = person.addNewContacts();
		Contact contact = contacts.addNewContact();
		contact.setType(TypeDocument.Type.Enum.forInt(Y41bConstantes.CONTACTTYPE));
		Value value = contact.addNewValue();
		value.setPhoneNumber(crearEJGV.getSolicitante().getTelefono());

		// Comprobar si tiene representante
		if (crearEJGV.getRepresentante() != null && StringUtils.isNotBlank(crearEJGV.getRepresentante().getDni())) {
			persons = applicantInfo.addNewPersons();
			person = persons.addNewPerson();
			person.setId(crearEJGV.getRepresentante().getDni().trim());
			person.setName(crearEJGV.getRepresentante().getNombre());
			person.setPersonType(Y41bConstantes.PERSONTYPE);
			person.setHolderShip(Y41bConstantes.HOLDERSHIP_REPRESENTANTE);
		}

		NotificationDocument.Notification notification = applicantInfo.addNewNotification();

		AddresseeDocument.Addressee addressee = notification.addNewAddressee();
		addressee.setAddresseeID(crearEJGV.getSolicitante().getDni());
		addressee.setAddresseeName(crearEJGV.getSolicitante().getNombre());

		ChannelDocument.Channel channel = notification.addNewChannel();

		if (null != crearEJGV.getNotificacionPostal()
				&& Y41bConstantes.ELECTRONICO.equals(crearEJGV.getNotificacionPostal())) {
			channel.setChannelType(ChannelTypeDocument.ChannelType.Enum.forInt(1));
		} else {
			channel.setChannelType(ChannelTypeDocument.ChannelType.Enum.forInt(2));
		}

		if (null != crearEJGV.getNotificacionPostal()
				&& Y41bConstantes.POSTAL.equals(crearEJGV.getNotificacionPostal())) {

			NotificacionPostal notificacionPostal = crearEJGV.getNotificacionPostal();

			ChannelInfoDocument.ChannelInfo channelInfo = ChannelInfoDocument.ChannelInfo.Factory.newInstance();
			com.ejie.r02K.xml.PostalAddressDocument.PostalAddress postal = channelInfo.addNewPostalAddress();
			postal.setPais(notificacionPostal.getPais());
			postal.setDireccion(notificacionPostal.getCalle());
			postal.setMunicipio(notificacionPostal.getMunicipio());
			postal.setLocalidad(notificacionPostal.getLocalidad());

			Provincia provincia = postal.addNewProvincia();
			cas = provincia.addNewLanguage();
			cas.setLocale(Locale.ES);
			cas.setStringValue(notificacionPostal.getProvincia());
			eus = provincia.addNewLanguage();
			eus.setLocale(Locale.EU);
			eus.setStringValue(notificacionPostal.getProvincia());
			entityName.setDescription(description);
			postal.setProvincia(provincia);

			postal.setPortal(notificacionPostal.getPortal());
			postal.setCp(notificacionPostal.getCodigoPostal());

			channel.setChannelInfo(channelInfo);
		} else {
			ChannelInfoDocument.ChannelInfo channelInfo = ChannelInfoDocument.ChannelInfo.Factory.newInstance();
			if (Y41bUtils.isFilled(crearEJGV.getSolicitante().getMail())) {
				channelInfo.setEmailAddress(crearEJGV.getSolicitante().getMail());
			}
			if (Y41bUtils.isFilled(crearEJGV.getSolicitante().getTelefono())) {
				channelInfo.setSmsNumber(crearEJGV.getSolicitante().getTelefono());
			}
			channel.setChannelInfo(channelInfo);
		}

		Notices notices = applicantInfo.addNewNotices();
		Notice notice = notices.addNewNotice();
		addressee = notice.addNewAddressee();
		addressee.setAddresseeID(crearEJGV.getSolicitante().getDni());
		addressee.setAddresseeName(crearEJGV.getSolicitante().getNombre());
		channel = notice.addNewChannel();
		channel.setChannelType(ChannelTypeDocument.ChannelType.Enum.forInt(Y41bConstantes.CHANNELTYPE));
		ChannelInfo channelInfo = channel.addNewChannelInfo();
		channelInfo.setEmailAddress(crearEJGV.getSolicitante().getMail());

		LanguageDocument.Language language = applicantInfo.addNewLanguage();

		if (crearEJGV.getIdiomaNotificacion() != null
				&& crearEJGV.getIdiomaNotificacion().equals(Y41bConstantes.EUSKERA)) {
			language.setLocale(Locale.EU);
		} else {
			language.setLocale(Locale.ES);
		}

		StringBuffer sbDetail = new StringBuffer();

		// Recorremos el HashMap para sacar todas las key
		final Set keys = crearEJGV.getMapaSolicitud().keySet();
		final Iterator it = keys.iterator();
		while (it.hasNext()) {
			final String key = it.next().toString();
			sbDetail.append("<info id=\"");
			if (key.startsWith(Y41bConstantes.PREFIJO_CAMPO_OCULTO)) {
				sbDetail.append(key.substring(key.indexOf(Y41bConstantes.PREFIJO_CAMPO_OCULTO)
						+ Y41bConstantes.PREFIJO_CAMPO_OCULTO.length()));
			} else {
				sbDetail.append(key);
			}
			sbDetail.append("\">");
			if (!"xslIdioma".equals(key)) {
				sbDetail.append("<![CDATA[");
			}
			sbDetail.append(crearEJGV.getMapaSolicitud().get(key));
			if (!"xslIdioma".equals(key)) {
				sbDetail.append("]]>");
			}
			sbDetail.append("</info>");
		}
		body.setDetailInfo("CADENA_REMPL_DETAILINFO");

		body.addNewSender();

		Attachments attachments = ejgvDocument.addNewAttachments();

		List<Documento> listDocumento = crearEJGV.getDocumentosAdjuntos();

		if (listDocumento != null && listDocumento.size() > 0) {
			for (Documento documento : crearEJGV.getDocumentosAdjuntos()) {
				Attachment attachment = attachments.addNewAttachment();
				attachment.setID(documento.getOidDokusi().trim());
				attachment.setCode(Y41bConstantes.CODE_ELECTRONICDDOCUMENT);
				attachment.setRoleId(documento.getTipoDocumentalTipoSubtipo());
				attachment.setSourceName(documento.getNombre());
			}
		}
		sbXml.append(ejgvDocument.xmlText());
		return Y41bUtilsWS.encodeString(sbXml.toString().replaceAll("CADENA_REMPL_DETAILINFO", sbDetail.toString()));
	}

	/**
	 * Crear el xml para realizar el envío de una solicitud telemática
	 * 
	 * @param crearNotifEJGV
	 *            CrearNotifEJGV
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLNotificacion(CrearNotifEJGV crearNotifEJGV, Procedure procedureCatalog)
			throws Exception {

		NotificationCreateTaskDocument notificationCreateTaskDocument = NotificationCreateTaskDocument.Factory
				.newInstance();
		NotificationCreateTask notificationCreateTask = notificationCreateTaskDocument.addNewNotificationCreateTask();
		// Generar XML
		notificationCreateTask.setSignatureType("xades");

		if (crearNotifEJGV != null && !Y41bUtils.esNullOCadenaVacia(crearNotifEJGV.getSerieDocumental())) {
			notificationCreateTask.setDaDocumentalSeries(crearNotifEJGV.getSerieDocumental());
		}

		notificationCreateTask.setProcedureID(procedureCatalog.getProcedureId());

		String procedureNameEs = "";
		if (procedureCatalog.getProcedureName() != null) {
			String descriptionXML = Y41bXMLUtils.quitarNameSpacesString(procedureCatalog.getProcedureName().copy());
			procedureNameEs = Y41bXMLUtils.getDescLanguageByDesc(Y41bConstantes.CASTELLANO, descriptionXML);

		}
		notificationCreateTask.setProcedureName(procedureNameEs);
		notificationCreateTask.setDepartmentID(procedureCatalog.getDepartmentId());

		String departamentNameEs = "";
		if (procedureCatalog.getDepartmentName() != null) {
			String descriptionXML = Y41bXMLUtils.quitarNameSpacesString(procedureCatalog.getDepartmentName().copy());
			departamentNameEs = Y41bXMLUtils.getDescLanguageByDesc(Y41bConstantes.CASTELLANO, descriptionXML);

		}
		notificationCreateTask.setDepartmentName(departamentNameEs);
		notificationCreateTask.setManagementUnitID(procedureCatalog.getManagingUnitId());

		String managingUnitNameEs = "";
		if (procedureCatalog.getManagingUnitName() != null) {
			String descriptionXML = Y41bXMLUtils.quitarNameSpacesString(procedureCatalog.getManagingUnitName().copy());
			managingUnitNameEs = Y41bXMLUtils.getDescLanguageByDesc(Y41bConstantes.CASTELLANO, descriptionXML);

		}
		notificationCreateTask.setManagementUnitName(managingUnitNameEs);

		notificationCreateTask.setOrganizationID(procedureCatalog.getEntityCode());
		notificationCreateTask.setYear(crearNotifEJGV.getEjercicio());
		notificationCreateTask.setDaProcedureID(procedureCatalog.getDaProcedureID());
		notificationCreateTask.setFolderNumber(crearNotifEJGV.getNumeroExpediente());
		notificationCreateTask.setNotifiedActID(crearNotifEJGV.getIdTipoNotificacion());
		notificationCreateTask.setNotifiedActName(crearNotifEJGV.getDescTipoNotificacion());

		if (crearNotifEJGV.getSolicitante() != null && !StringUtils.isBlank(crearNotifEJGV.getSolicitante().getDni())
				&& !StringUtils.isBlank(crearNotifEJGV.getSolicitante().getNombre())) {
			notificationCreateTask.setAddresseeID(crearNotifEJGV.getSolicitante().getDni());
			notificationCreateTask.setAddresseeName(crearNotifEJGV.getSolicitante().getNombre());
		} else {
			throw new Y41bUDAException("error.platea.destinatario.datosminimos", true, null);
		}
		notificationCreateTask.setNotificationLanguage(crearNotifEJGV.getIdiomaNotificacion().toLowerCase());

		notificationCreateTask.setNotificationText(crearNotifEJGV.getTextoNotificacion());
		notificationCreateTask.setSenderID(crearNotifEJGV.getSender().getDni());
		notificationCreateTask.setSenderName(crearNotifEJGV.getSender().getNombre());

		com.ejie.servicesIfz.xml.q99MTareaNotificarSchema.NoticesListDocument.NoticesList noticeList = notificationCreateTask
				.addNewNoticesList();
		if (StringUtils.isNotEmpty(crearNotifEJGV.getSolicitante().getMail())) {
			com.ejie.servicesIfz.xml.q99MTareaNotificarSchema.NoticeDocument.Notice notice = noticeList.addNewNotice();
			notice.setChannelType(Y41bConstantes.CHANNELTYPE_NOTIF_EMAIL + "");
			notice.setAddresseName(crearNotifEJGV.getSolicitante().getNombre());
			notice.addNewChannelInfo().setEmailAddress(crearNotifEJGV.getSolicitante().getMail());
		}

		if (StringUtils.isNotEmpty(crearNotifEJGV.getSolicitante().getTelefono())) {
			com.ejie.servicesIfz.xml.q99MTareaNotificarSchema.NoticeDocument.Notice notice = noticeList.addNewNotice();
			notice.setChannelType(Y41bConstantes.CHANNELTYPE_NOTIF_SMS + "");
			notice.setAddresseName(crearNotifEJGV.getSolicitante().getNombre());
			notice.addNewChannelInfo().setSmsNumber(crearNotifEJGV.getSolicitante().getTelefono());
		}

		if (null != crearNotifEJGV.getDocumentosAdjuntos() && crearNotifEJGV.getDocumentosAdjuntos().size() > 0) {
			notificationCreateTask.addNewAttachmentsList()
					.set(Y41bPlateaHelper.addAttachmentListXMLNotificacion(crearNotifEJGV));
		}
		return Y41bXMLUtils.quitarNameSpacesString(notificationCreateTaskDocument);
	}

	/**
	 * Carga el xsl necesario para crear el ejgvDocument
	 * 
	 * @param crearEJGV
	 *            CrearEJGV
	 * @return String. xsl
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	public static String crearXSLSolicitud(CrearEJGV crearEJGV) throws Exception {
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		StringBuffer rutaXsl = new StringBuffer(Y41bConstantes.NUM_200);
		rutaXsl.append(prop.getProperty("RUTA_XSL_SOLICITUD"));
		rutaXsl.append("solicitud_").append(crearEJGV.getProcedure().getIdProcedimiento()).append(".xsl");

		return Y41bUtilsWS.encodeString(new String(Y41bDocumento.leerArchivoOrigen(rutaXsl.toString()), "8859_1"));
	}

	/**
	 * Crea el texto plano de la solicitud
	 * 
	 * @param crearEJGV
	 *            CrearEJGV
	 * @return String: texto plano de la solicitud
	 */
	public static String crearTextoPlanoSolicitud(CrearEJGV crearEJGV) {

		StringBuffer sbDetail = new StringBuffer();
		// Recorremos el HashMap para sacar todas las key
		final Set keys = crearEJGV.getMapaSolicitud().keySet();
		final Iterator it = keys.iterator();
		while (it.hasNext()) {
			final String key = it.next().toString();
			if (!key.startsWith(Y41bConstantes.PREFIJO_CAMPO_OCULTO)) {
				sbDetail.append(key);
				sbDetail.append(":");
				sbDetail.append(crearEJGV.getMapaSolicitud().get(key));
				sbDetail.append("\n");
			}
		}
		List<Documento> listDocumento = crearEJGV.getDocumentosAdjuntos();

		if (listDocumento != null && listDocumento.size() > 0) {
			sbDetail.append("\n");
			sbDetail.append(Y41bConstantes.DOCUMENTOS_AGIRIAK);
			sbDetail.append("\n");
			sbDetail.append(Y41bConstantes.DOCUMENTOS_AGIRIAK_SUB);

			for (Documento documento : crearEJGV.getDocumentosAdjuntos()) {
				sbDetail.append("\n");
				sbDetail.append(Y41bConstantes.DOCUMENTOS_DOCUMENTO + ": " + documento.getNombre() + "."
						+ documento.getExtension() + "\n");
			}
		}

		return sbDetail.toString();
	}

	/**
	 * Crea el xml para el parametro contextSubmission del envío de la
	 * solicitud
	 * 
	 * @param envioEJGV
	 *            EnvioEJGV
	 * @param datosCertificado
	 *            DatosCertificado
	 * @param procedureCatalog
	 *            Procedure
	 * @return String: xml contextSubmision para la llamada al webService de la
	 *         E-Administración
	 * @throws Exception
	 *             Exception
	 */
	public static String crearXMLContentSubmisionEnvio(EnvioEJGV envioEJGV, DatosCertificado datosCertificado,
			Procedure procedureCatalog) throws Exception {

		ContextSubmissionDocument contextSubmissionDocument = ContextSubmissionDocument.Factory.newInstance();
		ContextSubmission contextSubmission = contextSubmissionDocument.addNewContextSubmission();

		contextSubmission.setProcedureID(envioEJGV.getProcedure().getIdProcedimiento());

		contextSubmission.setProcedureName(procedureCatalog.getProcedureName());

		contextSubmission.setDepartmentID(procedureCatalog.getDepartmentId());
		contextSubmission.setManagingUnitID(procedureCatalog.getManagingUnitId());

		contextSubmission.setSenderID(datosCertificado.getFirmante());

		/**
		 * Si el nombre_empresa esta relleno quiere decir que el certificado es
		 * de entidad el nombre del firmante debe ser la empresa
		 */
		String nombreFirmante = datosCertificado.getNombre_empresa();
		if (nombreFirmante == null || StringUtils.isBlank(nombreFirmante.trim())) {
			nombreFirmante = datosCertificado.getNombre() + " " + datosCertificado.getApellidos();
		}

		contextSubmission.setSenderName(nombreFirmante);
		contextSubmission.setSubmissionType(Y41bConstantes.SUBMISSIONTYPE_SOLICITUD);

		contextSubmission.setRegistrySenderID(datosCertificado.getFirmante());
		contextSubmission.setRegistrySenderName(nombreFirmante);
		contextSubmission.setFamilyID(procedureCatalog.getFamilyId());
		contextSubmission.setEntityID(procedureCatalog.getEntityCode());

		String strDesEntityName = Y41bXMLUtils.createLanguageEstructura("description",
				Y41bConstantes.LITERAL_GOBIERNO_VASCO_ES, Y41bConstantes.LITERAL_GOBIERNO_VASCO_EU);
		contextSubmission.setEntityName(XmlObject.Factory.parse(strDesEntityName));

		contextSubmission.setDepartmentName(procedureCatalog.getDepartmentName());

		String strDesSubmissionTypeName = Y41bXMLUtils.createLanguageEstructura("description",
				Y41bConstantes.LITERAL_SOLICITUD_ES, Y41bConstantes.LITERAL_SOLICITUD_EU);
		contextSubmission.setSubmissionTypeName(XmlObject.Factory.parse(strDesSubmissionTypeName));

		contextSubmission.setManagingUnitName(procedureCatalog.getManagingUnitName());

		DataControl dataControl = contextSubmission.addNewDataControl();
		dataControl.setType(Y41bConstantes.DATACONTROL1_TYPE);
		dataControl.setValue(Y41bConstantes.DATACONTROL1_VALUE);

		contextSubmission.setMailbox(procedureCatalog.getProcedureInboxId());

		contextSubmission.setProcedureInboxID(procedureCatalog.getProcedureInboxId());

		contextSubmission.setProcedureInboxName(procedureCatalog.getProcedureInboxName());

		// ApplicantInfo Inicio
		ApplicantInfo applicantInfo = contextSubmission.addNewApplicantInfo();
		applicantInfo.setLanguage(Y41bConstantes.CASTELLANO);
		Persons persons = applicantInfo.addNewPersons();
		Person solicitante = persons.addNewPerson();
		solicitante.setId(envioEJGV.getSolicitante().getDni().trim());
		solicitante.setName(envioEJGV.getSolicitante().getNombre());
		solicitante.setHolderShip(Y41bConstantes.TITULAR);
		solicitante.setPersonType(Y41bConstantes.FISICA);

		if (envioEJGV.getRepresentante() != null) {
			Person representante = persons.addNewPerson();
			representante.setId(envioEJGV.getRepresentante().getDni().trim());
			representante.setName(envioEJGV.getRepresentante().getNombre());
			representante.setHolderShip(Y41bConstantes.REPRESENTANTE);
			representante.setPersonType(Y41bConstantes.FISICA);
		}

		Notification notification = applicantInfo.addNewNotification();
		Addressee direccion = notification.addNewAddressee();
		direccion.setAddresseeID(envioEJGV.getSolicitante().getDni());
		direccion.setAddresseeName(envioEJGV.getSolicitante().getNombre());

		Channel canal = notification.addNewChannel();
		canal.setChannelType(envioEJGV.getTipoNotificacion());

		if (null != envioEJGV.getNotificacionPostal()
				&& Y41bConstantes.POSTAL.equals(envioEJGV.getNotificacionPostal())) {

			NotificacionPostal notificacionPostal = envioEJGV.getNotificacionPostal();

			PostalAddressDocument channelInfo = PostalAddressDocument.Factory.newInstance();
			PostalAddress postal = channelInfo.addNewPostalAddress();
			postal.setPais(notificacionPostal.getPais());
			postal.setDireccion(notificacionPostal.getCalle());
			postal.setLocalidad(notificacionPostal.getLocalidad());
			String provincia = Y41bXMLUtils.createLanguageEstructura("provincia", notificacionPostal.getProvincia());
			postal.setProvincia(XmlObject.Factory.parse(provincia));

			postal.setPortal(notificacionPostal.getPortal());
			postal.setCp(notificacionPostal.getCodigoPostal());

			canal.setChannelInfo(channelInfo);
		} else {
			ChannelInfoDocument.ChannelInfo channelInfo = ChannelInfoDocument.ChannelInfo.Factory.newInstance();
			if (Y41bUtils.isFilled(envioEJGV.getSolicitante().getMail())) {
				channelInfo.setEmailAddress(envioEJGV.getSolicitante().getMail());
			}
			if (Y41bUtils.isFilled(envioEJGV.getSolicitante().getTelefono())) {
				channelInfo.setSmsNumber(envioEJGV.getSolicitante().getTelefono());
			}
			canal.setChannelInfo(channelInfo);
		}

		com.ejie.ctfm.xml.NoticesDocument.Notices notices = applicantInfo.addNewNotices();
		com.ejie.ctfm.xml.NoticeDocument.Notice notice = notices.addNewNotice();
		Addressee addresseeNotice = notice.addNewAddressee();
		addresseeNotice.setAddresseeID(envioEJGV.getSolicitante().getDni());
		addresseeNotice.setAddresseeName(envioEJGV.getSolicitante().getNombre());
		Channel channelNotice = notice.addNewChannel();
		channelNotice.setChannelType(Y41bConstantes.CHANNELTYPE + "");
		ChannelInfoDocument.ChannelInfo channelInfoNotice = ChannelInfoDocument.ChannelInfo.Factory.newInstance();
		if (Y41bUtils.isFilled(envioEJGV.getSolicitante().getMail())) {
			channelInfoNotice.setEmailAddress(envioEJGV.getSolicitante().getMail());
		}
		if (Y41bUtils.isFilled(envioEJGV.getSolicitante().getTelefono())) {
			channelInfoNotice.setSmsNumber(envioEJGV.getSolicitante().getTelefono());
		}
		channelNotice.setChannelInfo(channelInfoNotice);

		// ApplicantInfo Fin
		Documents documents = contextSubmission.addNewDocuments();
		Document document = documents.addNewDocument();
		document.setRoleId(Y41bConstantes.EJGV_APPLICATION);

		String strDesRoleName = Y41bXMLUtils.createLanguageEstructura("description",
				Y41bConstantes.LITERAL_SOLICITUD_ES, Y41bConstantes.LITERAL_SOLICITUD_EU);
		document.setRoleName(XmlObject.Factory.parse(strDesRoleName));
		document.setSourceName(Y41bConstantes.SOURCE_NAME_SOLICITUD);
		document.setExtension(Y41bConstantes.EXTENSION_SOLICITUD);
		document.setDocumentType(Y41bConstantes.DOCUMENT_TYPE_PRE);

		Signatures signatures = document.addNewSignatures();
		Signature signature = signatures.addNewSignature();
		String sign = Y41bPlateaHelper.fncCrearXMLFirmaSimple(envioEJGV.getFirma(), false);
		signature.setSign(XmlObject.Factory.parse(sign.toString()));
		signature.setSignerID(datosCertificado.getFirmante());
		signature.setSignerName(nombreFirmante);

		if (null != envioEJGV.getDocumentosAdjuntos() && envioEJGV.getDocumentosAdjuntos().size() > 0) {
			for (Documento documentoAux : envioEJGV.getDocumentosAdjuntos()) {
				document = documents.addNewDocument();
				document.setLocation(documentoAux.getOidDokusi());
				String strDesRoleNameDocAux = Y41bXMLUtils.createLanguageEstructura("description",
						(documentoAux.getDescripcion() == null ? "" : documentoAux.getDescripcion()),
						(documentoAux.getDescripcion() == null ? "" : documentoAux.getDescripcion()));
				document.addNewRoleName().set(XmlObject.Factory.parse(strDesRoleNameDocAux));
				document.setExtension("." + documentoAux.getExtension());
				document.setDocumentType(documentoAux.getExtension());
				document.setSourceName(documentoAux.getNombre());
				document.setRoleId(documentoAux.getTipoDocumentalTipoSubtipo());
			}
		}

		return Y41bXMLUtils.quitarNameSpacesString(contextSubmissionDocument);

	}

	/**
	 * Método que construye el XML para procesar las esperas
	 * 
	 * @param espera
	 *            Espera
	 * @param procedureCatalog
	 *            Procedure
	 * @param tipoTareaEspera
	 *            Determina si es un tipo de espera de crear o matar
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLEspera(Espera espera, Procedure procedureCatalog, String tipoTareaEspera)
			throws Exception {
		final String tipoEsperaCod = espera.getTipoEspera();
		SaveorupdateProceedingsNTDocument saveorupdateProceedingsNTDocument = SaveorupdateProceedingsNTDocument.Factory
				.newInstance();
		SaveorupdateProceedingsNTType saveorupdateProceedingsNTType = saveorupdateProceedingsNTDocument
				.addNewSaveorupdateProceedingsNT();

		CompleteFolderNumberNTType completeFolderNumberNTType = saveorupdateProceedingsNTType
				.addNewCompleteFolderNumber();
		completeFolderNumberNTType.setProcedureId(procedureCatalog.getProcedureId());
		completeFolderNumberNTType.setExercise(espera.getEjercicio());
		completeFolderNumberNTType.setFolderNumber(espera.getNumeroExpediente());

		saveorupdateProceedingsNTType.setUpdateTimestamp(Calendar.getInstance());

		if (Y41bUtils.isFilled(espera.getIdParticipacion())) {
			saveorupdateProceedingsNTType.setParticipantId(espera.getIdParticipacion().trim());
		} else {
			saveorupdateProceedingsNTType.setParticipantId(espera.getSolicitante().getDni().trim());
		}

		ProceedingsType proceedingsType = saveorupdateProceedingsNTType.addNewProceedings();
		proceedingsType.setProceedingsId(null != espera.getOidEspera() ? espera.getOidEspera() : "");
		proceedingsType.setTimestamp(Calendar.getInstance());
		DescriptionType descriptionType = proceedingsType.addNewDescription();
		Language desLanguage = descriptionType.addNewLanguage();
		desLanguage.setLocale(Y41bConstantes.CASTELLANO);
		desLanguage.setStringValue(Y41bConstantes.ESPERA_DESC_ACTO_NOTIF_ES);
		desLanguage = descriptionType.addNewLanguage();
		desLanguage.setLocale(Y41bConstantes.EUSKERA);
		desLanguage.setStringValue(Y41bConstantes.ESPERA_DESC_ACTO_NOTIF_EU);
		proceedingsType.setManagingUnitId(procedureCatalog.getManagingUnitId());
		DescriptionType descriptionTypeManaging = proceedingsType.addNewManagingUnitName();
		Language languageManaging = descriptionTypeManaging.addNewLanguage();
		String managingUnitNameEs = "";
		String managingUnitNameEu = "";
		if (procedureCatalog.getManagingUnitName() != null) {
			String descriptionXML = Y41bXMLUtils.quitarNameSpacesString(procedureCatalog.getManagingUnitName().copy());
			managingUnitNameEs = Y41bXMLUtils.getDescLanguageByDesc(Y41bConstantes.CASTELLANO, descriptionXML);
			managingUnitNameEu = Y41bXMLUtils.getDescLanguageByDesc(Y41bConstantes.EUSKERA, descriptionXML);
		}
		languageManaging.setLocale(Y41bConstantes.CASTELLANO);
		languageManaging.setStringValue(managingUnitNameEs);
		languageManaging = descriptionTypeManaging.addNewLanguage();
		languageManaging.setLocale(Y41bConstantes.EUSKERA);
		languageManaging.setStringValue(managingUnitNameEu);

		WaitingType waitingType = proceedingsType.addNewWaiting();
		long w = Long.parseLong(tipoEsperaCod);
		waitingType.setWaitingType(BigInteger.valueOf(w));
		DescriptionType descNotificedAct = waitingType.addNewNotifiedAct();
		Language languageNotif = descNotificedAct.addNewLanguage();
		languageNotif.setLocale(Y41bConstantes.CASTELLANO);
		languageNotif.setStringValue(Y41bConstantes.ESPERA_DESC_ACTO_NOTIF_ES);
		languageNotif = descNotificedAct.addNewLanguage();
		languageNotif.setLocale(Y41bConstantes.EUSKERA);
		languageNotif.setStringValue(Y41bConstantes.ESPERA_DESC_ACTO_NOTIF_EU);

		waitingType.setOfficialDeliveryTimestamp(Calendar.getInstance());

		if (Y41bConstantes.TIPO_TAREA_MATAR_ESPERA.equals(tipoTareaEspera)) {
			waitingType.setEndWaitingTimestamp(Calendar.getInstance());
		} else {
			if (espera.getDiasEspera() > 0) {
				Calendar endWaitingDate = Calendar.getInstance();
				endWaitingDate.add(Calendar.DAY_OF_YEAR, espera.getDiasEspera());
				waitingType.setDelayMaxTimestamp(endWaitingDate);
			}
		}

		waitingType.setOrganToSendId(procedureCatalog.getManagingUnitId());
		DescriptionType descOrgan = waitingType.addNewOrganToSendName();
		Language languageOrgan = descOrgan.addNewLanguage();
		languageOrgan.setLocale(Y41bConstantes.CASTELLANO);
		languageOrgan.setStringValue(managingUnitNameEs);
		languageOrgan = descOrgan.addNewLanguage();
		languageOrgan.setLocale(Y41bConstantes.EUSKERA);
		languageOrgan.setStringValue(managingUnitNameEu);
		return Y41bXMLUtils.quitarNameSpacesString(saveorupdateProceedingsNTDocument);
	}

	/**
	 * Método que construye el XML para registrar un historico en Platea
	 * 
	 * @param historico
	 *            Historico
	 * @param procedureCatalog
	 *            Procedure
	 * @return String
	 * @throws Exception
	 *             ex
	 */
	public static String crearXMLRegistrarHistorico(Historico historico, Procedure procedureCatalog) throws Exception {
		Calendar fechaRegistroHistorico = Calendar.getInstance();

		SaveorupdateProceedingsNTDocument saveorupdateProceedingsNTDocument = SaveorupdateProceedingsNTDocument.Factory
				.newInstance();
		SaveorupdateProceedingsNTType saveorupdateProceedingsNTType = saveorupdateProceedingsNTDocument
				.addNewSaveorupdateProceedingsNT();

		CompleteFolderNumberNTType completeFolderNumberNTType = saveorupdateProceedingsNTType
				.addNewCompleteFolderNumber();
		completeFolderNumberNTType.setProcedureId(procedureCatalog.getProcedureId());
		completeFolderNumberNTType.setExercise(historico.getEjercicio());
		completeFolderNumberNTType.setFolderNumber(historico.getNumeroExpediente());

		saveorupdateProceedingsNTType.setUpdateTimestamp(fechaRegistroHistorico);

		saveorupdateProceedingsNTType.setParticipantId(historico.getTitular().getDni().trim());

		ProceedingsType proceedingsType = saveorupdateProceedingsNTType.addNewProceedings();
		proceedingsType.setProceedingsId(null != historico.getIdHistorico() ? historico.getIdHistorico() : "");
		proceedingsType.setTimestamp(fechaRegistroHistorico);
		DescriptionType descriptionType = proceedingsType.addNewDescription();
		Language desLanguage = descriptionType.addNewLanguage();
		desLanguage.setLocale(Y41bConstantes.CASTELLANO);
		desLanguage.setStringValue(Y41bConstantes.HISTORICO_DESC_ACTO_NOTIF_ES);
		desLanguage = descriptionType.addNewLanguage();
		desLanguage.setLocale(Y41bConstantes.EUSKERA);
		desLanguage.setStringValue(Y41bConstantes.HISTORICO_DESC_ACTO_NOTIF_EU);
		proceedingsType.setManagingUnitId(procedureCatalog.getManagingUnitId());
		DescriptionType descriptionTypeManaging = proceedingsType.addNewManagingUnitName();
		Language languageManaging = descriptionTypeManaging.addNewLanguage();
		String managingUnitNameEs = "";
		String managingUnitNameEu = "";
		if (procedureCatalog.getManagingUnitName() != null) {
			String descriptionXML = Y41bXMLUtils.quitarNameSpacesString(procedureCatalog.getManagingUnitName().copy());
			managingUnitNameEs = Y41bXMLUtils.getDescLanguageByDesc(Y41bConstantes.CASTELLANO, descriptionXML);
			managingUnitNameEu = Y41bXMLUtils.getDescLanguageByDesc(Y41bConstantes.EUSKERA, descriptionXML);
		}
		languageManaging.setLocale(Y41bConstantes.CASTELLANO);
		languageManaging.setStringValue(managingUnitNameEs);
		languageManaging = descriptionTypeManaging.addNewLanguage();
		languageManaging.setLocale(Y41bConstantes.EUSKERA);
		languageManaging.setStringValue(managingUnitNameEu);

		NotificationProceedingsType notificationProceedingType = proceedingsType.addNewNotificationProceedings();
		NotificationType notificationType = notificationProceedingType.addNewNotification();
		notificationType.setOfficialDeliveryTimestamp(fechaRegistroHistorico);
		DescriptionType descriptionTypeNotifiedAct = notificationType.addNewNotifiedAct();
		Language languageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
		languageNotifiedAct.setLocale(Y41bConstantes.CASTELLANO);
		languageNotifiedAct.setStringValue(historico.getActoEs());
		languageNotifiedAct = descriptionTypeNotifiedAct.addNewLanguage();
		languageNotifiedAct.setLocale(Y41bConstantes.EUSKERA);
		languageNotifiedAct.setStringValue(historico.getActoEu());
		if (Y41bUtils.isFilled(historico.getResultadoEs())) {
			if (Y41bUtils.isFilled(historico.getOidSolicitud())) {
				com.ejie.r02R.xml.NotificationType.Electronic electronic = notificationType.addNewElectronic();
				electronic.setPublicationTimestamp(fechaRegistroHistorico);
				electronic.setDeliveryTimestamp(fechaRegistroHistorico);
				electronic.setOidnotification(historico.getOidSolicitud());
				DescriptionType descriptionTypeResult = electronic.addNewResult();
				Language languageResult = descriptionTypeResult.addNewLanguage();
				languageResult.setLocale(Y41bConstantes.CASTELLANO);
				languageResult.setStringValue(historico.getResultadoEs());
				languageResult = descriptionTypeNotifiedAct.addNewLanguage();
				languageResult.setLocale(Y41bConstantes.EUSKERA);
				languageResult.setStringValue(historico.getResultadoEu());
			} else {
				com.ejie.r02R.xml.NotificationType.Postal postal = notificationType.addNewPostal();
				postal.setPublicationTimestamp(fechaRegistroHistorico);
				postal.setDeliveryTimestamp(fechaRegistroHistorico);
				DescriptionType descriptionTypeResult = postal.addNewResult();
				Language languageResult = descriptionTypeResult.addNewLanguage();
				languageResult.setLocale(Y41bConstantes.CASTELLANO);
				languageResult.setStringValue(historico.getResultadoEs());
				languageResult = descriptionTypeNotifiedAct.addNewLanguage();
				languageResult.setLocale(Y41bConstantes.EUSKERA);
				languageResult.setStringValue(historico.getResultadoEu());
			}
		}
		return Y41bXMLUtils.quitarNameSpacesString(saveorupdateProceedingsNTDocument);
	}

	/**
	 * Método que construye el XML para eliminar un historico en Platea
	 * 
	 * @param historico
	 *            Historico
	 * @param procedureCatalog
	 *            Procedure
	 * @return String
	 * @throws Exception
	 *             ex
	 */
	public static String crearXMLEliminarHistorico(Historico historico, Procedure procedureCatalog) throws Exception {
		DeleteProceedingsNTDocument deleteProceedingsDocument = DeleteProceedingsNTDocument.Factory.newInstance();
		DeleteProceedingsNTType deleteProceedings = deleteProceedingsDocument.addNewDeleteProceedingsNT();

		CompleteFolderNumberNTType folderNumber = deleteProceedings.addNewCompleteFolderNumber();
		folderNumber.setFolderNumber(historico.getNumeroExpediente());
		folderNumber.setExercise(historico.getEjercicio());
		folderNumber.setProcedureId(historico.getProcedure().getIdProcedimiento());
		deleteProceedings.setParticipantId(historico.getTitular().getDni().trim());
		deleteProceedings.setProceedingsId(historico.getIdHistorico());

		return Y41bXMLUtils.quitarNameSpacesString(deleteProceedingsDocument);
	}

	/**
	 * Crea un XML con la firma simple *
	 * 
	 * @param strPfFirma
	 *            String con la firma @param bolPfXMLTag True si es necesario
	 *            anyadir la primera etiqueta del XML, False si no @return
	 *            String XML con la firma simple @throws
	 */
	public static String fncCrearXMLFirmaSimple(final String strPfFirma, final boolean bolPfXMLTag) {
		StringBuffer sbSignedData = new StringBuffer();
		if (bolPfXMLTag) {
			sbSignedData.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
		}
		sbSignedData.append("<ejgvDocument>");
		sbSignedData.append("<header>");
		sbSignedData.append("<type>SIMPLE_SIGNATURE</type>");
		sbSignedData.append("<version>1.0</version>");
		sbSignedData.append("<flags>0</flags>");
		sbSignedData.append("</header>");
		sbSignedData.append("<body>");
		sbSignedData.append("<simpleSignature>");
		sbSignedData.append(strPfFirma);
		sbSignedData.append("</simpleSignature>");
		sbSignedData.append("</body>");
		sbSignedData.append("</ejgvDocument>");
		return sbSignedData.toString();
	}

	/**
	 * 
	 * @param crearNotifEJGV
	 *            CrearNotifEJGV
	 * @return AttachmentsList attachmentsList para notificationCreateTask
	 * @throws Exception
	 *             Exception
	 */
	private static AttachmentsList addAttachmentListXMLNotificacion(CrearNotifEJGV crearNotifEJGV) throws Exception {
		AttachmentsListDocument attachmentsListDocument = AttachmentsListDocument.Factory.newInstance();
		AttachmentsList attachmentsListET = attachmentsListDocument.addNewAttachmentsList();
		// arrDocumentos
		List<Documento> arrDocumentos = crearNotifEJGV.getDocumentosAdjuntos();
		Documento docType = null;
		if (arrDocumentos != null && arrDocumentos.size() > 0) {
			for (int i = 0; i < arrDocumentos.size(); i++) {
				docType = arrDocumentos.get(i);
				// DOCUMENTOS EN RDE/DOKUSI, TIENEN OID
				com.ejie.servicesIfz.xml.q99MTareaNotificarSchema.AttachmentDocument.Attachment attachment = attachmentsListET
						.addNewAttachment();
				if (Y41bUtils.isFilled(docType.getOidDokusi())) {
					attachment.setDocumentOID(docType.getOidDokusi());
				}
				if (Y41bUtils.isFilled(docType.getTipoDocumental())) {
					attachment.setDocumentRolID(docType.getTipoDocumentalTipoSubtipo());
				}

				if (Y41bUtils.isFilled(docType.getDescripcion())) {

					String strDesSubmissionTypeName = Y41bXMLUtils.createLanguageEstructura("description",
							docType.getDescripcion(), docType.getDescripcion());
					attachment.setDocumentRolName(XmlObject.Factory.parse(strDesSubmissionTypeName));
				}

				if (Y41bUtils.isFilled(docType.getNombre())) {
					attachment.setDocumentName(Y41bUtils
							.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(docType.getNombre())));
				}
				if (Y41bUtils.isFilled(docType.getExtension())) {
					attachment.setDocumentExtension(docType.getExtension());
				}
				if (Y41bUtils.isFilled(docType.getTieneLocalizador())
						&& Y41bConstantes.SI.equals(docType.getTieneLocalizador())) {
					attachment.setName(Y41bConstantes.PDFA);
				}
			}
		}
		return attachmentsListDocument.getAttachmentsList();
	}

	/**
	 * Crear xml para la apertura de un expediente telemático
	 * 
	 * @param actualizarExpediente
	 *            ActualizarExpediente
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLActualizacionParticipantExpediente(ActualizarExpediente actualizarExpediente,
			Procedure procedureCatalog) throws Exception {

		SaveOrUpdateParticipantNTDocument expedientNTDocument = SaveOrUpdateParticipantNTDocument.Factory.newInstance();
		SaveOrUpdateParticipantNTType expedientNTType = expedientNTDocument.addNewSaveOrUpdateParticipantNT();

		CompleteFolderNumberNTType completeFolderNumberNTType = expedientNTType.addNewCompleteFolderNumber();

		completeFolderNumberNTType.setProcedureId(actualizarExpediente.getProcedure().getIdProcedimiento());

		completeFolderNumberNTType.setExercise(actualizarExpediente.getEjercicio());
		completeFolderNumberNTType.setFolderNumber(actualizarExpediente.getNumeroExpediente());

		expedientNTType.setUpdateTimestamp(Calendar.getInstance());

		// ParticipantType participant = expedientNTType.addNewParticipant();

		if (Y41bUtils.isFilled(actualizarExpediente.getIdParticipacion())) {
			expedientNTType.setParticipantId(actualizarExpediente.getIdParticipacion().trim());
		} else {
			expedientNTType.setParticipantId(actualizarExpediente.getSolicitante().getDni().trim());
		}

		expedientNTType
				.setRole(com.ejie.r02R.xml.SaveOrUpdateParticipantNTType.Role.Enum.forString(Y41bConstantes.APPLICANT));

		if (StringUtils.isEmpty(actualizarExpediente.getSolicitante().getIdioma())) {
			expedientNTType.setLanguage(
					com.ejie.r02R.xml.SaveOrUpdateParticipantNTType.Language.Enum.forString(Y41bConstantes.CASTELLANO));
		} else {
			expedientNTType.setLanguage(com.ejie.r02R.xml.SaveOrUpdateParticipantNTType.Language.Enum
					.forString(actualizarExpediente.getSolicitante().getIdioma().toLowerCase()));
		}

		NoticeChanelType noticeChanelType = expedientNTType.addNewNoticeChanel();
		if (actualizarExpediente.getSolicitante().getTelefono() != null) {
			// noticeChanelType.addPhone(actualizarExpediente.getSolicitante().getTelefono());
			noticeChanelType.addSms(actualizarExpediente.getSolicitante().getTelefono());
		}
		if (actualizarExpediente.getSolicitante().getMail() != null) {
			noticeChanelType.addEmail(actualizarExpediente.getSolicitante().getMail());
		}

		NotificationChanelType notificationChanelType = expedientNTType.addNewNotificationChanel();
		if (StringUtils.isBlank(actualizarExpediente.getTipoNotificacion())
				|| actualizarExpediente.getTipoNotificacion().equals(Y41bConstantes.ELECTRONICO)) {
			notificationChanelType.setElectronic("");
		} else {
			Postal postal = notificationChanelType.addNewPostal();
			postal.setStreet(actualizarExpediente.getNotificacionPostal().getCalle());
			DescriptionType descriptionProvincia = postal.addNewProvince();
			Language languageProv = descriptionProvincia.addNewLanguage();
			languageProv.setLocale(Y41bConstantes.EUSKERA);
			languageProv.setStringValue(actualizarExpediente.getNotificacionPostal().getProvincia());
			languageProv = descriptionProvincia.addNewLanguage();
			languageProv.setLocale(Y41bConstantes.CASTELLANO);
			languageProv.setStringValue(actualizarExpediente.getNotificacionPostal().getProvincia());

			DescriptionType descriptionTown = postal.addNewTown();
			Language languageTown = descriptionTown.addNewLanguage();
			languageTown.setLocale(Y41bConstantes.EUSKERA);
			languageTown.setStringValue(actualizarExpediente.getNotificacionPostal().getMunicipio());
			languageTown = descriptionTown.addNewLanguage();
			languageTown.setLocale(Y41bConstantes.CASTELLANO);
			languageTown.setStringValue(actualizarExpediente.getNotificacionPostal().getMunicipio());

			postal.setZipcode(actualizarExpediente.getNotificacionPostal().getCodigoPostal());
		}

		ParticipantsType participantsType = expedientNTType.addNewParticipants();

		PersonType holder = participantsType.addNewHolder();
		holder.setType(BigInteger.ONE);
		holder.setId(actualizarExpediente.getSolicitante().getDni().trim());
		holder.setNombre(StringEscapeUtils.escapeHtml(actualizarExpediente.getSolicitante().getNombre()));

		if (Y41bUtils.isFilled(actualizarExpediente.getSolicitante().getApellido1())) {
			holder.setApellido1(StringEscapeUtils.escapeHtml(actualizarExpediente.getSolicitante().getApellido1()));
		} else {
			holder.setApellido1(".");
		}

		if (actualizarExpediente.getRepresentante() != null
				&& StringUtils.isNotBlank(actualizarExpediente.getRepresentante().getDni())) {
			PersonType representante = participantsType.addNewRepresentative();
			representante.setId(actualizarExpediente.getRepresentante().getDni().trim());
			representante.setNombre(StringEscapeUtils.escapeHtml(actualizarExpediente.getRepresentante().getNombre()));

			if (Y41bUtils.isFilled(actualizarExpediente.getRepresentante().getApellido1())) {
				representante.setApellido1(
						StringEscapeUtils.escapeHtml(actualizarExpediente.getRepresentante().getApellido1()));
			} else {
				representante.setApellido1(".");
			}
			representante.setType(BigInteger.ONE);
		}

		return Y41bXMLUtils.quitarNameSpacesString(expedientNTDocument);
	}

	/**
	 * Crear xml para la apertura de un expediente telemático
	 * 
	 * @param actualizarExpediente
	 *            ActualizarExpediente
	 * @param procedureCatalog
	 *            Procedure
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static String crearXMLCancelCloseExpediente(ActualizarExpediente actualizarExpediente,
			Procedure procedureCatalog) throws Exception {

		CancelcloseExpedientNTDocument cancelCloseNTDocument = CancelcloseExpedientNTDocument.Factory.newInstance();

		CancelcloseExpedientNTType cancelCloseNTType = cancelCloseNTDocument.addNewCancelcloseExpedientNT();

		CompleteFolderNumberNTType completeFolderNumberNTType = cancelCloseNTType.addNewCompleteFolderNumber();

		completeFolderNumberNTType.setProcedureId(actualizarExpediente.getProcedure().getIdProcedimiento());

		completeFolderNumberNTType.setExercise(actualizarExpediente.getEjercicio());
		completeFolderNumberNTType.setFolderNumber(actualizarExpediente.getNumeroExpediente());

		cancelCloseNTType.setUpdateTimestamp(Calendar.getInstance());

		// probar

		return Y41bXMLUtils.quitarNameSpacesString(cancelCloseNTDocument);
	}

	/**
	 * Crear xml para el envio de notificacin telemtica
	 * 
	 * @param crearNotifEJGV
	 *            CrearNotifEJGV
	 * @throws Exception
	 *             ex
	 * @return String
	 */
	public static TNotificationCreateNew crearXMLTNotificationCreateNew(CrearNotifEJGV crearNotifEJGV)
			throws Exception {

		TNotificationCreateNew tNotificationCreateNew = new TNotificationCreateNew();

		tNotificationCreateNew.setNotifiedActID(crearNotifEJGV.getIdTipoNotificacion());
		tNotificationCreateNew.setFolderNumber(crearNotifEJGV.getNumeroExpediente());
		tNotificationCreateNew.setYear(crearNotifEJGV.getEjercicio());
		tNotificationCreateNew.setProcedureID(crearNotifEJGV.getProcedure().getIdProcedimiento());

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		tNotificationCreateNew.setDaDocumentalSerieId(
				new Integer(prop.getProperty(crearNotifEJGV.getProcedure().getIdProcedimiento() + ".serie."
						+ Y41bDokusiHelper.getProvSerieFromNumExp(crearNotifEJGV.getNumeroExpediente()))).intValue());

		tNotificationCreateNew.setFormat(TNotificationType.ELECTRONICA);

		com.ejie.y41b.ws.cliente.x43notificaciones.TPersonIDName senderID = new com.ejie.y41b.ws.cliente.x43notificaciones.TPersonIDName();
		senderID.setID(crearNotifEJGV.getSender().getDni());
		senderID.setName(crearNotifEJGV.getSender().getNombre());
		tNotificationCreateNew.setSenderID(senderID);

		com.ejie.y41b.ws.cliente.x43notificaciones.TPersonIDName addresseeID = new com.ejie.y41b.ws.cliente.x43notificaciones.TPersonIDName();

		if (crearNotifEJGV.getSolicitante() != null && !StringUtils.isBlank(crearNotifEJGV.getSolicitante().getDni())
				&& !StringUtils.isBlank(crearNotifEJGV.getSolicitante().getNombre())) {
			addresseeID.setID(crearNotifEJGV.getSolicitante().getDni());
			addresseeID.setName(crearNotifEJGV.getSolicitante().getNombre());
			tNotificationCreateNew.setAddresseeID(addresseeID);
		} else {
			throw new Y41bUDAException("error.platea.destinatario.datosminimos", true, null);
		}

		tNotificationCreateNew.setText(crearNotifEJGV.getTextoNotificacion());

		if (crearNotifEJGV.getIdiomaNotificacion() != null
				&& crearNotifEJGV.getIdiomaNotificacion().toLowerCase() != null
				&& crearNotifEJGV.getIdiomaNotificacion().toLowerCase().equals(Y41bConstantes.EUSKERA)) {
			tNotificationCreateNew.setLanguage(com.ejie.y41b.ws.cliente.x43notificaciones.TLanguage.EU);
		} else {
			tNotificationCreateNew.setLanguage(com.ejie.y41b.ws.cliente.x43notificaciones.TLanguage.ES);
		}

		TNoticeMessage tNoticeMessage = new TNoticeMessage();
		TNoticeAddresseeList tNoticeAddresseeList = new TNoticeAddresseeList();
		List<TNoticeAddressee> listTNoticeAddressee = tNoticeAddresseeList.getItem();

		if (StringUtils.isNotEmpty(crearNotifEJGV.getSolicitante().getMail())) {
			TNoticeAddressee tNoticeAddressee = new TNoticeAddressee();
			tNoticeAddressee.setAddressee(addresseeID);

			if (StringUtils.isNotEmpty(crearNotifEJGV.getSolicitante().getMail())) {
				TNoticeChannel tNoticeChannel = new TNoticeChannel();

				tNoticeChannel.setChannelType(TNoticeType.EMAIL);
				tNoticeChannel.setEmail(crearNotifEJGV.getSolicitante().getMail());

				tNoticeAddressee.setChannel(tNoticeChannel);
			}
			listTNoticeAddressee.add(tNoticeAddressee);
		}

		if (StringUtils.isNotEmpty(crearNotifEJGV.getSolicitante().getTelefono())) {
			TNoticeAddressee tNoticeAddressee = new TNoticeAddressee();
			tNoticeAddressee.setAddressee(addresseeID);

			if (StringUtils.isNotEmpty(crearNotifEJGV.getSolicitante().getTelefono())) {
				TNoticeChannel tNoticeChannel = new TNoticeChannel();
				tNoticeChannel.setChannelType(TNoticeType.SMS);
				tNoticeChannel.setSms(crearNotifEJGV.getSolicitante().getTelefono());
				tNoticeAddressee.setChannel(tNoticeChannel);
			}

			listTNoticeAddressee.add(tNoticeAddressee);
		}

		// 0155918: Fallo en el servicio de notificaciones por no disponer de
		// datos de aviso
		// Se procede a construir el bloque independientemente de que exista
		// contenido (mail y/o telefono)
		// if (StringUtils.isNotEmpty(crearNotifEJGV.getSolicitante().getMail())
		// || StringUtils.isNotEmpty(crearNotifEJGV.getSolicitante()
		// .getTelefono())) {

		tNoticeMessage.setAddresseeList(tNoticeAddresseeList);

		tNotificationCreateNew.setNotice(tNoticeMessage);
		// }

		if (null != crearNotifEJGV.getDocumentosAdjuntos() && crearNotifEJGV.getDocumentosAdjuntos().size() > 0) {
			tNotificationCreateNew
					.setAttachmentList(Y41bPlateaHelper.addAttachmentListXMLNotificacionX43(crearNotifEJGV));
		}

		return tNotificationCreateNew;
	}

	/**
	 * 
	 * @param crearNotifEJGV
	 *            CrearNotifEJGV
	 * @return TAttachmentList attachmentsList para notificationCreateTask
	 * @throws Exception
	 *             Exception
	 */
	private static TAttachmentList addAttachmentListXMLNotificacionX43(CrearNotifEJGV crearNotifEJGV) throws Exception {
		TAttachmentList tAttachmentList = new TAttachmentList();
		List<com.ejie.y41b.ws.cliente.x43notificaciones.TAttachment> listTAttachment = tAttachmentList.getAttachment();

		// arrDocumentos
		List<Documento> arrDocumentos = crearNotifEJGV.getDocumentosAdjuntos();
		Documento docType = null;
		if (arrDocumentos != null && arrDocumentos.size() > 0) {
			for (int i = 0; i < arrDocumentos.size(); i++) {
				docType = arrDocumentos.get(i);
				// DOCUMENTOS EN RDE/DOKUSI, TIENEN OID
				com.ejie.y41b.ws.cliente.x43notificaciones.TAttachment attachment = new com.ejie.y41b.ws.cliente.x43notificaciones.TAttachment();
				if (Y41bUtils.isFilled(docType.getOidDokusi())) {
					attachment.setDokusiID(docType.getOidDokusi());
				}
				if (Y41bUtils.isFilled(docType.getTipoDocumental())) {
					attachment.setDocumentRoleID(docType.getTipoDocumentalTipoSubtipo());
				}

				if (Y41bUtils.isFilled(docType.getDescripcion())) {

					com.ejie.y41b.ws.cliente.x43notificaciones.TTextI18N value = new com.ejie.y41b.ws.cliente.x43notificaciones.TTextI18N();
					List<com.ejie.y41b.ws.cliente.x43notificaciones.TStringI18N> listTStringI18N = value.getText();
					com.ejie.y41b.ws.cliente.x43notificaciones.TStringI18N tStringI18N = new com.ejie.y41b.ws.cliente.x43notificaciones.TStringI18N();
					tStringI18N.setLocale(com.ejie.y41b.ws.cliente.x43notificaciones.TLanguage.ES);
					tStringI18N.setValue(docType.getDescripcion());
					listTStringI18N.add(tStringI18N);

					tStringI18N = new com.ejie.y41b.ws.cliente.x43notificaciones.TStringI18N();
					tStringI18N.setLocale(com.ejie.y41b.ws.cliente.x43notificaciones.TLanguage.EU);
					tStringI18N.setValue(docType.getDescripcion());
					listTStringI18N.add(tStringI18N);

					attachment.setDocumentRoleName(value);
				}

				if (Y41bUtils.isFilled(docType.getNombre())) {
					attachment.setSourceName(Y41bUtils
							.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(docType.getNombre())));
				}
				if (Y41bUtils.isFilled(docType.getExtension())) {
					attachment.setExtension(docType.getExtension());
				}
				if (Y41bUtils.isFilled(docType.getTieneLocalizador())
						&& Y41bConstantes.SI.equals(docType.getTieneLocalizador())) {
					attachment.setFormat(Y41bConstantes.PDFA);
				}

				listTAttachment.add(attachment);
			}
		}
		return tAttachmentList;
	}
}
