package com.ejie.y41b.adapter.helper;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;

import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.stereotype.Component;

import com.ejie.cp.xml.ProcedureDocument;
import com.ejie.y31.vo.Y31AttachmentBean;
import com.ejie.y41b.adapter.Y41bPifAdapterService;
import com.ejie.y41b.adapter.services.NSHFServiceImpl;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.contextprovider.AppContext;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.Firma;
import com.ejie.y41b.model.dokusi.Formato;
import com.ejie.y41b.model.dokusi.Metadato;
import com.ejie.y41b.model.sir.retrieveRegistryDocuments.DocumentIDList;
import com.ejie.y41b.model.sir.retrieveRegistryDocuments.DocumentIDList.DocumentID;
import com.ejie.y41b.model.sir.schemaSIRRetrieveDocumentsContent.ContentList;
import com.ejie.y41b.model.sir.schemaSIRRetrieveDocumentsContent.ContentList.Content;
import com.ejie.y41b.model.sir.schemaSIRStringList.StringListList;
import com.ejie.y41b.model.sir.schemaSIRStringList.StringListList.StringList;
import com.ejie.y41b.nshf.Body;
import com.ejie.y41b.nshf.EjgvDocument;
import com.ejie.y41b.nshf.EjgvDocumentType;
import com.ejie.y41b.nshf.Header;
import com.ejie.y41b.nshf.VerificationResultType;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.xml.Y41bXMLUtils;

import noNamespace.ConditionListDocument;
import noNamespace.SignatureListDocument;
import noNamespace.StringListDocument;
import noNamespace.T65BAttributeListListType;
import noNamespace.T65BAttributeListType;
import noNamespace.T65BAttributeType;
import noNamespace.T65BConditionListType;
import noNamespace.T65BConditionType;
import noNamespace.T65BContentListType;
import noNamespace.T65BContentType;
import noNamespace.T65BDocumentIDListType;
import noNamespace.T65BDocumentIDType;
import noNamespace.T65BFormatListType;
import noNamespace.T65BFormatType;
import noNamespace.T65BSignatureInfoListType;
import noNamespace.T65BSignatureInfoType;
import noNamespace.T65BSignatureListType;
import noNamespace.T65BSignatureType;
import noNamespace.T65BStringListType;

/**
 * <p>
 * Titulo: Y41bDokusiHelper
 * </p>
 * <p>
 * Descripcion: Contiene metodos para crear los parametros de envio en las
 * llamadas a los WebServices de Dokusi
 * </p>
 * <p>
 * Copyright: Copyright (c) 2013
 * </p>
 * <p>
 * Empresa: Bilbomatica
 * </p>
 * 
 *  
 * @version 1.0
 */
@Component(value = "Y41bDokusiHelper")
public final class Y41bDokusiHelper {

	private static Y41bPifAdapterService y41bPifAdapterService;

	/**
	 * Constructor
	 */
	private Y41bDokusiHelper() {
		super();
	}

	/**
	 * @param procedimiento
	 *            id_procedure
	 * @param dni
	 *            identificacion del usuario
	 * @param nombre
	 *            del usuario
	 * @return the auditUser
	 */
	public static String getAuditUser(String procedimiento, String dni, String nombre) {
		return new StringBuffer().append(dni).append("#").append(nombre).append("#").append(dni).append("#")
				.append(procedimiento).toString();
	}

	/**
	 * Método que crea el xml SearchConditionsList
	 * 
	 * @param metadatos
	 *            List<Metadato>
	 * @return xmlSearchConditionsList String
	 * @throws Exception
	 *             Exception
	 */
	public static String crearXMLSearchConditionsList(final List<Metadato> metadatos) throws Exception {

		ConditionListDocument conditionListDocument = ConditionListDocument.Factory.newInstance();
		T65BConditionListType condicionesFiltroDocumentum = conditionListDocument.addNewConditionList();

		if (metadatos != null) {
			if (metadatos != null) {
				for (int index = 0; index < metadatos.size(); index++) {
					Metadato metadato = metadatos.get(index);
					T65BConditionType condicion = condicionesFiltroDocumentum.addNewCondition();
					T65BAttributeType atributo = condicion.addNewAttribute();
					atributo.setKey(metadato.getNombre());
					atributo.setValue(metadato.getValor());
					condicion.setOperator(metadato.getOperador());
				}
			}
		}
		return Y41bXMLUtils.quitarNameSpacesString(conditionListDocument);
	}

	/**
	 * Método que crea el xml ReturnedAttributeKeysList
	 * 
	 * @param metadatos
	 *            List<Metadato>
	 * 
	 * @return xmlReturnedAttributeKeysList String
	 * @throws Exception
	 *             Exception
	 */
	public static String crearXMLReturnedAttributeKeysList(List<Metadato> metadatos) throws Exception {
		StringListDocument listaAtributos = StringListDocument.Factory.newInstance();

		T65BStringListType t65BStringListType = listaAtributos.addNewStringList();

		// Añadimos los metadatos al documento
		if (metadatos != null && metadatos.size() > 0) {
			for (Metadato metadato : metadatos) {

				t65BStringListType.addElement(metadato.getNombre());
			}
		}
		return Y41bXMLUtils.quitarNameSpacesString(listaAtributos);
	}

	/**
	 * Método que crea el xml ReturnedAttributeKeysList
	 * 
	 * @param metadatos
	 *            List<Metadato>
	 * 
	 * @return xmlReturnedAttributeKeysList String
	 * @throws Exception
	 *             Exception
	 */
	public static String crearXMLReturnedAttributeKeysListSIR(List<Metadato> metadatos) throws Exception {
		StringListList stringListList = new StringListList();

		StringList stringList = new StringList();

		// Añadimos los metadatos al documento
		if (metadatos != null && metadatos.size() > 0) {
			for (Metadato metadatoAux : metadatos) {
				stringList.getElement().add(metadatoAux.getNombre());
			}
		}
		stringListList.setStringList(stringList);

		JAXBContext jaxbContext = JAXBContext.newInstance(StringListList.class);
		StringWriter writer = new StringWriter();
		Marshaller m = jaxbContext.createMarshaller();
		m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);

		jaxbContext.createMarshaller().marshal(stringListList, writer);

		return writer.toString();
	}

	/**
	 * Método que crea el xml AttributeList
	 * 
	 * @param documento
	 *            Documento
	 * @param procedureDocument
	 *            ProcedureDocument
	 * 
	 * @return xmlAttributeList String
	 * @throws Exception
	 *             Exception
	 */
	public static String crearXMLAttributeList(Documento documento, ProcedureDocument procedureDocument)
			throws Exception {

		T65BAttributeListListType t65BAttributeListListType = T65BAttributeListListType.Factory.newInstance();

		T65BAttributeListType listaAtributos = t65BAttributeListListType.addNewAttributeList();

		List<Metadato> metadatos = documento.getMetadatos();

		// Añadimos los metadatos al documento
		if (metadatos != null && metadatos.size() > 0) {
			for (Metadato metadato : metadatos) {
				T65BAttributeType atributo = listaAtributos.addNewAttribute();

				atributo.setKey(metadato.getNombre());
				atributo.setValue(metadato.getValor());
			}
		}

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		T65BAttributeType atributo = listaAtributos.addNewAttribute();

		atributo.setKey("ejgv_naturaleza");
		if (Y41bUtils.isFilled(documento.getNaturaleza())) {
			atributo.setValue(documento.getNaturaleza());
		} else {
			atributo.setValue(Y41bConstantes.NATURALEZA_ELECTRONICO);
		}

		atributo = listaAtributos.addNewAttribute();
		atributo.setKey("ejgv_procedimiento");
		atributo.setValue(procedureDocument.getProcedure().getDaProcedureID());

		if (Y41bUtils.isFilled(Y41bUtils.getNameFile(documento.getNombre()))) {
			atributo = listaAtributos.addNewAttribute();
			atributo.setKey("object_name");
			atributo.setValue(Y41bUtils.removeAcentosCaracteresEspeciales(
					StringEscapeUtils.unescapeHtml(Y41bUtils.getNameFile(documento.getNombre()))));
		} else {
			atributo = listaAtributos.addNewAttribute();
			atributo.setKey("object_name");
			atributo.setValue(
					Y41bUtils.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(documento.getNombre())));
		}

		atributo = listaAtributos.addNewAttribute();
		atributo.setKey("title");
		atributo.setValue(
				Y41bUtils.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(documento.getNombre())));

		atributo = listaAtributos.addNewAttribute();
		atributo.setKey("ejgv_serie");
		atributo.setValue(prop.getProperty(documento.getProcedure().getIdProcedimiento() + ".serie."
				+ Y41bDokusiHelper.getProvSerieFromNumExp(documento.getNumeroExpediente())));

		atributo = listaAtributos.addNewAttribute();
		atributo.setKey("ejgv_origen");
		atributo.setValue(documento.getOrigenDocumento());

		atributo = listaAtributos.addNewAttribute();
		atributo.setKey("acl_name");
		atributo.setValue(prop.getProperty(Y41bConstantes.ACL_NOMBRE));

		if (Y41bUtils.isFilled(documento.getNumeroExpediente())) {
			atributo = listaAtributos.addNewAttribute();
			atributo.setKey("ejgv_expediente");
			atributo.setValue(documento.getNumeroExpediente());
		}

		atributo = listaAtributos.addNewAttribute();
		atributo.setKey("ejgv_proc_infraestructura");
		atributo.setValue(documento.getProcedure().getIdProcedimiento());

		if (Y41bUtils.isFilled(documento.getRegistryNumber())) {
			atributo = listaAtributos.addNewAttribute();
			atributo.setKey("ejgv_num_registro");
			atributo.setValue(documento.getRegistryNumber());

			atributo = listaAtributos.addNewAttribute();
			atributo.setKey("ejgv_formato_registro");
			atributo.setValue(documento.getExtension());
		}
		if (Y41bUtils.isFilled(documento.getRegistryTimestamp())) {
			atributo = listaAtributos.addNewAttribute();
			atributo.setKey("ejgv_fecha_registro");
			atributo.setValue(documento.getRegistryTimestamp());
		}

		if (Y41bUtils.isFilled(documento.getEntradaSalida())) {
			atributo = listaAtributos.addNewAttribute();
			atributo.setKey("ejgv_entrada_salida");
			atributo.setValue(documento.getEntradaSalida());
		}

		if (Y41bUtils.isFilled(documento.getTipoDocumental())
				&& documento.getTipoDocumental().equals(Y41bConstantes.TIPO_DOC_BOLETIN)) {
			atributo = listaAtributos.addNewAttribute();
			atributo.setKey("ejgv_tipo_boletin");
			atributo.setValue(Y41bConstantes.EJGV_TIPO_BOLETIN_BOPV);
		}

		if (Y41bUtils.isFilled(documento.getTipoDocumental())
				&& documento.getTipoDocumental().equals(Y41bConstantes.TIPO_DOC_SENTENCIA)) {
			if (Y41bUtils.isFilled(documento.getNumeroExpediente())) {
				atributo = listaAtributos.addNewAttribute();
				atributo.setKey("ejgv_num_sentencia");
				atributo.setValue(documento.getNumeroExpediente());
			}

			atributo = listaAtributos.addNewAttribute();
			atributo.setKey("ejgv_fecha_sentencia");
			java.util.Date date = new java.util.Date();
			atributo.setValue(Y41bUtils.fncParsearFechaLargaAlternativa(new Timestamp(date.getTime())));
		}

		if (Y41bUtils.isFilled(documento.getTipoDocumental())
				&& documento.getTipoDocumental().equals(Y41bConstantes.TIPO_DOC_FACTURA)) {
			if (Y41bUtils.isFilled(documento.getNombre())) {
				atributo = listaAtributos.addNewAttribute();
				atributo.setKey("ejgv_num_factura");
				atributo.setValue(Y41bUtils
						.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(documento.getNombre())));
			}
		}

		return Y41bXMLUtils.quitarNameSpacesString(t65BAttributeListListType);
	}

	/**
	 * Método que crea el xml AttributeList para modificar documento
	 * 
	 * @param documento
	 *            Documento
	 * 
	 * @return xmlAttributeList String
	 * @throws Exception
	 *             Exception
	 */
	public static String crearXMLAttributeListModificacion(Documento documento) throws Exception {

		T65BAttributeListListType t65BAttributeListListType = T65BAttributeListListType.Factory.newInstance();

		T65BAttributeListType listaAtributos = t65BAttributeListListType.addNewAttributeList();

		List<Metadato> metadatos = documento.getMetadatos();

		// Añadimos los metadatos al documento
		if (metadatos != null && metadatos.size() > 0) {
			for (Metadato metadato : metadatos) {
				T65BAttributeType atributo = listaAtributos.addNewAttribute();

				atributo.setKey(metadato.getNombre());
				atributo.setValue(metadato.getValor());
			}
		}
		return Y41bXMLUtils.quitarNameSpacesString(t65BAttributeListListType);
	}

	/**
	 * Método que crea el xml content
	 * 
	 * @return saveTask String
	 */
	public static String crearXMLContent() {

		T65BContentListType contentToStore = T65BContentListType.Factory.newInstance();
		T65BContentType content = contentToStore.addNewContent();
		T65BFormatType format = content.addNewFormat();
		format.setName(Y41bConstantes.NATURALEZA_PAPEL);

		return contentToStore.xmlText();
	}

	/**
	 * Método que crea el xml content
	 * 
	 * @param name
	 *            nombre del documento
	 * 
	 * @param extension
	 *            el documento
	 * @param bytes
	 *            array de bytes con el contenido del fichero
	 * @return saveTask String
	 */
	public static String crearXMLContent(final String name, final String extension, byte[] bytes) {

		T65BContentListType contentToStore = T65BContentListType.Factory.newInstance();
		T65BContentType content = contentToStore.addNewContent();
		content.setContent(bytes);
		content.setDocLocation("");
		content.setLenght(bytes.length);
		T65BFormatType t65BFormatType = content.addNewFormat();
		t65BFormatType
				.setDescription(Y41bUtils.removeAcentosCaracteresEspeciales(StringEscapeUtils.unescapeHtml(name)));
		t65BFormatType.setExtension(extension);

		return contentToStore.xmlText();
	}

	/**
	 * Método que crea el xml content
	 * 
	 * @param extension
	 *            el documento
	 * @param bytes
	 *            array de bytes con el contenido del fichero
	 * @return saveTask String
	 */
	public static String crearXMLContent(final String extension, byte[] bytes) {

		T65BContentListType contentToStore = T65BContentListType.Factory.newInstance();
		T65BContentType content = contentToStore.addNewContent();
		content.setContent(bytes);
		content.setDocLocation("");
		content.setLenght(bytes.length);
		T65BFormatType t65BFormatType = content.addNewFormat();
		t65BFormatType.setExtension(extension);

		return contentToStore.xmlText();
	}

	/**
	 * étodo que crea el xml documentID
	 * 
	 * @param oidDokusi
	 *            id del documento en dokusi
	 * @return String documentIDRetornado
	 */
	public static String crearXMLdocumentID(String oidDokusi) {

		T65BDocumentIDListType t65BDocumentIDListType = T65BDocumentIDListType.Factory.newInstance();
		T65BDocumentIDType t65BDocumentIDType = t65BDocumentIDListType.addNewDocumentID();
		t65BDocumentIDType.setId(oidDokusi);

		return t65BDocumentIDListType.xmlText();
	}

	/**
	 * étodo que crea el xml documentID SIR
	 * 
	 * @param oidDokusi
	 *            id del documento en dokusi
	 * @return String documentIDRetornado
	 * @throws JAXBException
	 */
	public static String crearXMLdocumentIDSIR(String oidDokusi) throws JAXBException {

		DocumentIDList documentIDList = new DocumentIDList();
		DocumentID documentID = new DocumentID();
		documentID.setId(oidDokusi);
		documentIDList.getDocumentID().add(documentID);

		JAXBContext jaxbContext = JAXBContext.newInstance(DocumentIDList.class);
		StringWriter writer = new StringWriter();
		Marshaller m = jaxbContext.createMarshaller();
		m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);

		jaxbContext.createMarshaller().marshal(documentIDList, writer);
		return writer.toString();
	}

	/**
	 * Mtodo que crea el xml content
	 * 
	 * @param name
	 *            del documento
	 * @param pifId
	 *            pif
	 * @return saveTask String
	 */
	public static String crearXMLContentName(final String name, final String pifId) {
		T65BContentListType t65BContentListType = T65BContentListType.Factory.newInstance();
		T65BContentType t65BContentType = t65BContentListType.addNewContent();
		t65BContentType.addNewFormat().setName(name);

		t65BContentType.setPifId(pifId);
		return t65BContentListType.xmlText();
	}

	/**
	 * Mtodo que crea el xml content
	 * 
	 * @param pifId
	 *            pif
	 * @return String
	 * @throws JAXBException
	 */
	public static String crearXMLContentNameSIR(final String pifId) throws JAXBException {
		ContentList contentList = new ContentList();
		Content content = new Content();
		content.setPifId(pifId);
		contentList.getContent().add(content);

		JAXBContext jaxbContext = JAXBContext.newInstance(ContentList.class);
		StringWriter writer = new StringWriter();
		Marshaller m = jaxbContext.createMarshaller();
		m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);

		jaxbContext.createMarshaller().marshal(contentList, writer);
		return writer.toString();
	}

	/**
	 * Método que crea el xml content
	 * 
	 * @param documento
	 *            Documento
	 * @return saveTask String
	 */
	public static String crearXMLformat(Documento documento) {
		T65BFormatListType t65BFormatListType = T65BFormatListType.Factory.newInstance();
		t65BFormatListType.addNewFormat();

		return t65BFormatListType.xmlText();
	}

	/**
	 * Método que crea el xml content
	 * 
	 * @return saveTask String
	 */
	public static String crearXMLformatTransformacion() {
		T65BFormatListType t65BFormatListType = T65BFormatListType.Factory.newInstance();
		T65BFormatType t65BFormatType = t65BFormatListType.addNewFormat();
		t65BFormatType.setName(Y41bConstantes.PDFA);

		return t65BFormatListType.xmlText();
	}

	/**
	 * Método que recupera a partir del numExpediente la provincia. En caso de
	 * ser NULL el numExpediente o no ser capaz de extraerla, devuelve por
	 * defecto la de ARABA
	 * 
	 * @param numExpediente
	 *            String
	 * @return String (01/20/48)
	 */
	public static String getProvSerieFromNumExp(String numExpediente) {
		if (Y41bUtils.isFilled(numExpediente)) {
			StringTokenizer tokenizer = new StringTokenizer(numExpediente, "-");
			String organismo = "";
			if (tokenizer.hasMoreTokens()) {
				// Procedimiento
				tokenizer.nextToken();
				if (tokenizer.hasMoreTokens()) {
					// Organismo
					organismo = tokenizer.nextToken();
				}
			}
			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
			String organismoCentral = prop.getProperty("ORGANISMO_CENTRAL");
			if (Y41bUtils.isFilled(organismo) && organismo.length() >= 2) {
				if (organismo.equals(organismoCentral)) {
					return Y41bConstantes.CODIGO_PROVINCIA_OTROS;
				} else {
					String codProv = organismo.substring(0, 2);
					if (Y41bConstantes.CODIGO_PROVINCIA_ARABA.equals(codProv)) {
						return Y41bConstantes.CODIGO_PROVINCIA_ARABA;
					} else if (Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA.equals(codProv)) {
						return Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA;
					} else if (Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA.equals(codProv)) {
						return Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA;
					}
				}
			}
		}
		return Y41bConstantes.CODIGO_PROVINCIA_OTROS;
	}

	/**
	 * Mtodo que crea el xml content
	 * 
	 * @param pathPif
	 *            ruta del documento
	 * @param name
	 *            nombre del documento
	 * 
	 * @param extension
	 *            el documento
	 * @return saveTask String
	 */
	public static String crearXMLContentPif(String pathPif, String name, String extension) {

		T65BContentListType contentToStore = T65BContentListType.Factory.newInstance();
		T65BContentType content = contentToStore.addNewContent();

		content.setPifId(pathPif);

		content.setDocLocation("");
		// content.setLenght(bytes.length);
		T65BFormatType t65BFormatType = content.addNewFormat();
		t65BFormatType.setDescription(name);
		t65BFormatType.setExtension(extension);

		return contentToStore.xmlText();
	}

	/**
	 * Método que crea el xml signatures
	 * 
	 * @param documento
	 *            Documento
	 * @param formato
	 *            Formato
	 * @return saveTask String
	 * @throws Exception
	 *             Exception
	 */
	public static String crearXMLsignaturesNSHF(Documento documento, Formato formato) throws Exception {

		SignatureListDocument signatureListDocument = SignatureListDocument.Factory.newInstance();
		T65BSignatureListType t65BSignatureListType = signatureListDocument.addNewSignatureList();

		if (documento != null && documento.getFirmas().size() > 0) {
			for (Firma firma : documento.getFirmas()) {

				// ******************************************************

				EjgvDocumentType signature = new EjgvDocumentType();
				signature.setEjgvDocument(new EjgvDocument());
				signature.getEjgvDocument().setHeader(new Header());
				signature.getEjgvDocument().getHeader().setType("xades");
				signature.getEjgvDocument().getHeader().setPlacement("detached");
				signature.getEjgvDocument().getHeader().setFormat("ES-A");
				signature.getEjgvDocument().getHeader().setVersion("2.0");
				signature.getEjgvDocument().getHeader().setFlags("0");
				signature.getEjgvDocument().getHeader().setTsaSerialNumber(documento.getTsaSerialNumber());
				signature.getEjgvDocument().getHeader().setIsConservable("1");
				signature.getEjgvDocument().getHeader().setDocumentIsRequired("0");

				signature.getEjgvDocument().setBody(new Body());

				signature.getEjgvDocument().getBody().setSign(firma.getFirma());

				Date fechaHoy = new Date();
				String fechaActual = com.ejie.y41b.utils.Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

				StringBuffer nombreSignature = new StringBuffer().append("verifySignatureLocation")
						.append(documento.getOidDokusi()).append(fechaActual).append(".xml");

				// Create JAXB Context
				JAXBContext jaxbContext = JAXBContext.newInstance(EjgvDocumentType.class);

				// Create Marshaller
				Marshaller jaxbMarshaller = jaxbContext.createMarshaller();

				// Required formatting??
				jaxbMarshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);

				QName qName = new QName("com.ejie.y41b.nshf.EjgvDocumentType", "ejgvDocumentType");
				JAXBElement<EjgvDocumentType> root = new JAXBElement<EjgvDocumentType>(qName, EjgvDocumentType.class,
						signature);

				// Print XML String to Console
				StringWriter swSignature = new StringWriter();

				// Write XML to StringWriter
				jaxbMarshaller.marshal(root, swSignature);

				InputStream myInputStream = new ByteArrayInputStream(com.ejie.y41b.utils.Y41bUtils
						.removePrefixes(swSignature.toString()).replaceAll("<ejgvDocumentType >", "")
						.replaceAll("</ejgvDocumentType>", "").getBytes());

				Y41bDokusiHelper.y41bPifAdapterService = (Y41bPifAdapterService) AppContext.getContext()
						.getBean("Y41bPifAdapterServiceImpl");

				String idPifSignature = Y41bDokusiHelper.y41bPifAdapterService.putFileToPLATEA(myInputStream,
						nombreSignature.toString());

				Y31AttachmentBean y31AttachmentBeanDoc = Y41bDokusiHelper.y41bPifAdapterService
						.moveToPLATEA(documento.getPifId(), true);

				NSHFServiceImpl nshfService = new NSHFServiceImpl();
				VerificationResultType signatureReturn = nshfService.verifySignatureLocation(idPifSignature,
						y31AttachmentBeanDoc.getFilePath());

				// *************************************************

				T65BSignatureType t65BSignatureType = t65BSignatureListType.addNewSignature();

				t65BSignatureType.setDate(com.ejie.y41b.utils.Y41bUtils.fncFechaActualLargaAlternativa());

				String firmaData = com.ejie.y41b.utils.Y41bUtils.removePrefixes(swSignature.toString())
						.replaceAll("<ejgvDocumentType >", "").replaceAll("</ejgvDocumentType>", "");

				t65BSignatureType.setSignature(firmaData);

				String dni = "";
				String nombre = "";

				if (signatureReturn != null && signatureReturn.getVerificationResult() != null
						&& signatureReturn.getVerificationResult().getSignCertificates() != null
						&& signatureReturn.getVerificationResult().getSignCertificates().getSignCertificate() != null
						&& signatureReturn.getVerificationResult().getSignCertificates().getSignCertificate().size() > 0
						&& signatureReturn.getVerificationResult().getSignCertificates().getSignCertificate().get(0)
								.getSuscriptor() != null) {
					dni = signatureReturn.getVerificationResult().getSignCertificates().getSignCertificate().get(0)
							.getSuscriptor().getDni();
					nombre = signatureReturn.getVerificationResult().getSignCertificates().getSignCertificate().get(0)
							.getSuscriptor().getNombreCompleto();
				} else if (signatureReturn != null && signatureReturn.getVerificationResult() != null
						&& signatureReturn.getVerificationResult().getSignCertificates() != null
						&& signatureReturn.getVerificationResult().getSignCertificates().getSignCertificate() != null
						&& signatureReturn.getVerificationResult().getSignCertificates().getSignCertificate().size() > 0
						&& signatureReturn.getVerificationResult().getSignCertificates().getSignCertificate().get(0)
								.getEntidad() != null) {
					dni = signatureReturn.getVerificationResult().getSignCertificates().getSignCertificate().get(0)
							.getEntidad().getCif();
					nombre = signatureReturn.getVerificationResult().getSignCertificates().getSignCertificate().get(0)
							.getEntidad().getRazonSocial();
				}

				T65BSignatureInfoListType t65BSignatureInfoListType = t65BSignatureType.addNewSignatureInfoList();
				T65BSignatureInfoType t65BSignatureInfoType = t65BSignatureInfoListType.addNewSignatureInfo();

				t65BSignatureInfoType.setSignerID(dni);
				t65BSignatureInfoType.setSignerName(nombre);

				// t65BSignatureType.addNewFormat().setName("");
				// t65BSignatureType.getFormat().setExtension(documento.getExtension());

				T65BFormatType t65BFormatType = t65BSignatureType.addNewFormat();
				t65BFormatType.setName(formato.getName());
				t65BFormatType.setExtension(formato.getExtension());
				t65BFormatType.setMimeType(formato.getMimeType());
				t65BFormatType.setDescription(formato.getDescription());
				t65BFormatType.setFullText(formato.getFullText());

				/**
				 * <is_conservable>1</is_conservable>
				 * <document_is_requiered>1</document_is_requiered>
				 * <signature_type>detached</signature_type>
				 * <signature_format>xades</signature_format>
				 * <signature_profile>ES-A</signature_profile>
				 * <timestamp_serial_number>218</timestamp_serial_number>
				 * 
				 */

				t65BSignatureType.setIsConservable("1");
				t65BSignatureType.setSignatureType("detached");
				t65BSignatureType.setSignatureFormat("xades");
				t65BSignatureType.setSignatureProfile("ES-A");
			}
		}

		// return
		// Y41bXMLUtils.quitarNameSpacesString(signatureListDocument.getSignatureList());
		return Y41bXMLUtils.quitarNameSpacesString(signatureListDocument);
	}
}
