package com.ejie.y41b.adapter;

import com.ejie.cp.xml.ProcedureDocument;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.platea.ActualizarExpediente;
import com.ejie.y41b.model.platea.ActualizarMisGestiones;
import com.ejie.y41b.model.platea.CierreExpediente;
import com.ejie.y41b.model.platea.CrearEJGV;
import com.ejie.y41b.model.platea.CrearNotifEJGV;
import com.ejie.y41b.model.platea.DatosCertificado;
import com.ejie.y41b.model.platea.EnvioEJGV;
import com.ejie.y41b.model.platea.EnvioNotifEJGV;
import com.ejie.y41b.model.platea.Espera;
import com.ejie.y41b.model.platea.ExpedienteOficio;
import com.ejie.y41b.model.platea.Historico;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.model.platea.RegistroEntrada;
import com.ejie.y41b.model.platea.RegistroSalida;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentNotificacion;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentSolicitud;
import com.ejie.y41b.model.platea.RespuestaNotificacion;
import com.ejie.y41b.model.platea.RespuestaProcesarEspera;
import com.ejie.y41b.model.platea.RespuestaRegistrarHistorico;
import com.ejie.y41b.model.platea.RespuestaSolicitudTelematica;
import com.ejie.y41b.model.platea.SolicitudOficio;
import com.ejie.y41b.model.platea.SolicitudPresencial;
import com.ejie.y41b.model.platea.SolicitudTelematica;
import com.ejie.y41b.nshf.SignCertificateType;
import com.ejie.y41b.ws.cliente.x43notificaciones.TDocumentFilter;
import com.ejie.y41b.ws.cliente.x43notificaciones.TDocumentList;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNotification;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNotificationFilter;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNotificationList;

/**
 * Y41bPlateaAdapterService.
 * 
 *  
 */

public interface Y41bPlateaAdapterService {

	/**
	 * Método que recupera los datos del catálogo de Procedimientos
	 * 
	 * @param procedure
	 *            Procedure: Procedimiento de platea
	 * 
	 * @return ProcedureDocument: objeto con los datos del procedimiento
	 * 
	 */
	public ProcedureDocument obtenerDatosCatalogoProcedimientos(Procedure procedure);

	/**
	 * Método que abre un expediente presencial
	 * 
	 * @param solicitudPresencial
	 *            Objeto con los datos de la solicitud presencial
	 * @return SolicitudPresencial
	 * 
	 */
	public SolicitudPresencial crearSolicitudPresencial(SolicitudPresencial solicitudPresencial);

	/**
	 * Metodo que actualiza Mis Gestiones
	 * 
	 * @param actualizarMisGestiones
	 *            Objeto con los datos de mis gestiones
	 * 
	 */
	public void actualizarMisGestiones(ActualizarMisGestiones actualizarMisGestiones);

	/**
	 * Metodo que actualiza Mis Gestiones para el acta
	 * 
	 * @param actualizarMisGestiones
	 *            Objeto con los datos de mis gestiones
	 * 
	 */
	public void actualizarMisGestionesActa(ActualizarMisGestiones actualizarMisGestiones);

	/**
	 * Metodo que actualiza Mis Gestiones
	 * 
	 * @param actualizarMisGestiones
	 *            Objeto con los datos de mis gestiones
	 * 
	 */
	public void actualizarMisGestionesX43(ActualizarMisGestiones actualizarMisGestiones);

	/**
	 * Metodo que recupera el EJGVDocument
	 * 
	 * @param idSolicitud
	 *            String
	 * @param folderId
	 *            String
	 * @return String
	 */
	public String getRequestInformation(String idSolicitud, String folderId);

	/**
	 * Metodo que actualiza Mis Gestiones
	 * 
	 * @param actualizarMisGestiones
	 *            Objeto con los datos de mis gestiones
	 * 
	 */
	public void actualizarMisGestionesComunicacion(ActualizarMisGestiones actualizarMisGestiones);

	/**
	 * Metodo que actualiza Mis Gestiones
	 * 
	 * @param actualizarMisGestiones
	 *            Objeto con los datos de mis gestiones
	 * 
	 */
	public void actualizarMisGestionesNotificacion(ActualizarMisGestiones actualizarMisGestiones);

	/**
	 * Metodo que actualiza Mis Gestiones
	 * 
	 * @param actualizarMisGestiones
	 *            Objeto con los datos de mis gestiones
	 * 
	 */
	public void actualizarMisGestionesDecision(ActualizarMisGestiones actualizarMisGestiones);

	/**
	 * Metodo que elimina de Mis Gestiones
	 * 
	 * @param actualizarMisGestiones
	 *            Objeto con los datos de mis gestiones
	 * 
	 */
	public void eliminarMisGestiones(ActualizarMisGestiones actualizarMisGestiones);

	/**
	 * Metodo que elimina de Mis Gestiones
	 * 
	 * @param actualizarMisGestiones
	 *            Objeto con los datos de mis gestiones
	 * 
	 */
	public void eliminarMisGestionesX43(ActualizarMisGestiones actualizarMisGestiones);

	/**
	 * Metodo que actualiza Mis Gestiones
	 * 
	 * @param actualizarExpediente
	 *            Objeto con los datos de mis gestiones
	 * 
	 */
	public void actualizarExpediente(ActualizarExpediente actualizarExpediente);

	/**
	 * Método que abre el expediente de oficio
	 * 
	 * @param solicitudOficio
	 *            Objeto con los datos de la solicitud de oficio
	 * 
	 */
	public void crearSolicitudOficio(SolicitudOficio solicitudOficio);

	/**
	 * Método que abre el expediente telematico
	 * 
	 * @param solicitudTelematica
	 *            Objeto con los datos de la solicitud telematica
	 * 
	 */
	public void crearSolicitudTelematica(SolicitudTelematica solicitudTelematica);

	/**
	 * Cerrará los expedientes telemáticos que se encuentren abiertos
	 * 
	 * @param cierreExpediente
	 *            CierreExpediente
	 */
	public void cerrarExpediente(CierreExpediente cierreExpediente);

	/**
	 * Método que abre el expediente de oficio
	 * 
	 * @param expedienteOficio
	 *            ExpedienteOficio
	 * @return ExpedienteOficio
	 */
	public ExpedienteOficio abrirExpedienteOficio(ExpedienteOficio expedienteOficio);

	/**
	 * Método que crea un registro de entrada
	 * 
	 * @param registroEntrada
	 *            RegistroEntrada
	 * 
	 * @return RegistroEntrada
	 * 
	 */
	public RegistroEntrada obtenerRegistroEntrada(RegistroEntrada registroEntrada);

	/**
	 * Método que crea un registro de salida
	 * 
	 * @param registroSalida
	 *            RegistroSalida
	 * 
	 * @return RegistroSalida
	 * 
	 */
	public RegistroSalida obtenerRegistroSalida(RegistroSalida registroSalida);

	/**
	 * Método que obtiene los datos contenidos en el certificado de la firma
	 * 
	 * @param firmaSimple
	 *            la firma simple
	 * 
	 * @return DatosCertificado
	 * 
	 */
	public DatosCertificado obtenerDatosCertificadoFirma(String firmaSimple);

	/**
	 * Método que sirve para procesar el crear el ejgv
	 * 
	 * @param crearEJGV
	 *            CrearEJGV
	 * 
	 * @return RespuestaCrearEJGVDocumentSolicitud
	 * 
	 */
	public RespuestaCrearEJGVDocumentSolicitud crearEJGVDocumentSolicitud(CrearEJGV crearEJGV);

	/**
	 * Método que sirve para procesar el crear el ejgv de la Notificacion
	 * 
	 * @param crearNotifEJGV
	 *            CrearNotifEJGV
	 * 
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * 
	 */
	public RespuestaCrearEJGVDocumentNotificacion crearEJGVDocumentNotificacion(CrearNotifEJGV crearNotifEJGV);

	/**
	 * Método que sirve para procesar el crear el ejgv de la Comunicacion
	 * 
	 * @param crearNotifEJGV
	 *            CrearNotifEJGV
	 * 
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * 
	 */
	public RespuestaCrearEJGVDocumentNotificacion crearEJGVDocumentComunicacion(CrearNotifEJGV crearNotifEJGV);

	/**
	 * Método que sirve para recuperar el Registro de Salida de una
	 * Notificacion/Comunicacion Electronica
	 * 
	 * @param idNotificacion
	 *            String
	 * 
	 * @return RegistroSalida
	 * 
	 */
	public RegistroSalida getRegistroSalidaFromIdNotificacion(String idNotificacion);

	/**
	 * Este metodo sirve para procesar el envio de la solicitud
	 * 
	 * @param envioEJGV
	 *            EnvioEJGV
	 * 
	 * @return RespuestaSolicitudTelematica numero de registro de la solicitud +
	 *         Ejgv Firmado
	 * 
	 */
	public RespuestaSolicitudTelematica procesarEnviarSolicitud(EnvioEJGV envioEJGV);

	/**
	 * Este metodo sirve para procesar el envio de la notificacion
	 * 
	 * @param EnvioNotifEJGV
	 *            envioNotifEJGV
	 * 
	 * @return RespuestaNotificacion numero de registro de la notificacion
	 * 
	 */
	public RespuestaNotificacion procesarEnviarNotificacion(EnvioNotifEJGV envioNotifEJGV);

	/**
	 * Este metodo sirve para procesar el envio de la notificacion mediante
	 * X43Notificacion
	 * 
	 * @param crearNotifEJGV
	 *            CrearNotifEJGV
	 * 
	 * @return RespuestaNotificacion numero de registro de la notificacion
	 * 
	 */
	public RespuestaNotificacion procesarEnviarNotificacionX43(CrearNotifEJGV crearNotifEJGV);

	/**
	 * Este metodo sirve para procesar el envio de la comunicacion
	 * 
	 * @param EnvioNotifEJGV
	 *            envioNotifEJGV
	 * 
	 * @return RespuestaNotificacion numero de registro de la notificacion
	 * 
	 */
	public RespuestaNotificacion procesarEnviarComunicacion(EnvioNotifEJGV envioNotifEJGV);

	/**
	 * Metodo que recupera el HASH de un documento de DOKUSI
	 * 
	 * @param documento
	 *            Objeto con los atributos necesarios para generar el HASH en
	 *            Dokusi
	 * 
	 * @return String Hash Generado.
	 */
	public String generarHashDocumento(Documento documento);

	/**
	 * Método que sirve crear una espera
	 * 
	 * @param espera
	 *            Espera
	 * 
	 * @return RespuestaProcesarEspera
	 * 
	 */
	public RespuestaProcesarEspera crearEspera(Espera espera);

	/**
	 * Método que sirve matar una espera
	 * 
	 * @param espera
	 *            Espera
	 * 
	 * @return RespuestaProcesarEspera
	 * 
	 */
	public RespuestaProcesarEspera matarEspera(Espera espera);

	/**
	 * Método que sirve para registrar información en el historico del
	 * expediente
	 * 
	 * @param historico
	 *            Historico
	 * 
	 * @return RespuestaRegistrarHistorico
	 * 
	 */
	public RespuestaRegistrarHistorico registrarHistorico(Historico historico);

	/**
	 * Método que sirve para eliminar información en el historico del
	 * expediente
	 * 
	 * @param historico
	 *            Historico
	 * 
	 */
	public void eliminarHistorico(Historico historico);

	/**
	 * Este metodo sirve para verificar el certificado que ha firmado
	 * 
	 * @param certificateB64
	 *            byte[]
	 * 
	 * @return SignCertificateType
	 * 
	 */
	public SignCertificateType verifyCertificate(byte[] certificateB64);

	/**
	 * Metodo que actualiza Mis Gestiones
	 * 
	 * @param actualizarExpediente
	 *            Objeto con los datos de mis gestiones
	 * 
	 */
	public void actualizarParticipantExpediente(ActualizarExpediente actualizarExpediente);

	/**
	 * Metodo que actualiza Mis Gestiones
	 * 
	 * @param actualizarExpediente
	 *            Objeto con los datos de mis gestiones
	 * 
	 */
	public void cancelarCierreExpediente(ActualizarExpediente actualizarExpediente);

	/**
	 * Metodo que recupera el EJGVDocument
	 * 
	 * @param filter
	 *            TDocumentFilter
	 * @param ep
	 *            AExtensionPoint
	 * @return TDocumentList
	 */
	public TDocumentList searchDocument(TDocumentFilter filter,
			com.ejie.y41b.ws.cliente.x43notificaciones.AExtensionPoint ep);

	/**
	 * Metodo que devuelve la lista de todas las notificaciones existentes segn
	 * los parmetros de entrada. Al menos tiene que tener un parmetro de
	 * filtro.
	 * 
	 * @param filter
	 *            TNotificationFilter
	 * @param ep
	 *            AExtensionPoint
	 * @return TNotificationList
	 */
	public TNotificationList searchNotification(TNotificationFilter filter,
			com.ejie.y41b.ws.cliente.x43notificaciones.AExtensionPoint ep);

	/**
	 * Método que sirve para recuperar el justificante de la notificacin
	 * 
	 * @param idNotificacion
	 *            String
	 * 
	 * @return TNotification
	 * 
	 */
	public TNotification getJustificanteNotificacion(String idNotificacion);

	/**
	 * Método que sirve para recuperar el justificante del acuse de la
	 * notificacin
	 * 
	 * @param idNotificacion
	 *            String
	 * 
	 * @return TNotification
	 * 
	 */
	public TNotification getJustificanteAcuseNotificacion(String idNotificacion);

	/**
	 * Método que sirve para recuperar la cuenta del interesado
	 * 
	 * @param numIdentificacion
	 *            String
	 * 
	 * @return String
	 * 
	 */
	public String getCuentaInteresado(String numIdentificacion);

	/**
	 * Método que sirve para recuperar si tiene email de contacto el interesado
	 * 
	 * @param numIdentificacion
	 *            String
	 * 
	 * @return String
	 * 
	 */
	public boolean tieneEmailCuentaInteresado(String numIdentificacion);
}
