/**
 * 
 */
package com.ejie.y41b.adapter;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;

import com.ejie.y41b.adapter.services.Y41bPifService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y31.vo.Y31AttachmentBean;

/**
 *  
 * 
 */
@Service(value = "Y41bPifAdapterServiceImpl")
public class Y41bPifAdapterServiceImpl implements Y41bPifAdapterService {

	/**
	 * Final static logger.
	 */
	private static final Logger logger = LoggerFactory.getLogger(Y41bPifAdapterServiceImpl.class);

	@Autowired
	public Y41bPifService y41bPifService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Clase que adaptara los servicios de PIF a nuestro sistema
	 */
	public Y41bPifAdapterServiceImpl() {
		super();
	}

	/**
	 * Subir documento a PIF
	 * 
	 * @param file
	 *            Fichero que se va a subir al PIF
	 * @param fileName
	 *            Nombre del fichero
	 * @return
	 * @throws Exception
	 */
	public String putFile(InputStream file, String fileName) throws Exception {
		logger.info("Y41bPifAdapterServiceImpl.putFile - Inicio");
		try {
			String pathTo = "/" + Y41bConstantes.COD_APLICACION.toLowerCase() + "/" + fileName;

			Document documentItemSesion = com.ejie.y41b.utils.xlnets.Y41bUtils.getInstance().getDocumentItemSesion(
					Boolean.parseBoolean((String) this.appConfiguration.get("xlnets.loginApp.isSimulated")));

			Y31AttachmentBean y31AttachmentBeanResult = this.y41bPifService.putFile(documentItemSesion, file, pathTo,
					true, Long.valueOf(appConfiguration.getProperty("PIF.TIEMPO")));
			return y31AttachmentBeanResult.getFilePath();
		} catch (Exception e) {
			logger.error("Y41bPifAdapterServiceImpl.putFile", e);
			throw new Y41bUDAException(Y41bConstantes.PIF_LITERAL_GENERAL, true, e);
		} finally {
			logger.info("Y41bPifAdapterServiceImpl.putFile - Final");
		}
	}

	/**
	 * Subir documento a PIF
	 * 
	 * @param file
	 *            Fichero que se va a subir al PIF
	 * @param fileName
	 *            Nombre del fichero
	 * @return
	 * @throws Exception
	 */
	public String putFileToDokusi(InputStream file, String fileName) throws Exception {
		logger.info("Y41bPifAdapterServiceImpl.putFileToDokusi - Inicio");
		try {
			String pathTo = "/" + appConfiguration.getProperty("PIF.CARPETA.DOKUSI") + "/"
					+ Y41bConstantes.COD_APLICACION.toLowerCase() + "/" + fileName;

			Document documentItemSesion = com.ejie.y41b.utils.xlnets.Y41bUtils.getInstance().getDocumentItemSesion(
					Boolean.parseBoolean((String) this.appConfiguration.get("xlnets.loginApp.isSimulated")));

			Y31AttachmentBean y31AttachmentBeanResult = this.y41bPifService.putFile(documentItemSesion, file, pathTo,
					true, Long.valueOf(appConfiguration.getProperty("PIF.TIEMPO")));
			return y31AttachmentBeanResult.getFilePath();
		} catch (Exception e) {
			logger.error("Y41bPifAdapterServiceImpl.putFileToDokusi", e);
			throw new Y41bUDAException(Y41bConstantes.PIF_LITERAL_GENERAL, true, e);
		} finally {
			logger.info("Y41bPifAdapterServiceImpl.putFileToDokusi - Final");
		}
	}

	/**
	 * Subir documento a PIF
	 * 
	 * @param file
	 *            Fichero que se va a subir al PIF
	 * @param fileName
	 *            Nombre del fichero
	 * @return
	 * @throws Exception
	 */
	public String putFileToPLATEA(InputStream file, String fileName) throws Exception {
		logger.info("Y41bPifAdapterServiceImpl.putFileToDokusi - Inicio");
		try {
			String pathTo = "/" + appConfiguration.getProperty("PIF.CARPETA.PLATEA") + "/"
					+ Y41bConstantes.COD_APLICACION.toLowerCase() + "/" + fileName;

			Document documentItemSesion = com.ejie.y41b.utils.xlnets.Y41bUtils.getInstance().getDocumentItemSesion(
					Boolean.parseBoolean((String) this.appConfiguration.get("xlnets.loginApp.isSimulated")));

			Y31AttachmentBean y31AttachmentBeanResult = this.y41bPifService.putFile(documentItemSesion, file, pathTo,
					true, Long.valueOf(appConfiguration.getProperty("PIF.TIEMPO")));
			return y31AttachmentBeanResult.getFilePath();
		} catch (Exception e) {
			logger.error("Y41bPifAdapterServiceImpl.putFileToDokusi", e);
			throw new Y41bUDAException(Y41bConstantes.PIF_LITERAL_GENERAL, true, e);
		} finally {
			logger.info("Y41bPifAdapterServiceImpl.putFileToDokusi - Final");
		}
	}

	/**
	 * Subir documento a PIF
	 * 
	 * @param file
	 *            Fichero que se va a subir al PIF
	 * @param fileName
	 *            Nombre del fichero
	 * @return
	 * @throws Exception
	 */
	public String putFileToPath(InputStream file, String pathTo) throws Exception {
		logger.info("Y41bPifAdapterServiceImpl.putFileToPath - Inicio");
		try {
			Document documentItemSesion = com.ejie.y41b.utils.xlnets.Y41bUtils.getInstance().getDocumentItemSesion(
					Boolean.parseBoolean((String) this.appConfiguration.get("xlnets.loginApp.isSimulated")));

			Y31AttachmentBean y31AttachmentBeanResult = this.y41bPifService.putFile(documentItemSesion, file, pathTo,
					true, Long.valueOf(appConfiguration.getProperty("PIF.TIEMPO")));
			return y31AttachmentBeanResult.getFilePath();
		} catch (Exception e) {
			logger.error("Y41bPifAdapterServiceImpl.putFileToPath", e);
			throw new Y41bUDAException(Y41bConstantes.PIF_LITERAL_GENERAL, true, e);
		} finally {
			logger.info("Y41bPifAdapterServiceImpl.putFileToPath - Final");
		}
	}

	/**
	 * Obtener documento a PIF
	 * 
	 * @param file
	 *            Fichero que se va a subir al PIF
	 * @param fileName
	 *            Nombre del fichero
	 * @return
	 * @throws Exception
	 */
	public BufferedInputStream getFile(String pathFrom) throws Exception {
		logger.info("Y41bPifAdapterServiceImpl.getFile - Inicio");
		try {
			Document documentItemSesion = com.ejie.y41b.utils.xlnets.Y41bUtils.getInstance().getDocumentItemSesion(
					Boolean.parseBoolean((String) this.appConfiguration.get("xlnets.loginApp.isSimulated")));

			return (BufferedInputStream) this.y41bPifService.getFile(documentItemSesion, pathFrom);
		} catch (Exception e) {
			logger.error("Y41bPifAdapterServiceImpl.getFile", e);
			throw new Y41bUDAException(Y41bConstantes.PIF_LITERAL_GENERAL, true, e);
		} finally {
			logger.info("Y41bPifAdapterServiceImpl.getFile - Final");
		}
	}

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @param fileName
	 *            Nombre del fichero
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de dìgitos que lo hace único en el repositorio
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws Exception
	 */
	public Y31AttachmentBean moveFile(String pathFrom, String fileName, boolean preserveName) throws Exception {
		logger.info("Y41bPifAdapterServiceImpl.moveFile - Inicio");
		try {
			String pathTo = Y41bConstantes.COD_APLICACION.toLowerCase() + "/" + fileName;

			Document documentItemSesion = com.ejie.y41b.utils.xlnets.Y41bUtils.getInstance().getDocumentItemSesion(
					Boolean.parseBoolean((String) this.appConfiguration.get("xlnets.loginApp.isSimulated")));

			return this.y41bPifService.moveFile(documentItemSesion, pathFrom, pathTo, preserveName);
		} catch (Exception e) {
			logger.error("Y41bPifAdapterServiceImpl.moveFile", e);
			throw new Y41bUDAException(Y41bConstantes.PIF_LITERAL_GENERAL, true, e);
		} finally {
			logger.info("Y41bPifAdapterServiceImpl.moveFile - Final");
		}
	}

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de dìgitos que lo hace único en el repositorio
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws Exception
	 */
	public Y31AttachmentBean moveToDokusi(String pathFrom, boolean preserveName) throws Exception {
		logger.info("Y41bPifAdapterServiceImpl.moveToDokusi - Inicio");
		try {
			String pathTo = "/" + appConfiguration.getProperty("PIF.CARPETA.DOKUSI") + pathFrom;

			Document documentItemSesion = com.ejie.y41b.utils.xlnets.Y41bUtils.getInstance().getDocumentItemSesion(
					Boolean.parseBoolean((String) this.appConfiguration.get("xlnets.loginApp.isSimulated")));

			return this.y41bPifService.moveFile(documentItemSesion, pathFrom, pathTo, preserveName);
		} catch (Exception e) {
			logger.error("Y41bPifAdapterServiceImpl.moveToDokusi", e);
			throw new Y41bUDAException(Y41bConstantes.PIF_LITERAL_GENERAL, true, e);
		} finally {
			logger.info("Y41bPifAdapterServiceImpl.moveToDokusi - Final");
		}
	}

	/**
	 * 
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de dìgitos que lo hace único en el repositorio
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws Exception
	 *             Exception
	 */
	public Y31AttachmentBean moveToPLATEA(String pathFrom, boolean preserveName) throws Exception {
		logger.info("Y41bPifAdapterServiceImpl.moveToDokusi - Inicio");
		try {
			StringBuffer pathTo = new StringBuffer().append("/")
					.append(appConfiguration.getProperty("PIF.CARPETA.PLATEA")).append("/")
					.append(Y41bConstantes.COD_APLICACION.toLowerCase()).append("/")
					.append(Y41bUtils.getNameFileFromPath(pathFrom));

			Document documentItemSesion = com.ejie.y41b.utils.xlnets.Y41bUtils.getInstance().getDocumentItemSesion(
					Boolean.parseBoolean((String) this.appConfiguration.get("xlnets.loginApp.isSimulated")));

			return this.y41bPifService.moveFile(documentItemSesion, pathFrom, pathTo.toString(), preserveName);
		} catch (Exception e) {
			logger.error("Y41bPifAdapterServiceImpl.moveToDokusi", e);
			throw new Y41bUDAException(Y41bConstantes.PIF_LITERAL_GENERAL, true, e);
		} finally {
			logger.info("Y41bPifAdapterServiceImpl.moveToDokusi - Final");
		}
	}

	/**
	 * 
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @param pathTo
	 *            Ruta lógica hasta donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de dìgitos que lo hace único en el repositorio
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws Exception
	 *             Exception
	 */
	public Y31AttachmentBean moveToPath(String pathFrom, String pathTo, boolean preserveName) throws Exception {
		logger.info("Y41bPifAdapterServiceImpl.moveToDokusi - Inicio");
		try {

			Document documentItemSesion = com.ejie.y41b.utils.xlnets.Y41bUtils.getInstance().getDocumentItemSesion(
					Boolean.parseBoolean((String) this.appConfiguration.get("xlnets.loginApp.isSimulated")));

			return this.y41bPifService.moveFile(documentItemSesion, pathFrom, pathTo, preserveName);
		} catch (Exception e) {
			logger.error("Y41bPifAdapterServiceImpl.moveToDokusi", e);
			throw new Y41bUDAException(Y41bConstantes.PIF_LITERAL_GENERAL, true, e);
		} finally {
			logger.info("Y41bPifAdapterServiceImpl.moveToDokusi - Final");
		}
	}

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que est� escribiendo en el
	 *            repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicaci�n origen
	 * @param pathTo
	 *            Ruta lógica donde se va a mover el fichero. Incluirá como
	 *            carpeta principal la aplicaci�n destino
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de dìgitos que lo hace único en el repositorio
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws Exception
	 */
	public Y31AttachmentBean copyFile(Document sSessionToken, String pathFrom, String fileName, boolean preserveName)
			throws Exception {

		logger.info("Y41bPifAdapterServiceImpl.copyFile - Inicio");
		try {
			String pathTo = Y41bConstantes.COD_APLICACION.toLowerCase() + "/" + fileName;

			Document documentItemSesion = com.ejie.y41b.utils.xlnets.Y41bUtils.getInstance().getDocumentItemSesion(
					Boolean.parseBoolean((String) this.appConfiguration.get("xlnets.loginApp.isSimulated")));

			return this.y41bPifService.copyFile(documentItemSesion, pathFrom, pathTo, preserveName);
		} catch (Exception e) {
			logger.error("Y41bPifAdapterServiceImpl.copyFile", e);
			throw new Y41bUDAException(Y41bConstantes.PIF_LITERAL_GENERAL, true, e);
		} finally {
			logger.info("Y41bPifAdapterServiceImpl.copyFile - Final");
		}
	}

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicaci�n que est� escribiendo en el
	 *            repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @return List<Y31AttachmentBean>
	 * @throws Exception
	 */
	public List<Y31AttachmentBean> listFile(String pathFrom) throws Exception {
		logger.info("Y41bPifAdapterServiceImpl.listFile - Inicio");
		try {
			Document documentItemSesion = com.ejie.y41b.utils.xlnets.Y41bUtils.getInstance().getDocumentItemSesion(
					Boolean.parseBoolean((String) this.appConfiguration.get("xlnets.loginApp.isSimulated")));

			// invocando el metodo
			return this.y41bPifService.listFile(documentItemSesion, pathFrom);
		} catch (Exception e) {
			logger.error("Y41bPifAdapterServiceImpl.listFile", e);
			throw new Y41bUDAException(Y41bConstantes.PIF_LITERAL_GENERAL, true, e);
		} finally {
			logger.info("Y41bPifAdapterServiceImpl.listFile - Final");
		}
	}

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @throws Exception
	 */
	public void deleteFile(String pathFrom) throws Exception {
		logger.info("Y41bPifAdapterServiceImpl.deleteFile - Inicio");
		try {
			Document documentItemSesion = com.ejie.y41b.utils.xlnets.Y41bUtils.getInstance().getDocumentItemSesion(
					Boolean.parseBoolean((String) this.appConfiguration.get("xlnets.loginApp.isSimulated")));
			// invocando el metodo
			this.y41bPifService.deleteFile(documentItemSesion, pathFrom);
		} catch (Exception e) {
			logger.error("Y41bPifAdapterServiceImpl.deleteFile", e);
			throw new Y41bUDAException(Y41bConstantes.PIF_LITERAL_GENERAL, true, e);
		} finally {
			logger.info("Y41bPifAdapterServiceImpl.deleteFile - Final");
		}
	}
}