/**
 * 
 */
package com.ejie.y41b.adapter;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.List;

import org.w3c.dom.Document;

import com.ejie.y31.vo.Y31AttachmentBean;

/**
 *  
 * 
 */
public interface Y41bPifAdapterService {

	/**
	 * Subir documento a PIF
	 * 
	 * @param file
	 *            Fichero que se va a subir al PIF
	 * @param fileName
	 *            Nombre del fichero
	 * @return
	 * @throws Exception
	 */
	public String putFile(InputStream file, String fileName) throws Exception;

	/**
	 * Subir documento a PIF
	 * 
	 * @param file
	 *            Fichero que se va a subir al PIF para posteriormente subir a
	 *            DOKUSI
	 * @param fileName
	 *            Nombre del fichero
	 * @return
	 * @throws Exception
	 */
	public String putFileToDokusi(InputStream file, String fileName) throws Exception;

	/**
	 * Subir documento a PIF
	 * 
	 * @param file
	 *            Fichero que se va a subir al PIF
	 * @param fileName
	 *            Nombre del fichero
	 * @return
	 * @throws Exception
	 */
	public String putFileToPLATEA(InputStream file, String fileName) throws Exception;

	/**
	 * Subir documento a PIF
	 * 
	 * @param file
	 *            Fichero que se va a subir al PIF
	 * @param fileName
	 *            Nombre del fichero
	 * @return
	 * @throws Exception
	 */
	public String putFileToPath(InputStream file, String pathTo) throws Exception;

	/**
	 * Obtener documento a PIF
	 * 
	 * @param file
	 *            Fichero que se va a subir al PIF
	 * @param fileName
	 *            Nombre del fichero
	 * @return
	 * @throws Exception
	 */
	public BufferedInputStream getFile(String pathFrom) throws Exception;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @param fileName
	 *            Nombre del fichero
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de dígitos que lo hace único en el repositorio
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws Exception
	 */
	public Y31AttachmentBean moveFile(String pathFrom, String pathTo, boolean preserveName) throws Exception;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que est� escribiendo en el
	 *            repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicaci�n origen
	 * @param pathTo
	 *            Ruta lógica donde se va a mover el fichero. Incluirá como
	 *            carpeta principal la aplicaci�n destino
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de dígitos que lo hace único en el repositorio
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws Exception
	 */
	public Y31AttachmentBean copyFile(Document sSessionToken, String pathFrom, String pathTo, boolean preserveName)
			throws Exception;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicaci�n que est� escribiendo en el
	 *            repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @return List<Y31AttachmentBean>
	 * @throws Exception
	 */
	public List<Y31AttachmentBean> listFile(String pathFrom) throws Exception;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @throws Exception
	 */
	public void deleteFile(String pathFrom) throws Exception;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesión de aplicación que está escribiendo en el repositorio
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de dígitos que lo hace único en el repositorio
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws Exception
	 */
	public Y31AttachmentBean moveToDokusi(String pathFrom, boolean preserveName) throws Exception;

	/**
	 * 
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de dìgitos que lo hace único en el repositorio
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws Exception
	 *             Exception
	 */
	public Y31AttachmentBean moveToPLATEA(String pathFrom, boolean preserveName) throws Exception;

	/**
	 * 
	 * @param pathFrom
	 *            Ruta lógica desde donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @param pathTo
	 *            Ruta lógica hasta donde se va a mover el fichero. Incluirá
	 *            como carpeta principal la aplicación origen
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de dìgitos que lo hace único en el repositorio
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws Exception
	 *             Exception
	 */
	public Y31AttachmentBean moveToPath(String pathFrom, String pathTo, boolean preserveName) throws Exception;
}
