package com.ejie.y41b.adapter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.y41b.adapter.services.Y41bEikaConsultaResultadoPagosServiceImpl;
import com.ejie.y41b.adapter.services.Y41bEikaConsultaTercerosServiceImpl;
import com.ejie.y41b.adapter.services.Y41bEikaCrearObligacionesServiceImpl;
import com.ejie.y41b.constantes.Y41bADOConstantes;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.service.ParametrosService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.ws.cliente.eika.cp.consultaResultadoPagos.DTCONSULTARESULTADOPAGOSREQUEST;
import com.ejie.y41b.ws.cliente.eika.cp.consultaResultadoPagos.DTCONSULTARESULTADOPAGOSRESPONSE;
import com.ejie.y41b.ws.cliente.eika.cp.consultaResultadoPagos.DTCONSULTARESULTADOPAGOSRESPONSE.RESULTADOPAGOS.PAGO;
import com.ejie.y41b.ws.cliente.eika.cp.crearO.DTCREAROREQUEST;
import com.ejie.y41b.ws.cliente.eika.cp.crearO.DTCREAROREQUEST.CABECERA;
import com.ejie.y41b.ws.cliente.eika.cp.crearO.DTCREAROREQUEST.POSICION;
import com.ejie.y41b.ws.cliente.eika.cp.crearO.DTCREAROREQUEST.RETENCION;
import com.ejie.y41b.ws.cliente.eika.cp.crearO.DTCREARORESPONSE;
import com.ejie.y41b.ws.cliente.eika.cp.crearO.DTCREARORESPONSE.POSICIONES.LINEA;
import com.ejie.y41b.ws.cliente.eika.tesoreria.consultaTerceros.DTCONSULTATERCEROSREQUEST;
import com.ejie.y41b.ws.cliente.eika.tesoreria.consultaTerceros.DTCONSULTATERCEROSRESPONSE;

/**
 * Y41bEIKAAdapterServiceImpl
 */
@Service(value = "Y41bEIKAAdapterServiceImpl")
public class Y41bEIKAAdapterServiceImpl implements Y41bEIKAAdapterService {

	@Autowired
	private Y41bEikaConsultaResultadoPagosServiceImpl consultaResultadoPagosServiceImpl;

	@Autowired
	private Y41bEikaConsultaTercerosServiceImpl consultaTercerosServiceImpl;

	@Autowired
	private Y41bEikaCrearObligacionesServiceImpl crearObligacionesServiceImpl;

	@Autowired
	private ParametrosService parametrosService;

	/**
	 * Final static logger.
	 */
	private static final Logger logger = LoggerFactory.getLogger(Y41bEIKAAdapterServiceImpl.class);

	private static final String CADENA_ERROR = "error.eika.invocation";

	/**
	 * Clase que adaptara los servicios de EIKA a nuestro sistema
	 */
	private Y41bEIKAAdapterServiceImpl() {
		super();
	}

	/**
	 * crearObligaciones
	 * 
	 * @param listaPagos
	 *            List<Map<String, String>>
	 * @return List<Map<String, String>>
	 */
	public List<Map<String, String>> crearObligaciones(List<Map<String, String>> listaPagos) {
		logger.info("Y41bEIKAAdapterServiceImpl.crearObligaciones - Inicio");
		List<Map<String, String>> listaResultado;
		try {
			DTCREAROREQUEST request = new DTCREAROREQUEST();
			// INICIO CABECERA
			CABECERA cabecera = new CABECERA();
			// CODOPER
			Parametros parametros = new Parametros();
			parametros.setParametro(Y41bADOConstantes.NAME_ADO_EIKA_TIPDOC);
			parametros = this.parametrosService.find(parametros);
			cabecera.setCODOPER(parametros.getValor());
			// EJERCICIO
			parametros = new Parametros();
			parametros.setParametro(Y41bADOConstantes.NAME_ADO_EJER);
			parametros = this.parametrosService.find(parametros);
			cabecera.setEJERCICIO(parametros.getValor());
			// SOCIEDAD
			parametros = new Parametros();
			parametros.setParametro(Y41bADOConstantes.NAME_ADO_CODINS);
			parametros = this.parametrosService.find(parametros);
			cabecera.setSOCIEDAD(parametros.getValor());
			// TITULO
			cabecera.setTITULO("Pagos a arbitros (" + Y41bUtils.fncFechaActualLargaAlternativa() + ")");
			// EXPORIGEN
			cabecera.setEXPORIGEN("");
			// NUMDOCREF
			cabecera.setNUMDOCREF("");
			// NUMEXPADMA
			cabecera.setNUMEXPADMA("");
			// EXPPERFCONTR
			cabecera.setEXPPERFCONTR("");
			// NUMEXPADMD
			cabecera.setNUMEXPADMD("");
			// CODSUBV
			cabecera.setCODSUBV("");
			// TIPOCONT
			parametros = new Parametros();
			parametros.setParametro(Y41bADOConstantes.NAME_ADO_EIKA_CODDTIPCNTR);
			parametros = this.parametrosService.find(parametros);
			cabecera.setTIPOCONT(parametros.getValor());
			// FORMAADJUD
			cabecera.setFORMAADJUD("");
			// INDCONTDEF
			parametros = new Parametros();
			parametros.setParametro(Y41bADOConstantes.NAME_ADO_EIKA_INDCONTDEF);
			parametros = this.parametrosService.find(parametros);
			cabecera.setINDCONTDEF(parametros.getValor());
			// CODIGOINTERVENCION
			// Aparece en la documentacion pero no en el objeto
			// INDADODIEJEC
			cabecera.setINDADODIEJEC("");
			// NUMLOTE
			cabecera.setNUMLOTE("");
			// REMESA
			cabecera.setREMESA("");

			request.setCABECERA(cabecera);
			// FIN CABECERA

			// INICIO POSICIONES/RETENCIONES
			List<POSICION> listaPosiciones = request.getPOSICION();
			List<RETENCION> listaRetenciones = request.getRETENCION();
			int contador = 1;
			for (Map<String, String> pago : listaPagos) {
				// INICIO POSICION
				POSICION posicion = new POSICION();

				// POSEXPREF
				posicion.setPOSEXPREF("");
				// CENTROGESTOR
				parametros = new Parametros();
				parametros.setParametro(Y41bADOConstantes.NAME_ADO_EIKA_CENTROGESTOR);
				parametros = this.parametrosService.find(parametros);
				posicion.setCENTROGESTOR(parametros.getValor());
				// POSPRESUP
				parametros = new Parametros();
				parametros.setParametro(Y41bADOConstantes.NAME_ADO_EIKA_PARTIDAPRESU);
				parametros = this.parametrosService.find(parametros);
				posicion.setPOSPRESUP(parametros.getValor());
				// ELEMPEP
				parametros = new Parametros();
				parametros.setParametro(Y41bADOConstantes.NAME_ADO_EIKA_ELEMPEP);
				parametros = this.parametrosService.find(parametros);
				posicion.setELEMPEP(parametros.getValor());
				// TERCERO
				posicion.setTERCERO("");
				// NIF
				posicion.setNIF(Y41bUtils.rellenaIzda(pago.get("ID"), "0", 9));
				// IMPORTE
				parametros = new Parametros();
				if ("L".equals(pago.get("TIPO"))) {
					parametros.setParametro(Y41bADOConstantes.NAME_ADO_IMPORTE);
				} else {
					parametros.setParametro(Y41bADOConstantes.NAME_ADO_IMPORTE_PAGPERCOLEGIO);
				}
				parametros = this.parametrosService.find(parametros);
				posicion.setIMPORTE(
						(new BigDecimal(parametros.getValor())).divide(new BigDecimal(100), RoundingMode.UNNECESSARY));
				// CUENTA
				posicion.setCUENTA("");
				// ACTIVO
				posicion.setACTIVO("");
				// SUBACTIVO
				posicion.setSUBACTIVO("");
				// NUMCONTRATO
				posicion.setNUMCONTRATO("");
				// EXPBENEFICIARIO
				posicion.setEXPBENEFICIARIO("");
				// FECHACONCES
				posicion.setFECHACONCES("");
				// TERRITORIO
				parametros = new Parametros();
				parametros.setParametro(Y41bADOConstantes.NAME_ADO_EIKA_TERRITORIO);
				parametros = this.parametrosService.find(parametros);
				posicion.setTERRITORIO(parametros.getValor());
				// VIAPAGO
				parametros = new Parametros();
				parametros.setParametro(Y41bADOConstantes.NAME_ADO_EIKA_VIAPAGO);
				parametros = this.parametrosService.find(parametros);
				posicion.setVIAPAGO(parametros.getValor());
				// TIPOBANCO
				posicion.setTIPOBANCO("");
				// NUMREGCONTABLEFACTURA
				posicion.setNUMREGCONTABLEFACTURA("");
				// AJUST
				posicion.setAJUST("");
				// FECHAJUST
				posicion.setFECHAJUST("");
				// INDIMPUESTO
				posicion.setINDIMPUESTO("");
				// SOCDOCREF
				posicion.setSOCDOCREF("");
				// NDOCDOCREF
				posicion.setNDOCDOCREF("");
				// NPOSDOCREF
				posicion.setNPOSDOCREF("");
				// EJERCDOCREF
				posicion.setEJERCDOCREF("");

				listaPosiciones.add(posicion);
				// FIN POSICION

				// INICIO RETENCION
				RETENCION retencion = new RETENCION();

				// POS
				retencion.setPOS(Y41bUtils.rellenaIzda(String.valueOf(contador), "0", 10));
				contador++;
				// TIPORETENCION
				parametros = new Parametros();
				parametros.setParametro(Y41bADOConstantes.NAME_ADO_EIKA_TIPORETENCION);
				parametros = this.parametrosService.find(parametros);
				retencion.setTIPORETENCION(parametros.getValor());
				// INDRETENCION
				parametros = new Parametros();
				parametros.setParametro(Y41bADOConstantes.NAME_ADO_EIKA_INDRETENCION);
				parametros = this.parametrosService.find(parametros);
				retencion.setINDRETENCION(parametros.getValor());
				// BASERETENCION
				parametros = new Parametros();
				if ("L".equals(pago.get("TIPO"))) {
					parametros.setParametro(Y41bADOConstantes.NAME_ADO_IMPORTE);
				} else {
					parametros.setParametro(Y41bADOConstantes.NAME_ADO_IMPORTE_PAGPERCOLEGIO);
				}
				parametros = this.parametrosService.find(parametros);
				retencion.setBASERETENCION(
						(new BigDecimal(parametros.getValor())).divide(new BigDecimal(100), RoundingMode.UNNECESSARY));
				// CUOTARETENCION
				retencion.setCUOTARETENCION(null);

				listaRetenciones.add(retencion);
				// FIN RETENCION
			}
			// FIN POSICIONES/RETENCIONES

			DTCREARORESPONSE response = this.crearObligacionesServiceImpl.crearObligaciones(null, request);
			if (response != null && response.getMENSAJE() == null) {
				if (response.getCABECERA() != null && response.getCABECERA().getCODIGOEXPEDIENTE() != null
						&& response.getPOSICIONES() != null) {
					listaResultado = new ArrayList<Map<String, String>>();
					List<LINEA> lineas = response.getPOSICIONES().getLINEA();
					for (LINEA linea : lineas) {
						Map<String, String> resultadoPosicion = new HashMap<String, String>();
						resultadoPosicion.put("CODIGOEXPEDIENTE", response.getCABECERA().getCODIGOEXPEDIENTE());
						resultadoPosicion.put("DOCFI", linea.getDOCFI());
						resultadoPosicion.put("ID", linea.getNIF());
						listaResultado.add(resultadoPosicion);
					}
				} else {
					logger.error("Y41bEIKAAdapterServiceImpl.crearObligaciones",
							"No se localiza el codigo de expediente en la cabecera");
					throw new Y41bUDAException(Y41bEIKAAdapterServiceImpl.CADENA_ERROR, true, null);
				}
			} else {
				String error = "";
				if (response != null && response.getMENSAJE() != null) {
					error = response.getMENSAJE().getCODRDO() + " - " + response.getMENSAJE().getDESCRIP();
				}
				logger.error("Y41bEIKAAdapterServiceImpl.crearObligaciones",
						"Respuesta llamada a servicio crear obligaciones error: " + error);
				throw new Y41bUDAException(error, true, null);
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception excCrearObligaciones) {
			logger.error("Y41bEIKAAdapterServiceImpl.crearObligaciones", excCrearObligaciones);
			throw new Y41bUDAException(Y41bEIKAAdapterServiceImpl.CADENA_ERROR, true, excCrearObligaciones);
		} finally {
			logger.info("Y41bEIKAAdapterServiceImpl.crearObligaciones - Final");
		}
		return listaResultado;

	}

	/**
	 * consultaResultadoPagos
	 * 
	 * @param expediente
	 *            String
	 * @param posicion
	 *            String
	 *
	 * @return Date
	 */
	public Date consultaResultadoPagos(String expediente, String docFi) {
		logger.info("Y41bEIKAAdapterServiceImpl.consultaResultadoPagos - Inicio");
		Date resultado = null;
		try {
			DTCONSULTARESULTADOPAGOSREQUEST request = new DTCONSULTARESULTADOPAGOSREQUEST();
			request.setCODIGOEXPEDIENTE(expediente);
			DTCONSULTARESULTADOPAGOSRESPONSE response = this.consultaResultadoPagosServiceImpl
					.consultaResultadoPagos(null, request);
			if (response != null && response.getMENSAJE() == null && response.getRESULTADOPAGOS() != null) {
				for (PAGO pago : response.getRESULTADOPAGOS().getPAGO()) {
					if (pago.getDOCFI() != null && pago.getDOCFI().equals(docFi)) {
						if ("X".equals(pago.getINDPAGADO())) {
							resultado = Y41bUtils.formatearStringToDateFormato(pago.getFECHAPAGO(), "yyyyMMDD");
						}
						break;
					}
				}
			} else {
				String error = "";
				if (response != null && response.getMENSAJE() != null) {
					error = response.getMENSAJE().getCODRDO() + " - " + response.getMENSAJE().getDESCRIP();
				}
				logger.error("Y41bEIKAAdapterServiceImpl.consultaResultadoPagos",
						"Respuesta llamada a servicio consulta resultado pagos error: " + error);
				throw new Y41bUDAException(error, true, null);
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Y41bEIKAAdapterServiceImpl.consultaResultadoPagos", e);
			throw new Y41bUDAException(Y41bEIKAAdapterServiceImpl.CADENA_ERROR, true, e);
		} finally {
			logger.info("Y41bEIKAAdapterServiceImpl.consultaResultadoPagos - Final");
		}
		return resultado;
	}

	/**
	 * consultaTerceros
	 * 
	 * @param id
	 *            String
	 * @param tipoId
	 *            String
	 * @return boolean
	 */
	public boolean consultaTerceros(String id, String tipoId) {
		logger.info("Y41bEIKAAdapterServiceImpl.consultaTerceros - Inicio");
		boolean resultado = false;
		try {
			DTCONSULTATERCEROSREQUEST request = new DTCONSULTATERCEROSREQUEST();
			request.setNIF(Y41bUtils.rellenaIzda(id, "0", 9));
			request.setTIPIDFISCAL(tipoId);
			DTCONSULTATERCEROSRESPONSE respuesta = this.consultaTercerosServiceImpl.consultaTerceros(null, request);
			boolean resultadoCorrecto = respuesta != null && respuesta.getMENSAJE() != null
					&& Y41bConstantes.EIKA_RESULTADO_CORRECTO.equals(respuesta.getMENSAJE().getCODRDO());
			if (resultadoCorrecto) {
				boolean situacionAprobado = respuesta.getDATOSGENERALESTERCERO() != null
						&& Y41bConstantes.EIKA_SITUACION_APROBADO
								.equals(respuesta.getDATOSGENERALESTERCERO().getSITUACION());
				boolean estadoOperativo = respuesta.getDATOSGENERALESTERCERO() != null
						&& Y41bConstantes.EIKA_ESTADO_OPERATIVO
								.equals(respuesta.getDATOSGENERALESTERCERO().getESTADO());
				boolean retencionG = false;
				if (respuesta.getDATOSRETENCIONES() != null) {
					List<com.ejie.y41b.ws.cliente.eika.tesoreria.consultaTerceros.DTCONSULTATERCEROSRESPONSE.DATOSRETENCIONES.LINEA> listaLineas = respuesta
							.getDATOSRETENCIONES().getLINEA();
					for (com.ejie.y41b.ws.cliente.eika.tesoreria.consultaTerceros.DTCONSULTATERCEROSRESPONSE.DATOSRETENCIONES.LINEA linea : listaLineas) {
						if ("G".equals(linea.getINDRETENCION())) {
							retencionG = true;
							break;
						}
					}
				}
				resultado = resultadoCorrecto && situacionAprobado && estadoOperativo && retencionG;
			} else {
				resultado = false;
				String error;
				if (respuesta != null && respuesta.getMENSAJE() != null) {
					error = respuesta.getMENSAJE().getCODRDO() + " - " + respuesta.getMENSAJE().getDESCRIP();
				} else {
					error = "Respuesta es null";
				}
				logger.error("Y41bEIKAAdapterServiceImpl.consultaTerceros",
						"Respuesta llamada a servicio consulta terceros error: " + error);
				throw new Y41bUDAException(error, true, null);
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception excConsultaTerceros) {
			logger.error("Y41bEIKAAdapterServiceImpl.consultaTerceros", excConsultaTerceros);
			throw new Y41bUDAException(Y41bEIKAAdapterServiceImpl.CADENA_ERROR, true, excConsultaTerceros);
		} finally {
			logger.info("Y41bEIKAAdapterServiceImpl.consultaTerceros - Final");
		}
		return resultado;

	}

}
