package com.ejie.y41b.adapter;

import java.util.List;

import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.DocumentoBusqueda;
import com.ejie.y41b.model.dokusi.Formato;
import com.ejie.y41b.model.dokusi.LocalizadorDocumento;
import com.ejie.y41b.model.dokusi.RespuestaEliminarDocumento;
import com.ejie.y41b.model.dokusi.RespuestaLocalizadorDocumento;
import com.ejie.y41b.model.dokusi.RespuestaTransformarDocumento;
import com.ejie.y41b.model.dokusi.TransformarDocumento;

/**
 * Y41bDokusiAdapterService.
 * 
 *  
 */

public interface Y41bDokusiAdapterService {

	/**
	 * Metodo que obtiene los ids de documentos obtenidos filtrando por una
	 * lista de metadatos
	 * 
	 * @param documentoBusqueda
	 *            Objeto con los atributos necesarios para el filtro de
	 *            documentos
	 * @return List<Documento>.
	 */
	public List<Documento> buscarDocumentosDokusi(DocumentoBusqueda documentoBusqueda);

	/**
	 * Metodo que registra el documento en DOKUSI
	 * 
	 * @param documento
	 *            Objeto con los atributos necesarios para registrar el
	 *            documento en dokusi
	 * 
	 * @return Documento.
	 */
	public Documento registrarDocumentoDokusi(Documento documento);

	/**
	 * Metodo que registra el documento en DOKUSI Sin localizar Ni transformar
	 * 
	 * @param documento
	 *            Objeto con los atributos necesarios para registrar el
	 *            documento en dokusi
	 * 
	 * @return Documento.
	 */
	public Documento registrarDocumentoDokusiSinLocalizar(Documento documento);

	/**
	 * Metodo que retramita el documento en DOKUSI
	 * 
	 * @param documento
	 *            Objeto con los atributos necesarios para retramitar el
	 *            documento en dokusi
	 * 
	 * @return String.
	 */
	public String retramitarDocumentoDokusi(Documento documento);

	/**
	 * Metodo que modifica el documento en DOKUSI
	 * 
	 * @param documento
	 *            Objeto con los atributos necesarios para registrar el
	 *            documento en dokusi
	 * 
	 * @return Documento.
	 */
	public Documento modificarDocumentoDokusi(Documento documento);

	/**
	 * Metodo que descarga el documento de DOKUSI
	 * 
	 * @param documento
	 *            Objeto con los atributos necesarios para registrar el
	 *            documento en dokusi
	 * 
	 * @return Documento.
	 */
	public Documento descargarDocumentoDokusi(Documento documento);

	/**
	 * Metodo que descarga el documento de SIR
	 * 
	 * @param documento
	 *            Objeto con los atributos necesarios para registrar el
	 *            documento en dokusi
	 * 
	 * @return Documento.
	 */
	public Documento descargarDocumentoSIR(Documento documento);

	/**
	 * Metodo que descarga el documento de DOKUSI
	 * 
	 * @param documento
	 *            Objeto con los atributos necesarios para registrar el
	 *            documento en dokusi
	 * 
	 * @return Documento.
	 */
	public Documento descargarDocumentoDokusiSinDocumento(Documento documento);

	/**
	 * Metodo que descarga el documento de DOKUSI y lo deja en PIF
	 * 
	 * @param documento
	 *            Objeto con los atributos necesarios para registrar el
	 *            documento en dokusi
	 * 
	 * @return Documento.
	 */
	public Documento descargarPifDocumentoDokusi(Documento documento);

	/**
	 * Metodo que descarga el documento de DOKUSI y lo deja en PIF
	 * 
	 * @param documento
	 *            Objeto con los atributos necesarios para registrar el
	 *            documento en dokusi
	 * @param pathTo
	 *            Ruta donde dejar el documento
	 * @return Documento.
	 */
	public Documento descargarPifDocumentoDokusiRuta(Documento documento, String pathTo);

	/**
	 * Metodo que elimina el documento de DOKUSI
	 * 
	 * @param documento
	 *            Objeto con los atributos necesarios para eliminar el documento
	 *            en dokusi
	 * 
	 * @return RespuestaEliminarDocumento.
	 */
	public RespuestaEliminarDocumento eliminarDocumentoDokusi(Documento documento);

	/**
	 * Metodo que recupera las firmas de un documento de DOKUSI
	 * 
	 * @param documento
	 *            Objeto con los atributos necesarios para eliminar el documento
	 *            en dokusi
	 * 
	 * @return Documento.
	 */
	public Documento recuperarFirmarDocumentosDokusi(Documento documento);

	/**
	 * Método que permite añadir firmas a un documento almacenado en DOKUSI
	 * 
	 * @param documento
	 *            Objeto con los atributos necesarios para eliminar el documento
	 *            en dokusi
	 * 
	 * @return String.
	 */
	public String firmarDocumentosDokusi(Documento documento);

	/**
	 * Método que incorpora un localizador a un documento de DOKUSI
	 * 
	 * @param localizadorDocumento
	 *            LocalizadorDocumento
	 * 
	 * @return RespuestaLocalizadorDocumento.
	 */
	public RespuestaLocalizadorDocumento incorporarLocalizadorDokusi(LocalizadorDocumento localizadorDocumento);

	/**
	 * Metodo que transforma un documento de DOKUSI
	 * 
	 * @param transformarDocumento
	 *            TransformarDocumento
	 * 
	 * @return RespuestaTransformarDocumento.
	 */
	public RespuestaTransformarDocumento transformarDocumentoDokusi(TransformarDocumento transformarDocumento);

	/**
	 * Metodo que recupera los formatos de un documento de DOKUSI
	 * 
	 * @param documento
	 *            Objeto con los atributos necesarios para recuperar el formato
	 *            del documento en dokusi
	 * 
	 * @return Formato.
	 */
	public Formato recuperarFormatosDocumentosDokusi(Documento documento);

	/**
	 * Metodo que genera un nuevo documento copia que comparte el contenido del
	 * original.
	 * 
	 * @param documento
	 *            Objeto con los atributos necesarios para compartir el
	 *            documento en dokusi
	 * 
	 * @return Documento.
	 */
	public Documento shareDocumentContents(Documento documento);

	/**
	 * Método que permitirá cambiar un documento de contexto de Registro a
	 * contexto de Tramitación y modifica el acl o la serie documental de un
	 * documento de DOKUSI
	 * 
	 * @param documento
	 *            Objeto con los atributos necesarios para para modificar el acl
	 *            o la serie documental del documento en dokusi
	 * 
	 * @return boolean.
	 */
	public boolean tramitarDocumentoDokusi(Documento documento);

	/**
	 * Metodo que recupera las firmas de un documento de DOKUSI
	 * 
	 * @param documento
	 *            Objeto con los atributos necesarios para eliminar el documento
	 *            en dokusi
	 * 
	 * @return String.
	 */
	public String recuperarFirmarDocumentosDokusiString(Documento documento);
}
