package com.ejie.y41e.webservices;

import java.util.List;
import java.util.Locale;

import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.ejie.y41e.common.Y41eConstants;
import com.ejie.y41e.model.Y41eEncuesta;
import com.ejie.y41e.model.Y41eEnvio;
import com.ejie.y41e.model.webservice.Y41eEncuestaWs;
import com.ejie.y41e.model.webservice.Y41eResultadoWs;
import com.ejie.y41e.service.Y41eEncuestaService;
import com.ejie.y41e.service.Y41eEncuestaWSService;
import com.ejie.y41e.service.Y41eEnviosService;

/**
 * The type Y41eWebServiceImpl.
 *
 *  
 *
 */
@WebService(serviceName = "y41eWebService", portName = "y41eWebServicePort", targetNamespace = "http://com.ejie.y41e.webservices")
@SOAPBinding(parameterStyle = ParameterStyle.WRAPPED)
@HandlerChain(file = "server-handlers.xml")
public class Y41eWebServiceImpl extends SpringBeanAutowiringSupport {

    @Autowired()
    private ReloadableResourceBundleMessageSource appMessageSource;
    @Autowired()
    private Y41eEncuestaWSService y41eEncuestaWSService;
    @Autowired
    private Y41eEncuestaService y41eEncuestaService;
    @Autowired
    private Y41eEnviosService y41eEnviosService;


    private static final Logger LOGGER = LoggerFactory.getLogger(Y41eWebServiceImpl.class);

    /**
     * Da de alta una solicitud de asesoramiento
     * 
     * @param solicitud
     *            Y41eSolicitudAsesoramiento
     * @return Y41eRespuesta
     */
    @WebMethod()
    @WebResult(name = "resultado")
    public Y41eResultadoWs envioEncuestas(@WebParam(name = "encuesta") Y41eEncuestaWs encuestaWs) {
        Y41eWebServiceImpl.LOGGER.info("envioEncuestas");
        Locale localeEs = new Locale(Y41eConstants.LANG_CASTELLANO);
        Locale localeEu = new Locale(Y41eConstants.LANG_EUSKERA);
        Y41eResultadoWs rdo = new Y41eResultadoWs();

        rdo = y41eEncuestaWSService.validarCamposObligatorios(encuestaWs);
        if (StringUtils.isNotBlank(rdo.getCodigo())) {
            return rdo;
        }
        // buscar encuesta
        Y41eEncuesta encuesta = new Y41eEncuesta();
        encuesta.setIdEncuesta(Long.valueOf(encuestaWs.getIdEncuesta()));
        encuesta.setActiva(Y41eConstants.SI);
        encuesta = y41eEncuestaService.find(encuesta);
        // comprobar que existe
        if (encuesta == null) {
            rdo.setCodigo(Y41eConstants.RETORNO_WS_ENCUESTA_NO_EXISTE);
            rdo.setDescripcionEs(appMessageSource.getMessage("retornoWs.encuestaNoExiste", null, localeEs));
            rdo.setDescripcionEu(appMessageSource.getMessage("retornoWs.encuestaNoExiste", null, localeEu));
            return rdo;
        }

        final List<Y41eEnvio> listaEnvios = y41eEncuestaWSService.crearEnvios(encuesta, encuestaWs.getListaUsuarios());
        //guardar envíos
        try {
            y41eEnviosService.guardarEnvios(encuesta, listaEnvios);
        }catch (Exception e) {
            Y41eWebServiceImpl.LOGGER.error("Error al guardar los envios " + e);
            rdo.setCodigo(Y41eConstants.RETORNO_WS_GUARDAR_ENVIOS);
            rdo.setDescripcionEs(appMessageSource.getMessage("retornoWs.errorGuardarEnvios", null, localeEs));
            rdo.setDescripcionEu(appMessageSource.getMessage("retornoWs.errorGuardarEnvios", null, localeEu));
            return rdo;
        }
        //enviar emails
        try {
            y41eEncuestaWSService.notificarEnvios(encuesta, listaEnvios);
        }catch (Exception e) {
            Y41eWebServiceImpl.LOGGER.error("Error al enviar los mails " + e);
            rdo.setCodigo(Y41eConstants.RETORNO_WS_ENVIAR_EMAILS);
            rdo.setDescripcionEs(appMessageSource.getMessage("retornoWs.errorEnvioMails", null, localeEs));
            rdo.setDescripcionEu(appMessageSource.getMessage("retornoWs.errorEnvioMails", null, localeEu));
            return rdo;
        }

        rdo.setCodigo(Y41eConstants.RETORNO_WS_OK);
        rdo.setDescripcionEs(appMessageSource.getMessage("retornoWs.ok", null, localeEs));
        rdo.setDescripcionEu(appMessageSource.getMessage("retornoWs.ok", null, localeEu));
        return rdo;
    }

}