package com.ejie.y41e.control;

import java.util.List;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.y41e.model.Y41eTipoRespuesta;
import com.ejie.y41e.service.Y41eTipoRespuestaService;

/**
 * Y41eTipoRespustaController
 *  
 */

@Controller
@RequestMapping (value = "/tipoRespuesta")

public class Y41eTipoRespustaController  {

    private static final Logger LOGGER = LoggerFactory.getLogger(Y41eTipoRespustaController.class);

    @Autowired
    private Y41eTipoRespuestaService y41eTipoRespuestaService;

    @RequestMapping(value = "/respuestasAviso", method = RequestMethod.GET)
    @ResponseBody() public List<Y41eTipoRespuesta> getAllRespuestas(@RequestParam(value="tipoPregunta.idTipoPregunta",required = false) Long idTipoPregunta, Locale locale) {
        Y41eTipoRespustaController.LOGGER.info("[GET - find_ALL] : getAllRespuestas");
        Y41eTipoRespuesta tipoRespuesta = new Y41eTipoRespuesta();
        tipoRespuesta.getTipoPregunta().setIdTipoPregunta(idTipoPregunta);
        return y41eTipoRespuestaService.findAllRespuesta(tipoRespuesta);
    }

}
