package com.ejie.y41e.control;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.y41e.common.Y41eConstants;
import com.ejie.y41e.model.Y41eTipoPregunta;
import com.ejie.y41e.service.Y41eTipoPreguntaService;

/**
 * Y41eTipoPreguntaController
 *  
 */

@Controller
@RequestMapping (value = "/tipoPregunta")

public class Y41eTipoPreguntaController  {

    private static final Logger LOGGER = LoggerFactory.getLogger(Y41eTipoPreguntaController.class);

    @Autowired
    private Y41eTipoPreguntaService y41eTipoPreguntaService;

    /**
     * Devuelve una lista de beans correspondientes a los valores de filtrados
     * indicados en el objeto pasado como parametro.
     *
     * @param filterY41eTipoPregunta Y41eTipoPregunta
     *            Objeto que contiene los parametros de filtrado utilizados en
     *            la busqueda.
     * @return List<Y41eTipoPregunta> 
     *            Lista de objetos correspondientes a la busqueda realizada.
     */
    @RequestMapping(method = RequestMethod.GET)
    @ResponseBody public List<Y41eTipoPregunta> getAll(@ModelAttribute Y41eTipoPregunta filterY41eTipoPregunta) {
        Y41eTipoPreguntaController.LOGGER.info("[GET - find_ALL] : Obtener Y41eTipoPregunta por filtro");
        filterY41eTipoPregunta.setActiva(Y41eConstants.SI);
        return this.y41eTipoPreguntaService.findAll(filterY41eTipoPregunta, null);
    }

}
