package com.ejie.y41e.control;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.y41e.model.Y41eRelEncuestaBloque;
import com.ejie.y41e.service.Y41eRelEncuestaBloqueService;

/**
 * Y41eRelEncuestaBloqueController
 *  
 */

@Controller
@RequestMapping (value = "/relencuestabloque")

public class Y41eRelEncuestaBloqueController  {

    private static final Logger LOGGER = LoggerFactory.getLogger(Y41eRelEncuestaBloqueController.class);

    @Autowired
    private Y41eRelEncuestaBloqueService relEncuestaBloqueService;


    /**
     * Operacion de filtrado del componente RUP_TABLE.
     * 
     * @param filterRelEncuestaBloque RelEncuestaBloque
     *            Bean que contiene los parametros de filtrado a emplear.
     * @param jqGridRequestDto
     *            Dto que contiene los parametros de configuracion propios del
     *            RUP_TABLE a aplicar en el filtrado.
     * @return JQGridResponseDto<RelEncuestaBloque>
     *            Dto que contiene el resultado del filtrado realizado por el 
     *            componente RUP_TABLE.
     */
    @RequestMapping(value = "/filter", method = RequestMethod.POST)
    @ResponseBody public JQGridResponseDto<Y41eRelEncuestaBloque> filter(
            @RequestJsonBody(param="filter") Y41eRelEncuestaBloque filterRelEncuestaBloque,
            @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
        Y41eRelEncuestaBloqueController.LOGGER.info("[POST - filter] : Obtener RelEncuestaBloques");
        return this.relEncuestaBloqueService.filter(filterRelEncuestaBloque, jqGridRequestDto, false);
    }

    /**
     * Ordena las bloques según el orden pasado
     *
     * @param orden String
     * @param idEncuesta String
     */
    @RequestMapping(value = "/moverBloque", method = RequestMethod.POST)
    @ResponseBody public void moverBloque(@RequestJsonBody(param="orden") String orden, @RequestJsonBody(param="idEncuesta") String idEncuesta) {
        Y41eRelEncuestaBloqueController.LOGGER.info("[POST] : moverBloque");
        this.relEncuestaBloqueService.moverBloque(orden, idEncuesta);
    }


    /**
     * Operacion CRUD Read. Devuelve el bean correspondiente al identificador indicado.
     * 
     * @param idEncuesta Long
     * @param idBloque Long
     * @return RelEncuestaBloque 
     *            Objeto correspondiente al identificador indicado.
     */
    @RequestMapping(value = "/{idEncuesta}/{idBloque}", method = RequestMethod.GET)
    @ResponseBody public Y41eRelEncuestaBloque get(@PathVariable Long idEncuesta, @PathVariable Long idBloque) {
        Y41eRelEncuestaBloque relEncuestaBloque = new Y41eRelEncuestaBloque();
        relEncuestaBloque.getEncuesta().setIdEncuesta(idEncuesta);
        relEncuestaBloque.getBloque().setIdBloque(idBloque);
        relEncuestaBloque = this.relEncuestaBloqueService.find(relEncuestaBloque);
        Y41eRelEncuestaBloqueController.LOGGER.info("[GET - findBy_PK] : Obtener RelEncuestaBloque por PK");
        return relEncuestaBloque;
    }

    /**
     * Devuelve una lista de beans correspondientes a los valores de filtrados
     * indicados en el objeto pasado como parametro.
     *
     * @param filterRelEncuestaBloque RelEncuestaBloque
     *            Objeto que contiene los parametros de filtrado utilizados en
     *            la busqueda.
     * @return List<RelEncuestaBloque> 
     *            Lista de objetos correspondientes a la busqueda realizada.
     */
    @RequestMapping(method = RequestMethod.GET)
    @ResponseBody public List<Y41eRelEncuestaBloque> getAll(@ModelAttribute Y41eRelEncuestaBloque filterRelEncuestaBloque) {
        Y41eRelEncuestaBloqueController.LOGGER.info("[GET - find_ALL] : Obtener RelEncuestaBloque por filtro");
        return this.relEncuestaBloqueService.findAll(filterRelEncuestaBloque, null);
    }

    /**
     * Operacion CRUD Edit. Modificacion del bean indicado.
     *
     * @param relEncuestaBloque RelEncuestaBloque 
     *            Bean que contiene la informacion a modificar.
     * @return RelEncuestaBloque 
     *            Bean resultante de la modificacion.
     */
    @RequestMapping(method = RequestMethod.PUT)
    @ResponseBody public Y41eRelEncuestaBloque edit(@RequestBody Y41eRelEncuestaBloque relEncuestaBloque) {
        Y41eRelEncuestaBloque relEncuestaBloqueAux = this.relEncuestaBloqueService.update(relEncuestaBloque);
        Y41eRelEncuestaBloqueController.LOGGER.info("[PUT] : RelEncuestaBloque actualizado correctamente");
        return relEncuestaBloqueAux;
    }

    /**
     * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
     * indicado.
     *
     * @param relEncuestaBloque RelEncuestaBloque 
     *            Bean que contiene la informacion con la que se va a crear el
     *            nuevo registro.
     * @return RelEncuestaBloque
     *            Bean resultante del proceso de creacion.
     */
    @RequestMapping(method = RequestMethod.POST)
    @ResponseBody public Y41eRelEncuestaBloque add(@RequestBody Y41eRelEncuestaBloque relEncuestaBloque) {
        Y41eRelEncuestaBloque relEncuestaBloqueAux = this.relEncuestaBloqueService.add(relEncuestaBloque);
        Y41eRelEncuestaBloqueController.LOGGER.info("[POST] : RelEncuestaBloque insertado correctamente");
        return relEncuestaBloqueAux;
    }

    /**
     * Operacion CRUD Delete. Borrado del registro correspondiente al
     * identificador especificado.
     *
     * @param idEncuesta Long
     * @param idBloque Long
     *            Identificador del objeto que se desea eliminar.
     * @return RelEncuestaBloque
     *            Bean eliminado.
     */
    @RequestMapping(value = "/{idEncuesta}/{idBloque}", method = RequestMethod.DELETE)
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody public Y41eRelEncuestaBloque remove(@PathVariable Long idEncuesta, @PathVariable Long idBloque) {
        Y41eRelEncuestaBloque relEncuestaBloque = new Y41eRelEncuestaBloque();
        relEncuestaBloque.getEncuesta().setIdEncuesta(idEncuesta);
        relEncuestaBloque.getBloque().setIdBloque(idBloque);
        this.relEncuestaBloqueService.remove(relEncuestaBloque);
        Y41eRelEncuestaBloqueController.LOGGER.info("[DELETE] : RelEncuestaBloque borrado correctamente");
        return relEncuestaBloque;
    }


    /*
     * METODOS COMPONENTE RUP_TABLE
     * 
     */

    /**
     * Metodo de presentacion del RUP_TABLE.
     * 
     * @param model Model
     * @return String
     */
    @RequestMapping(value = "/maint", method = RequestMethod.GET)
    public String getFormEdit(Model model) {
        Y41eRelEncuestaBloqueController.LOGGER.info("[GET - View] : relencuestabloque");
        return "relencuestabloque";
    }
}
