package com.ejie.y41e.control;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.y41e.model.Y41eRelBloquePregunta;
import com.ejie.y41e.service.Y41eRelBloquePreguntaService;

/**
 * Y41eRelBloquePreguntaController
 *  
 */

@Controller
@RequestMapping (value = "/relbloquepregunta")

public class Y41eRelBloquePreguntaController  {

    private static final Logger LOGGER = LoggerFactory.getLogger(Y41eRelBloquePreguntaController.class);

    @Autowired
    private Y41eRelBloquePreguntaService relBloquePreguntaService;

    /**
     * Ordena las pregutnas según el orden pasado
     *
     * @param orden String
     * @param idBloque String
     */
    @RequestMapping(value = "/moverPregunta", method = RequestMethod.POST)
    @ResponseBody public void moverPregunta(@RequestJsonBody(param="orden") String orden, @RequestJsonBody(param="idBloque") String idBloque) {
        Y41eRelBloquePreguntaController.LOGGER.info("[POST] : moverPregunta");
        this.relBloquePreguntaService.moverPregunta(orden, idBloque);
    }

    /**
     * Operacion CRUD Read. Devuelve el bean correspondiente al identificador indicado.
     * 
     * @param idBloque Long
     * @param idPregunta Long
     * @return RelBloquePregunta 
     *            Objeto correspondiente al identificador indicado.
     */
    @RequestMapping(value = "/{idBloque}/{idPregunta}", method = RequestMethod.GET)
    @ResponseBody public Y41eRelBloquePregunta get(@PathVariable Long idBloque, @PathVariable Long idPregunta) {
        Y41eRelBloquePregunta relBloquePregunta = new Y41eRelBloquePregunta();
        relBloquePregunta.getBloque().setIdBloque(idBloque);
        relBloquePregunta.getPregunta().setIdPregunta(idPregunta);
        relBloquePregunta = this.relBloquePreguntaService.find(relBloquePregunta);
        Y41eRelBloquePreguntaController.LOGGER.info("[GET - findBy_PK] : Obtener RelBloquePregunta por PK");
        return relBloquePregunta;
    }

    /**
     * Devuelve una lista de beans correspondientes a los valores de filtrados
     * indicados en el objeto pasado como parametro.
     *
     * @param filterRelBloquePregunta RelBloquePregunta
     *            Objeto que contiene los parametros de filtrado utilizados en
     *            la busqueda.
     * @return List<RelBloquePregunta> 
     *            Lista de objetos correspondientes a la busqueda realizada.
     */
    @RequestMapping(method = RequestMethod.GET)
    @ResponseBody public List<Y41eRelBloquePregunta> getAll(@ModelAttribute Y41eRelBloquePregunta filterRelBloquePregunta) {
        Y41eRelBloquePreguntaController.LOGGER.info("[GET - find_ALL] : Obtener RelBloquePregunta por filtro");
        return this.relBloquePreguntaService.findAll(filterRelBloquePregunta, null);
    }

    /**
     * Operacion CRUD Edit. Modificacion del bean indicado.
     *
     * @param relBloquePregunta RelBloquePregunta 
     *            Bean que contiene la informacion a modificar.
     * @return RelBloquePregunta 
     *            Bean resultante de la modificacion.
     */
    @RequestMapping(method = RequestMethod.PUT)
    @ResponseBody public Y41eRelBloquePregunta edit(@RequestBody Y41eRelBloquePregunta relBloquePregunta) {
        Y41eRelBloquePregunta relBloquePreguntaAux = this.relBloquePreguntaService.update(relBloquePregunta);
        Y41eRelBloquePreguntaController.LOGGER.info("[PUT] : RelBloquePregunta actualizado correctamente");
        return relBloquePreguntaAux;
    }

    /**
     * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
     * indicado.
     *
     * @param relBloquePregunta RelBloquePregunta 
     *            Bean que contiene la informacion con la que se va a crear el
     *            nuevo registro.
     * @return RelBloquePregunta
     *            Bean resultante del proceso de creacion.
     */
    @RequestMapping(method = RequestMethod.POST)
    @ResponseBody public Y41eRelBloquePregunta add(@RequestBody Y41eRelBloquePregunta relBloquePregunta) {
        Y41eRelBloquePregunta relBloquePreguntaAux = this.relBloquePreguntaService.add(relBloquePregunta);
        Y41eRelBloquePreguntaController.LOGGER.info("[POST] : RelBloquePregunta insertado correctamente");
        return relBloquePreguntaAux;
    }

    /**
     * Operacion CRUD Delete. Borrado del registro correspondiente al
     * identificador especificado.
     *
     * @param idBloque Long
     * @param idPregunta Long
     *            Identificador del objeto que se desea eliminar.
     * @return RelBloquePregunta
     *            Bean eliminado.
     */
    @RequestMapping(value = "/{idEncuesta}/{idBloque}/{idPregunta}", method = RequestMethod.DELETE)
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody public Y41eRelBloquePregunta remove(@PathVariable Long idEncuesta, @PathVariable Long idBloque, @PathVariable Long idPregunta) {
        Y41eRelBloquePregunta relBloquePregunta = new Y41eRelBloquePregunta();
        relBloquePregunta.getBloque().setIdEncuesta(idEncuesta);
        relBloquePregunta.getBloque().setIdBloque(idBloque);
        relBloquePregunta.getPregunta().setIdPregunta(idPregunta);
        this.relBloquePreguntaService.remove(relBloquePregunta);
        Y41eRelBloquePreguntaController.LOGGER.info("[DELETE] : RelBloquePregunta borrado correctamente");
        return relBloquePregunta;
    }

    /**
     * Operacion de filtrado del componente RUP_TABLE.
     * 
     * @param filterRelBloquePregunta RelBloquePregunta
     *            Bean que contiene los parametros de filtrado a emplear.
     * @param jqGridRequestDto
     *            Dto que contiene los parametros de configuracion propios del
     *            RUP_TABLE a aplicar en el filtrado.
     * @return JQGridResponseDto<RelBloquePregunta>
     *            Dto que contiene el resultado del filtrado realizado por el 
     *            componente RUP_TABLE.
     */
    @RequestMapping(value = "/filter", method = RequestMethod.POST)
    @ResponseBody public JQGridResponseDto<Y41eRelBloquePregunta> filter(
            @RequestJsonBody(param="filter") Y41eRelBloquePregunta filterRelBloquePregunta,
            @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
        Y41eRelBloquePreguntaController.LOGGER.info("[POST - filter] : Obtener RelBloquePreguntas");
        return this.relBloquePreguntaService.filter(filterRelBloquePregunta, jqGridRequestDto, false);
    }
}
