package com.ejie.y41e.control;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.y41e.model.Y41ePregunta;
import com.ejie.y41e.model.Y41ePreguntaEnlazada;
import com.ejie.y41e.service.Y41ePreguntaEnlazadaService;

/**
 * Y41ePreguntaEnlazadaController
 *  
 */

@Controller
@RequestMapping (value = "/preguntaEnlazada")

public class Y41ePreguntaEnlazadaController  {

    private static final Logger LOGGER = LoggerFactory.getLogger(Y41ePreguntaEnlazadaController.class);

    @Autowired
    private Y41ePreguntaEnlazadaService y41ePreguntaEnlazadaService;

    /**
     * Obtiene la pregunta y sus enlazadas
     * @param idPreguntaPadre Long
     * @param idBloqueEnlazar Long
     * @param idEncuestaEnlazar Long
     * @return Y41ePregunta
     */
    @RequestMapping(value = "/treePreguntaEnlazada", method = RequestMethod.GET)
    @ResponseBody() public Y41ePregunta getTreePreguntasEnlazadas(
            @RequestParam(required=true) Long idPreguntaPadre,
            @RequestParam(required=true) Long idBloqueEnlazar,
            @RequestParam(required=true) Long idEncuestaEnlazar) {
        Y41ePreguntaEnlazadaController.LOGGER.info("[GET - getTreePreguntasEnlazadas]");
        return this.y41ePreguntaEnlazadaService.findTreeEnlazadas(idPreguntaPadre, idBloqueEnlazar, idEncuestaEnlazar);
    }

    /**
     * Enlaza las preguntas seleccionadas
     * @param selectedIds List<String>
     * @param idPregunta Long
     */
    @RequestMapping(value = "/enlazarPreguntas", method = RequestMethod.POST)
    @ResponseBody() public void enlazarPreguntas(
            @RequestJsonBody(param = "selectedIds") List<String> selectedIds,
            @RequestJsonBody(param = "idPregunta") Long idPregunta,
            @RequestJsonBody(param = "idBloque") Long idBloque,
            @RequestJsonBody(param = "idEncuesta") Long idEncuesta) {
        Y41ePreguntaEnlazadaController.LOGGER.info("[POST] : enlazarPreguntas");
        Y41ePreguntaEnlazada preguntaEnlazada = new Y41ePreguntaEnlazada(idEncuesta, idBloque, idPregunta);
        y41ePreguntaEnlazadaService.addEnlazadas(selectedIds, preguntaEnlazada);
    }

}
