package com.ejie.y41e.control;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;
import com.ejie.y41e.common.Y41eConstants;
import com.ejie.y41e.model.Y41eOrigen;
import com.ejie.y41e.service.Y41eOrigenService;

/**
 * Y41eOrigenController
 *  
 */

@Controller
@RequestMapping (value = "/otrosMant/origen")

public class Y41eOrigenController  {

    private static final Logger LOGGER = LoggerFactory.getLogger(Y41eOrigenController.class);

    @Autowired
    private Y41eOrigenService y41eOrigenService;

    /*
     * OPERACIONES CRUD (Create, Read, Update, Delete)
     * 
     */

    /**
     * Operacion CRUD Read. Devuelve el bean correspondiente al identificador indicado.
     * 
     * @param idOrigen Long
     * @return Y41eOrigen 
     *            Objeto correspondiente al identificador indicado.
     */
    @RequestMapping(value = "/{idOrigen}", method = RequestMethod.GET)
    @ResponseBody public Y41eOrigen get(@PathVariable Long idOrigen) {
        Y41eOrigen y41eOrigen = new Y41eOrigen();
        y41eOrigen.setIdOrigen(idOrigen);
        y41eOrigen = this.y41eOrigenService.find(y41eOrigen);
        Y41eOrigenController.LOGGER.info("[GET - findBy_PK] : Obtener Y41eOrigen por PK");
        return y41eOrigen;
    }

    /**
     * Devuelve una lista de beans correspondientes a los valores de filtrados
     * indicados en el objeto pasado como parametro.
     *
     * @param filterY41eOrigen Y41eOrigen
     *            Objeto que contiene los parametros de filtrado utilizados en
     *            la busqueda.
     * @return List<Y41eOrigen> 
     *            Lista de objetos correspondientes a la busqueda realizada.
     */
    @RequestMapping(method = RequestMethod.GET)
    @ResponseBody public List<Y41eOrigen> getAll(@ModelAttribute Y41eOrigen filterY41eOrigen) {
        Y41eOrigenController.LOGGER.info("[GET - find_ALL] : Obtener Y41eOrigen por filtro");
        filterY41eOrigen.setActiva(Y41eConstants.SI);
        return this.y41eOrigenService.findAll(filterY41eOrigen, null);
    }

    /**
     * Operacion CRUD Edit. Modificacion del bean indicado.
     *
     * @param y41eOrigen Y41eOrigen 
     *            Bean que contiene la informacion a modificar.
     * @return Y41eOrigen 
     *            Bean resultante de la modificacion.
     */
    @RequestMapping(method = RequestMethod.PUT)
    @ResponseBody public Y41eOrigen edit(@RequestBody Y41eOrigen y41eOrigen) {
        Y41eOrigen y41eOrigenAux = this.y41eOrigenService.update(y41eOrigen);
        Y41eOrigenController.LOGGER.info("[PUT] : Y41eOrigen actualizado correctamente");
        return y41eOrigenAux;
    }

    /**
     * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
     * indicado.
     *
     * @param y41eOrigen Y41eOrigen 
     *            Bean que contiene la informacion con la que se va a crear el
     *            nuevo registro.
     * @return Y41eOrigen
     *            Bean resultante del proceso de creacion.
     */
    @RequestMapping(method = RequestMethod.POST)
    @ResponseBody public Y41eOrigen add(@RequestBody Y41eOrigen y41eOrigen) {
        Y41eOrigen y41eOrigenAux = this.y41eOrigenService.add(y41eOrigen);
        Y41eOrigenController.LOGGER.info("[POST] : Y41eOrigen insertado correctamente");
        return y41eOrigenAux;
    }

    /**
     * Operacion CRUD Delete. Borrado del registro correspondiente al
     * identificador especificado.
     *
     * @param idOrigen Long
     *            Identificador del objeto que se desea eliminar.
     * @return Y41eOrigen
     *            Bean eliminado.
     */
    @RequestMapping(value = "/{idOrigen}", method = RequestMethod.DELETE)
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody public Y41eOrigen remove(@PathVariable Long idOrigen) {
        Y41eOrigen y41eOrigen = new Y41eOrigen();
        y41eOrigen.setIdOrigen(idOrigen);
        this.y41eOrigenService.remove(y41eOrigen);
        Y41eOrigenController.LOGGER.info("[DELETE] : Y41eOrigen borrado correctamente");
        return y41eOrigen;
    }


    /*
     * METODOS COMPONENTE RUP_TABLE
     * 
     */

    /**
     * Metodo de presentacion del RUP_TABLE.
     * 
     * @param model Model
     * @return String
     */
    @RequestMapping(value = "/maint", method = RequestMethod.GET)
    public String getFormEdit(Model model) {
        Y41eOrigenController.LOGGER.info("[GET - View] : origen");
        return "origen";
    }

    /**
     * Operacion de filtrado del componente RUP_TABLE.
     * 
     * @param filterY41eOrigen Y41eOrigen
     *            Bean que contiene los parametros de filtrado a emplear.
     * @param jqGridRequestDto
     *            Dto que contiene los parametros de configuracion propios del
     *            RUP_TABLE a aplicar en el filtrado.
     * @return JQGridResponseDto<Y41eOrigen>
     *            Dto que contiene el resultado del filtrado realizado por el 
     *            componente RUP_TABLE.
     */
    @RequestMapping(value = "/filter", method = RequestMethod.POST)
    @ResponseBody public JQGridResponseDto<Y41eOrigen> filter(
            @RequestJsonBody(param="filter") Y41eOrigen filterY41eOrigen,
            @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
        Y41eOrigenController.LOGGER.info("[POST - filter] : Obtener Y41eOrigens");
        return this.y41eOrigenService.filter(filterY41eOrigen, jqGridRequestDto, false);
    }

    /**
     * Operacion de busqueda del componente RUP_TABLE.
     * 
     * @param filterY41eOrigen Y41eOrigen
     *            Bean que contiene los parametros de filtrado a emplear.
     * @param searchY41eOrigen Y41eOrigen
     *            Bean que contiene los parametros de busqueda a emplear.
     * @param jqGridRequestDto
     *            Dto que contiene los parametros de configuracion propios del
     *            RUP_TABLE a aplicar en la búsqueda.
     * @return TableRowDto<Y41eOrigen> 
     *            Dto que contiene el resultado de la busqueda realizada por el
     *            componente RUP_TABLE. 
     */
    @RequestMapping(value = "/search", method = RequestMethod.POST)
    @ResponseBody public List<TableRowDto<Y41eOrigen>> search(
            @RequestJsonBody(param="filter") Y41eOrigen filterY41eOrigen,
            @RequestJsonBody(param="search") Y41eOrigen searchY41eOrigen,
            @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
        Y41eOrigenController.LOGGER.info("[POST - search] : Buscar Y41eOrigens");
        return this.y41eOrigenService.search(filterY41eOrigen, searchY41eOrigen, jqGridRequestDto, false);
    }

    /**
     * Borrado multiple de registros
     * 
     * @param filterY41eOrigen Y41eOrigen
     *            Bean que contiene los parametros de filtrado a emplear.
     * @param jqGridRequestDto
     *            Dto que contiene los parametros de configuracion propios del
     *            RUP_TABLE a aplicar en la busqueda.
     * @return List<String>
     *            Lista de los identificadores de los registros eliminados.
     * 
     */
    @RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody public List<String> removeMultiple(
            @RequestJsonBody(param="filter") Y41eOrigen filterY41eOrigen,
            @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
        Y41eOrigenController.LOGGER.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Y41eOrigens");
        this.y41eOrigenService.removeMultiple(filterY41eOrigen, jqGridRequestDto, false);
        Y41eOrigenController.LOGGER.info("All entities correctly deleted!");

        return jqGridRequestDto.getMultiselection().getSelectedIds();
    }

}
