package com.ejie.y41e.control;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.y41e.model.Y41eEnvio;
import com.ejie.y41e.service.Y41eEnviosService;

/**
 * Y41eEnviosController
 *  
 */

@Controller
@RequestMapping (value = "/encuesta/envios")

public class Y41eEnviosController  {

    private static final Logger LOGGER = LoggerFactory.getLogger(Y41eEnviosController.class);

    @Autowired
    private Y41eEnviosService y41eEnviosService;

    /**
     * Metodo de presentacion del RUP_TABLE.
     * 
     * @param model Model
     * @return String
     */
    @RequestMapping(value = "/maint", method = RequestMethod.GET)
    public String getFormEdit(Model model) {
        Y41eEnviosController.LOGGER.info("[GET - View] : relusuarioencuesta");
        return "envios";
    }

    /**
     * Operacion CRUD Read. Devuelve el bean correspondiente al identificador indicado.
     * 
     * @param idEnvio Long
     * @return Y41eEnvio 
     *            Objeto correspondiente al identificador indicado.
     */
    @RequestMapping(value = "/{idEnvio}", method = RequestMethod.GET)
    @ResponseBody public Y41eEnvio get(@PathVariable Long idEnvio) {
        Y41eEnvio envio = new Y41eEnvio();
        envio.setIdEnvio(idEnvio);
        envio = this.y41eEnviosService.find(envio);
        Y41eEnviosController.LOGGER.info("[GET - findBy_PK] : Obtener Y41eEnvio por PK");
        return envio;
    }

    /**
     * Devuelve una lista de beans correspondientes a los valores de filtrados
     * indicados en el objeto pasado como parametro.
     *
     * @param filterY41eEnvio Y41eEnvio
     *            Objeto que contiene los parametros de filtrado utilizados en
     *            la busqueda.
     * @return List<Y41eEnvio> 
     *            Lista de objetos correspondientes a la busqueda realizada.
     */
    @RequestMapping(method = RequestMethod.GET)
    @ResponseBody public List<Y41eEnvio> getAll(@ModelAttribute Y41eEnvio filterY41eEnvio) {
        Y41eEnviosController.LOGGER.info("[GET - find_ALL] : Obtener Y41eEnvio por filtro");
        return this.y41eEnviosService.findAll(filterY41eEnvio, null);
    }

    /**
     * Operacion CRUD Edit. Modificacion del bean indicado.
     *
     * @param envio Y41eEnvio 
     *            Bean que contiene la informacion a modificar.
     * @return Y41eEnvio 
     *            Bean resultante de la modificacion.
     */
    @RequestMapping(method = RequestMethod.PUT)
    @ResponseBody public Y41eEnvio edit(@RequestBody Y41eEnvio envio) {
        Y41eEnvio envioAux = this.y41eEnviosService.update(envio);
        Y41eEnviosController.LOGGER.info("[PUT] : Y41eEnvio actualizado correctamente");
        return envioAux;
    }

    /**
     * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
     * indicado.
     *
     * @param envio Y41eEnvio 
     *            Bean que contiene la informacion con la que se va a crear el
     *            nuevo registro.
     * @return Y41eEnvio
     *            Bean resultante del proceso de creacion.
     */
    @RequestMapping(method = RequestMethod.POST)
    @ResponseBody public Y41eEnvio add(@RequestBody Y41eEnvio envio) {
        Y41eEnvio envioAux = this.y41eEnviosService.add(envio);
        Y41eEnviosController.LOGGER.info("[POST] : Y41eEnvio insertado correctamente");
        return envioAux;
    }

    /**
     * Operacion CRUD Delete. Borrado del registro correspondiente al
     * identificador especificado.
     *
     * @param idEnvio Long
     *            Identificador del objeto que se desea eliminar.
     * @return Y41eEnvio
     *            Bean eliminado.
     */
    @RequestMapping(value = "/{idEnvio}", method = RequestMethod.DELETE)
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody public Y41eEnvio remove(@PathVariable Long idEnvio) {
        Y41eEnvio envio = new Y41eEnvio();
        envio.setIdEnvio(idEnvio);
        this.y41eEnviosService.remove(envio);
        Y41eEnviosController.LOGGER.info("[DELETE] : Y41eEnvio borrado correctamente");
        return envio;
    }

    /**
     * Operacion de filtrado del componente RUP_TABLE.
     * 
     * @param filterY41eEnvio Y41eEnvio
     *            Bean que contiene los parametros de filtrado a emplear.
     * @param jqGridRequestDto
     *            Dto que contiene los parametros de configuracion propios del
     *            RUP_TABLE a aplicar en el filtrado.
     * @return JQGridResponseDto<Y41eEnvio>
     *            Dto que contiene el resultado del filtrado realizado por el 
     *            componente RUP_TABLE.
     */
    @RequestMapping(value = "/filter", method = RequestMethod.POST)
    @ResponseBody public JQGridResponseDto<Y41eEnvio> filter(
            @RequestJsonBody(param="filter") Y41eEnvio filterY41eEnvio,
            @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
        Y41eEnviosController.LOGGER.info("[POST - filter] : Obtener Y41eEnvios");
        return this.y41eEnviosService.filter(filterY41eEnvio, jqGridRequestDto, false);
    }

}
