package com.ejie.y41e.control;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.y41e.model.Y41eConfiguracion;
import com.ejie.y41e.model.Y41eListConfiguracion;
import com.ejie.y41e.service.Y41eConfiguracionService;

/**
 * Y41eY41eConfiguracionController
 *  
 */

@Controller
@RequestMapping (value = "/otrosMant/configuracion")

public class Y41eConfiguracionController  {

    private static final Logger LOGGER = LoggerFactory.getLogger(Y41eConfiguracionController.class);

    @Autowired
    private Y41eConfiguracionService y41eConfiguracionService;

    /**
     * Metodo de presentacion del RUP_TABLE.
     * 
     * @param model Model
     * @return String
     */
    @RequestMapping(value = "/maint", method = RequestMethod.GET)
    public String getFormEdit(Model model) {
        Y41eConfiguracionController.LOGGER.info("[GET - View] : configuracion");
        List<Y41eConfiguracion>  listadoConfig = this.y41eConfiguracionService.findAll(new Y41eConfiguracion(), new JQGridRequestDto(null, null, "ID_CONFIG_012", "ASC"));
        Y41eListConfiguracion listConfiguracion = new Y41eListConfiguracion();
        listConfiguracion.setListConfiguracion(listadoConfig);
        model.addAttribute("listadoConfig", listConfiguracion);
        return "configuracion";
    }

    /**
     * Operacion CRUD Read. Devuelve el bean correspondiente al identificador indicado.
     * 
     * @param idConfig Long
     * @return Y41eConfiguracion 
     *            Objeto correspondiente al identificador indicado.
     */
    @RequestMapping(value = "/cancelar", method = RequestMethod.GET)
    @ResponseBody public Y41eListConfiguracion cancelar() {
        List<Y41eConfiguracion>  listadoConfig = this.y41eConfiguracionService.findAll(new Y41eConfiguracion(), new JQGridRequestDto(null, null, "ID_CONFIG_012", "ASC"));
        Y41eListConfiguracion listConfiguracion = new Y41eListConfiguracion();
        listConfiguracion.setListConfiguracion(listadoConfig);
        return listConfiguracion;
    }

    @RequestMapping(value = "/edit", method = RequestMethod.POST)
    @ResponseBody() public void editConfiguracion(@RequestBody() Y41eListConfiguracion listConfiguracion) {
        Y41eConfiguracionController.LOGGER.info("editConfiguracion");
        y41eConfiguracionService.editConfiguracion(listConfiguracion);
    }

    /**
     * Operacion CRUD Read. Devuelve el bean correspondiente al identificador indicado.
     * 
     * @param idConfig Long
     * @return Y41eConfiguracion 
     *            Objeto correspondiente al identificador indicado.
     */
    @RequestMapping(value = "/{idConfig}", method = RequestMethod.GET)
    @ResponseBody public Y41eConfiguracion get(@PathVariable Integer idConfig) {
        Y41eConfiguracion configuracion = new Y41eConfiguracion();
        configuracion.setIdConfig(idConfig);
        configuracion = this.y41eConfiguracionService.find(configuracion);
        Y41eConfiguracionController.LOGGER.info("[GET - findBy_PK] : Obtener Y41eConfiguracion por PK");
        return configuracion;
    }

    /**
     * Devuelve una lista de beans correspondientes a los valores de filtrados
     * indicados en el objeto pasado como parametro.
     *
     * @param filterY41eConfiguracion Y41eConfiguracion
     *            Objeto que contiene los parametros de filtrado utilizados en
     *            la busqueda.
     * @return List<Y41eConfiguracion> 
     *            Lista de objetos correspondientes a la busqueda realizada.
     */
    @RequestMapping(method = RequestMethod.GET)
    @ResponseBody public List<Y41eConfiguracion> getAll(@ModelAttribute Y41eConfiguracion filterY41eConfiguracion) {
        Y41eConfiguracionController.LOGGER.info("[GET - find_ALL] : Obtener Y41eConfiguracion por filtro");
        return this.y41eConfiguracionService.findAll(filterY41eConfiguracion, null);
    }

    /**
     * Operacion CRUD Edit. Modificacion del bean indicado.
     *
     * @param configuracion Y41eConfiguracion 
     *            Bean que contiene la informacion a modificar.
     * @return Y41eConfiguracion 
     *            Bean resultante de la modificacion.
     */
    @RequestMapping(method = RequestMethod.PUT)
    @ResponseBody public Y41eConfiguracion edit(@RequestBody Y41eConfiguracion configuracion) {     
        Y41eConfiguracion configuracionAux = this.y41eConfiguracionService.update(configuracion);
        Y41eConfiguracionController.LOGGER.info("[PUT] : Y41eConfiguracion actualizado correctamente");
        return configuracionAux;
    }

    /**
     * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
     * indicado.
     *
     * @param configuracion Y41eConfiguracion 
     *            Bean que contiene la informacion con la que se va a crear el
     *            nuevo registro.
     * @return Y41eConfiguracion
     *            Bean resultante del proceso de creacion.
     */
    @RequestMapping(method = RequestMethod.POST)
    @ResponseBody public Y41eConfiguracion add(@RequestBody Y41eConfiguracion configuracion) {      
        Y41eConfiguracion configuracionAux = this.y41eConfiguracionService.add(configuracion);
        Y41eConfiguracionController.LOGGER.info("[POST] : Y41eConfiguracion insertado correctamente");
        return configuracionAux;
    }

    /**
     * Operacion de filtrado del componente RUP_TABLE.
     * 
     * @param filterY41eConfiguracion Y41eConfiguracion
     *            Bean que contiene los parametros de filtrado a emplear.
     * @param jqGridRequestDto
     *            Dto que contiene los parametros de configuracion propios del
     *            RUP_TABLE a aplicar en el filtrado.
     * @return JQGridResponseDto<Y41eConfiguracion>
     *            Dto que contiene el resultado del filtrado realizado por el 
     *            componente RUP_TABLE.
     */
    @RequestMapping(value = "/filter", method = RequestMethod.POST)
    @ResponseBody public JQGridResponseDto<Y41eConfiguracion> filter(
            @RequestJsonBody(param="filter") Y41eConfiguracion filterY41eConfiguracion,
            @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
        Y41eConfiguracionController.LOGGER.info("[POST - filter] : Obtener Y41eConfiguracions");
        return this.y41eConfiguracionService.filter(filterY41eConfiguracion, jqGridRequestDto, false);
    }
}