package com.ejie.y41e.control;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.y41e.common.Y41eConstants;
import com.ejie.y41e.model.Y41eArea;
import com.ejie.y41e.service.Y41eAreaService;

/**
 * AreaController
 *  
 */

@Controller
@RequestMapping (value = "/otrosMant/area")

public class Y41eAreaController  {

    private static final Logger LOGGER = LoggerFactory.getLogger(Y41eAreaController.class);

    @Autowired
    private Y41eAreaService y41eAreaService;

    /*
     * OPERACIONES CRUD (Create, Read, Update, Delete)
     * 
     */

    /**
     * Operacion CRUD Read. Devuelve el bean correspondiente al identificador indicado.
     * 
     * @param id Integer
     * @return Area 
     *            Objeto correspondiente al identificador indicado.
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ResponseBody public Y41eArea get(@PathVariable Integer id) {
        Y41eArea area = new Y41eArea();
        area.setIdArea(id);
        area = this.y41eAreaService.find(area);
        Y41eAreaController.LOGGER.info("[GET - findBy_PK] : Obtener Area por PK");
        return area;
    }

    /**
     * Devuelve una lista de beans correspondientes a los valores de filtrados
     * indicados en el objeto pasado como parametro.
     *
     * @param filterArea Area
     *            Objeto que contiene los parametros de filtrado utilizados en
     *            la busqueda.
     * @return List<Area> 
     *            Lista de objetos correspondientes a la busqueda realizada.
     */
    @RequestMapping(method = RequestMethod.GET)
    @ResponseBody public List<Y41eArea> getAll(@ModelAttribute Y41eArea filterArea) {
        Y41eAreaController.LOGGER.info("[GET - find_ALL] : Obtener Area por filtro");
        filterArea.setActiva(Y41eConstants.SI);
        return this.y41eAreaService.findAll(filterArea, null);
    }

    /**
     * Operacion CRUD Edit. Modificacion del bean indicado.
     *
     * @param area Area 
     *            Bean que contiene la informacion a modificar.
     * @return Area 
     *            Bean resultante de la modificacion.
     */
    @RequestMapping(method = RequestMethod.PUT)
    @ResponseBody public Y41eArea edit(@RequestBody Y41eArea area) {
        Y41eArea areaAux = this.y41eAreaService.update(area);
        Y41eAreaController.LOGGER.info("[PUT] : Area actualizado correctamente");
        return areaAux;
    }

    /**
     * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
     * indicado.
     *
     * @param area Area 
     *            Bean que contiene la informacion con la que se va a crear el
     *            nuevo registro.
     * @return Area
     *            Bean resultante del proceso de creacion.
     */
    @RequestMapping(method = RequestMethod.POST)
    @ResponseBody public Y41eArea add(@RequestBody Y41eArea area) {
        Y41eArea areaAux = this.y41eAreaService.add(area);
        Y41eAreaController.LOGGER.info("[POST] : Area insertado correctamente");
        return areaAux;
    }

    /**
     * Operacion CRUD Delete. Borrado del registro correspondiente al
     * identificador especificado.
     *
     * @param id Integer
     *            Identificador del objeto que se desea eliminar.
     * @return Area
     *            Bean eliminado.
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody public Y41eArea remove(@PathVariable Integer id) {
        Y41eArea area = new Y41eArea();
        area.setIdArea(id);
        this.y41eAreaService.remove(area);
        Y41eAreaController.LOGGER.info("[DELETE] : Area borrado correctamente");
        return area;
    }


    /*
     * METODOS COMPONENTE RUP_TABLE
     * 
     */

    /**
     * Metodo de presentacion del RUP_TABLE.
     * 
     * @param model Model
     * @return String
     */
    @RequestMapping(value = "/maint", method = RequestMethod.GET)
    public String getFormEdit(Model model) {
        Y41eAreaController.LOGGER.info("[GET - View] : area");
        return "area";
    }

    /**
     * Operacion de filtrado del componente RUP_TABLE.
     * 
     * @param filterArea Area
     *            Bean que contiene los parametros de filtrado a emplear.
     * @param jqGridRequestDto
     *            Dto que contiene los parametros de configuracion propios del
     *            RUP_TABLE a aplicar en el filtrado.
     * @return JQGridResponseDto<Area>
     *            Dto que contiene el resultado del filtrado realizado por el 
     *            componente RUP_TABLE.
     */
    @RequestMapping(value = "/filter", method = RequestMethod.POST)
    @ResponseBody public JQGridResponseDto<Y41eArea> filter(
            @RequestJsonBody(param="filter") Y41eArea filterArea,
            @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
        Y41eAreaController.LOGGER.info("[POST - filter] : Obtener Areas");
        return this.y41eAreaService.filter(filterArea, jqGridRequestDto, false);
    }

    /**
     * Borrado multiple de registros
     * 
     * @param filterArea Area
     *            Bean que contiene los parametros de filtrado a emplear.
     * @param jqGridRequestDto
     *            Dto que contiene los parametros de configuracion propios del
     *            RUP_TABLE a aplicar en la busqueda.
     * @return List<String>
     *            Lista de los identificadores de los registros eliminados.
     * 
     */
    @RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody public List<String> removeMultiple(
            @RequestJsonBody(param="filter") Y41eArea filterArea,
            @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
        Y41eAreaController.LOGGER.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Areas");
        this.y41eAreaService.removeMultiple(filterArea, jqGridRequestDto, false);
        Y41eAreaController.LOGGER.info("All entities correctly deleted!");

        return jqGridRequestDto.getMultiselection().getSelectedIds();
    }

}
