<%@include file="/WEB-INF/includeTemplate.inc"%>

<div class="container-fluid y41e-fade in" id="divEncuesta">
	<h2>${encuesta.descPublEu}</h2>
	<h2>${encuesta.descPublEs}</h2>
	<hr class="mb-2">
	<form:form id="encuestaForm" method="post" modelAttribute="encuesta" action="/y41eeEncuestaWar/enviar">
	   <form:hidden path="idEncuesta"/>
       <div class="form-row mt-2">
           <div class="col-xs-12">
                <label><i class="fa fa-asterisk" aria-hidden="true"></i> <spring:message code="comun.obligatorio"/></label>
           </div>
       </div>
	   <c:forEach items="${encuesta.listaBloques}" var="bloque" varStatus="loopBloque">
	       <form:hidden path="listaBloques[${loopBloque.index}].idBloque" id="bloque_${bloque.idBloque}"/>
	       <c:set var="oculto" value="${(bloque.isEnlazada eq 'S')? 'd-none' : ''}"/>
	       <fieldset id="bloque_${bloque.idPreguntaPadre}_${bloque.idBloque}" class="${oculto}">
		       <div class="form-row  mt-2 tituloBloque">
		            <div class="col-xs-12">
		                <h3>${bloque.descPublEu}</h3>
		                <h3>${bloque.descPublEs}</h3>
		            </div>
		       </div>
		       <div class="form-row mt-2 ml-2 preguntaBloque">
		           <c:forEach items="${bloque.listaPreguntas}" var="pregunta" varStatus="loopPregunta">
		               <form:hidden path="listaBloques[${loopBloque.index}].listaPreguntas[${loopPregunta.index}].idPregunta" id="pregunta_${pregunta.idPregunta}"/>
		               <c:set var="required" value="${(bloque.obligatorio eq 'S' || pregunta.obligatorio eq 'S')? 'required' : ''}"/>
		               <c:set var="oculto" value="${(pregunta.isEnlazada eq 'S')? 'd-none' : ''}"/>
			           <div id="pregunta_${bloque.idBloque}_${pregunta.idPreguntaPadre}_${pregunta.idPregunta}" class="${oculto}">
				           <div class="mt-2">
		                        <div class="col-xs-12">
				                    <span>${loopPregunta.index+1}.</span>${pregunta.descPublEu}
				                    <c:if test="${bloque.obligatorio eq 'S' || pregunta.obligatorio eq 'S'}">
				                        <i class="fa fa-asterisk" aria-hidden="true"></i>
				                    </c:if>
				                </div>
				                <div class="col-xs-12">
				                    ${pregunta.descPublEs}
				                </div>
				           </div>
				           <div class="mt-2">
				                 <c:if test="${empty pregunta.listRespuestas}">
			                          <div class="col-xs-12">
			                              <form:textarea rows="4" path="listaBloques[${loopBloque.index}].listaPreguntas[${loopPregunta.index}].resultado.texto" maxlength="500" 
			                              class="form-control textarea ${required}" id="respuesta_${bloque.idBloque}_${pregunta.idPregunta}"/>
			                          </div>
				                 </c:if>
				                 <c:if test="${not empty pregunta.listRespuestas}">
                                     <c:set var="mostrarEnlazadas" value="${(pregunta.tipoPregunta.idTipoPregunta eq '1')? 'mostrarEnlazadas(this)' : ''}"/>
				                     <div class="switch-field">
		                                 <c:forEach items="${pregunta.listRespuestas}" var="repuestas" varStatus="loopRespuestas">
		                                     <c:choose>
											     <c:when test="${pregunta.tipoPregunta.idTipoPregunta eq '1'}">
											         <div class="col-xs-6 col-sm-2">
											     </c:when>
											     <c:when test="${pregunta.tipoPregunta.idTipoPregunta eq '2'}">
											         <div class="col-xs-2 col-sm-1">
											     </c:when>
											     <c:otherwise>
											         <div class="col-xs-1">
											     </c:otherwise>
											</c:choose>
		                                         <form:radiobutton path="listaBloques[${loopBloque.index}].listaPreguntas[${loopPregunta.index}].resultado.respuesta.idTipoRespuesta" 
		                                         class="form-control ${required}" 
		                                         id="respuesta_${bloque.idBloque}_${pregunta.idPregunta}_${repuestas.idTipoRespuesta}" value="${repuestas.idTipoRespuesta}" onclick="${mostrarEnlazadas}"/>
		                                         <label for="respuesta_${bloque.idBloque}_${pregunta.idPregunta}_${repuestas.idTipoRespuesta}">${repuestas.descWeb}</label>
		                                     </div>
		                                 </c:forEach>
	                                 </div>
	                             </c:if>
				           </div>
			           </div>
		           </c:forEach>
		       </div>
	       </fieldset>
	   </c:forEach>
	   <div class="mt-2 mb-2 col-xs-12 text-right">
            <button id="btnEnviarEncuesta" type="button" class="btn btn-primary">
                <spring:message code="boton.enviar" />
            </button>
       </div>
	</form:form>
</div>