package com.ejie.y41e.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

import com.ejie.y41e.common.Y41eConstants;

/**
 * The type Y41eUtils.
 *
 *  
 *
 */
public final class Y41eUtils {

    /**
     * The JAVA_DATE_FORMAT_ES.
     */
    public static final String JAVA_DATE_FORMAT_ES = "dd/MM/yyyy";
    /**
     * The JAVA_DATE_FORMAT_EU.
     */
    public static final String JAVA_DATE_FORMAT_EU = "yyyy/MM/dd";

    /**
     * El metodo constructor.
     */
    private Y41eUtils() {

    }


    /**
     *
     * @param fecha Date
     * @return String
     */
    public static String obtFechaFormateada(Date fecha){
        Locale locale = LocaleContextHolder.getLocale();
        SimpleDateFormat formato;
        if(Y41eConstants.LANG_CASTELLANO.equals(locale.getLanguage())){
            formato = new SimpleDateFormat(Y41eUtils.JAVA_DATE_FORMAT_ES);
        }else{
            formato = new SimpleDateFormat(Y41eUtils.JAVA_DATE_FORMAT_EU);
        }
        String date="";
        if(fecha!=null){
            date=formato.format(fecha);
        }
        return date;
    }


    /**
     *
     * @param fecha Date
     * @param locale Locale
     * @return String
     */
    public static String obtFechaFormateada(Date fecha, Locale locale){
        SimpleDateFormat formato;
        if(Y41eConstants.LANG_CASTELLANO.equals(locale.getLanguage())){
            formato = new SimpleDateFormat(Y41eUtils.JAVA_DATE_FORMAT_ES);
        }else{
            formato = new SimpleDateFormat(Y41eUtils.JAVA_DATE_FORMAT_EU);
        }
        String date="";
        if(fecha!=null){
            date=formato.format(fecha);
        }
        return date;
    }

    /**
     * Devuelve literalEu separator literalEs
     * @param ms ReloadableResourceBundleMessageSource
     * @param prop String
     * @param propArgs String[]
     * @param separator String
     * @return String
     */
    public static String getLiteralEuEs(ReloadableResourceBundleMessageSource ms, String prop, String[] propArgs, String separator){
        return ms.getMessage(prop, propArgs, new Locale(Y41eConstants.LANG_EUSKERA))
                + separator
                + ms.getMessage(prop, propArgs, new Locale(Y41eConstants.LANG_CASTELLANO));
    }

    /**
     * Devuelve un codigo para enviar por email
     * @return String
     */
    public static String generarCodigo(){
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

}
