package com.ejie.y41e.utils;

import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 *  
 *
 */
public class JQGridManagerCustom extends JQGridManager {

    private static final long serialVersionUID = 1L;

    /**
     * @param pagination
     * @param query
     * @return
     */
    public static <T> StringBuilder getQueryForPaginationOracle12(JQGridRequestDto pagination, StringBuilder query) {
        return getQueryForPaginationOracle12(pagination, query, false);
    }

    /**
     * @param pagination
     * @param query
     * @param isJerarquia
     * @return
     */
    public static <T> StringBuilder getQueryForPaginationOracle12(JQGridRequestDto pagination, StringBuilder query,
            boolean isJerarquia) {
        query.append(getOrderBy(pagination, isJerarquia));
        StringBuilder paginationQuery = new StringBuilder();
        paginationQuery.append(query);

        Long page = pagination.getPage();
        Long rows = pagination.getRows();

        if (page != null) {
            // página inicial
            paginationQuery.append(" offset ").append(String.valueOf(rows.longValue() * (page.longValue() - 1L)))
            .append(" row ");
        }
        if (rows != null) {
            // número de registros a recuperar por página
            paginationQuery.append(" fetch first ").append(rows.longValue()).append(" rows only ");
        }

        return paginationQuery;
    }
}
