package com.ejie.y41e.service;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.y41e.dao.Y41eGenericoDao;
import com.ejie.y41e.dao.Y41eTipoRespuestaDao;
import com.ejie.y41e.model.Y41eTipoRespuesta;

/**
 * Y41eTipoRespuestaServiceImpl
 *  
 */

@Service(value = "y41eTipoRespuestaService")
public class Y41eTipoRespuestaServiceImpl extends Y41eGenericoServiceImpl<Y41eTipoRespuesta> implements Y41eTipoRespuestaService {

    @Autowired
    private Y41eTipoRespuestaDao y41eTipoRespuestaDao;

    @Override()
    protected Y41eGenericoDao<Y41eTipoRespuesta> getDao() {
        return this.y41eTipoRespuestaDao;
    }

    /**
     * Obtiene las respuestas según el tipo de pregunta
     * @param tipoRespuesta Y41eTipoRespuesta
     * @return List<Y41eTipoRespuesta>
     */
    @Override
    public List<Y41eTipoRespuesta> findAllRespuesta(Y41eTipoRespuesta tipoRespuesta){
        return y41eTipoRespuestaDao.findAllRespuesta(tipoRespuesta);
    }

}

