package com.ejie.y41e.service;


import java.util.List;

import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.y41e.model.Y41eEncuesta;
import com.ejie.y41e.model.Y41eEnvio;
import com.ejie.y41e.model.Y41eGrafico;
import com.ejie.y41e.model.Y41eResultados;
import com.ejie.y41e.model.excel.Y41eExcelModel;

/**
 * Y41eResultadosService
 *  
 */

public interface Y41eResultadosService extends Y41eGenericoService<Y41eResultados> {

    /**
     * Obtiene los resultados por encuesta
     * @param filterEncuesta Y41eEncuesta
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith boolean
     * @return JQGridResponseDto<Y41eEncuesta>
     */
    public JQGridResponseDto<Y41eEncuesta> filterEncuestas(Y41eEncuesta filterEncuesta,
            JQGridRequestDto jqGridRequestDto, boolean startsWith);

    /**
     * Obtiene una lista de resultados para pintar los graficos
     * @param resultado Y41eResultados
     * @return List<Y41eGrafico>
     */
    public List<Y41eGrafico> getGraficos(Y41eResultados resultado);

    /**
     * Obtiene los resultados por destinatario
     * @param filter Y41eEnvio
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith boolean
     * @return JQGridResponseDto<Y41eEnvio>
     */
    public JQGridResponseDto<Y41eEnvio> filterDestinatario(Y41eEnvio filter, JQGridRequestDto jqGridRequestDto,
            boolean startsWith);

    /**
     * Obtiene el excel de resultados por destinatario
     * @param envio Y41eEnvio
     * @return ExcelModel
     */
    public Y41eExcelModel getExcelResultadosDestinatario(Y41eEnvio envio);

    /**
     * Guardar las respuestas del usuario
     * @param encuesta Y41eEncuesta
     * @param idEnvio Long
     */
    public void guardarRespuestas(Y41eEncuesta encuesta, Long idEnvio);

}


