package com.ejie.y41e.service;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41e.dao.Y41eGenericoDao;
import com.ejie.y41e.dao.Y41ePreguntaEnlazadaDao;
import com.ejie.y41e.dao.Y41eRelEncuestaBloqueDao;
import com.ejie.y41e.model.Y41eBloque;
import com.ejie.y41e.model.Y41ePreguntaEnlazada;
import com.ejie.y41e.model.Y41eRelEncuestaBloque;

/**
 * RelEncuestaBloqueServiceImpl
 *  
 */

@Service(value = "relEncuestaBloqueService")
public class Y41eRelEncuestaBloqueServiceImpl extends Y41eGenericoServiceImpl<Y41eRelEncuestaBloque> implements Y41eRelEncuestaBloqueService {

    @Autowired
    private Y41eRelEncuestaBloqueDao relEncuestaBloqueDao;
    @Autowired
    private Y41ePreguntaEnlazadaDao y41ePreguntaEnlazadaDao;

    @Override()
    protected Y41eGenericoDao<Y41eRelEncuestaBloque> getDao() {
        return this.relEncuestaBloqueDao;
    }

    /**
     * Asocia los bloques seleccionados a la encuesta
     * @param idEncuesta Long
     * @param listaBloquesSeleccionados List<Y41eBloque>
     */
    @Override
    public void asosiarBloques(Long idEncuesta, List<Y41eBloque> listaBloquesSeleccionados){
        this.relEncuestaBloqueDao.asosiarBloques(idEncuesta, listaBloquesSeleccionados);
    }

    /**
     * Ordena las bloques según el orden pasado
     * @param orden String
     * @param idEncuesta String
     */
    @Override
    public void moverBloque(String orden, String idEncuesta){
        this.relEncuestaBloqueDao.moverBloque(orden, idEncuesta);
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.service.Y41eGenericoServiceImpl#remove(java.lang.Object)
     */
    @Transactional(rollbackFor = Throwable.class)
    @Override
    public void remove(Y41eRelEncuestaBloque bean){
        //borrar bloque
        this.relEncuestaBloqueDao.remove(bean);
        //borrar preguntas enlazadas al bloque
        Y41ePreguntaEnlazada preguntaEnlazada = new Y41ePreguntaEnlazada(bean.getEncuesta().getIdEncuesta(), bean.getBloque().getIdBloque());
        y41ePreguntaEnlazadaDao.removeByBloque(preguntaEnlazada);
    }
}

